#include "mbed.h"
#include "SLCD.h"


#define PROGNAME "lightsense_kl46z_basic v1\n\r"
#define DATATIME 400 // milliseconds
#define LCDLEN 10
#define LIGHTSENSORPORT PTE22
#define NUMBUTS 2
#define LBUT PTC12 
#define RBUT PTC3



SLCD slcd; //define LCD display globally define
Serial pc(USBTX, USBRX);
Timer LEDTimer;
DigitalIn buttons[NUMBUTS] = {RBUT, LBUT};
DigitalOut LEDs[NUMBUTS] = {LED_GREEN, LED_RED};

void LCDMess(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
} 


int main() {
    AnalogIn LightSensor(LIGHTSENSORPORT);
    float lightData; 
    char lcdData[LCDLEN];
    PwmOut gled(LED_GREEN);
    PwmOut rled(LED_RED);
   
    int timeToChangeDF = DATATIME;
    LEDTimer.start();
    LEDTimer.reset();
    pc.printf(PROGNAME);
    
    while(true) {    
        if (LEDTimer.read_ms() > timeToChangeDF){ // check for timer time out transtion
            lightData = (1.0 - LightSensor.read_u16()); // show as increasiing with increasing intensity  
            sprintf(lcdData,"%4.3f",lightData);       
            LCDMess(lcdData);
            gled = 1.0 - lightData;
            rled = 1.0 - lightData;  
            timeToChangeDF = DATATIME;
            LEDTimer.reset();
        }        
    }// emd while
}
