#include "mbed.h"
#include "MMA8451Q.h"
#include "SLCD.h"
/* 
Test of the accelerometer, digital I/O, on-board LCD screen, and 16-bit ADC.
 
 */

#define BLINKTIME 0.7
#define DATATIME 0.1
#define DATADISPDWELL 0.2
#define NUMLEDS 2
#define LEDON 0
#define LEDOFF 1
#define SCALING 13
#define RSTARTMESS "RSET"
#define MAXVECT "MAXV"
#define XCOMP "XCMP"
#define YCOMP "YCMP"
#define ZCOMP "ZCMP"
#define ANALTOVOLTS 3.3
#define LEDDELAY 0.400
//define states
#define NUMSTATES 4
#define XCOMPD 0
#define YCOMPD 1
#define ZCOMPD 2
#define VMAXD 3

#define PROGNAME "LCD_ACC_LCDv3 46\r/n"

//#define PRINTDBUG
// Accelerometer SPI pins
#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  PinName const SDA = PTE25;
  PinName const SCL = PTE24;
#elif defined (TARGET_KL05Z)
  PinName const SDA = PTB4;
  PinName const SCL = PTB3;
#else
  #error TARGET NOT DEFINED
#endif

#define MMA8451_I2C_ADDRESS (0x1d<<1)

SLCD slcd; //define LCD display
Timer blinkTimer;
Timer dataTimer;
Timer displayTimer;
MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
AnalogIn TMP01(PTB1);
DigitalOut LEDs[NUMLEDS]={LED_RED, LED_GREEN}; //Indicator LEDs
Serial pc(USBTX, USBRX);


void LCDMess(char *lMess, float dWait){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
        wait(dWait);
} 
void LCDMessNoDwell(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
} 


void allLEDsOFF(int numberOfLEDS) {
    int i;
    for (i=0;i<numberOfLEDS; i++){
            LEDs[i] = LEDOFF;
        }

}



int main() {
    
    int RButtonState;
    int LButtonState;
    DigitalIn RtButton(PTC12);
    DigitalIn LftButton(PTC3);
    int displayState = XCOMPD; 
    float xAcc = 0.0;
    float yAcc = 0.0;
    float zAcc = 0.0;
    float vector;
    float vMax = 0.0;
    float DisplayTime = DATADISPDWELL;
    int outState = false;
    char lcdData[10]; //buffer needs places for decimal pt and colon

    
#ifdef PRINTDBUG
        pc.printf(PROGNAME);
#endif
    LCDMess(RSTARTMESS, BLINKTIME);
// Initialze readings and sequence the LED's for dramtic effect.
    allLEDsOFF(NUMLEDS);
    blinkTimer.start();
    blinkTimer.reset();
    displayTimer.start();
    displayTimer.reset();
    dataTimer.start();
    dataTimer.reset();
  
// main loop forever 
    while(true) {

// Handle user input for display selections
        RButtonState = !RtButton; // button is pulled up so false is when button is pushed it's inverted to avoid confusion downstream
        if (RButtonState){
            vMax = 0.0; // Clear vMax
            LCDMess(RSTARTMESS, BLINKTIME);
        }
        LButtonState = !LftButton;
        if (LButtonState) {  //Change data that is displayed
            displayState = (displayState + 1) % NUMSTATES;
            // Change to switch/case soon.
            switch (displayState){
                case XCOMPD: {
                    LCDMess(XCOMP,BLINKTIME);
                    break;
                }
                case YCOMPD: {
                    LCDMess(YCOMP,BLINKTIME);
                    break;
                }
                case ZCOMPD: {
                    LCDMess(ZCOMP,BLINKTIME);
                    break;
                }
                case VMAXD:{
                    LCDMess(MAXVECT,BLINKTIME);
                    break;
                }
            }// switch        
        }
        
// --------------------------------------------
        while (dataTimer.read() > DATATIME){ //correct place?
// No offset
            xAcc = abs(acc.getAccX());
            xCounts = acc.getAccAxis(REG_OUT_X_MSB);
            yAcc = abs(acc.getAccY());
            yCounts = acc.getAccAxis(REG_OUT_Y_MSB);
            zAcc = abs(acc.getAccZ());
            zCounts = acc.getAccAxis(REG_OUT_z_MSB);
 // Calulate vector sum of x,y and z reading.       
            vector = sqrt(pow(xAcc,2) + pow(zAcc,2));
            vector = zAcc;
            if (vector > vMax) {
                vMAX = vector;
            }
            
            accaxisdata[XCOMPD] = abs((float)xCounts/COUNTSCALE); //why xCounts? x cord I think
            accaxisdata[YCOMPD] = abs((float)yCounts/COUNTSCALE);
            accaxisdata[zCOMPD] = abs((float)zCounts/COUNTSCALE);
            accaxisdata[VMAXD] = vMax;
            dataTimer.reset();
            LEDDwell = 1.1 - vMax/MAXGS //don't unbderstand where this comes from
        }

// Display the appropriate data on the LCD based upon what mode was chosen
        while (displayTimer.read() > DisplayTime){
            switch (displayState) {
                case XCOMPD: {
                    sprintf (lcdData,"%4.3f",xAcc);
                    break;
                }
                case YCOMPD: {
                    sprintf (lcdData,"%4.3f",yAcc);
                    break;
                }
                case ZCOMPD: {
                    sprintf (lcdData,"%4.3f",zAcc);
                    break;
                }
                case VMAXD:{
                    sprintf (lcdData,"%4.3f",vMax);
                    break;
                }
            }
            LCDMessNoDwell(lcdData);
            displayTimer.reset();
        } // displaytimer 
// Wait then do the whole thing again.  
// Alive LEDs
        while(blinkTimer.read()> LEDDELAY) {     
            LEDs[0].write(outState);
            LEDs[1].write(!outState);
            outState = !outState; 
            blinkTimer.reset();
        } 
    }//forever loop
}// main