#include "mbed.h"
#include <math.h> 
#include "MMA8451Q.h"
#include "SLCD.h"

#define NUMAXES 3
#define XAXIS 0
#define YAXIS 1
#define ZAXIS 2
#define NUMBUTS 2
#define LBUT PTC12  // port addresses for buttons
#define RBUT PTC3
#define BUTTONTIME 0.200
#define DATAINTERVAL 0.200
#define LCDWAIT  1.5
#define LCDDATALEN 10

#define PROGNAME "ACC_LCD_all_axes_v1\r\n"

#define PRINTDBUG
// 
#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  PinName const SDA = PTE25;  // Data pins for the accelerometer/magnetometer.
  PinName const SCL = PTE24;  // DO NOT CHANGE
#elif defined (TARGET_KL05Z)
  PinName const SDA = PTB4;
  PinName const SCL = PTB3;
#else
  #error TARGET NOT DEFINED
#endif

#define MMA8451_I2C_ADDRESS (0x1d<<1)

SLCD slcd; //define LCD display
char lcdData[LCDDATALEN]; //buffer needs places dor decimal pt and colon
int currentAxis = XAXIS; // xaxis

MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
Serial pc(USBTX, USBRX);
Timer dataTimer;
Timer ButtonTimer; // for reading button states
DigitalIn buttons[NUMBUTS] = {RBUT, LBUT}; // set up buttons

char axisName[NUMAXES][LCDDATALEN] = {"<X<","<Y<", "<Z<"};   

void LCDMess(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
} 

void LCDsignedFloat(float theNumber){
    sprintf (lcdData," %3.2f",theNumber); 
    // changed SLCD.cpp to interpret < as -
    if (theNumber < 0.0) sprintf (lcdData,"<%3.2f",fabs(theNumber));   
    LCDMess(lcdData); 
}

void LCDsignedAngle(float theAngle) {
    sprintf (lcdData," %2.0f@",theAngle);
    if (theAngle < 0.0) sprintf (lcdData,"<%2.0f@",fabs(theANgle));   
    LCDMess(lcdData);
    } 

void initialize_global_vars(){
    pc.printf(PROGNAME);
    // set up DAQ timers
    ButtonTimer.start();
    ButtonTimer.reset();
    dataTimer.start();
    dataTimer.reset(); 
    LCDMess(axisName[currentAxis]);  
    wait(LCDWAIT);  
    
} 

int main() {
    int i; // loop index
    float axisValue[NUMAXES]; // set up an array of axid values
    int buttonSum = 0;
    
    initialize_global_vars();
//roll  = (atan2(-fYg, fZg)*180.0)/M_PI;
    //pitch = (atan2(fXg, sqrt(fYg*fYg + fZg*fZg))*180.0)/M_PI;
 
    //Serial.print(pitch);
    //Serial.print(":");
    //Serial.println(roll);
    
    //could be like above, doesnt work here because different syntax.
    //0xDF code for 
    
// main loop forever 
    while(true) {
        while (ButtonTimer > BUTTONTIME){ //Use a while instead of an if 
            buttonSum = 0; // Note
            buttonSum = !buttons[0] + !buttons[1];
            if (buttonSum != 0) { // 
                currentAxis = (currentAxis + 1 ) % NUMAXES;
                                                       
                //if (axis = greater than a certain point)
                    //sin equation goes here?
                    //Gsin0 = y
                    //Sign is throwing me off
                    
                    
                                                        
                LCDMess(axisName[currentAxis]);  
                wait(LCDWAIT);           
            }// for loop to look at buttons
            ButtonTimer.reset(); // Make sure you reset the timer or..
                                // Groundhog Day.
        }
        while (dataTimer.read() > DATAINTERVAL){
            dataTimer.reset();             
            axisValue[XAXIS]= acc.getAccX();
            axisValue[YAXIS] = acc.getAccY(); 
            axisValue[ZAXIS] = acc.getAccZ();     
#ifdef PRINTDBUG
            for (i=0; i< NUMAXES;i++){
                pc.printf("Acc %d = %f\r\n",i, axisValue[i]);
            }
#endif
            LCDsignedFloat(axisValue[currentAxis]);              
       }
    }
}