#ifndef __LCD__
#define __LCD__

#include "mbed.h"
#include "DisplayBace.h"
#include "LCD_shield_config_4_3inch.h"
#include "RGA.h"
#include "CppStandardHelper.hpp"

class LCD {
    static constexpr int FRAME_BUFFER_BYTE_PER_PIXEL = 2;
    static constexpr int FRAME_BUFFER_STRIDE = ((LCD_PIXEL_WIDTH * FRAME_BUFFER_BYTE_PER_PIXEL) + 31u) & ~31u;
    static volatile int32_t vsync_count;
    static void IntCallbackFunc_LoVsync(DisplayBase::int_type_t int_type);
    static frame_buffer_t frame_buffer_info;
    static uint8_t MBED_ALIGN(32) user_frame_buffer1[FRAME_BUFFER_STRIDE * LCD_PIXEL_HEIGHT];
    static uint8_t MBED_ALIGN(32) user_frame_buffer2[FRAME_BUFFER_STRIDE * LCD_PIXEL_HEIGHT];
    mbed::DigitalOut lcd_pwon;
    mbed::DigitalOut lcd_blon;
    mbed::PwmOut     lcd_cntrst;
    DisplayBase Display;
    Canvas2D_ContextClass canvas2d;
    graphics_t *graphics;
    LCD();
    static LCD instance;
    void Wait_Vsync(const int32_t wait_count);
    void Swap_FrameBuffer();
    void Update_LCD_Display();
    
public:
    static LCD *singleton() {
        return &instance;
    }
    void start();
    void stop();
    void drawImage(const graphics_image_t *image, int_t minX, int_t minY) {
//        Swap_FrameBuffer();
        frame_buffer_info.draw_buffer_index ^= 1;
        R_GRAPHICS_DrawImage(graphics, image, minX, minY);
        R_GRAPHICS_Finish(graphics);
        Display.Graphics_Read_Change(DisplayBase::GRAPHICS_LAYER_0,
                                     (void *)frame_buffer_info.buffer_address[frame_buffer_info.draw_buffer_index]);
//        Update_LCD_Display();
    }
    void drawImage(const graphics_image_t *image) {
        drawImage(image, 0, 0);
    }
};

#endif

