#ifndef __MovFile__
#define __MovFile__

#include <stdio.h>
#include <stdint.h>
#include "CppStandardHelper.hpp"

class MovFile {
    union __attribute__((packed)) Buffer {
        uint8_t  array[4];
        uint32_t value;
    };
    static constexpr int bufSize = 32;
    static uint32_t frameSizes[bufSize];
    static uint32_t audioSizes[bufSize];
    static MovFile singleton;
    MovFile();
    FILE *file;
    uint32_t numOfFrames;
    uint32_t *frameSizesP;
    uint32_t *audioSizesP;
    uint32_t stszAddress;
    uint32_t stcoAddress;
    uint32_t lastFrameAddress;
    int availableCount;
    void search(uint32_t pattern);
    void fillCaches();
    
public:
    static MovFile *sharedFile() {
        return &singleton;
    }
    void start(FILE *f);
    bool read(char *videoBuf, char *audioBuf, uint32_t *audioSize);
};

#endif

