#ifndef __MovPlayer__
#define __MovPlayer__

#include "rtos.h"
#include "LCD.hpp"
#include "R_BSP_Ssif.h"
#include "MovFile.hpp"
#include "CppStandardHelper.hpp"

class MovPlayer {
public:
    static constexpr int BufferLength = 20;
    typedef mbed::Callback<int32_t (void * const, uint32_t, const rbsp_data_conf_t *)> AudioCallback;
    
private:
    struct VideoBuffer {
        char MBED_ALIGN(0x20) buf[65535];
    };
    struct AudioBuffer {
        char MBED_ALIGN(4) buf[0x1B90];
        uint32_t size;
    };
    static VideoBuffer videoBuf[BufferLength];
    static AudioBuffer __attribute__((section("NC_BSS"))) audioBuf[BufferLength];
    static MovPlayer singleton;
    static unsigned char audioThreadStack[DEFAULT_STACK_SIZE];
    rtos::Thread audioThread;
    rtos::RtosTimer frameTimer;
    rtos::Semaphore frameSemaphore;
    rtos::Queue<VideoBuffer, BufferLength - 2> videoQueue;
    MovFile *mov;
    AudioCallback output;
    volatile uint32_t queueTimeout;
    MovPlayer();
    void frameTimerCallback();
    void audioProcessor();
    
public:
    static MovPlayer *defaultPlayer() {
        return &singleton;
    }
    void play(MovFile *mov, LCD *lcd, AudioCallback callback);
};

#endif

