#include "mbed.h"
//#include "cstdlib.h"
//#include "rtos.h"
#include "uLCD_4DGL.h"
#include <string>
#include <list>
#include <mpr121.h>

#define YELLOW 0xFFFF00
#define PURPLE 0x800080
#define ORANGE 0xFFA500
#define Color1 RED
#define Color2 BLUE
#define Color3 ORANGE
#define Color4 GREEN
#define Color5 PURPLE
#define Color6 YELLOW


uLCD_4DGL uLCD(p28, p27, p29); // create a global lcd object

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);


// Create the interrupt receiver object on pin 26
InterruptIn interrupt(p26);

// Setup the Serial to the PC for debugging
//Serial pc(USBTX, USBRX);

// Setup the i2c bus on pins 28 and 27
I2C i2c(p9, p10);

// Setup the Mpr121:
// constructor(i2c object, i2c address of the mpr121)
Mpr121 mpr121(&i2c, Mpr121::ADD_VSS);

volatile int keypress;

void fallInterrupt() {
    int key_code=0;
    int i=0;
    int value=mpr121.read(0x00);
    value +=mpr121.read(0x01)<<8;
    // LED demo mod by J. Hamblen
    //pc.printf("MPR value: %x \r\n", value);
    i=0;
    // puts key number out to LEDs for demo
    for (i=0; i<12; i++) {
        if (((value>>i)&0x01)==1) key_code=i+1;
        }
   // led4=key_code & 0x01;
  //  led3=(key_code>>1) & 0x01;
  //  led2=(key_code>>2) & 0x01;
  //  led1=(key_code>>3) & 0x01;
    keypress = key_code;
       
}


typedef struct Card
{
    int Color;
    int x;
    int y;
    int Matched;
}Card;

typedef struct Deck
{
    Card Cards[12];
}Deck;



int Score1,Score2;
int Used[] = {255,255,255,255,255,255,255,255,255,255,255,255};

int RColor(){
    return rand()%16777215;
}

void Print_Card(int x, int y, int Color){
    uLCD.filled_rectangle(x,y,x+15,y+20,Color);
    uLCD.rectangle(x,y,x+15,y+20,DGREY);
    //wait(.07);
}


void Shuffle(int count){
    for(int i = 0; i<count; i++){
        Print_Card(16,32,RColor());
        Print_Card(43,32,RColor());
        Print_Card(70,32,RColor());
        Print_Card(97,32,RColor());
        Print_Card(16,64,RColor());
        Print_Card(43,64,RColor());
        Print_Card(70,64,RColor());
        Print_Card(97,64,RColor());
        Print_Card(16,96,RColor());
        Print_Card(43,96,RColor());
        Print_Card(70,96,RColor());
        Print_Card(97,96,RColor());
        wait(.25);
    }
}
    
int ColorAssigner(int i){
        int color = (i%6)+1;
        if(color == 6) return Color6;
        if(color == 1) return Color1;
        if(color == 2) return Color2;
        if(color == 3) return Color3;
        if(color == 4) return Color4;
        if(color == 5) return Color5;
        return BLACK;
    }
        
    
void Setup(){
    Score1 = 0;
    Score2 = 0;
    uLCD.filled_rectangle(0,20,127,127,LGREY);
    uLCD.filled_rectangle(0,0,127,19,DGREY);
     uLCD.color(PURPLE);
        uLCD.locate(1,0);
        uLCD.printf("Turns = %d ", Score1);
     uLCD.color(ORANGE);
        uLCD.locate(1,1);   
        uLCD.printf("Matchs = %d ", Score2);
    Shuffle((rand()%5));
    Shuffle(1);
    Print_Card(16,32,LGREY);
    Print_Card(43,32,LGREY);
    Print_Card(70,32,LGREY);
    Print_Card(97,32,LGREY);
    Print_Card(16,64,LGREY);
    Print_Card(43,64,LGREY);
    Print_Card(70,64,LGREY);
    Print_Card(97,64,LGREY);
    Print_Card(16,96,LGREY);
    Print_Card(43,96,LGREY);
    Print_Card(70,96,LGREY);
    Print_Card(97,96,LGREY);
    
}

void Update_Score(){
    uLCD.color(PURPLE);
        uLCD.locate(1,0);
        uLCD.printf("Turns = %d ", Score1);
    uLCD.color(ORANGE);
        uLCD.locate(1,1);   
        uLCD.printf("Matchs = %d ", Score2);
//    uLCD.color(GREEN);
//        uLCD.locate(1,4);   
//        uLCD.printf("Key Code %d ", keypress);
}

volatile int count = 0;

void Flush(){
    for(int i = 0; i<12; i++){
        Used[i] = 255;
    }
    srand(count);
}

Deck Deal(Deck deck){
int temp;
int tempc;
Flush();
tempc = rand();
//go = 1;
    for(int i = 0; i<12; i++){
       srand(tempc*count);
       tempc = tempc + rand();
       temp = rand()%12;
       for(int k = i; k>=0; k--){
            if(temp == Used[k]){
                temp = rand()%12;
                k = i;
            }
        }
       Used[i] = temp;
    }
    for(int c = 0; c<12; c++){
        deck.Cards[c].Color = ColorAssigner(Used[c]+1);
//        uLCD.color(RED); 
  //      uLCD.locate(2,c+2);
    //    uLCD.printf( "%d",Used[c]+1 );
      //  uLCD.color(BLUE); 
        //uLCD.locate(5,c+2);
        //uLCD.printf( "%d",((Used[c]+1)%6)+1 );
        
        
        
    }
    deck.Cards[0].x = 16;
    deck.Cards[0].y = 32;
    deck.Cards[0].Matched = 0;
    deck.Cards[1].x = 43;
    deck.Cards[1].y = 32;
    deck.Cards[1].Matched = 0;
    deck.Cards[2].x = 70;
    deck.Cards[2].y = 32;
    deck.Cards[2].Matched = 0;
    deck.Cards[3].x = 97;
    deck.Cards[3].y = 32;
    deck.Cards[3].Matched = 0;
    deck.Cards[4].x = 16;
    deck.Cards[4].y = 64;
    deck.Cards[4].Matched = 0;
    deck.Cards[5].x = 43;
    deck.Cards[5].y = 64;
    deck.Cards[5].Matched = 0;
    deck.Cards[6].x = 70;
    deck.Cards[6].y = 64;
    deck.Cards[6].Matched = 0;
    deck.Cards[7].x = 97;
    deck.Cards[7].y = 64;
    deck.Cards[7].Matched = 0;
    deck.Cards[8].x = 16;
    deck.Cards[8].y = 96;
    deck.Cards[8].Matched = 0;
    deck.Cards[9].x = 43;
    deck.Cards[9].y = 96;
    deck.Cards[9].Matched = 0;
    deck.Cards[10].x = 70;
    deck.Cards[10].y = 96;
    deck.Cards[10].Matched = 0;
    deck.Cards[11].x = 97;
    deck.Cards[11].y = 96;
    deck.Cards[11].Matched = 0;
return deck;
}
    

//Deck New_deck;


int main() {
    
    interrupt.fall(&fallInterrupt);
    interrupt.mode(PullUp);
    uLCD.baudrate(3000000);
    
    
    int Turn = 0;
    int Reset = 0;
    Deck deck;
    int showing = 0;
    int show1 = 0;
    int show2 = 0;
    int tempress = 0;
    while(1) {
        
        if(Turn == 0 | Reset == 1){
            
            Setup();
            Turn =0;
        }
        if(Turn == 0){
            
            deck = Deal(deck);
            Turn++;
        }
        
         if (Score2 == 6 and keypress != 0) {count=count+Turn; Turn = 0; Score2 = 0;}
        if (Score2 <6){ 
        Score1 = Turn;
        Update_Score();
    //    if(Turn == 5){
    //    for(int i = 0; i < 12; i++){
    //        if(deck.Cards[0].Matched == 0){
    //            Print_Card(deck.Cards[i].x,deck.Cards[i].y,deck.Cards[i].Color);
                
    //        }
    //    }wait(3);}
        
   //   uLCD.color(PURPLE);
  //    uLCD.locate(1,14);
//uLCD.printf("%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d", Used[0],Used[1],Used[2],Used[3],Used[4],Used[5],Used[6],Used[7],Used[8],Used[9],Used[10],Used[11]);
        //while(1);
//Score2 = Turn/3; 
     
           /*     uLCD.color(GREEN);
                uLCD.locate(1,7);
                uLCD.printf( "%d", showing);
              //  wait(.5);
                uLCD.locate(1,8);
                uLCD.printf( "%d", show1);
            //    wait(.5);
                uLCD.locate(1,9);
                uLCD.printf( "%d", show2);
           //     wait(.5); */
      /*  uLCD.color(GREEN); 
        uLCD.locate(1,11);
        uLCD.printf( "show 1 %d",show1 );
        uLCD.locate(1,12);
        uLCD.printf( "show 2 %d",show2 );
        uLCD.locate(1,13);
        uLCD.printf( "showing %d",showing );
        uLCD.locate(1,10);
        uLCD.printf( "Key %d",keypress );
        uLCD.locate(1,9);
        uLCD.printf( "Last Key %d",tempress ); 
      */  

        
        
        if(showing < 2 and tempress != keypress){
        if(keypress !=0 ){
            if(deck.Cards[keypress-1].Matched == 0){
            if (show1 != keypress){ 
                Print_Card(deck.Cards[keypress-1].x,deck.Cards[keypress-1].y,deck.Cards[keypress-1].Color);
                showing++;
                if(show1 != 0 ) show2 = keypress;
                if(show1 == 0 )show1 = keypress;
                Update_Score();
            }
            }
        }
        }
        
                
        
      //  Update_Score();
        if(showing == 2){
            wait(.3);   
            if(deck.Cards[show1-1].Color == deck.Cards[show2-1].Color){ 
                deck.Cards[show1-1].Matched = 1;
                deck.Cards[show2-1].Matched = 1;
                Print_Card(deck.Cards[show1-1].x,deck.Cards[show1-1].y,DGREY);
                wait(.1);
                Print_Card(deck.Cards[show2-1].x,deck.Cards[show2-1].y,DGREY);
                Score2++;
            }else{
                Print_Card(deck.Cards[show1-1].x,deck.Cards[show1-1].y,LGREY);
                wait(.1);
                Print_Card(deck.Cards[show2-1].x,deck.Cards[show2-1].y,LGREY);
            }
            show1 = 0;
            show2 = 0;
            showing = 0;
            Turn++;
            Update_Score();
            wait(.3);
        }
                
        //if(Turn== 25)Turn=0;
        //uLCD.filled_rectangle(4,4,19,24,DGREY);
        tempress=keypress;
        count++;
        }else  Shuffle(rand()%3);   
    }
}
