#include "mbed.h"              
 

 #if !DEVICE_ANALOGOUT
#error You cannot use this example as the AnalogOut is not supported on this device.
#else
AnalogOut my_output(PA_4);
#endif


AnalogIn analog0_value(D11);
AnalogIn analog1_value(A0);


#define KP              (1.0)
#define KI              (0.02)
#define Cylinder_mass   (0.2799)     //Cylinder mass and additional weight
#define Beem_mass       (0.857+0.4)
#define Gravity         (9.80665)
#define Spring_Konstant (0.01388)
#define Natural_length  (0.295)
#define Initial_length  (0.145)
#define Area            (8.0)           //Pressure receiving area
#define Beem_length     (0.145)
#define COG             (0.0628)        //Center of gravity
 
int main() {
    
    printf("ok\n");
    
    double DISTANCE;
    double PRESSURE;
    double Pressure_target;
    double distance;
    double pressure;
    
    int Pressure_diff;
    int Pressure_integral;
    double control_value;
    
    double PtoBit = 66*1000/65535;  //66 kPa / 65535 bit
    
    while(1)
    {
        DISTANCE = analog0_value.read();
        PRESSURE = analog1_value.read();
    
        distance = 4*DISTANCE+0.2;
        pressure = PRESSURE*5.07;
        
        Pressure_target = ((Cylinder_mass * COG/Beem_length + Beem_mass ) * Gravity - Spring_Konstant * (Initial_length - distance )) / Area * 1000.0;
    
        Pressure_diff = Pressure_target - pressure;
        
        control_value = (double)(KP * Pressure_diff + KI * Pressure_integral) / PtoBit;
        
        if(control_value >= 0 && control_value <= 1689){
           my_output.write_u16(1689);
       }else if(control_value > 1689 && control_value <= 65535){
           my_output.write_u16(control_value);
       }else if(control_value > 65535){
           my_output.write_u16(65535);
       }else if(control_value < 0){
           my_output.write_u16(0);
       }
       
       Pressure_integral+= Pressure_diff; 
        
        printf("D=%f",distance);
        printf("P=%f",pressure);
        printf("Pt=%f",Pressure_target);
        printf("V=%f\n",control_value);
    }
    
}