#include "mbed.h"
#include "Servo.h"

PwmOut fan(PB_10); //ventilador
DigitalOut heater(PB_5); //calentador
InterruptIn inicio(USER_BUTTON); //boton led tarjeta
DigitalOut led(LED1); //led tarjeta

Servo gate_1(PB_3);
Servo gate_2(PA_10);

I2C tempsensor(PB_4,PA_8);   /// Recursos para el uso de I2C
InterruptIn alarma(PB_10);//alarma
Serial pc(USBTX, USBRX); //tx, rx

//recursos para uso de SPI
SPI spi(PA_7, PA_6, PA_5); // mosi, miso, sclk
DigitalOut cs(PB_6);

const int addr = 0x90;  //Dirección I2C
char config_t[3]; // Arreglo que apunta al pointer register y los registros de configuración
char temp_read[2]; // Arreglo para la lectura de temperatura
float temp; //Variable que almacena la conversión numérica de los valores

void alerta(void);
void calentar(void);
void temp80(void);
void temp60(void);
void temp30(void);
void temp25(void);



int main()

{
    alarma.rise(&temp80);
    inicio.fall(&calentar);
    cs = 1;

    gate_1=1;
    gate_2=0;

    config_t[0] = 0x01; // Pointer register ----> Registro de configuración
    config_t[1] = 0x62; // Registro de configuración 1
    config_t[2] = 0xA0; // Registro de configuración 2
    tempsensor.write(addr, config_t, 3); // Etapa de escritura

    config_t[0] = 0x03; // HIGH TEM
    config_t[1] = 0x32; // Registro de configuración 1
    config_t[2] = 0x00; // Registro de configuración 2
    tempsensor.write(addr, config_t, 3); // Etapa de escritura

    config_t[0] = 0x00; // Pointer register ----> registro de lectura
    tempsensor.write(addr, config_t, 1);

    fan.period(4.0f);

    pc.printf("welcome \n\r en espera para iniciar \n\r");

    while(1) {

        tempsensor.read(addr, temp_read, 2);
        temp = 0.0625 * (((temp_read[0] << 8) + temp_read[1]) >> 4);
        pc.printf("Temp = %.2f degC\n\r", temp);

        //ENVIO DE DATOS PARA GRAFICAR
        cs = 0;
        spi.format(8,3);
        spi.frequency(1000000);

        spi.write(0x8F);

        int whoami = spi.write(0x00);
        printf("WHOAMI register = 0x%X\n", whoami);
        cs = 1;

    }
}

void temp80 (void)
{
    pc.printf("80 Grados ALERTA!!!\n\r");
    heater=0;
    fan.write(1.0f);
    gate_1=0;
    gate_2=0;
    while (temp>=60) {}
    void tem60(void);

}

void tem60(void)
{
    heater=0;
    fan.write(0.5f);
    while (temp>=30) {}
    void tem30(void);

}
void temp30(void)
{
    heater=0;
    fan.write(0.25f);
    while (temp>=25) {}
    void tem25(void);

}
void temp25(void)
{
    fan.write(0.0f);
    gate_1=1;
    gate_2=1;
    wait(0.5);
    heater=1;
}

void calentar(void)
{
    wait(5);
    gate_2=1;
    wait(0.5);
    heater=1;
}
