#include "buzzer.h"
#include "mbed.h"

using namespace mbed;
Beep::Beep(PinName pin) : _pwm(pin)
{
    _pwm.write(0.0);
}

void Beep::nobeep()
{
    _pwm.write(0.0);
}

void Beep::beep(float frekvencija, float vrijeme)
{

    _pwm.period(1.0/frekvencija);
    _pwm.write(0.5);            // 50% radnog ciklusa
    toff.attach(this,&Beep::nobeep, vrijeme);   // vrijeme za isključenje
}