#ifndef MBED_LCDCLASS_H
#define MBED_LCDCLASS_H

#include "mbed.h"

class lcdClass : public Stream {
public:
    lcdClass(PinName rs, PinName e, PinName d4, PinName d5, PinName d6, PinName d7);

#if DOXYGEN_ONLY
    int putc(int c);
    int printf(const char* format, ...);
#endif
    void locate(int column, int row);
    void cls();
protected:
    virtual int _putc(int value);
    virtual int _getc();
    
    void character(int column, int row, int c);
    void writeByte(int value);
    void writeCommand(int command);
    void writeData(int data);

    DigitalOut _rs, _e;
    BusOut _d;

    int _column;
    int _row;
};

#endif