#include "lcdClass.h"
#include "mbed.h"

float W = 0.000040; float W1 = 0.00164;
lcdClass::lcdClass(PinName rs, PinName e, PinName d4, PinName d5, PinName d6, PinName d7) : _rs(rs), _e(e), _d(d4, d5, d6, d7){
    _e  = 1; _rs = 0;                                                   //E pin high, RS set to 0 for instruction register
    wait(0.015);                                                        //Wait for VCC to rise
    for (int i=0; i<3; i++) {writeByte(0x3);wait(W1);}                  //Send initialisation value, 0x3.
    writeByte(0x2); wait(W);                                            //Set Bus Width (4-bit)
    writeCommand(0x28);                                                 //4-bit mode, 2-line, 5x7 font
    writeCommand(0x0C);                                                 //No Cursor or Blink
    writeCommand(0x6);                                                  //Automatic Increment, No Display Shift
    cls();                                                              //Ensure screen is cleared
}

void lcdClass::character(int column, int row, int c) {
    int a = 0x80 + (row * 0x40) + column;                               
    writeCommand(a); writeData(c);}

void lcdClass::cls() {writeCommand(0x01); wait(W1); locate(0, 0);}      //Send Clear Display Command, Set location back to column 0, row 0

void lcdClass::locate(int column, int row) {_column = column;   _row = row;}    //Set protected column and row to input column and row

int lcdClass::_putc(int value) {
    if (value == '\n') {
        _column = 0; _row++;                            //If input character is \n, set column to 0, increment row.
        if (_row >= 2) {_row = 0;}                          //If row is 2, set row to 0
    }         
    else {
        character(_column, _row, value);_column++;      //Else write the input value to the 
        if (_column >= 16) {
            _column = 0;_row++;
            if (_row >= 2) {_row = 0;}
        }
    }
    return value;
}
int lcdClass::_getc() {return -1;}
void lcdClass::writeByte(int value) {
    _d = value >> 4;    wait(W);
    _e = 0;             wait(W);
    _e = 1;
    _d = value >> 0;    wait(W);
    _e = 0;             wait(W);
    _e = 1;
}

void lcdClass::writeCommand(int command) {_rs = 0; writeByte(command);}
void lcdClass::writeData(int data)       { _rs = 1; writeByte(data);}