#include "mbed.h"
#include "EthernetInterface.h"
#include "HTTPServer.h"
#include "FsHandler.h"
#include "RpcHandler.h"
#include "rtos.h"
#include <string>
#include <string.h>
#include "mbed_rpc.h"
#include <time.h>
#include "defines.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);

//Start IR
#include "ReceiverIR.h"
#include "TransmitterIR.h"
#include "IR.h"
//END IR


// Start DB
#include <stdio.h>
#include <stdlib.h>
#include "SDFileSystem.h"
#include "db.h"
// End DB

Serial pc(USBTX, USBRX);
Serial HC06(PTC15,PTC14); // BT TX,RX

SDFileSystem sd(PTE3,PTE1,PTE2,PTE4, "sd"); // the pinout on the mbed

//Function that calls the function that lists users
TCPSocketConnection socket;

char username[]="root\r\n";
char password[]="password\r\n";
char chngpwd[]="nvram set wl_wpa_psk=PleaseVote1forkamoona\r\n";
char getusers[]="cat /proc/net/arp\r\n";
char getpwd[]="nvram get wl_wpa_psk\r\n";

int main()
{   
    char *randptr = (char*) malloc (10);
    char *Rand = randstring(10,randptr);
    printf ("Random String out of function is %s\n",Rand);
   
    // Telnet related
    HC06.baud(9600);
    HC06.printf("Bluetooth connected. Please send an IR command!\n");
    printf("Bluetooth connected. Please send an IR command!\n");
    //  mkdir("/sd/mydir", 0777);
    mkdir("/sd/Wifi", 0777);
    printf("Created the /sd/Wifi directory in SD card\n");   
    
    FILE *fp = fopen("/sd/Wifi/sdtest.txt", "w");
    if(fp == NULL) {
        error("Could not open file for write\n");
    }
    fprintf(fp, "Opened SD for to test!");
    fclose(fp); 
 
    printf("Printed in /sd/Wifi/sdtest.txt successfullly !\n");
    
    EthernetInterface eth;
    led1 = 1;
    led2 = 1;
    eth.init ("192.168.2.9","255.255.255.0","0.0.0.0");
    eth.connect();
   
    printf("IP: %s\n \r", eth.getIPAddress());
    printf("Setup OK\n \r");

    // DB Init
    mkdir("/sd/SmartRemote", 0777);
    printf("Hello World!\n");   
 
    mkdir("/sd/mydir", 0777);
    
    fp = fopen("/sd/mydir/sdtest.txt", "w");
    if(fp == NULL) {
        error("Could not open file for write\n");
    }
    fprintf(fp, "Hello fun SD Card World!");
    fclose(fp); 
 
    printf("Goodbye World!\n");

    char tuple_code[128];
    char tuple_name[128];
    char tuple_bitlength[128];
    char tuple_format[128];
    char temp[20];
    int n;
    //End DB init

    //IR Init
    uint8_t buf1[32];
    uint8_t buf2[32];
    int bitlength1;
    int bitlength2;
    char tempstr[3];
    char bufc1[2]; //For IR command comparison
    RemoteIR::Format format;
    printf("Constructor Initialized\n");
    memset(buf1, 0x00, sizeof(buf1));
    memset(buf2, 0x00, sizeof(buf2));
    //END IR Init

    printf("Listening...\n \r");
    int Learn = 1;
    
    //Listen indefinitely
    while(true)
    {
        if (Learn) 
        {
            // Debug LED
            led1=0;
            // Receive the code
            bitlength1 = receive(&format, buf1, sizeof(buf1));
            if (bitlength1 < 0) 
            {
                printf("Continuing\n");
                continue;
            }
            display_status("RECV", bitlength1);
            display_data(buf1, bitlength1);
            display_format(format);
            
            printf("Converting Bytes ...\n");
            sprintf(bufc1,"%02X",buf1[0]);
            printf("%s\n",bufc1);
         
            if (strcmp(bufc1,"4B") == 0)
            {
                printf("Running task 0 ...\n");
                led1 = 1;
                telnet_task(0);
            }
            else if (strcmp(bufc1,"71") == 0)
            {
                printf("Running task 1 ...\n");
                led1 = 1;
                telnet_task(1);
            }
            else if (strcmp(bufc1,"E3") == 0)
            {
                printf("Running task 2 ...\n");
                led1 = 1;
                telnet_task(2);
            }
        }
        // Reset
        led1 = 1;
        //    Learn = 0;
        // Set up the variables
        
        sprintf(tuple_code,         "%X", buf1);
        sprintf(tuple_bitlength,    "%d", bitlength1);
        sprintf(tuple_format,       "%d", format);
        for (int i = 0; i < 10; i++) 
        {
            if (tuple_name[i] == '~') tuple_name[i] = ' ';
        }

        const int n = bitlength1 / 8 + (((bitlength1 % 8) != 0) ? 1 : 0);
        strcpy(tuple_code, "");
        for (int i = 0; i < n; i++) 
        {
            sprintf(temp, "%02X", buf1[i]);
            strcat(tuple_code, temp);
        }
    }
    eth.disconnect();
    return 0;
}

void cursor(char *check, bool sd,char c)
{
    printf("Check = %s\n", check);
    printf("sd = %d\n", sd);
    printf("c = %c\n", c);
    char BTbuf[100], title[100];
    char shift[strlen(check)];
    char buf[] = " ";
    bool res=false;
    FILE *fp;
    if (sd)
    {   
        if (c=='u')
            fp=fopen("/sd/Wifi/users.txt", "w");
        else if (c=='p')
            fp=fopen("/sd/Wifi/pass.txt", "w");    
        if(fp == NULL) 
        {
            error("Could not open file for write\n");       
        }
    }
    int negState = 0;
    int negCnt = 0;
    char negAns[3];
    
    while (res==false)
    {
        int n = socket.receive(buf, 1);
        
        if (negState == 1 && negCnt < 3)
        {
            if (buf[0] == DO)
            {
                negAns[negCnt] = WONT;
                negCnt ++;
            }
            else
            {
                negAns[negCnt] = buf[0];
                negCnt ++;
            }
        }
        else if (negCnt >= 3)
        {
            negCnt = 0;
            negState = 0;
            socket.send_all(negAns, sizeof(negAns));
        }
    
        if (buf[0] == IAC)
        {
            negCnt = 0;
            negState = 1;
            negAns[negCnt] = IAC;
            negCnt ++;
        }
        
        printf("Last received is %s\n",buf);
        
        if (negState == 0)
        {
            if (sd)
            {
                fprintf(fp, "%c",buf[0]);
            }
            printf("%c",buf[0]);
            HC06.printf("%c",buf[0]);
            for (int k=0;k<strlen(check);k++)
                shift[k]=shift[k+1];
            shift[strlen(check)]=buf[0];
            if (strcmp(shift,check) == 0)
            {
                printf("Prompt Reached!\n");
                res = true;
            }
        }
    } 
    
    if (sd)
    {
        printf("Closing file on SD...\n");
        fgets(BTbuf, sizeof BTbuf, fp); /* expect string like "title: TITLE WITH SPACES" */
        sscanf(buf, "%*s %99[^\n]", title);
        HC06.printf("%s",BTbuf);
        printf("%s",BTbuf);
        HC06.printf("%s",title);
        printf("%s",title);
        fclose(fp);
    }
}

/*void lsusrsf(void) //callstring is a sting passed to be sent by the TCP socket
{
    socket.send_all("cat /proc/net/arp\r\n", sizeof("cat /proc/net/arp\r\n") - 1);
    printf("Users listed in memory card: \n Exited lsusersf function, after \n");
} */   

void telnet_task(int taskNumber)
{
    while (socket.connect(ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT) < 0) {
        printf("Unable to connect to (%s) on port (%d)\n", ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT);
        wait(1);
    }
    //char negot[]={255,253,1,255,254,31};
    //socket.send_all(negot, sizeof(negot) - 1);
    
    int requirelogin = 1;
    
    if (requirelogin == 1)
    {
        printf("Entering function: \n");
        char log[] = login;
        cursor(&log[0],false,'a');
        printf("Exiting function: \n");
        socket.send_all(username, sizeof(username) - 1); 
        printf("Sent username!\n");

        printf("Entering function: \n");
        char paspmt[] = passcurs;
        cursor(&paspmt[0],false,'a');
        printf("Exiting function: \n");
        socket.send_all(password, sizeof(password) - 1);  
        printf("Sent password!\n");
    }
    
    printf("Entering function: \n");
    char curspmt[] = cursr;
    cursor(&curspmt[0],false,'a');
    printf("Exiting function: \n");

    switch (taskNumber)
    {
    case 0:    // Get users
        printf("Entering Case 0 function: \n");
        socket.send_all(getusers, sizeof(getusers) - 1);  
        cursor(&curspmt[0],true,'u');
        
        break;
    
    case 1:     // Change password
        printf("Entering Case 1 function: \n");
        socket.send_all(chngpwd, sizeof(chngpwd) - 1);
        
        cursor(&curspmt[0],false,'a');
        printf("Sent chngpwd!\n");
        break;
    case 2:     // Get password
        printf("Entering Case 2 function: \n");
        socket.send_all(getpwd, sizeof(getpwd) - 1); 
        cursor(&curspmt[0],true,'p'); 
        printf("getpwd!\n");
        break;    
    }
    socket.close();
}


char *randstring(size_t length, char *randptr)
{
    static char charset[] = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789,.-#'?!";        
    char tmpStr[length+1];
    srand (time(NULL));
    if (length)
    {
        for (int n = 0;n < length;n++) 
        {            
            int RndNum = rand();
            int key = RndNum % (int)(sizeof(charset) -1);
            tmpStr[n] = charset[key];
        }
        tmpStr[length] = '\0';
        printf ("Random String in function %s\n",tmpStr); 
    }
    memmove(randptr,tmpStr,length);
    return randptr;
}