/**
 ******************************************************************************
 * @file    main.cpp
 * @author  AST / EST
 * @version V0.0.1
 * @date    14-August-2015
 * @brief   Simple Example application for using the X_NUCLEO_IKS01A1 
 *          MEMS Inertial & Environmental Sensor Nucleo expansion board.
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; COPYRIGHT(c) 2015 STMicroelectronics</center></h2>
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *   1. Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 *   3. Neither the name of STMicroelectronics nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************
*/ 

/* Includes */
#include "mbed.h"
#include "x_nucleo_iks01a1.h"

/* Instantiate the expansion board */
static X_NUCLEO_IKS01A1 *mems_expansion_board = X_NUCLEO_IKS01A1::Instance(D14, D15);

/* Retrieve the composing elements of the expansion board */
static GyroSensor *gyroscope = mems_expansion_board->GetGyroscope();
static MotionSensor *accelerometer = mems_expansion_board->GetAccelerometer();
static MagneticSensor *magnetometer = mems_expansion_board->magnetometer;
static HumiditySensor *humidity_sensor = mems_expansion_board->ht_sensor;
static PressureSensor *pressure_sensor = mems_expansion_board->pt_sensor;
static TempSensor *temp_sensor1 = mems_expansion_board->ht_sensor;
static TempSensor *temp_sensor2 = mems_expansion_board->pt_sensor;

/* Helper function for printing floats & doubles */
static char *printDouble(char* str, double v, int decimalDigits=2)
{
  int i = 1;
  int intPart, fractPart;
  int len;
  char *ptr;

  /* prepare decimal digits multiplicator */
  for (;decimalDigits!=0; i*=10, decimalDigits--);

  /* calculate integer & fractinal parts */
  intPart = (int)v;
  fractPart = (int)((v-(double)(int)v)*i);

  /* fill in integer part */
  sprintf(str, "%i.", intPart);

  /* prepare fill in of fractional part */
  len = strlen(str);
  ptr = &str[len];

  /* fill in leading fractional zeros */
  for (i/=10;i>1; i/=10, ptr++) {
    if(fractPart >= i) break;
    *ptr = '0';
  }

  /* fill in (rest of) fractional part */
  sprintf(ptr, "%i", fractPart);

  return str;
}

/* Green LED*/
DigitalOut myled(LED1);
/* Blue Button */
DigitalIn mybutton(USER_BUTTON);

/* Timer instance */
Timer t;

/* Millisecond counter*/
//Ticker ms_tick;

/* Serial communication */
Serial uart2Comm(USBTX, USBRX);

/* Function prototypes */


/* Simple main function */
int main() {
  uint8_t id;
  float value1, value2;
  char buffer1[32], buffer2[32];
  int32_t axes_acc[3], axes_gyro[3]={0}, axes_mag[3]={0};
  uint32_t millis, tickLast, tickCurrent; 
  uint32_t measurementPrintRequest, i;
  
  tickLast = 0;
  tickCurrent = 0;
  measurementPrintRequest = 0;
 // axes_gyro[3] = {0,0,0};
 // axes_mag[3] = {0, 0, 0};
  
  /* UART2 - Set baud rate to 115200 baud */
  //uart2Comm.baud(115200);
  uart2Comm.baud(230400);
  
  //uxMsCount = 0;
//  ms_tick.attach(&memsSample, 0.1); /*!< Every 100 Milliseonds*/
  
  //set_time(1546300800);  // Set RTC time to Wed, 1 Jan 2019 00:00:00
  t.start();        /*!< Timer Start */
  
  /* Print Starting Info message*/
    printf("\r\n--- Starting new run ---\r\n");
    
    humidity_sensor->read_id(&id);
    printf("HTS221  humidity & temperature    = 0x%X\r\n", id);
    pressure_sensor->read_id(&id);
    printf("LPS25H  pressure & temperature    = 0x%X\r\n", id);
    magnetometer->read_id(&id);
    printf("LIS3MDL magnetometer              = 0x%X\r\n", id);
    gyroscope->read_id(&id);
    printf("LSM6DS0 accelerometer & gyroscope = 0x%X\r\n", id);
    
    /* print current temperature and humidity */
    temp_sensor1->get_temperature(&value1);
    humidity_sensor->get_humidity(&value2);
    printf("HTS221: [temp] %7s C,   [hum] %s%%\r\n", printDouble(buffer1, value1), printDouble(buffer2, value2));
    
    temp_sensor2->get_fahrenheit(&value1);
    
    pressure_sensor->get_pressure(&value2);
    printf("LPS25H: [temp] %7s F, [press] %smbar\r\n", printDouble(buffer1, value1), printDouble(buffer2, value2));
    
    printf("--------\r\n");
  
  /*Print CSV Header*/
  //printf ("\r\nTimeStamp,Acc X,Acc Y,Acc Z,Gyro X,Gyro Y,Gyro Z,Mag X,Mag Y,Mag Z");
  printf ("\r\nTimeStamp,Acc X,Acc Y,Acc Z");
  
  wait(3);
 
  while(1) {
    tickCurrent = t.read_ms();
    if((tickCurrent - tickLast) >= 4 ){         // Ts = 4 ms
        tickLast = tickCurrent;
        
        myled = !myled;     // Toggle NUCLEO LD2
        
        /* Take samples from MEMS sensors */
        accelerometer->get_x_axes(axes_acc);
        //gyroscope->get_g_axes(axes_gyro);
        //magnetometer->get_m_axes(axes_mag);
        
        millis = t.read_ms();       //!<Timestamp
        
        measurementPrintRequest = 1;
    }
    if (mybutton == 0){
//        measurementPrintRequest = 0;    /*!< Disable printing */
        millis = 0;                     /*!< Pripare data for all-zero row */
        for(i=0;i<3;i++){
            axes_acc[i] = 0;
            axes_gyro[i] = 0;
            axes_mag[i] = 0;
        }
    }
    if (measurementPrintRequest == 1){
  /*      printf("\r\n%7ld,%7ld,%7ld,%7ld,%7ld,%7ld,%7ld,%7ld,%7ld,%7ld", millis,\
                                axes_acc[1],axes_acc[0],axes_acc[2],\
                                axes_gyro[0],axes_gyro[1],axes_gyro[2],\
                                axes_mag[0],axes_mag[1],axes_mag[2]);                   */
        printf("\r\n%7ld,%7ld,%7ld,%7ld", millis, axes_acc[1],axes_acc[0],axes_acc[2]);
        //printf("%7ld,%7ld,%7ld,", axes_gyro[0], axes_gyro[1],axes_gyro[2]);
        //printf("%7ld,%7ld,%7ld", axes_mag[0], axes_mag[1],axes_mag[2]);
        measurementPrintRequest = 0;
    }
    
//    wait(0.001);      //wait() is interrupting everithing else and putting MCU to sleep
  }
}
