#include "Navigator.h"

Navigator::Navigator(Menu *root, SerialLCD *lcd) : activeMenu(root), lcd(lcd) 
{
    bottom = root->selections.size();
    cursorPos = 0;
    cursorLine = 1;
    button = 0;
    lastButton = 0;
    setButtons();
    printMenu();
    printCursor();
}

DigitalIn pbUp(p21);
DigitalIn pbDown(p22);
DigitalIn pbSelect(p23);


void Navigator::setButtons()
{
    pbUp.mode(PullUp);
    pbDown.mode(PullUp);
    pbSelect.mode(PullUp);
}

void Navigator::printMenu()
{ 
    lcd->clear();
    if(bottom == 1){ // the current Menu only has one selection
        lcd->printf("%s", activeMenu->selections[0].selText);
    } else {
        if(cursorLine == 2){ 
            // moving down in menu
            lcd->printf("%s", activeMenu->selections[cursorPos-1].selText);
            lcd->setPosition(1,0); // Sparkfun Serial LCD based on PIC16LF88
            lcd->printf("%s", activeMenu->selections[cursorPos].selText);
        } else {
            // moving up in menu
            lcd->printf("%s", activeMenu->selections[cursorPos].selText);
            lcd->setPosition(1,0); // Sparkfun Serial LCD based on PIC16LF88
            lcd->printf("%s", activeMenu->selections[cursorPos+1].selText);
        }
    }
}

void Navigator::printCursor()
{   
     
    lcd->setPosition(0,0); // Sparkfun Serial LCD based on PIC16LF88
    if(cursorLine == 1){
        lcd->printf(">");
        lcd->setPosition(1,0); // Sparkfun Serial LCD based on PIC16LF88
        lcd->printf(" ");
    } else if(cursorLine == 2){
        lcd->printf(" ");
        lcd->setPosition(1,0); // Sparkfun Serial LCD based on PIC16LF88
        lcd->printf(">");
    }
}

void Navigator::poll()
{

    if(pbUp == 0){
        wait(0.2);
        moveUp();
    }
    if(pbDown == 0){
        wait(0.2);
        moveDown();
    }
    if(pbSelect == 0){
        wait(0.2);
        
        if(activeMenu->selections[cursorPos].fun != NULL){
            (activeMenu->selections[cursorPos].fun)();
        }
        
        if(activeMenu->selections[cursorPos].childMenu != NULL){
            activeMenu = activeMenu->selections[cursorPos].childMenu;
            bottom = activeMenu->selections.size();
            cursorPos = 0;
            cursorLine = 1;
            printMenu();
            printCursor();
        }
    }
    lastButton = button;
      
}

void Navigator::moveUp()
{
    if(cursorLine == 1){
        printMenu();
    } else if(cursorLine == 2){
        cursorLine = 1;
    }
    
    if(cursorPos != 0){
        cursorPos--;
        printMenu();
    }
    printCursor();
}

void Navigator::moveDown()
{
    if(cursorLine == 1){
        cursorLine = 2;
    } else if(cursorLine == 2){
        printMenu();
    }
    
    if(cursorPos != (bottom-1)){
        cursorPos++;
        printMenu();
    }
    printCursor();
}