#include "mbed.h"

Serial pc(USBTX,USBRX);

DigitalInOut pingPin(p18);

Timer tmr;

long microsecondsToInches(long microseconds);
long microsecondsToCentimeters(long microseconds);

int main() {
    while (1) {
        // establish variables for duration of the ping,
        // and the distance result in inches and centimeters:
        long duration, inches, cm;

        // The PING))) is triggered by a HIGH pulse of 2 or more microseconds.
        // Give a short LOW pulse beforehand to ensure a clean HIGH pulse:
        pingPin.output();
        pingPin = 0;
        wait_us(2);
        pingPin = 1;
        wait_us(5);
        pingPin = 0;

        // The same pin is used to read the signal from the PING))): a HIGH
        // pulse whose duration is the time (in microseconds) from the sending
        // of the ping to the reception of its echo off of an object.
        pingPin.input();

        // pulseIn
        while (!pingPin); // wait for high
        tmr.start();
        while (pingPin); // wait for low
        duration = tmr.read_us();

        // convert the time into a distance
        inches = microsecondsToInches(duration);
        cm = microsecondsToCentimeters(duration);

        pc.printf("in=%4d, cm=%4d\n", inches, cm);
        wait_ms(100);
    }
}

long microsecondsToInches(long microseconds) {
    // According to Parallax's datasheet for the PING))), there are
    // 73.746 microseconds per inch (i.e. sound travels at 1130 feet per
    // second).  This gives the distance travelled by the ping, outbound
    // and return, so we divide by 2 to get the distance of the obstacle.
    // See: http://www.parallax.com/dl/docs/prod/acc/28015-PING-v1.3.pdf
    return microseconds / 74 / 2;
}

long microsecondsToCentimeters(long microseconds) {
    // The speed of sound is 340 m/s or 29 microseconds per centimeter.
    // The ping travels out and back, so to find the distance of the
    // object we take half of the distance travelled.
    return microseconds / 29 / 2;
}