#ifndef MBED_PING_H
#define MBED_PING_H
#include "mbed.h"

/* Class: PING
 *  Abstraction for the PING Ultrasonic range finder
 *
 * Example:
 * > // Print measured distance
 * >
 * > #include "mbed.h"
 * > #include "PING.h"
 * >
 * > PING ping(p9);
 * >
 * > int main() {
 * >     while(1) {
 * >         printf("Measured : %.1f\n", ping.read());
 * >         wait(0.2);
 * >     }
 * > }
 */
class PING
{
// Public functions
public:
   /* Constructor: PING
    *  Create a PING object, connected to the specified pins
    *
    * Variables:
    *  trigger - Output to trigger the PING
    */
   PING(PinName trigger);

   /* Function: read
    *  A non-blocking function that will return the last measurement
    *
    * Variables:
    *  returns - floating point representation in cm.
    */
   float read(void);

   /* Function: read_in
    *  A non-blocking function that will return the last measurement
    *
    * Variables:
    *  returns - floating point representation in in.
    */
   float read_in(void);

   /* Function: operator float
    *  A short hand way of using the read function
    *
    * Example:
    * > float range = ping.read();
    * > float range = ping;
    * >
    * > if(ping.read() > 0.25) { ... }
    * > if(ping > 0.25) { ... }
    */
   operator float();

private :
   DigitalInOut _trigger;
   Timer _timer;
   Ticker _ticker;
   void _startRange(void);
   float _dist;
};

#endif