#include "mbed.h"
#include "sdram.h"
#include "savePower.h"

static int phy_write(unsigned int PhyReg, unsigned short Data)
{
    unsigned int timeOut;

    LPC_EMAC->MADR = DP83848C_DEF_ADR | PhyReg;
    LPC_EMAC->MWTD = Data;

    for(timeOut = 0; timeOut < MII_WR_TOUT; timeOut++) {     /* Wait until operation completed */
        if((LPC_EMAC->MIND & MIND_BUSY) == 0) {
            return 0;
        }
    }

    return -1;
}

DigitalOut cke(P2_24);
Ethernet eth;
DigitalOut p1_19(P1_19);
DigitalOut p2_18(P2_18);


void savePower(void)
{
    /*
    ------------------------------------------------------->
    Initialize SDRAM and set CKE 0 to make sure SDRAM is
    in power-down mode. CKE is also connected to a 1K5 pull
    down resistor
     */
    //  DigitalOut cke(P2_24);
    sdram_init();
    cke = 0; // set low not to draw any current

     /* ------------------------------------------------------->
    Initialize Ethernet by instantiating the Ethernet class
    The Ethernet interface doesn't contain a power-down
    method so we reimplement phy_write in this app and
    puts the PHY in power-down here
    */
    // Ethernet eth;
    
    phy_write(PHY_REG_BMCR, PHY_BMCR_PWR_DOWN);
    
    /*<-------------------------------------------------------
    must be low to disable U7 (STMPS2171STR)
    DigitalOut p1_19(P1_19);
    */
    p1_19 = 0;


    /* p2.18 connected to 1K5 pull-down resistor
    DigitalOut p2_18(P2_18);
    */
    p2_18 = 0;

}