//
// Academic License - for use in teaching, academic research, and meeting
// course requirements at degree granting institutions only.  Not for
// government, commercial, or other organizational use.
// File: envSignal.cpp
//
// MATLAB Coder version            : 3.3
// C/C++ source code generated on  : 13-Jul-2017 15:47:47
//

// Include Files
#include "envSignal.h"
#include "envSignal_emxutil.h"
#include "ifft.h"
#include "fft.h"

// Function Declarations
static float rt_hypotf(float u0, float u1);

// Function Definitions

//
// Arguments    : float u0
//                float u1
// Return Type  : float
//
static float rt_hypotf(float u0, float u1)
{
  float y;
  float a;
  float b;
  a = std::abs(u0);
  b = std::abs(u1);
  if (a < b) {
    a /= b;
    y = b * std::sqrt(a * a + 1.0F);
  } else if (a > b) {
    b /= a;
    y = a * std::sqrt(b * b + 1.0F);
  } else {
    y = a * 1.41421354F;
  }

  return y;
}

//
// Bandpass filter signal
// Arguments    : const emxArray_real32_T *x
//                const emxArray_real32_T *fir_coef
//                emxArray_real32_T *y
// Return Type  : void
//
void envSignal(const emxArray_real32_T *x, const emxArray_real32_T *fir_coef,
               emxArray_real32_T *y)
{
  emxArray_real32_T *b;
  int nx_m_nb;
  int naxpy;
  emxArray_real32_T *b_y1;
  int nb;
  unsigned int uv0[2];
  int nx;
  int k;
  int jp;
  int j;
  emxArray_real32_T *x_filt;
  emxArray_creal32_T *b_x;
  int b_x_filt[1];
  emxArray_real32_T c_x_filt;
  emxArray_creal32_T *c_x;
  emxInit_real32_T1(&b, 1);
  nx_m_nb = b->size[0];
  b->size[0] = x->size[1];
  emxEnsureCapacity((emxArray__common *)b, nx_m_nb, sizeof(float));
  naxpy = x->size[1];
  for (nx_m_nb = 0; nx_m_nb < naxpy; nx_m_nb++) {
    b->data[nx_m_nb] = x->data[x->size[0] * nx_m_nb];
  }

  emxInit_real32_T1(&b_y1, 1);
  nb = fir_coef->size[1];
  uv0[0] = (unsigned int)b->size[0];
  nx_m_nb = b_y1->size[0];
  b_y1->size[0] = (int)uv0[0];
  emxEnsureCapacity((emxArray__common *)b_y1, nx_m_nb, sizeof(float));
  nx = b->size[0];
  naxpy = b_y1->size[0];
  nx_m_nb = b_y1->size[0];
  b_y1->size[0] = naxpy;
  emxEnsureCapacity((emxArray__common *)b_y1, nx_m_nb, sizeof(float));
  for (nx_m_nb = 0; nx_m_nb < naxpy; nx_m_nb++) {
    b_y1->data[nx_m_nb] = 0.0F;
  }

  if (b->size[0] >= (fir_coef->size[1] << 1)) {
    for (k = 1; k <= nb; k++) {
      for (j = k; j <= nx; j++) {
        b_y1->data[j - 1] += fir_coef->data[k - 1] * b->data[j - k];
      }
    }
  } else {
    if (b->size[0] > fir_coef->size[1]) {
      nx_m_nb = b->size[0] - fir_coef->size[1];
    } else {
      nx_m_nb = 0;
    }

    jp = -2;
    for (k = 1; k <= nx_m_nb; k++) {
      jp++;
      for (j = 1; j <= nb; j++) {
        b_y1->data[jp + j] += b->data[jp + 1] * fir_coef->data[j - 1];
      }
    }

    naxpy = b->size[0] - nx_m_nb;
    for (k = nx_m_nb + 1; k <= nx; k++) {
      jp++;
      for (j = 1; j <= naxpy; j++) {
        b_y1->data[jp + j] += b->data[jp + 1] * fir_coef->data[j - 1];
      }

      naxpy--;
    }
  }

  emxFree_real32_T(&b);
  emxInit_real32_T(&x_filt, 2);
  nx_m_nb = x_filt->size[0] * x_filt->size[1];
  x_filt->size[0] = 1;
  x_filt->size[1] = b_y1->size[0];
  emxEnsureCapacity((emxArray__common *)x_filt, nx_m_nb, sizeof(float));
  naxpy = b_y1->size[0];
  for (nx_m_nb = 0; nx_m_nb < naxpy; nx_m_nb++) {
    x_filt->data[x_filt->size[0] * nx_m_nb] = b_y1->data[nx_m_nb];
  }

  emxFree_real32_T(&b_y1);
  emxInit_creal32_T(&b_x, 1);

  //  Compute the complex valued analytic signal using fourier transform
  //  method, with all negative frequency components set to zero
  // xAnalytic = hilbert(xfilt);
  b_x_filt[0] = x_filt->size[1];
  c_x_filt = *x_filt;
  c_x_filt.size = (int *)&b_x_filt;
  c_x_filt.numDimensions = 1;
  fft(&c_x_filt, b_x);
  naxpy = x_filt->size[1];
  nx_m_nb = naxpy >> 1;
  if ((naxpy & 1) == 0) {
    jp = nx_m_nb;
  } else {
    jp = nx_m_nb + 1;
  }

  for (k = 1; k + 1 <= jp; k++) {
    b_x->data[k].re *= 2.0F;
    b_x->data[k].im *= 2.0F;
  }

  for (k = nx_m_nb + 1; k + 1 <= naxpy; k++) {
    b_x->data[k].re = 0.0F;
    b_x->data[k].im = 0.0F;
  }

  emxInit_creal32_T(&c_x, 1);
  nx_m_nb = c_x->size[0];
  c_x->size[0] = b_x->size[0];
  emxEnsureCapacity((emxArray__common *)c_x, nx_m_nb, sizeof(creal32_T));
  naxpy = b_x->size[0];
  for (nx_m_nb = 0; nx_m_nb < naxpy; nx_m_nb++) {
    c_x->data[nx_m_nb] = b_x->data[nx_m_nb];
  }

  ifft(c_x, b_x);

  //  Compute modulus of analytic signal
  emxFree_creal32_T(&c_x);
  for (nx_m_nb = 0; nx_m_nb < 2; nx_m_nb++) {
    uv0[nx_m_nb] = (unsigned int)x_filt->size[nx_m_nb];
  }

  nx_m_nb = y->size[0] * y->size[1];
  y->size[0] = 1;
  y->size[1] = (int)uv0[1];
  emxEnsureCapacity((emxArray__common *)y, nx_m_nb, sizeof(float));
  for (k = 0; k + 1 <= x_filt->size[1]; k++) {
    y->data[k] = rt_hypotf(b_x->data[k].re, b_x->data[k].im);
  }

  emxFree_creal32_T(&b_x);
  emxFree_real32_T(&x_filt);
}

//
// File trailer for envSignal.cpp
//
// [EOF]
//

