
#include "mbed.h"
#include "measureSignal.h"
#include "WM8731.h"
#include "I2S.h"


/* Define codec and I2S instances */
WM8731 _codec(P0_27, P0_28);
I2S    _i2sTx(I2S_TRANSMIT, p11, p12, p13);
I2S    _i2sRx(I2S_RECEIVE, p14, p33, p34);



void measureSignal(int signal[],int fs,int N)
{

    printf("Sampling data....\n");
    int _rxBuf[16];
    int signalPtr=0;


    _codec.power(true);
    _codec.frequency(fs);
    _codec.wordsize(32);
    _codec.master(true);
    _codec.input_select(WM8731_MIC); //select mic as input.
    //_codec.input_power(true);
    //_codec.input_mute(false);
    //_codec.microphone_boost(true);
    _codec.start();

    _i2sRx.frequency(fs);
    _i2sRx.wordsize(32);
    _i2sRx.stereomono(I2S_STEREO);
    _i2sRx.masterslave(I2S_SLAVE);
    //_i2sRx.set_interrupt_fifo_level(7);
    _i2sRx.start();
    
    wait(0.5);

    while (signalPtr<N) {
        int to_read = _i2sRx.fifo_points();  //Find out how many stereo samples to read
        _i2sRx.read(_rxBuf, to_read);

        //Loop through all stereo samples
        for(int i = 0; i <to_read; i+=2) {
            //Only fill echo buffer with right side samples, i.e., ignore rxBuf[i+1] content
            signal[signalPtr] = _rxBuf[i];

            //Increment echo buffer write pointer and check for wrap-around
            signalPtr++;
        }
    }
    _codec.stop();
    _i2sRx.stop();
    printf("Signal sampled.\n\n");
}