#include "main.h"
#include <string>
#include "mbed.h"
#include "sdram.h"
#include "SPIFI.h"
#include "stdio.h"
#include "string.h"
#include "math.h"
#include "stdlib.h"
#include "MCIFileSystem.h"
#include "measureSignal.h"
#include "savePower.h"
#include "sdcard.h"
#include <algorithm>

#include "bandPass.h"
#include "envSignal.h"
#include "envSignal_emxAPI.h"
#include "envSignal_emxutil.h"
#include "envSignal_types.h"
#include "main.h"

static emxArray_real32_T *argInit_Unboundedx1_real32_T(float* x);

/* Define variables */
int fs=33000;   // sampling rate
int xsize=33000;// signal length;
int transient=0; // transient part that is cut from the signal
std::string filename = "test";  // name of file saved to SD card


Serial pc(USBTX, USBRX);


int main()
{

    /* -----------------Initial setup  -----------------------*/
    pc.baud(115200); // set baud rate for serial port.
    sdram_init();  // initialize SDRAM.
    //savePower();  //save power by turning ethernet and SDRAM off.


    /*-----------------Record Signal with Codec---------------------*/
   
    int N=xsize+transient; //length of the original signal
    int *signal_raw = (int *)malloc(N*sizeof(int));
    measureSignal(signal_raw,fs,N);  // measure a signal with sampling frequency of fs and lenght of N

    // Scale data and convert to float

    float *signal = (float *)malloc(xsize*sizeof(float));
    for (int i = 0; i < xsize; i++) {
        signal[i]=(float)(signal_raw[i+transient])/(5.8*pow(2.0,24));
    }
    //free(signal_raw);

    /*----------------Envelope Analysis-----------------------------*/
/*
    printf("Performing analysis...\n");
    emxArray_real32_T *signal2;
    emxArray_real32_T *fir_coef;
    emxArray_real32_T *env_signal ;
    
    static int iv0[2] = { xsize,1 };
    signal2 = emxCreateND_real32_T(1, iv0);
    for (int idx0 = 0; idx0 < xsize; idx0++) {
        signal2->data[idx0] = signal[idx0];
    }

    static int iv[2] = { 3201,1 };
    fir_coef = emxCreateND_real32_T(1, iv);
    for (int idx = 0; idx < 3201; idx++) {
        fir_coef->data[idx] = fir_c[idx];
    }

 
    emxInitArray_real32_T(&env_signal, 1);
    envSignal(signal2,fir_coef, env_signal);

*/
    // Print data to terminal
    //printf("analysis done\n");
    for (int i = 5000; i < 5200; i++) {
        //printf("%f            %f          %f\n",signal[i],signal2->data[i],env_signal->data[i]);
        printf("%f           \n");

    }


    /*---------------------------------------------------------------*/
    saveToSD(signal,xsize,filename.c_str());  //save data to SD card
    //saveToSD(signal,xsize,"signal.txt");
    // saveToSD(env_signal->data,xsize,"envsignal.txt");


    return 0;
}