/**
@file My_Ultrasonic_sensor.cpp
@brief Header file containing functions prototypes, defines and global variables.
@brief Doxygen documentation.
@brief Revision 1.0.
@author Mohammed Al Mahrouqi
@date   1 May 2015
*/

/// import "mbed.h" library to the code
#include "mbed.h"
/// import "N5110.h" library to the code
#include "N5110.h"
/// import "SRF02.h" library to the code
#include "SRF02.h"
/// import "PowerControl/PowerControl.h" library to the code
#include "PowerControl/PowerControl.h"
/// import "PowerControl/EthernetPowerControl.h" library to the code
#include "PowerControl/EthernetPowerControl.h"

/// power down USB interface
#define USR_POWERDOWN   (0x104)


//    VCC,SCE,RST,D/C,MOSI,SCLK,LED
///N5110 lcd object defined
N5110 lcd(p7,p8,p9,p10,p11,p13,p26);
// Can also power (VCC) directly from VOUT (3.3 V) -
// Can give better performance due to current limitation from GPIO pin
/// PWM pin for buzzer output
PwmOut buzzer(p21);
/// SRF02 sensor pins
SRF02 sensor(p28,p27);
/// PWM pin for LED 
PwmOut led(p24);
/// AnalogIn pin for pot output
AnalogIn Pot(p20);
/// InterruptIn pin for button
InterruptIn button(p16);


/// a Ticker variable is created. used to get quicker reading response
Ticker timer;   

/// a float variable is created and called meterDistance
float metreDistance;

int timerFlag1 = 0;  //flag for timer

///Interrupt Service Routine
void timerExpired()
{
    /// set timerFlag1 = 1
    timerFlag1 = 1;  //set flag
}
/// Power down the USB interface
int semihost_powerdown()
{
    uint32_t arg;
    return __semihost(USR_POWERDOWN, &arg);

}
///draw rocket
///@param int x to set a pixel in x-axis of the display
///@param int y to set a pixel in y-axis of the display
void rocketDraw(int x, int y)  
{
    lcd.setPixel(42+x,27+y);

    lcd.setPixel(41+x,28+y);
    lcd.setPixel(40+x,29+y);

    lcd.setPixel(42+x,28+y);

    lcd.setPixel(43+x,28+y);
    lcd.setPixel(44+x,29+y);

    lcd.setPixel(41+x,29+y);
    lcd.setPixel(42+x,29+y);
    lcd.setPixel(43+x,29+y);

    lcd.setPixel(40+x,30+y);
    lcd.setPixel(40+x,31+y);
    lcd.setPixel(40+x,32+y);
    lcd.setPixel(40+x,33+y);
    lcd.setPixel(40+x,34+y);
    lcd.setPixel(40+x,35+y);

    lcd.setPixel(41+x,30+y);
    lcd.setPixel(41+x,31+y);
    lcd.setPixel(41+x,32+y);
    lcd.setPixel(41+x,33+y);
    lcd.setPixel(41+x,34+y);
    lcd.setPixel(41+x,35+y);

    lcd.setPixel(42+x,30+y);
    lcd.setPixel(42+x,31+y);
    lcd.setPixel(42+x,32+y);
    lcd.setPixel(42+x,33+y);
    lcd.setPixel(42+x,34+y);
    lcd.setPixel(42+x,35+y);

    lcd.setPixel(43+x,30+y);
    lcd.setPixel(43+x,31+y);
    lcd.setPixel(43+x,32+y);
    lcd.setPixel(43+x,33+y);
    lcd.setPixel(43+x,34+y);
    lcd.setPixel(43+x,35+y);

    lcd.setPixel(44+x,30+y);
    lcd.setPixel(44+x,31+y);
    lcd.setPixel(44+x,32+y);
    lcd.setPixel(44+x,33+y);
    lcd.setPixel(44+x,34+y);
    lcd.setPixel(44+x,35+y);

    lcd.setPixel(45+x,36+y);
    lcd.setPixel(46+x,37+y);
    lcd.setPixel(47+x,38+y);

    lcd.setPixel(39+x,36+y);
    lcd.setPixel(38+x,37+y);
    lcd.setPixel(37+x,38+y);

    lcd.setPixel(42+x,36+y);
    lcd.setPixel(42+x,37+y);
    lcd.setPixel(42+x,38+y);
}
/// set buttonFlag = 0
int buttonFlag = 0;

/// void function is used to initilize the button
void buttonPressed()
{
    /// Once button pressed, measuring unit changes
    buttonFlag = !buttonFlag;
}


/// initilize main function
int main()
{
    



    /// Pulldown is used to keep constant and only changes if button pressed
    button.mode(PullDown);
    /// This to allow unit changes if button pressed
    button.rise(&buttonPressed);
    /// call ISR every 1.0 seconds
    timer.attach(&timerExpired,0.1);    //call ISR every 1.0 seconds


    /// Powering down the Ethernet interface
    int result = semihost_powerdown();
    PHY_PowerDown();

    /// initialise display
    lcd.init();
    /// print this "text" in pixels coordinates (x,y)
    lcd.printString("Mini radar",15,0);
    /// wait (# seconds) till next function
    wait(1);
    /// print this "text" in pixels coordinates (x,y)
    lcd.printString("Done By:",20,1);
    /// wait (# seconds) till next function
    wait(1);
    /// print this "text" in pixels coordinates (x,y)
    lcd.printString("Mohammed",18,2);
    /// wait (# seconds) till next function
    wait(1);
    /// print this "text" in pixels coordinates (x,y)
    lcd.printString("Al Mahrouqi",10,3);
    /// wait (# seconds) till next function
    wait(1);
    /// print this "text" in pixels coordinates (x,y)
    lcd.printString("200823396",18,4);
    /// wait (# seconds) till next function
    wait(1);
    /// referesh the LCD display
    lcd.refresh();
    /// clear the display
    lcd.clear();


    /// create a while loop
    while(1) {




        /// create if function for timerFlag1. Flag is set
        if (timerFlag1)  { 
            ///Reset flag1
            timerFlag1 = 0;  
        
        }





        ///read sensor distance in cm and print over serial port
        int distance = sensor.getDistanceCm();
        //serial.printf("Distance = %d cm\n",distance);
        // short delay before next measurement


        /// each character is 6 pixels wide, screen is 84 pixels
        char buffer[14];  
        // so can display a string of a maximum 14 characters in length
        // or create formatted strings - ensure they aren't more than 14 characters long

        /// create float variable called distance
        float distanceFloat = distance;
        /// convert ditance from cm to m
        metreDistance = distanceFloat / 100;

        /// set button flag
        if(buttonFlag) {
            
            /// print formatted data to buffer
            int length = sprintf(buffer,"Dist = %.2f m",metreDistance);
            
            /// if string will fit on display
            if (length >= 14) { 
            /// display on screen
                lcd.printString(buffer,0,0);           
            }
            /// refresh screen
            lcd.refresh();
            
          /// if flag is = 0, print distance in cm  
        } else if(buttonFlag == 0) {
            /// print distance in cm
            int length = sprintf(buffer,"Dist = %2d Cm",distance); 
            
            /// if string will fit on display
            if (length <= 14) { 
                /// display on screen
                lcd.printString(buffer,0,0);          
            }
            /// referesh LCD screen
            lcd.refresh();
        }






        /// if ditance is less than 50, set buzzer = 1.0 
        if(distance < 50) {
            buzzer = 1.0;
            buzzer.period_ms(2);
            wait_ms((distance)+0.0001);
            buzzer = 0.5;
        }
        /// if distance is greater than 50, set buzzer = 0.0
        else {
            buzzer = 0.0;

        }
        /// if the condition is valid, print distance in cm
        if(distance > 50 && buttonFlag == 1) {
            lcd.clear();
            lcd.printString("Safe",30,2);
            int length = sprintf(buffer,"Dist = %2d Cm",distance); // print formatted data to buffer
            // it is important the format specifier ensures the length will fit in the buffer

            if (length <= 14)  // if string will fit on display
                lcd.printString(buffer,0,0);           // display on screen
            lcd.refresh();
        }
        /// if the condition is NOT valid, print distance in m
        else if(distance > 50 && buttonFlag == 0) {
            lcd.clear();
            lcd.printString("Safe",30,2);
            int length = sprintf(buffer,"Dist = %.2f m",metreDistance); // print formatted data to buffer
            // it is important the format specifier ensures the length will fit in the buffer

            if (length <= 14)  // if string will fit on display
                lcd.printString(buffer,0,0);           // display on screen
            lcd.refresh();
        }





        /// if condition is valid, print "Warning, Defense System On"
        else if(distance > 20 & distance < 50)   {
            lcd.clear();
            lcd.printString("Warning",20,2);
            lcd.printString("Defence",20,4);
            lcd.printString("System On",15,5);
            
            /// if buttonFlag=0, print distance in cm
            if(buttonFlag == 0) { //if button is in the unpressed state, print distance in cm
                int length = sprintf(buffer,"Dist = %2d Cm",distance); // print formatted data to buffer
                // it is important the format specifier ensures the length will fit in the buffer
                
                if (length <= 14)  // if string will fit on display
                    lcd.printString(buffer,0,0);           // display on screen
                lcd.refresh();
            }
            /// if buttonFlag = 1, print distance in m
            else if(buttonFlag == 1) { //print distance in metres if button pressed
                int length = sprintf(buffer,"Dist = %.2f m",metreDistance); // print formatted data to buffer
                // it is important the format specifier ensures the length will fit in the buffer

                if (length <= 14)  // if string will fit on display
                    lcd.printString(buffer,0,0);           // display on screen
                lcd.refresh();
            }
        }








        /// if all if functions Not valid, else will print "Fire" and draw "missile"
        else {
            lcd.clear();
            lcd.printString("Fire",30,2);
            rocketDraw(0,0);

            /// if buttonFlag=0, print distance in cm
            if(buttonFlag == 0) { //if button is in the unpressed state, print distance in cm
                int length = sprintf(buffer,"Dist = %2d Cm",distance); // print formatted data to buffer
                // it is important the format specifier ensures the length will fit in the buffer

                if (length <= 14)  // if string will fit on display
                    lcd.printString(buffer,0,0);           // display on screen
                lcd.refresh();
            }
            /// if buttonFlag = 1, print distance in m
            else if(buttonFlag == 1) { //print distance in metres if button pressed
                int length = sprintf(buffer,"Dist = %.2f m",metreDistance); // print formatted data to buffer
                // it is important the format specifier ensures the length will fit in the buffer

                if (length <= 14)  // if string will fit on display
                    lcd.printString(buffer,0,0);           // display on screen
                lcd.refresh();
            }
        }
        /// if distance is less than 50, switch on LED
        if(distance < 50) {
            led = 2.0;
        /// if NOT, keep LED off    
        } else {
            led = 0.0;

        }





        /// referesh the screen
        lcd.refresh();
        /// set brightness to be controlled by the potentiometer
        lcd.setBrightness(Pot.read());
        /// wait for 0.5 seconds
        wait(0.5);

    }
}
