#ifndef __UCAM_H__
#define __UCAM_H__

#include "mbed.h"
#include "MODSERIAL.h"
#include "FeRAM.h"

// Define colours
#define GREY_2BIT 0x01
#define GREY_4BIT 0x02
#define GREY_8BIT 0x03
#define COLOUR_8BIT 0x04
#define COLOUR_12BIT 0x05
#define COLOUR_16BIT 0x06
#define JPEG 0x07
// Define RAW formats
#define RAW_80x60 0x01
#define RAW_160x120 0x03
#define RAW_320x240 0x05
#define RAW_640x480 0x07
#define RAW_128x128 0x09
#define RAW_128x96 0x0B
// Define JPEG formats
#define JPEG_60x64 0x01
#define JPEG_160x128 0x03
#define JPEG_320x240 0x05
#define JPEG_640x480 0x07
// Define uCam responses
#define _ACK 0x0E
#define _SYNC 0x0D

// mode codes for 23K256
#define BYTE_MODE       0x00
#define SEQUENTIAL_MODE 0x40

// command codes for 23K256
#define READ            0x03
#define WRITE           0x02
#define READ_STATUS     0x05 // called RDSR in datasheet
#define WRITE_STATUS    0x01 // called WRSR in datasheet

class uCam {
public:
    // define which pins are used
    uCam(PinName tx, PinName rx, int buffer);

    // Methods
    int Sync();
    int SetBaud(int baud);
    int Initial(unsigned char COLOUR, unsigned char RES);
    int Get_Picture(unsigned char *data);
    int Get_Response(unsigned char type, unsigned char command);
    int Save_Picture_To_Memory(FeRAM &flash, int address);
    int Save_Zoom_Picture_To_Memory(FeRAM &flash, int address);
    
private:
    MODSERIAL _uCam;    // uCam TX and RX
    
};

#endif