#include "mbed.h"
#include "Terminal.h"

#define MaxNo_Menu 5

Terminal term(USBTX, USBRX); // tx, rx

char *menu_list1[MaxNo_Menu] = { "Apple", "Pear", "Banana", "Kiwi", "Plum" };
char *menu_list2[MaxNo_Menu] = { "Orange", "Peach", "Strawberry", "Blueberry", "Grapes" };
int ypos[MaxNo_Menu] = { 3, 6, 9, 12, 15 };

void InitScreen(void){        //Print all the fruits on the screen
    
    term.background(0xFF0000);
    term.foreground(0xFFFFFF);
    for(int i=0; i< MaxNo_Menu; i++){             
        term.locate(5, ypos[i]);
        term.printf("%s",menu_list1[i]);
        term.locate(15, ypos[i]);
        term.printf("%s",menu_list2[i]);
    }  
}

void UpdateScreen(int LastIndex, int LastColumn, int Index, int Column){    //Just update the fuits that has changed
     
     term.background(0xFFFFFF);                                //Highlight the new fruit
     term.foreground(0xFF0000);
     if(Column==0){
         term.locate(5, ypos[Index]);
         term.printf("%s",menu_list1[Index]);
     }
     else{
         term.locate(15, ypos[Index]);
         term.printf("%s",menu_list2[Index]);
     }  
     
     term.background(0xFF0000);                                //Black out the old fruit
     term.foreground(0xFFFFFF);
     if(LastColumn==0){
         term.locate(5, ypos[LastIndex]);
         term.printf("%s",menu_list1[LastIndex]);
     }
     else{
         term.locate(15, ypos[LastIndex]);
         term.printf("%s",menu_list2[LastIndex]);
     } 
}
     
int main() {

    int Key;
    int Index=0, Column=0, LastIndex=0, LastColumn=1;

    term.background(0xFF0000);
    term.foreground(0xFFFFFF);
    term.cls();
    term.locate(15,1);
    term.printf("What is your favourite fruit?");
    InitScreen();
    UpdateScreen(LastIndex, LastColumn,Index, Column);    
    term.box(2,2,30,15);   
 
    while(1){   
       Key=term.getc();                                //Get the keypad pressed
            if((Key>=0x30)&&(Key<=0x39)){              //See if it's a number (0-9)
            }
            else if(Key==0x1B){                        //If the keypress was an arrow key                                                  
                Key = term.getc();                     //Check again!                  
                if (Key == 0x5B){
                    Key = term.getc(); 
                    LastIndex=Index;
                    LastColumn=Column;
                    switch(Key){                          //Check to see which arrow key...
                        case 0x41:                        //It was the UP arrow key...
                            Index--;
                            if(Index<0)
                                Index = MaxNo_Menu - 1;
                            break;
                        case 0x42:                        //It was the DOWN arrow key...
                            Index++;
                            if(Index >= MaxNo_Menu)
                                Index = 0;
                            break;
                        case 0x43:                        //It was the RIGHT arrow key...
                            Column++;
                            if(Column>1)
                                Column=0;
                            break;
                        case 0x44:                        //It was the LEFT arrow key...
                            Column--;
                            if(Column<0)
                                Column=1;
                            break;
                    }
                    UpdateScreen(LastIndex, LastColumn,Index, Column);   
                }  
            }
            else if(Key>=0x0D){                        //See if it was ENTER
                term.locate(15,18);
                if(Column==0)
                    term.printf("Your favourite fruit is %s       ",menu_list1[Index]);
                else
                    term.printf("Your favourite fruit is %s       ",menu_list2[Index]);
            }
    }
}
