//
// OV7670 + FIFO AL422B camera board test
//
#include "mbed.h"
#include "ov7670.h"
#include "stdio.h"
#include "SPI_TFT.h"
#include "string"
#include "Arial12x12.h"
#include "Arial24x23.h"
#include "Arial28x28.h"
#include "font_big.h"

OV7670 camera(
    p28,p27,       // SDA,SCL(I2C / SCCB)
    p21,p22,p20,   // VSYNC,HREF,WEN(FIFO)
    Port0,0x07800033,
    p23,p24,p25) ; // RRST,OE,RCLK

// the TFT is connected to SPI pin 5-7
SPI_TFT TFT(p5, p6, p7, p8, p14,"TFT"); // mosi, miso, sclk, cs, reset

Serial pc(USBTX,USBRX);

#define SIZEX (160)
#define SIZEY (120)
#define SIZE 19200

unsigned char bank0 [SIZE];
unsigned char *bank1 = (unsigned char *)(0x2007C000);

int main() {

    // Set up the TFT
    TFT.claim(stdout);                          // Send stdout to the TFT display
    TFT.background(Black);                      // Set background to black
    TFT.foreground(White);                      // Set chars to white
    TFT.cls();                                  // Clear the screen
    TFT.set_font((unsigned char*) Arial12x12);  // Select the font
    TFT.set_orientation(3);                     // Select orientation

    // Reset camera on power up
    camera.Reset() ;

    // Set up for 160*120 pixels RGB565
    camera.InitQQVGA() ;
    
    // Print message to screen
    pc.printf("Hit Any Key to stop RGBx160x120 Capture Data.\r\n");
          
    // Kick things off by capturing an image
    camera.CaptureNext() ;
    while (camera.CaptureDone() == false) ;

    // Now enter the main loop
    while (!pc.readable()) {

        // Start reading in the image data from the camera hardware buffer                   
        camera.ReadStart();

        // Read in the first half of the image
        for (int i = 0; i < SIZE; i++) {
            bank0[i] =  camera.ReadOneByte();
        }

        // Read in the second half of the image
        for (int i = 0; i < SIZE ; i++) {
            bank1[i] =  camera.ReadOneByte();
        }  
        
        // Stop reading the image
        camera.ReadStop() ; 
        
        // Immediately request the next image to be captured (takes around 45ms)
        camera.CaptureNext() ;
        
        // Use this time to display the image on the screen
        // Display the top half
        TFT.Bitmap(0,0,160,60,bank1);
        // Display the bottom half
        TFT.Bitmap(0,60,160,60,bank0);
        
        /* Note: we still have around 15ms left here to do other stuff */
        
        // Now wait for the image to finish being captured
        while (camera.CaptureDone() == false) ;
    }
}
