#include "mbed.h"
#include "FeRAM.h"

FeRAM RAM(p11, p12, p13);
Serial pc(USBTX,USBRX);

int main() {
    unsigned char write_array[10], read_array[10];

    // Write to and read back from memory in single bytes
    for (int i = 0; i < 10; i++) {
        write_array[i] = i;                     // Set write value
        RAM.write_byte( i, write_array[i]);     // Write byte
        read_array[i] = 0;                      // Zero read array
        read_array[i] = RAM.read_byte(i);       // Read back from memory
    }

    pc.printf("\n\r Single byte values are: ");
    for (int i = 0; i < 10; i++) {
        pc.printf("%d, ",read_array[i]);        // Print read values
        read_array[i] = 0;                      // Zero read array
    }

    // Write to and read back from memory in multiple bytes
    RAM.write_multiple_bytes (100, write_array, 10);
    RAM.read_multiple_bytes(100, read_array, 10);

    pc.printf("\n\r Multiple byte values are: ");
    for (int i = 0; i < 10; i++) {
        pc.printf("%d, ",read_array[i]);        // Print read values
    }
}