/*  FeRAM Library
*
*   Martin Smith 2012
*
*   Working with FM25H20-DG 2 Mbit FeRAM IC
*/

#include "mbed.h"

#ifndef  FERAM_H
#define  FERAM_H

// LCP1768 SSP regiester defines
#define TNF         0x02    // Transmit buffer not full
#define TFE         0x01    // Transmit buffer full
#define RNE         0x04    // Receive buffer not empty
#define p6_GPIO     0xFFFFCFFF  
#define p14_GPIO    0xFFFFFFFC
#define p6_SSEL     0x00002000
#define p14_SSEL    0x00000002
// FeRAM command defines
#define WREN        0x06    // Write enable
#define WRITE       0x02    // Write command
#define READ        0x03    // Read command

/*
* Connections for IC:
* chip pin 1 - Chip Select - mbed p8 / p14
* chip pin 2 - MISO - mbed p6 / p12
* chip pin 3 - Write Protect - mbed VOUT (p40)
* chip pin 4 - VSS - mbed GND (p1)
* chip pin 5 - MOSI - mbed p5 / p11
* chip pin 6 - SCLK - mbed p7 / p13
* chip pin 7 - Hold - mbed VOUT (p40)
* chip pin 8 - VDD - mbed VOUT (p40)
*/

class FeRAM {
public:
    FeRAM(PinName mosi, PinName miso, PinName sclk);
    void write_byte (int address, unsigned char data);
    unsigned char read_byte (int address);
    void write_multiple_bytes (int start_address, unsigned char* data, int length);
    void read_multiple_bytes (int start_address, unsigned char* data, int length);
private:
    SPI _spi;
    PinName _miso;
    void spi_write_SSP0 (unsigned char data);
    void spi_write_SSP1 (unsigned char data);
};
#endif