#include "mbed.h"
#include "AX12.h"

#define B 45                // Offset dimension
#define FEMUR 80            // Femur length
#define TIBIA 140           // Tibia length
#define ULNA 90             // Ulna length
#define RADIUS 120          // Radius length
#define X_OFFSET 25         // Distance from the X-axis -> servo centre
#define PI 3.14159

#define HIND 0
#define FORE 1

/********** Global structures **********/
struct Joint_Angles {
    float lateral;
    float hip;
    float knee;
};

/**************************************************************************
Global variables
**************************************************************************/
extern AX12 Fore_Right_Hip_Lateral,
            Fore_Right_Hip,
            Fore_Right_Knee,
            Fore_Left_Hip_Lateral,
            Fore_Left_Hip,
            Fore_Left_Knee,
            Hind_Right_Hip_Lateral,
            Hind_Right_Hip,
            Hind_Right_Knee,
            Hind_Left_Hip_Lateral,
            Hind_Left_Hip,
            Hind_Left_Knee;

/********** Functions **********/
void FK_Engine(float*);
void Set_Pose(const int*, float);
Joint_Angles IK_Engine(int, int, int, char);
void Step_Forward(int);

/************ Define Poses ************/
extern const int Stand[];
extern const int Sit1[];
extern const int Sit2[];
extern const int Sit3[];
extern const int Sit4[];