#include "mbed.h"
#include "MSCFileSystem.h"

MSCFileSystem msc("usb"); // Mount flash drive under the name "msc"
Serial pc(USBTX,USBRX);

int main() {
    unsigned char data[120*160];                // Test array of data

    // Fill the data with values
    for (int i=0; i<120*160; i++) {
        data[i] = 0xAA;                          // Fill array with data
    }

    // Create timers
    Timer Write_time, Read_time;
    Write_time.start();

    // Write to local file
    FILE *fp = fopen( "/usb/test.txt", "w");
    for (int i=0; i<120*160; i++) {
        fprintf(fp, "%c",data[i]);
    }
    fclose(fp);

    Write_time.stop();
    pc.printf("\n\rTime taken so write array = %f seconds",Write_time.read());

    Read_time.start();
    // Read from local file
    fopen("/usb/test.txt","r");
    // Get data from file and load back into cam
    for (int i=0; i<120*160; i++) {
        data[i] = fgetc(fp);          // Get the next character
    }
    fclose(fp);
    Read_time.stop();
    pc.printf("\n\rTime taken to read array = %f seconds",Read_time.read());
}