#include "mbed.h"
#include "Terminal.h"

Terminal term(USBTX, USBRX);                         //Info transmitted to hypertermal via USB
int Flag=0, Count=10;

void Countdown(void){
    if(Flag==1){
        Count--;

    if(Count<=0){
        Flag=0;        //Turn off MoveFlag at the end of the move.  
    }
    term.locate(18,6);
    term.printf("%d ",Count);
    }
}
     
int main() {
    Ticker Timer_100ms;
    Timer_100ms.attach(&Countdown, 0.1);             //Call Profile every 0.1 seconds

    term.cls();                                           //Clear the screen (paint red)
    term.locate(18,5);
    term.printf("Count: %d ",Count);    
     
    while(1){                  
        int Key=term.getc();                      //Get the keypad pressed
        if(Key==0x0D){                        //See if it was ENTER
            Flag=1;
        }    
    }       
}