#include "mbed.h"

Ticker Box_Comms;                           // Ticker to send a command every 250ms
Serial PC (USBTX,USBRX);                    // Comms with PC via USB cable
Serial Comms (p28,p27);                     // External comms via RS232 IC

void isr_Comms(void) {
    char reply[70];                         // Array to store reply in
    char Command[] = {0x01,'R',0x02,'P',0x03};
    int ReplyIndex=0;                       // Variable for indexing the read data

    for (int i=0;i<5;i++) {                 // Send the Command
        Comms.putc(Command[i]);
    }
    while (Comms.readable()) {              // While there is data on the line to read...
        reply[ReplyIndex] = Comms.getc();   // Read it!
        ReplyIndex++;
    }
    PC.printf("\n\rNumber of bytes received = %d,",ReplyIndex);
}

int main() {    
    Comms.baud(38400);                      //Set up the Baud rates for the comms
    Box_Comms.attach(&isr_Comms,0.25);      //Call the isr_Comms function every 1/4 second
    
    PC.printf("Testing Started");
}