/*     This program is designed to interface with the AS5045 IC encoder
    It calls a function to read the encoder value every second 
    The program then prints the vaule to a PC screen via hyperterminal*/

#include "mbed.h"

Serial pc(USBTX, USBRX);
SPI spi(p5, p6, p7); // mosi, miso, sclk
DigitalOut cs(p25);

long EncoderValue; 
int Encoder;

Ticker ReadEncoder;

void Read(){

    spi.format(9,2);            // Setup the spi for 9 bit data, high steady state clock,
    spi.frequency(500000);  
    cs = 0;                     // Select the device by seting chip select low  

// Send a dummy byte to receive the contents encoder
    int upper = spi.write(0x00);
    int lower = spi.write(0x00);
    lower = lower >> 6;   
    upper = (upper << 6)+lower;
    cs = 1;
    
    pc.printf("%d  \r", upper);   
}


int main() {
    pc.printf("Hello World!\n");
    ReadEncoder.attach_us(&Read, 100000); // call flip every 100 milli-seconds
    
    while(1) {
    }
}

