#include "mbed.h"
#include "EthernetInterface.h"
#include "DS1820.h" 
 
#define MBED_DEV_IP       "192.168.144.24"
#define MBED_DEV_MASK     "255.255.0.0"
#define MBED_DEV_GW       "192.168.144.25"
#define ECHO_SERVER_PORT   80

#define DATA_PIN        A1

Ticker timer;

DigitalOut red_led(LED_RED, 1);
DigitalOut green_led(LED_GREEN, 1);
Serial pc(USBTX, USBRX); // Debug via USB port.


DS1820 probe(DATA_PIN);

char find_temperature[50] = "GET /demo_form.asp?OPTION=TEMPERATURE";
char find_lasttemperature[50] = "GET /demo_form.asp?OPTION=LAST";

int counter;

void attime()
{
probe.convertTemperature(true, DS1820::all_devices); 
            if(probe.temperature()>30)
            {
            red_led=0;
            green_led=1;    
            }
            else
            {
            red_led=1;
            green_led=0;
            }
}
int main (void) {
    
    pc.printf("\nHello!\n\r");
    //pc.baud(9600);
    EthernetInterface eth; // Interface using Ethernet to connect to an IP-based network.
    eth.init(); // Initialize the interface with DHCP.
    //eth.init(MBED_DEV_IP, MBED_DEV_MASK, MBED_DEV_GW); // Initialize the interface with a static IP address.
    eth.connect(); // Connect Bring the interface up, start DHCP if needed (Dynamic Host Configuration Protocol).
    
    pc.printf("\nIP Address is %s\n\r", eth.getIPAddress());
    
    TCPSocketServer server; // Instantiate a TCP Server.
    server.bind(ECHO_SERVER_PORT); // Bind a socket to a specific port (80 = HTTP).
    server.listen(); // Start listening for incoming connections.
    
    while (true) {
        timer.attach(&attime,1);
        pc.printf("\nWait for new connection...\n\r");
        TCPSocketConnection client; //  TCP socket connection.
        server.accept(client); // Accept a new connection.
        client.set_blocking(false, 1500); // Timeout after (1.5)s
        
        pc.printf("\nConnection from: %s\n\r", client.get_address());
        
        char buffer[600];
        int ret;
        char value[5];
        char last5values[5][5];
        
        int option =1;
     
        /////////////GET//////////////
        while (true) {
            ret = client.receive(buffer, sizeof(buffer)-1); 
            
            // Receive data from the remote host. 
            if (ret <= 0)break;
            buffer[ret] = '\0';
            pc.printf("Received %d chars from server:\n\r%s\n\r", ret, buffer);
            
            // Option seeking:
            if(strstr(buffer, find_temperature)>0) {
                probe.convertTemperature(true, DS1820::all_devices);         //Start temperature conversion, wait until ready
                pc.printf("It is %3.1foC\r\n", probe.temperature());
                sprintf(value,"%3.1f",probe.temperature());
                sprintf(last5values[counter],"%3.1f",probe.temperature());
                if(counter==4)
                {
                    counter=0;
                }
                else
                {
                    counter++;
                }
                option = 1;
            }
            if(strstr(buffer,find_lasttemperature)>0){
                
                option = 2;
                }

        }      
        // Webpage here:
        /*
        <!DOCTYPE html> 
<html> 
    <head> 
        <title> FRDM-K64F </title>
        </head>
        <body>
        
        <h1>Temperature Sensor</h1>
        <form action=""demo_form.asp"">
        <select name=""OPTION"">
        <option value=""TEMPERATURE"">
        TEMPERATURE
        <OPTION VALUE=""LAST"">
        LAST 5 TEMPERATURES
        </select>
        <input type=""submit"" value=""Submit"">
        </select>
        </form>
    </body>
</html>
        */
        char http_cmd1[] = "<!DOCTYPE html> <html> <head> <title> FRDM-K64F </title></head> <body><h1>Temperature Sensor</h1><form action=""demo_form.asp""><select name=""OPTION""><option value=""TEMPERATURE"">TEMPERATURE<OPTION VALUE=""LAST"">LAST 5 TEMPERATURES<input type=""submit"" value=""Submit""></select></form>";
        char http_cmd_current[]="<p>Current temperature in oC:</p>";
        char http_cmd_last5temp[]="<p>Last (max 5) temperatures in oC:</p>";
        char http_cmd_warning[]="<p><font color=""red"">WARNING! HIGH TEMPERATURE</font></p>";
        char http_cmd2[]="</body></html>";
        char http_cmd_newline_start[]="<p>";
        char http_cmd_newline_end[]="</p>";
        
        client.send_all(http_cmd1, sizeof(http_cmd1)-1); // Send all the data to the remote host. 
        if(option==1)
        {
        probe.convertTemperature(true, DS1820::all_devices); 
        pc.printf(" It's %3.1f oC\r\n",probe.temperature()); 
        client.send_all(http_cmd_current, sizeof(http_cmd_current)-1);
        client.send_all(value, sizeof(value)-1);
        if(probe.temperature()>25)
        {
            client.send_all(http_cmd_warning, sizeof(http_cmd_warning)-1);
        }  
        }
        else if(option ==2)
        {
            client.send_all(http_cmd_last5temp, sizeof(http_cmd_last5temp)-1);
            for(int i=0;i<=4;++i)
            {
                pc.printf("last %d value: %s",i,last5values[i]);
                client.send_all(http_cmd_newline_start, sizeof(http_cmd_newline_start)-1);
                client.send_all(last5values[i],sizeof(last5values[i])-1);
                client.send_all(http_cmd_newline_end, sizeof(http_cmd_newline_end)-1);
            }
        }
        client.send_all(http_cmd2, sizeof(http_cmd2)-1);        
        client.close(); //  Close the socket.
        pc.printf("\n\nClient closed\n\n\r");
     }
}