#include "mbed.h"           // stuff for the program we used to write the code
#include "TFC.h"            // stuff for the board we're using on the car
#include "Inits.h"          // where to find the initialization directions
#include "TheDetails.h"     // this layer translates the lower level code to the
                            // Freescale Mentoring Matters level of abstraction
#include "Modes.h"          // where to find our instructions for each mode

/****** main() *****************************************************************
Purpose: This is the software engine that runs the race car. It is a set of
    commands that run from the beginning to the end and then start over each
    time for as long as the car is turned on. This is called an 'infinite loop'.
Parameters: None
Returns: The main function always returns an 'int'.
*******************************************************************************/
int main()
{
    // 'mode' will always equal a number to indicate the mode the code is using
    uint16_t mode;

    // First, we have to turn on the car and all of its motors and parts.
    WhatToTurnOn();

    // This is the infinite loop for driving the race car starts here and runs
    // forever.
    for(;;)
    {
        // The loop determines what mode the car is in by reading the dip
        // switch number every time the loop starts over
        mode = DIP_SWITCH_SETTING;

        // Next, the loop runs the car in whichever mode the dip switches are
        // set for by 'switching' to that mode below. It only picks one mode
        // each time, runs that mode only once, and then starts the loop over
        // again by checking to see if the dip switches have been changed.

        // This code uses the files at the top of this page to find the
        // instructions for whichever mode it wants to go and run.
        switch(mode)
        {
            // Mode 0: Diagnostic that mode tests that the board is powered on.
            case 0:
                RunMode0();
                break;

            // Mode 1: Garage mode that tests motor speed and direction.
            case 1:
                RunMode1();
                break;

            // Mode 2: Garage mode that tests steering servo.
            case 2:
                RunMode2();
                break;

            // Mode 3: Garage mode that tests the camera settings and input.
            case 3:
                RunMode3();
                break;

            // Mode 4: Track mode with low speed settings for safer (slower)
                    // initial track testing.
            case 4:
                RunMode4();
                break;

            // Mode 5: Race mode with high speed settings used for faster actual
                    // racing speeds.
            case 5:
                RunMode5();
                break;

            // default mode activates diagnostic mode 0 to prevent unwanted
                    // damage or corruption/loss of calibrated data.
            default:
                RunMode0();
                break;
        } // end case
    }
}