#include "TFC.h"
#include "common.h"

/****** TFC_TickerUpdate() *****************************************************
Purpose: This ticker code is used to maintain compatibility with the CodeWarrior
    version of the sample. This code uses an MBED Ticker for background timing.
Parameters: None
Returns: None
*******************************************************************************/
void TFC_TickerUpdate()
{
    int i;

    for(i=0; i<NUM_TFC_TICKERS; i++)
    {
        if(TFC_Ticker[i]<0xFFFFFFFF) 
        {
            TFC_Ticker[i]++;
        }
    }
}

/****** WhatToTurnOn() *********************************************************
Purpose: This function initializes the interfaces between the controller
    board and the hardware.
Parameters: None
Returns: None
*******************************************************************************/
void WhatToTurnOn()
{
    // set baud rate for serial output based on terminal type
        // 115200 works with Excel, TeraTerm, and Putty
        // 9600 works with USB Serial Monitor Lite
            // USB Serial Monitor Lite does not work above 9600
    PC.baud(115200);

    // start counter for this hardware
    TFC_TickerObj.attach_us(&TFC_TickerUpdate,2000);

    // initialize camera, servo, and motor systems
    TFC_Init();
}