#include "mbed.h"
#include "TFC.h"

/****** MENTORING MATTERS LAYER DEFINITIONS ******/

#define DIP_SWITCH_SETTING          (TFC_GetDIP_Switch()&0x07)
#define CHECK_POT_1_VALUE           TFC_ReadPot(0);
#define CHECK_POT_2_VALUE           TFC_ReadPot(1);

#define DISABLE_THE_MOTORS          TFC_HBRIDGE_DISABLE
#define ENABLE_THE_MOTORS           TFC_HBRIDGE_ENABLE

#define TURN_ON_LED_0               TFC_BAT_LED0_ON
#define TURN_ON_LED_1               TFC_BAT_LED1_ON
#define TURN_ON_LED_2               TFC_BAT_LED2_ON
#define TURN_ON_LED_3               TFC_BAT_LED3_ON

#define TURN_OFF_LED_0              TFC_BAT_LED0_OFF
#define TURN_OFF_LED_1              TFC_BAT_LED1_OFF
#define TURN_OFF_LED_2              TFC_BAT_LED2_OFF
#define TURN_OFF_LED_3              TFC_BAT_LED3_OFF

#define BUTTON_A_IS_PRESSED         TFC_PUSH_BUTTON_0_PRESSED
#define BUTTON_B_IS_PRESSED         TFC_PUSH_BUTTON_1_PRESSED

#define CLOCK_NUMBER_1              TFC_Ticker[0]

#define SERVO_NUMBER_1              0

#define CAMERA_READY                TFC_LineScanImageReady
#define LINE_IMAGE                  terminalMode()
#define DEPENDS_ON_DIP_SWITCH_4     terminalMode()
#define THE_PIECE_OF_IMAGE          TFC_LineScanImage0
#define LOOKS_IMPORTANT             (4096 / 20)
#define USE_FAKE_IMAGES             debugFakeMode

/*************************************************/

extern bool debugFakeMode;

/****** terminalMode() *********************************************************
Purpose: Checks the current setting of dip switch 4.
Parameters: None
Returns: True if dip switch 4 is set.
*******************************************************************************/
bool terminalMode();

/****** GiveDriveSettingsToMotors() ********************************************
Purpose: Simply passes parameters to TFC_SetMotorPWM().
Parameters: The desired settings for each of the two motors
Returns: None
*******************************************************************************/
void GiveDriveSettingsToMotors(float right_drive_setting,
                               float left_drive_setting);

/****** GiveSteeringSettingTo() ************************************************
Purpose: Simply passes parameters to TFC_SetServo().
Parameters: The servo number and the steering setting.
Returns: None
*******************************************************************************/
void GiveSteeringSettingTo(uint8_t ServoNumber, float Position);

/****** ResetCamera() **********************************************************
Purpose: This function resets the camera after an image has been used.
Parameters: None
Returns: None
*******************************************************************************/
void ResetCamera();

/****** ResetMaximumLightReading() *********************************************
Purpose: Resets the maximum light intensity variable
Parameters: None
Returns: None
*******************************************************************************/
void ResetMaximumLightReading();

/****** ResetMinimumLightReading() *********************************************
Purpose: Resets the minimum light intensity variable
Parameters: None
Returns: None
*******************************************************************************/
void ResetMinimumLightReading();

/****** grabCameraFrame() ******************************************************
Purpose: This function gets a scan from the camera or fakes a scan from the
    camera. There are different types of fake scans that can be used to test
    other parts of the car to see how the car reacts to certain types of line
    conditions.
Parameters: None
Returns: None
*******************************************************************************/
void grabCameraFrame();

/****** GetTheImageToUse() *****************************************************
Purpose: Retrieves whichever image we are supposed to use.
Parameters: None
Returns: None
*******************************************************************************/
void GetTheImageToUse();

/****** GetCameraData() *****************************************************
Purpose: Processes an image to get the camera's raw data.
Parameters: None
Returns: None
*******************************************************************************/
void GetCameraData();

/****** derivativeLineScan() ***************************************************
Purpose: Calculates derivative of line scan data.
Parameters: Pointer to current image scan data, and a pointer to where you want
    the derivative to be output.
Returns: None
*******************************************************************************/
void derivativeLineScan(uint16_t* LineScanDataIn, float* DerivLineScanDataOut);

/****** printAdjustLightsData() ************************************************
Purpose: Prints out light intensity data to the terminal.
Parameters: None
Returns: None
*******************************************************************************/
void printAdjustLightsData();

/****** adjustLights() *********************************************************
Purpose: Adjusts the line found threshold for different lighting conditions.
Parameters: None
Returns: None
*******************************************************************************/
void adjustLights();

/****** FindTheLine() *********************************************************
Purpose: Simply a link to whichever version of the edge-finding functions you
    choose.
Parameters: None
Returns: None
*******************************************************************************/
void FindTheLine();

/****** findEdges_v2() *********************************************************
Purpose: This function is used to determine where the edges of the line are
    found in the camera image. The location of the line edges is printed out to
    the terminal if terminal output has been enabled.
Parameters: Pointer to the array of line scan data derivatives
Returns: None
*******************************************************************************/
void findEdges_v2(float* derivLineScanData);

/****** reviewEdges() **********************************************************
Purpose: This function check which edges were found and decides whether or not
    the line has been found. Its results are printed out to the terminal if
    terminal output has been enabled.
Parameters: None
Returns: None
*******************************************************************************/
void reviewEdges();

/****** PrintOutSomeData() *****************************************************
Purpose: Prints out a selection of Track mode data after image processing.
Parameters: None
Returns: None
*******************************************************************************/
void PrintOutSomeData();

/****** ActOnTrackStatus() *****************************************************
Purpose: This function decides what to do next based on the current track
    status. Its results are printed out to the terminal if terminal output has
    been enabled.
Parameters: None
Returns: None
*******************************************************************************/
void ActOnTrackStatus();

/****** feedbackLights() *******************************************************
Purpose: Turns on board LED's to indicate specific status for debugging
    purposes.
Parameters: None
Returns: None
*******************************************************************************/
void feedbackLights();

/****** SpeedControl() *********************************************************
Purpose: This function determines the speed settings in the code and set on the
    board itself. It then offers multiple ways to apply those settings to the
    actual speed output to the wheels.
    Its results are printed out to the terminal if terminal output has been
    enabled.
Parameters: None
Returns: None
*******************************************************************************/
void SpeedControl();

/****** Drive() ****************************************************************
Purpose: This is the function that enables the motors to run.  It monitors the
    pressing of buttons A and B to start and stop the car. It also monitors for
    emergency stop conditions and will turn off the motors to stop the car if
    necessary.
Parameters: None
Returns: None
*******************************************************************************/
void Drive();
/****** printLineScanData() ****************************************************
Purpose: This function prints out the camera data to the terminal for use in
    testing and debugging.
Parameters: Takes the most recent scan returned by the camera.
Returns: None
*******************************************************************************/
void printLineScanData(uint16_t* LineScanData);

/****** printDerivLineScanData() ***********************************************
Purpose: This function prints out the line scan derivative data to the terminal
    for use in testing and debugging.
Parameters: Takes the array of line scan data derivatives.
Returns: None
*******************************************************************************/
void printDerivLineScanData(float* derivLineScanData);

/****** printEdgesFound() ******************************************************
Purpose: This function prints the line edge data to the terminal for line use in
    debugging.
Parameters: None
Returns: None
*******************************************************************************/
void printEdgesFound();

/****** SteeringControl() ******************************************************
Purpose: This function decides how much to turn the front wheels to keep the car
    on course.
    The CurrentSteerSetting variable is set here.
    Its results are printed out to the terminal if terminal output has been
    enabled.
Parameters: None
Returns: None
*******************************************************************************/
void SteeringControl();

/****** Steer() ****************************************************************
Purpose: Sets the steering servo output to the value necessary for the current
    steering needs. It also checks the value needed to make sure the board isn't
    trying to steer harder than the wheels can turn.
Parameters: None
Returns: None
*******************************************************************************/
void Steer();

/****** GoSlow() ***************************************************************
Purpose: Sets the DoRisky variable to false
Parameters: None
Returns: None
*******************************************************************************/
void GoSlow();

/****** GoFast() ***************************************************************
Purpose: Sets the doRisky variable to true
Parameters: None
Returns: None
*******************************************************************************/
void GoFast();
