/****** RunMode0() *************************************************************
Purpose: Mode 0 is used for some very basic tests. It will test to see that the
    car is "turned on" by printing a message to the computer telling us that it
    is on. This mode also allows us to check that push buttons 'A' and 'B' are
    working and that the LEDs on the board are working.
    Most importantly, however, this quick and simple code will show us whether
    or not our CODE is working before we spend too much time writing the rest of
    the code.
Parameters: None
Returns: None
*******************************************************************************/
void RunMode0();

/****** RunMode1() *************************************************************
Purpose: Mode 1 isolates the drive motors on the rear wheels. The potentiometers
    on the board allow each motor to be adjusted individually. The numerical
    value that the pot represents is output to our computer so that we can
    gather some information about how the different values used for the drive
    settings will affect the direction and/or speed of the wheels.
Parameters: None
Returns: None
*******************************************************************************/
void RunMode1();

/****** RunMode2() *************************************************************
Purpose: Mode 2 isolates the steering servo. We are able to use a potentiometer
    on the board to adjust the steering settings left and right. The values
    being given to the steering servo are printed out to the computer so that
    they can be recorded and used later if necessary.
Parameters: None
Returns: None
*******************************************************************************/
void RunMode2();

/****** RunMode3() *************************************************************
Purpose: This function runs the camera test mode for the car. It disables the
    motors and steering servo to prevent damage to that hardware while isolating
    the camera output. First we check to see if the camera has an image ready
    for us to see and then we decode the camera image and translate it into a
    picture that can be displayed on the computer screen.  The image on the
    screen can be used to focus the camera lens. Dip switch 4 can be turned off 
    to output the original camera code to the screen if it is needed to test the
    camera in this mode.
Parameters: None
Returns: None
*******************************************************************************/
void RunMode3();

/****** RunMode4() *************************************************************
Purpose: Mode 4 is the first track mode. It takes all of the parts that we
    tested in modes 0 thru 3 and puts them together to [hopefully] make our car
    race around the track. Since we are still just testing the car, Mode 4 will
    limit the top speed of the car just in case something doesn't work. We don't
    want the car to crash into something too fast and break.
Parameters: None
Returns: None
*******************************************************************************/
void RunMode4();

/****** RunMode5() *************************************************************
Purpose: Mode 5 does exactly what mode 4 does, except that it does it FASTER.
    This makes the code VERY easy to write for Mode 5
Parameters: None
Returns: None
*******************************************************************************/
void RunMode5();
