#include <Joystick.h>
#include <N5110.h>
#include "Bullet.h"
#include "Enemy.h"
#include "Sound.h"
#include "Plane.h"
#include "Menu.h"

//objects//
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTD11);
Joystick joystick(PTB10,PTB11,PTC16);
InterruptIn start(PTC5);
InterruptIn buttonX(PTC17);
InterruptIn buttonY(PTC12);
InterruptIn buttonA(PTB9);
InterruptIn buttonB(PTD0);
BusOut output(PTA1,PTA2,PTC2,PTC3,PTC4,PTD3);
Sound sound;

Enemy *enemy = NULL;
Bullet *bullets[5] = {NULL,NULL,NULL,NULL,NULL};
Plane *plane = NULL;
Menu *menu = NULL;

int score[3] = {0,0,0};
int curScore = 0;
int fail = 0;
int Count = 0;
int mode = 0;

void atttack();
void move(int signal);
void shoot();
void welcome();
void over();
void updateScore();
void over();
void init();
void updateGame();

int main(){
    init();
    while(1) {
        menu->welcome(lcd,output,sound);
        menu->menu(lcd,buttonA,buttonY,buttonX,buttonB,start,score,3);
        plane = new Plane();
        plane ->init(37,38,10,10);
        mode = menu->getMode();
        while(1){
            updateGame();
            if (fail == 1){
                int tmp = menu ->again(lcd,curScore,buttonX,buttonY);
                if(tmp == 0)
                    break;
                else{
                    curScore+=tmp;
                    fail = 0;
                    lcd.clear();
                    enemy = NULL;
                }
            }
            Count++;
            if(Count %8 == 0)enemy->setSpeed(enemy->getSpeed()+1);
            wait(1.0f/3);
        }
        over();
        while (start == 0 ){
        }
        lcd.clear();
    }
}
void updateGame(){
    menu->displayCurScore(lcd,curScore);
    Direction d = joystick.get_direction();
    plane->update(d);
    plane->draw(lcd);
    shoot();
    //attack();
    lcd.clear();
}
void init(){
    buttonX.mode(PullDown);
    start.mode(PullDown);
    buttonA.mode(PullDown);
    buttonY.mode(PullDown);
    buttonB.mode(PullDown);
    joystick.init();
    lcd.init();
    menu = new Menu();
}
void over(){
    sound.tone(1500.0,0.5);
    menu->over(lcd,output);
    enemy = NULL;
    for(int i = 0;i<3;i++)bullets[i]=NULL;
    fail = 0;
    Count = 0;
    updateScore();
    curScore = 0;
}
void updateScore(){
    for(int i = 0;i<3;i++){
                    for(int j = 2;j>i;j--){
                        score[j] = score[j-1];
                    }
                    score[i] = curScore;
                    break;
                }
            }
void shoot() {
    if(buttonX == 1){
        for(int i=0;i<5;i++){
            if(bullets[i] == NULL){
                bullets[i] = new Bullet();
                bullets[i] ->init(plane->getPos().x+3,35,5,3);
                break;
            }
        }
    }
    for(int i=0;i<5;i++){
        if(bullets[i]!=NULL){
            bullets[i]->draw(lcd);
            lcd.refresh();
            if(bullets[i]->getPos().x>=enemy->getPos().x && bullets[i]->getPos().x<=(enemy->getPos().x+12)&&bullets[i]->getPos().y<=(enemy->getPos().y+5)){
                    sound.tone(750.0,0.2);
                    bullets[i]=NULL;
                    enemy->setBlood(1);
                    if(enemy->getBlood()<=0){
                        enemy = NULL;
                        curScore+=((mode+1)*2);
                    }
                }else if(bullets[i]->getPos().y<=0){
                    bullets[i] = NULL;
                }else {
                    bullets[i] ->update();
                }
            }
        }
    }
void attack(){
        if(enemy == NULL){
            enemy = new Enemy(mode);
            enemy ->init(12,5);
            enemy ->draw(lcd,mode);
            lcd.refresh();
        }else{
            enemy->update();
            if(enemy->getPos().y>=33){
                fail = 1;
            }else{
                enemy->draw(lcd,mode);
                lcd.refresh();
            }
        }
    }
                    