#include "Sound.h"
#include "mbed.h"
Sound::Sound()
    :
    _timeout(new Timeout()),
    _buzzer(new PwmOut(PTC10))
{}

Sound::~Sound()
{

}
void Sound::tone(float frequency, float duration)
{
    _buzzer->period(1.0f/frequency);
    _buzzer->write(0.5);
    _timeout->attach(callback(this,&Sound::tone_off),duration);
}
void Sound::welcome(){
    tone(1000.0f,0.5f);
    wait(0.5f);
    tone(2000.0f,0.1f);
    wait(0.5f);
    tone(2000.0f,0.2f);
    wait(0.5f);
    tone(3000.0f,0.3f);
    wait(0.5f);
    tone(1200.0f,0.2f);
    wait(0.5f);
    tone(1000.0f,0.3f);
    wait(0.5f);
    tone(2000.0f,0.2f);
    wait(0.5f);
    tone(1000.0f,0.5f);
    wait(0.5f);

}
void Sound::tone_off()
{
    _buzzer->write(0.0);
}