#include "Menu.h"
Menu::Menu(){
    mode = 0;
}
Menu::~Menu(){

}
void Menu::welcome(N5110 &lcd,BusOut &output,Sound &sound)
{
    lcd.printString(" Star War ",0,1);
    lcd.refresh();
    drawEverything(lcd);
    lcd.refresh();
    output=0b000000;
    sound.welcome();
    output=0b111111;
    lcd.clear();
}
void Menu::over(N5110 &lcd,BusOut &output)
{
    lcd.printString("Game Over!",0,1);
    lcd.printString("Press Start",0,4);
    lcd.refresh();
    wait(1.0f);
    output=0b000000;
    wait(1.0f);
    output=0b111111;
    lcd.clear();
}
void Menu::menu(N5110 &lcd,InterruptIn &buttonA,InterruptIn &buttonY,InterruptIn &buttonX,InterruptIn &buttonB,InterruptIn &start,int *score,int n)
{
    lcd.refresh();
    while(1){
        lcd.printString("Start Start",0,0);
        lcd.printString("A Ranking",0,2);
        lcd.printString("X Select Mode",0,3);
        lcd.printString("B Rules",0,4);
        lcd.printString("Y Store",0,5);
        lcd.refresh();
        
        if(buttonA){
            wait(0.5f);
            lcd.clear();
            ranking(lcd,score,n,buttonA);
            }else if(start){
                lcd.clear();
                break;
            }else if(buttonX){
                wait(0.5f);
                lcd.clear();
                setMode(lcd,buttonA,buttonY,buttonX);
            }else if(buttonB){
                wait(0.5f);
                lcd.clear();
                rules(lcd,buttonB);
            }else if(buttonY){
                wait(0.5f);
                lcd.clear();
                store(lcd,buttonY);
            }
        }
    }
void Menu::setMode(N5110 &lcd,InterruptIn &buttonA,InterruptIn &buttonY,InterruptIn &buttonX){
                lcd.refresh();
                while(1){
                    lcd.printString("Y Easy",0,1);
                    lcd.printString("A Normal",0,2);
                    lcd.printString("X Hard",0,3);
                    lcd.refresh();
                    
                if(buttonA){
                    mode = 1;
                    wait(0.5f);
                    lcd.clear();
                    break;
                }
            }
        }
int Menu::getMode(){
        return mode;
    }
void Menu::ranking(N5110 &lcd,int *score,int n,InterruptIn &buttonA){
        while(1){
            for(int i = 0;i<n;i++){
                char buffer[10];
                sprintf(buffer,"%d.%d",i+1,score[i]);
                lcd.printString(buffer,0,i+1);
            }
            lcd.printString("Press A to return",0,5);
            lcd.refresh();
            if(buttonA) {
                lcd.clear();
                wait(0.5f);
                return;
            }
        }
    }
void Menu::displayCurScore(N5110 &lcd,int score) {
        char buffer[4];
        sprintf(buffer,"%d",score);
        lcd.printString(buffer,0,0);
    }
void Menu::drawEverything(N5110 &lcd){
        int enemy[60] = {
            0,0,1,1,1,1,1,1,1,1,0,0,
            0,1,1,1,1,1,1,1,1,1,1,0,
            1,1,1,1,0,1,1,0,1,1,1,1,
            0,1,1,1,1,1,1,1,1,1,1,0,
            0,0,1,1,1,1,1,1,1,1,0,0 };
        Bitmap sprite(enemy,5,12);
        sprite.render(lcd,64,30);
        
        int bullet[15] = {
            0,0,0,1,0,
            1,1,1,1,1,
            0,0,0,1,0 };
        Bitmap spritel(bullet,3,5);
        spritel.render(lcd,40,32);
        
        int _Plane[] = {
            0,0,0,1,0,0,0,0,0,0,
            0,0,0,1,1,1,0,0,0,0,
            0,0,0,1,1,1,0,0,0,0,
            1,1,1,1,1,1,1,1,1,0,
            0,0,1,1,1,1,1,0,1,1,
            1,1,1,1,1,1,1,1,1,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0 };
            
            Bitmap sprite2(_Plane,10,10);
            sprite2.render(lcd,9,28);
        }
void Menu::rules(N5110 &lcd,InterruptIn &buttonB) {
    while(1){
        lcd.clear();
        lcd.printString("X fire bullet",0,0);
        lcd.printString("Joystick move",0,1);
        lcd.printString("Mission",0,2);
        lcd.printString("Destroy enemy",0,3);
        lcd.printString("Press B return",0,5);
        lcd.refresh();
        if(buttonB){
            lcd.clear();
            wait(0.5f);
            return;
        }
    }
}
int Menu::again(N5110 &lcd,int score,InterruptIn &buttonX, InterruptIn &buttonY){
    
    lcd.clear();
    while(1){
        if(score>10){
            lcd.printString("Play Again?",0,0);
            lcd.printString("Price :10",0,2);
            lcd.printString("X Yes",0,3);
            lcd.printString("Y Not",0,4); 
            lcd.refresh();
            if(buttonX){
                wait(0.5f);
                lcd.clear();
                return -10;
            }else if(buttonY){
                wait(0.5f);
                lcd.clear();
                return 0;
            }
        }else{
            lcd.printString("Fail!",0,1);
            lcd.printString("Press Y return",0,2);
            lcd.refresh();
            if(buttonY){
                wait(0.5f);
                lcd.clear();
                return 0;
                }
            }
        }
}

void Menu::store(N5110 &lcd,InterruptIn &buttonY) {
    while(1) {
        lcd.clear();
        int _heart[] = {
            0,1,0,0,0,1,0,
            1,1,1,0,1,1,1,
            1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,
            0,1,1,1,1,1,0,
            0,0,1,1,1,0,0,
            0,0,0,1,0,0,0 };
            Bitmap sprite3(_heart,7,7);
            sprite3.render(lcd,38,5);
            lcd.refresh();
            lcd.printString("In development",0,2);
            lcd.printString("Press Y return",0,5);
            lcd.refresh();
            if(buttonY) {
                lcd.clear();
                wait(0.5f);
                return;
            }
        }
    }