#include "mbed.h"

AnalogIn ain(p20);
AnalogOut aout(p18);

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

// use pin 20 and GND to display a binary read out on the lights
// of the voltage across the pins.
// did not validate this in anyway.
// mrhappy

void bindisplay(int i){

    // based on Kohei Matsumura code.
    wait(0.5);
    led1 = i & 0x01;
    led2 = i>>1 & 0x01;
    led3 = i>>2 & 0x01;
    led4 = i>>3 & 0x01;
         
}

int main() {
    
    float vout = 0;
    
    while(1)
    {
        bindisplay( ain * 0xffff );
        
        vout += 0.1;
        aout = vout;
        
        if (vout > 1) vout = 0;
    }
}