#include "FontPack.h"
#include "mbed.h"

using namespace FontPack;
using namespace std;

static const char FONTPACK_CHAR_WIDTH=5;

//numbers
static const char FONTPACK_0[FONTPACK_CHAR_WIDTH] = {0x7E, 0xE1, 0x99, 0x87, 0x7E};
static const char FONTPACK_1[FONTPACK_CHAR_WIDTH] = {0x21, 0x41, 0xFF, 0x01, 0x01};
static const char FONTPACK_2[FONTPACK_CHAR_WIDTH] = {0x63, 0x85, 0x89, 0x91, 0x61};
static const char FONTPACK_3[FONTPACK_CHAR_WIDTH] = {0x42, 0x81, 0x91, 0x91, 0x6E};
static const char FONTPACK_4[FONTPACK_CHAR_WIDTH] = {0x18, 0x28, 0x48, 0xFF, 0x08};
static const char FONTPACK_5[FONTPACK_CHAR_WIDTH] = {0xF2, 0x91, 0x91, 0x91, 0x8E};
static const char FONTPACK_6[FONTPACK_CHAR_WIDTH] = {0x7E, 0x91, 0x91, 0x91, 0x4E};
static const char FONTPACK_7[FONTPACK_CHAR_WIDTH] = {0x80, 0x8F, 0x90, 0xA0, 0xC0};
static const char FONTPACK_8[FONTPACK_CHAR_WIDTH] = {0x6E, 0x91, 0x91, 0x91, 0x6E};
static const char FONTPACK_9[FONTPACK_CHAR_WIDTH] = {0x70, 0x88, 0x88, 0x90, 0x7F};
//letters
static const char FONTPACK_A[FONTPACK_CHAR_WIDTH] = {0x3F, 0x48, 0x88, 0x48, 0x3F};
static const char FONTPACK_B[FONTPACK_CHAR_WIDTH] = {0xFF, 0x91, 0x91, 0x91, 0x6E};
static const char FONTPACK_C[FONTPACK_CHAR_WIDTH] = {0x7E, 0x81, 0x81, 0x81, 0x42};
static const char FONTPACK_D[FONTPACK_CHAR_WIDTH] = {0xFF, 0x81, 0x81, 0x81, 0x7E};
static const char FONTPACK_E[FONTPACK_CHAR_WIDTH] = {0xFF, 0x91, 0x91, 0x91, 0x91};
static const char FONTPACK_F[FONTPACK_CHAR_WIDTH] = {0xFF, 0x90, 0x90, 0x90, 0x80};
static const char FONTPACK_G[FONTPACK_CHAR_WIDTH] = {0x7E, 0x89, 0x89, 0x6E, 0x08}; //{0x7E, 0x89, 0x89, 0x89, 0x4E}; //
static const char FONTPACK_H[FONTPACK_CHAR_WIDTH] = {0xFF, 0x10, 0x10, 0x10, 0xFF};
static const char FONTPACK_I[FONTPACK_CHAR_WIDTH] = {0x81, 0x81, 0xFF, 0x81, 0x81};
static const char FONTPACK_J[FONTPACK_CHAR_WIDTH] = {0x86, 0x81, 0x81, 0xFE, 0x80};
static const char FONTPACK_K[FONTPACK_CHAR_WIDTH] = {0xFF, 0x18, 0x28, 0x44, 0x83};
static const char FONTPACK_L[FONTPACK_CHAR_WIDTH] = {0xFF, 0x01, 0x01, 0x01, 0x01};
static const char FONTPACK_M[FONTPACK_CHAR_WIDTH] = {0x7F, 0x80, 0x7C, 0x80, 0x7F};
static const char FONTPACK_N[FONTPACK_CHAR_WIDTH] = {0xFF, 0x60, 0x18, 0x06, 0xFF};
static const char FONTPACK_O[FONTPACK_CHAR_WIDTH] = {0x7E, 0x81, 0x81, 0x81, 0x7E};
static const char FONTPACK_P[FONTPACK_CHAR_WIDTH] = {0xFF, 0x88, 0x88, 0x88, 0x70};
static const char FONTPACK_Q[FONTPACK_CHAR_WIDTH] = {0x7E, 0x89, 0x85, 0x7E, 0x01};
static const char FONTPACK_R[FONTPACK_CHAR_WIDTH] = {0xFF, 0x88, 0x88, 0x98, 0x6F};
static const char FONTPACK_S[FONTPACK_CHAR_WIDTH] = {0x62, 0x91, 0x91, 0x91, 0x4E};
static const char FONTPACK_T[FONTPACK_CHAR_WIDTH] = {0x80, 0x80, 0xFF, 0x80, 0x80};
static const char FONTPACK_U[FONTPACK_CHAR_WIDTH] = {0xFE, 0x01, 0x01, 0x01, 0xFE};
static const char FONTPACK_V[FONTPACK_CHAR_WIDTH] = {0xFC, 0x02, 0x01, 0x02, 0xFC};
static const char FONTPACK_W[FONTPACK_CHAR_WIDTH] = {0xFE, 0x01, 0x0E, 0x01, 0xFE};
static const char FONTPACK_X[FONTPACK_CHAR_WIDTH] = {0xC7, 0x28, 0x10, 0x28, 0xC7};
static const char FONTPACK_Y[FONTPACK_CHAR_WIDTH] = {0xE0, 0x10, 0x0F, 0x10, 0xE0};
static const char FONTPACK_Z[FONTPACK_CHAR_WIDTH] = {0x83, 0x85, 0x99, 0xA1, 0xC1};

//special characters
static const char FONTPACK_COLON[FONTPACK_CHAR_WIDTH] = {0x00, 0x00, 0x24, 0x00, 0x00};
static const char FONTPACK_SPACE[FONTPACK_CHAR_WIDTH] = {0,0,0,0,0};
static const char FONTPACK_PERIOD[FONTPACK_CHAR_WIDTH] = {0x00, 0x00, 0x03, 0x03, 0x00};
static const char FONTPACK_EXCLAMATION[FONTPACK_CHAR_WIDTH] ={0x00, 0x00, 0xFB, 0xFB, 0x00};


int FontPack::writeChar(char c, char map[], int index, int col) {
    int out=index;
    FontPackChar myChar = getChar(c);
    if (col >= myChar.nCols) return index; //do nothing
    for (int i=0; i < myChar.nCols; i++) {
        out++;
        map[index+i] = myChar.getCol(i);
    }
    return out+1; //gives a bit of space between letters
}

int FontPack::blank(int index) {
    return index+1;
}

FontPackChar FontPack::getChar(char a) {
    FontPackChar myChar;
    myChar.nCols = FONTPACK_CHAR_WIDTH;

    switch (a) {
        case '0':
            myChar.col = FONTPACK_0;
            break;
        case '1':
            myChar.col = FONTPACK_1;
            break;
        case '2':
            myChar.col = FONTPACK_2;
            break;
        case '3':
            myChar.col = FONTPACK_3;
            break;
        case '4':
            myChar.col = FONTPACK_4;
            break;
        case '5':
            myChar.col = FONTPACK_5;
            break;
        case '6':
            myChar.col = FONTPACK_6;
            break;
        case '7':
            myChar.col = FONTPACK_7;
            break;
        case '8':
            myChar.col = FONTPACK_8;
            break;
        case '9':
            myChar.col = FONTPACK_9;
            break;
        case 'A':
        case 'a':
            myChar.col = FONTPACK_A;
            break;
        case 'B':
        case 'b':
            myChar.col = FONTPACK_B;
            break;
        case 'C':
        case 'c':
            myChar.col = FONTPACK_C;
            break;
        case 'D':
        case 'd':
            myChar.col = FONTPACK_D;
            break;
        case 'E':
        case 'e':
            myChar.col = FONTPACK_E;
            break;
        case 'F':
        case 'f':
            myChar.col = FONTPACK_F;
            break;
        case 'G':
        case 'g':
            myChar.col = FONTPACK_G;
            break;
        case 'H':
        case 'h':
            myChar.col = FONTPACK_H;
            break;
        case 'I':
        case 'i':
            myChar.col = FONTPACK_I;
            break;
        case 'J':
        case 'j':
            myChar.col = FONTPACK_J;
            break;
        case 'K':
        case 'k':
            myChar.col = FONTPACK_K;
            break;
        case 'L':
        case 'l':
            myChar.col = FONTPACK_L;
            break;
        case 'M':
        case 'm':
            myChar.col = FONTPACK_M;
            break;
        case 'N':
        case 'n':
            myChar.col = FONTPACK_N;
            break;
        case 'O':
        case 'o':
            myChar.col = FONTPACK_O;
            break;
        case 'P':
        case 'p':
            myChar.col = FONTPACK_P;
            break;
        case 'Q':
        case 'q':
            myChar.col = FONTPACK_Q;
            break;
        case 'R':
        case 'r':
            myChar.col = FONTPACK_R;
            break;
        case 'S':
        case 's':
            myChar.col = FONTPACK_S;
            break;
        case 'T':
        case 't':
            myChar.col = FONTPACK_T;
            break;
        case 'U':
        case 'u':
            myChar.col = FONTPACK_U;
            break;
        case 'V':
        case 'v':
            myChar.col = FONTPACK_V;
            break;
        case 'W':
        case 'w':
            myChar.col = FONTPACK_W;
            break;
        case 'X':
        case 'x':
            myChar.col = FONTPACK_X;
            break;
        case 'Y':
        case 'y':
            myChar.col = FONTPACK_Y;
            break;
        case 'Z':
        case 'z':
            myChar.col = FONTPACK_Z;
            break;
        case ':':
            myChar.col = FONTPACK_COLON;
            break;
        case '.':
            myChar.col = FONTPACK_PERIOD;
            break;
        case ' ':
            myChar.col = FONTPACK_SPACE;
            break;
        case '!':
            myChar.col = FONTPACK_EXCLAMATION;
            break;
        default:
            myChar.col = FONTPACK_SPACE;
            break;

    }
    return myChar;
}