#include "mbed.h"
#include "WatchdogTimer.h"


// "kick" or "feed" the dog - reset the watchdog timer
// by writing this required bit pattern
void WatchdogTimer::kick() {
    LPC_WDT->WDFEED = 0xAA;
    LPC_WDT->WDFEED = 0x55;
}
// Load timeout value in watchdog timer and enable
void WatchdogTimer::kick(float timeInSecond) {
    LPC_WDT->WDCLKSEL = 0x1;                // Set CLK src to PCLK
    uint32_t clk = SystemCoreClock / 16;    // WD has a fixed /4 prescaler, PCLK default is /4
    LPC_WDT->WDTC = timeInSecond * (float)clk;
    LPC_WDT->WDMOD = 0x3;                   // Enabled and Reset
    kick();
}

