//Code to send serial comms on 
//mbed appBoard with xbees
#include "mbed.h"
#include "C12832_lcd.h" // Include for LCD code
#include "stdlib.h" 
#include"string"
#include"stdio.h"
#include "hcsr04.h"

// watchdog

class Watchdog {
public:
// Load timeout value in watchdog timer and enable
    void kick(float s) {
        LPC_WDT->WDCLKSEL = 0x1;                // Set CLK src to PCLK
        uint32_t clk = SystemCoreClock / 16;    // WD has a fixed /4 prescaler, PCLK default is /4
        LPC_WDT->WDTC = s * (float)clk;
        LPC_WDT->WDMOD = 0x3;                   // Enabled and Reset
        kick();
    }
// "kick" or "feed" the dog - reset the watchdog timer
// by writing this required bit pattern
    void kick() {
        LPC_WDT->WDFEED = 0xAA;
        LPC_WDT->WDFEED = 0x55;
    }
};

Watchdog wdt;

//int SendSt (string );
HCSR04  usensor(p12,p13); // trig p12, echo p13
//Initialize xbee
Serial xbee(p9, p10);
DigitalOut rst1(p30);

//Initialize lcd
C12832_LCD lcd;
 
int main() 
{
   wdt.kick(5.0);
   // reset the xbees (at least 200ns)
    rst1 = 0;
    wait_ms(1); 
    rst1 = 1;
    wait_ms(1);
    //Setup LCD screen
    lcd.cls();     
    lcd.locate(0,1);
//--------------------------------variables------------------------------------
    int s[]={'0','1','2','3','4','5','6','7','8','9'}; 
    int s1[]={11,50,11,11};
    int i;
    int n;
    int dist, toSend,dist1;
    while(1) 
    {
        usensor.start();
        wait_ms(500); 
        dist=0;
        for(int i=0;i<20;i++)
            dist+=usensor.get_dist_cm();
        dist/=20;
        dist1=dist;
        xbee.putc('$');
        lcd.locate(0,0);
        lcd.printf("The distance is : %d   ",dist1);
        
        i=0;
        do
        {
            toSend=dist%10;
            s1[i]=s[toSend];
            i++;
            dist/=10;
        }while(dist!=0);

        for(n=i-1;n>=0;n--)
        {
            xbee.putc(s1[n]); 

        }

        xbee.putc('$');
        wdt.kick();
        
    }//while(1)
}// int main()