//Code to recieve serial comms on 
//mbed appBoard with xbees
#include "mbed.h"
#include "C12832_lcd.h" // Include for LCD code
#include "stdlib.h" 
#include"string"
#include"stdio.h"
#include "WiflyInterface.h"
#include "HTTPClient.h"


//          watchdog
class Watchdog {
public:
// Load timeout value in watchdog timer and enable
    void kick(float s) {
        LPC_WDT->WDCLKSEL = 0x1;                // Set CLK src to PCLK
        uint32_t clk = SystemCoreClock / 16;    // WD has a fixed /4 prescaler, PCLK default is /4
        LPC_WDT->WDTC = s * (float)clk;
        LPC_WDT->WDMOD = 0x3;                   // Enabled and Reset
        kick();
    }
// "kick" or "feed" the dog - reset the watchdog timer
// by writing this required bit pattern
    void kick() {
        LPC_WDT->WDFEED = 0xAA;
        LPC_WDT->WDFEED = 0x55;
    }
};
 
// Setup the watchdog timer
Watchdog wdt;


//  Variable
//      In lab version
//WiflyInterface wifly(p9, p10, p30, p29, "stroustrup", "stroustrupfsktm", WPA);
WiflyInterface wifly(p9, p10, p30, p29, "FSKTM-Training", "Training2018", WPA);
HTTPClient http;
char str[5];
int iPrint;
C12832_LCD lcd;
Serial xbee(p13, p14);
DigitalOut rst1(p15);
DigitalOut myled(LED1); 

Ticker myTicker;
int loadingStatus = 0;

void loadingcharLcd(void)
{
    lcd.locate(120,20);
    if(loadingStatus == 0)
        lcd.printf("-");
    else if(loadingStatus == 1)
        lcd.printf("\\");
    else if(loadingStatus == 2)
        lcd.printf("|");
    else if(loadingStatus == 3)
    {
        lcd.printf("/");
        loadingStatus = -1;
    }
    loadingStatus++;
    
        
}

//  Function
void SendDataToThingSpeak (int iValue);
void InitiateWifi(void);
void InitiateXbee(void);
void ReadXbee ();
//  int main 
int main() 
{
    wdt.kick(50.0); 
    while(1) 
    {
// call read xbee
        

        ReadXbee(); 
        lcd.cls();  
        lcd.locate(0,1);        
        lcd.printf("The distance is : %d   \n",iPrint);
        wait(1);
        lcd.cls();  
        lcd.locate(0,1);        
        lcd.printf("Wifi-connection verification... \n");
        
        myTicker.attach(&loadingcharLcd, 0.25);
        
        InitiateWifi();
        
        myTicker.detach();
        lcd.cls();
        lcd.locate(0,1);
        lcd.printf("Wifi-connection verification\nDone!");
        wait_ms(400);
        
        SendDataToThingSpeak(iPrint);
        wifly.disconnect();
//        wifly.disconnect();
//        InitiateXbee();
//        wait (2);
    } //while(1)
}// int main()

void SendDataToThingSpeak (int iValue)
{
    int iCounter=-1;
    char reverseData[4];
    int toSend;
    toSend=iValue;
    char tempStr[] = "https://api.thingspeak.com/update?api_key=PQXV093BQK2UNXIV&field2=    ";
    
 
    do
    {
        iCounter++;
        reverseData[iCounter]=toSend%10;
        reverseData[iCounter]+=48;
        toSend/=10;
    }while(toSend!=0);
    
   

    
    for(int i= 0; i < iCounter+1; i++)
    {
        tempStr[66+i]= reverseData[iCounter-i];  
    }
  //  tempStr[67+iCounter]='/';
    printf("iC %d RD %s \n", iCounter, reverseData);
    
    lcd.cls();  
    lcd.locate(0,1);
    lcd.printf("iC %d RD %s \n", iCounter, reverseData);       
    
    HTTPMap map;
    HTTPText text(str, 1);
    map.put("", "");
//    tempStr[66]=55;
    char tempStr1[] = "https://api.thingspeak.com/";
    printf("Trying to post data to the Cloud...%s \n", tempStr1);
    
    lcd.cls();  
    lcd.locate(0,1);    
    lcd.printf("Uploading To Cloud\nTHINGSPEAK");
    
    myTicker.attach(&loadingcharLcd, 0.25);

    http.post(tempStr, map, &text,1);
    
    myTicker.detach();
  
}// void SendDataToThingSpeak

void InitiateWifi(void)
{
    
    wifly.init(); //Use DHCP
    wifly.connect(); 
//    wait (2);
}// wifi

void InitiateXbee(void)
{
    rst1 = 0;
    wait_ms(10); 
    rst1 = 1;
    wait_ms(10);
    
} // xbee

void ReadXbee (void)
{
    printf("Waiting For The Sensor Node To Send Sensor Data To The Gateway \n");
    
    lcd.cls();  
    lcd.locate(0,1);    
    lcd.printf("Receiving Data From Sensor Node...\n");
    
     myTicker.attach(&loadingcharLcd, 0.25);
    

    
    InitiateXbee();
    int toPrint=0;
    for(int j=0;j<18;j++)
        toPrint=xbee.getc(); 

   iPrint=0;

   do
    {
        toPrint=xbee.getc();
        //printf("toPrint %c \n", toPrint);
    }while(toPrint!='$');
    while (!(xbee.readable()));
    toPrint=xbee.getc();
    //printf("toPrint %c \n", toPrint);
    iPrint=0;
    if(toPrint=='$')
    {
        do{
            toPrint=xbee.getc();
        }while(toPrint=='$');    
    }
  
    while (!(toPrint=='$'))
    {
        iPrint=(toPrint-48)+iPrint*10;
        //printf("iPrint %d \n", iPrint);
        while (!(xbee.readable()));
        toPrint=xbee.getc();
        printf("toPr %d , iPr %d \n", toPrint, iPrint);
        if ((LPC_WDT->WDMOD >> 2) & 1)
            printf("WatchDog :: Status On");    

           
    }   
    printf("The Sensor Data Has Been Received \n");
    
    lcd.cls();
    lcd.locate(0,1);    
    lcd.printf("he Sensor Data Has Been Received \n");
    
    wdt.kick();
    

    myTicker.detach();
    
}
