/*******************************************************************************
* DISCLAIMER
* This software is supplied by Renesas Electronics Corporation and is only
* intended for use with Renesas products. No other uses are authorized. This
* software is owned by Renesas Electronics Corporation and is protected under
* all applicable laws, including copyright laws.
* THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES REGARDING
* THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING BUT NOT
* LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
* AND NON-INFRINGEMENT. ALL SUCH WARRANTIES ARE EXPRESSLY DISCLAIMED.
* TO THE MAXIMUM EXTENT PERMITTED NOT PROHIBITED BY LAW, NEITHER RENESAS
* ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES SHALL BE LIABLE
* FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES FOR
* ANY REASON RELATED TO THIS SOFTWARE, EVEN IF RENESAS OR ITS AFFILIATES HAVE
* BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
* Renesas reserves the right, without notice, to make changes to this software
* and to discontinue the availability of this software. By using this software,
* you agree to the additional terms and conditions found by accessing the
* following link:
* http://www.renesas.com/disclaimer
* Copyright (C) 2012 - 2014 Renesas Electronics Corporation. All rights reserved.
*******************************************************************************/
/*******************************************************************************
* File Name   : gpio_iobitmask.h
* $Rev: 1115 $
* $Date:: 2014-07-09 15:35:02 +0900#$
* Description : General purpose I/O ports register define header
*******************************************************************************/
#ifndef GPIO_IOBITMASK_H
#define GPIO_IOBITMASK_H


/* ==== Mask values for IO registers ==== */
/* ---- P0 ---- */
#define GPIO_PPR0_PPR00                         (0x0001u)
#define GPIO_PPR0_PPR01                         (0x0002u)
#define GPIO_PPR0_PPR02                         (0x0004u)
#define GPIO_PPR0_PPR03                         (0x0008u)
#define GPIO_PPR0_PPR04                         (0x0010u)
#define GPIO_PPR0_PPR05                         (0x0020u)

#define GPIO_PMC0_PMC04                         (0x0010u)
#define GPIO_PMC0_PMC05                         (0x0020u)

#define GPIO_PMCSR0_PMCSR04                     (0x00000010uL)
#define GPIO_PMCSR0_PMCSR05                     (0x00000020uL)

#define GPIO_PIBC0_PIBC00                       (0x0001u)
#define GPIO_PIBC0_PIBC01                       (0x0002u)
#define GPIO_PIBC0_PIBC02                       (0x0004u)
#define GPIO_PIBC0_PIBC03                       (0x0008u)
#define GPIO_PIBC0_PIBC04                       (0x0010u)
#define GPIO_PIBC0_PIBC05                       (0x0020u)

/* ---- P1 ---- */
#define GPIO_P1_P10                             (0x0001u)
#define GPIO_P1_P11                             (0x0002u)
#define GPIO_P1_P12                             (0x0004u)
#define GPIO_P1_P13                             (0x0008u)
#define GPIO_P1_P14                             (0x0010u)
#define GPIO_P1_P15                             (0x0020u)
#define GPIO_P1_P16                             (0x0040u)
#define GPIO_P1_P17                             (0x0080u)

#define GPIO_PSR1_PSR10                         (0x00000001uL)
#define GPIO_PSR1_PSR11                         (0x00000002uL)
#define GPIO_PSR1_PSR12                         (0x00000004uL)
#define GPIO_PSR1_PSR13                         (0x00000008uL)
#define GPIO_PSR1_PSR14                         (0x00000010uL)
#define GPIO_PSR1_PSR15                         (0x00000020uL)
#define GPIO_PSR1_PSR16                         (0x00000040uL)
#define GPIO_PSR1_PSR17                         (0x00000080uL)
#define GPIO_PSR1_PSR116                        (0x00010000uL)
#define GPIO_PSR1_PSR117                        (0x00020000uL)
#define GPIO_PSR1_PSR118                        (0x00040000uL)
#define GPIO_PSR1_PSR119                        (0x00080000uL)
#define GPIO_PSR1_PSR120                        (0x00100000uL)
#define GPIO_PSR1_PSR121                        (0x00200000uL)
#define GPIO_PSR1_PSR122                        (0x00400000uL)
#define GPIO_PSR1_PSR123                        (0x00800000uL)

#define GPIO_PPR1_PPR10                         (0x0001u)
#define GPIO_PPR1_PPR11                         (0x0002u)
#define GPIO_PPR1_PPR12                         (0x0004u)
#define GPIO_PPR1_PPR13                         (0x0008u)
#define GPIO_PPR1_PPR14                         (0x0010u)
#define GPIO_PPR1_PPR15                         (0x0020u)
#define GPIO_PPR1_PPR16                         (0x0040u)
#define GPIO_PPR1_PPR17                         (0x0080u)
#define GPIO_PPR1_PPR18                         (0x0100u)
#define GPIO_PPR1_PPR19                         (0x0200u)
#define GPIO_PPR1_PPR110                        (0x0400u)
#define GPIO_PPR1_PPR111                        (0x0800u)
#define GPIO_PPR1_PPR112                        (0x1000u)
#define GPIO_PPR1_PPR113                        (0x2000u)
#define GPIO_PPR1_PPR114                        (0x4000u)
#define GPIO_PPR1_PPR115                        (0x8000u)

#define GPIO_PM1_PM10                           (0x0001u)
#define GPIO_PM1_PM11                           (0x0002u)
#define GPIO_PM1_PM12                           (0x0004u)
#define GPIO_PM1_PM13                           (0x0008u)
#define GPIO_PM1_PM14                           (0x0010u)
#define GPIO_PM1_PM15                           (0x0020u)
#define GPIO_PM1_PM16                           (0x0040u)
#define GPIO_PM1_PM17                           (0x0080u)

#define GPIO_PMC1_PMC10                         (0x0001u)
#define GPIO_PMC1_PMC11                         (0x0002u)
#define GPIO_PMC1_PMC12                         (0x0004u)
#define GPIO_PMC1_PMC13                         (0x0008u)
#define GPIO_PMC1_PMC14                         (0x0010u)
#define GPIO_PMC1_PMC15                         (0x0020u)
#define GPIO_PMC1_PMC16                         (0x0040u)
#define GPIO_PMC1_PMC17                         (0x0080u)
#define GPIO_PMC1_PMC18                         (0x0100u)
#define GPIO_PMC1_PMC19                         (0x0200u)
#define GPIO_PMC1_PMC110                        (0x0400u)
#define GPIO_PMC1_PMC111                        (0x0800u)
#define GPIO_PMC1_PMC112                        (0x1000u)
#define GPIO_PMC1_PMC113                        (0x2000u)
#define GPIO_PMC1_PMC114                        (0x4000u)
#define GPIO_PMC1_PMC115                        (0x8000u)

#define GPIO_PFC1_PFC10                         (0x0001u)
#define GPIO_PFC1_PFC11                         (0x0002u)
#define GPIO_PFC1_PFC12                         (0x0004u)
#define GPIO_PFC1_PFC13                         (0x0008u)
#define GPIO_PFC1_PFC14                         (0x0010u)
#define GPIO_PFC1_PFC15                         (0x0020u)
#define GPIO_PFC1_PFC16                         (0x0040u)
#define GPIO_PFC1_PFC17                         (0x0080u)
#define GPIO_PFC1_PFC18                         (0x0100u)
#define GPIO_PFC1_PFC19                         (0x0200u)
#define GPIO_PFC1_PFC110                        (0x0400u)
#define GPIO_PFC1_PFC111                        (0x0800u)
#define GPIO_PFC1_PFC112                        (0x1000u)
#define GPIO_PFC1_PFC113                        (0x2000u)
#define GPIO_PFC1_PFC114                        (0x4000u)
#define GPIO_PFC1_PFC115                        (0x8000u)

#define GPIO_PFCE1_PFCE10                       (0x0001u)
#define GPIO_PFCE1_PFCE11                       (0x0002u)
#define GPIO_PFCE1_PFCE12                       (0x0004u)
#define GPIO_PFCE1_PFCE13                       (0x0008u)
#define GPIO_PFCE1_PFCE14                       (0x0010u)
#define GPIO_PFCE1_PFCE15                       (0x0020u)
#define GPIO_PFCE1_PFCE16                       (0x0040u)
#define GPIO_PFCE1_PFCE17                       (0x0080u)
#define GPIO_PFCE1_PFCE18                       (0x0100u)
#define GPIO_PFCE1_PFCE19                       (0x0200u)
#define GPIO_PFCE1_PFCE110                      (0x0400u)
#define GPIO_PFCE1_PFCE111                      (0x0800u)
#define GPIO_PFCE1_PFCE112                      (0x1000u)
#define GPIO_PFCE1_PFCE113                      (0x2000u)
#define GPIO_PFCE1_PFCE114                      (0x4000u)
#define GPIO_PFCE1_PFCE115                      (0x8000u)

#define GPIO_PNOT1_PNOT10                       (0x0001u)
#define GPIO_PNOT1_PNOT11                       (0x0002u)
#define GPIO_PNOT1_PNOT12                       (0x0004u)
#define GPIO_PNOT1_PNOT13                       (0x0008u)
#define GPIO_PNOT1_PNOT14                       (0x0010u)
#define GPIO_PNOT1_PNOT15                       (0x0020u)
#define GPIO_PNOT1_PNOT16                       (0x0040u)
#define GPIO_PNOT1_PNOT17                       (0x0080u)

#define GPIO_PMSR1_PMSR10                       (0x00000001uL)
#define GPIO_PMSR1_PMSR11                       (0x00000002uL)
#define GPIO_PMSR1_PMSR12                       (0x00000004uL)
#define GPIO_PMSR1_PMSR13                       (0x00000008uL)
#define GPIO_PMSR1_PMSR14                       (0x00000010uL)
#define GPIO_PMSR1_PMSR15                       (0x00000020uL)
#define GPIO_PMSR1_PMSR16                       (0x00000040uL)
#define GPIO_PMSR1_PMSR17                       (0x00000080uL)
#define GPIO_PMSR1_PMSR116                      (0x00010000uL)
#define GPIO_PMSR1_PMSR117                      (0x00020000uL)
#define GPIO_PMSR1_PMSR118                      (0x00040000uL)
#define GPIO_PMSR1_PMSR119                      (0x00080000uL)
#define GPIO_PMSR1_PMSR120                      (0x00100000uL)
#define GPIO_PMSR1_PMSR121                      (0x00200000uL)
#define GPIO_PMSR1_PMSR122                      (0x00400000uL)
#define GPIO_PMSR1_PMSR123                      (0x00800000uL)

#define GPIO_PMCSR1_PMCSR10                     (0x00000001uL)
#define GPIO_PMCSR1_PMCSR11                     (0x00000002uL)
#define GPIO_PMCSR1_PMCSR12                     (0x00000004uL)
#define GPIO_PMCSR1_PMCSR13                     (0x00000008uL)
#define GPIO_PMCSR1_PMCSR14                     (0x00000010uL)
#define GPIO_PMCSR1_PMCSR15                     (0x00000020uL)
#define GPIO_PMCSR1_PMCSR16                     (0x00000040uL)
#define GPIO_PMCSR1_PMCSR17                     (0x00000080uL)
#define GPIO_PMCSR1_PMCSR116                    (0x00010000uL)
#define GPIO_PMCSR1_PMCSR117                    (0x00020000uL)
#define GPIO_PMCSR1_PMCSR118                    (0x00040000uL)
#define GPIO_PMCSR1_PMCSR119                    (0x00080000uL)
#define GPIO_PMCSR1_PMCSR120                    (0x00100000uL)
#define GPIO_PMCSR1_PMCSR121                    (0x00200000uL)
#define GPIO_PMCSR1_PMCSR122                    (0x00400000uL)
#define GPIO_PMCSR1_PMCSR123                    (0x00800000uL)

#define GPIO_PFCAE1_PFCAE10                     (0x0001u)
#define GPIO_PFCAE1_PFCAE11                     (0x0002u)
#define GPIO_PFCAE1_PFCAE12                     (0x0004u)
#define GPIO_PFCAE1_PFCAE13                     (0x0008u)
#define GPIO_PFCAE1_PFCAE14                     (0x0010u)
#define GPIO_PFCAE1_PFCAE15                     (0x0020u)
#define GPIO_PFCAE1_PFCAE16                     (0x0040u)
#define GPIO_PFCAE1_PFCAE17                     (0x0080u)
#define GPIO_PFCAE1_PFCAE18                     (0x0100u)
#define GPIO_PFCAE1_PFCAE19                     (0x0200u)
#define GPIO_PFCAE1_PFCAE110                    (0x0400u)
#define GPIO_PFCAE1_PFCAE111                    (0x0800u)
#define GPIO_PFCAE1_PFCAE112                    (0x1000u)
#define GPIO_PFCAE1_PFCAE113                    (0x2000u)
#define GPIO_PFCAE1_PFCAE114                    (0x4000u)
#define GPIO_PFCAE1_PFCAE115                    (0x8000u)

#define GPIO_PIBC1_PIBC10                       (0x0001u)
#define GPIO_PIBC1_PIBC11                       (0x0002u)
#define GPIO_PIBC1_PIBC12                       (0x0004u)
#define GPIO_PIBC1_PIBC13                       (0x0008u)
#define GPIO_PIBC1_PIBC14                       (0x0010u)
#define GPIO_PIBC1_PIBC15                       (0x0020u)
#define GPIO_PIBC1_PIBC16                       (0x0040u)
#define GPIO_PIBC1_PIBC17                       (0x0080u)
#define GPIO_PIBC1_PIBC18                       (0x0100u)
#define GPIO_PIBC1_PIBC19                       (0x0200u)
#define GPIO_PIBC1_PIBC110                      (0x0400u)
#define GPIO_PIBC1_PIBC111                      (0x0800u)
#define GPIO_PIBC1_PIBC112                      (0x1000u)
#define GPIO_PIBC1_PIBC113                      (0x2000u)
#define GPIO_PIBC1_PIBC114                      (0x4000u)
#define GPIO_PIBC1_PIBC115                      (0x8000u)

#define GPIO_PBDC1_PBDC10                       (0x0001u)
#define GPIO_PBDC1_PBDC11                       (0x0002u)
#define GPIO_PBDC1_PBDC12                       (0x0004u)
#define GPIO_PBDC1_PBDC13                       (0x0008u)
#define GPIO_PBDC1_PBDC14                       (0x0010u)
#define GPIO_PBDC1_PBDC15                       (0x0020u)
#define GPIO_PBDC1_PBDC16                       (0x0040u)
#define GPIO_PBDC1_PBDC17                       (0x0080u)
#define GPIO_PBDC1_PBDC18                       (0x0100u)
#define GPIO_PBDC1_PBDC19                       (0x0200u)
#define GPIO_PBDC1_PBDC110                      (0x0400u)
#define GPIO_PBDC1_PBDC111                      (0x0800u)
#define GPIO_PBDC1_PBDC112                      (0x1000u)
#define GPIO_PBDC1_PBDC113                      (0x2000u)
#define GPIO_PBDC1_PBDC114                      (0x4000u)
#define GPIO_PBDC1_PBDC115                      (0x8000u)

#define GPIO_PIPC1_PIPC10                       (0x0001u)
#define GPIO_PIPC1_PIPC11                       (0x0002u)
#define GPIO_PIPC1_PIPC12                       (0x0004u)
#define GPIO_PIPC1_PIPC13                       (0x0008u)
#define GPIO_PIPC1_PIPC14                       (0x0010u)
#define GPIO_PIPC1_PIPC15                       (0x0020u)
#define GPIO_PIPC1_PIPC16                       (0x0040u)
#define GPIO_PIPC1_PIPC17                       (0x0080u)

/* ---- P2 ---- */
#define GPIO_P2_P20                             (0x0001u)
#define GPIO_P2_P21                             (0x0002u)
#define GPIO_P2_P22                             (0x0004u)
#define GPIO_P2_P23                             (0x0008u)
#define GPIO_P2_P24                             (0x0010u)
#define GPIO_P2_P25                             (0x0020u)
#define GPIO_P2_P26                             (0x0040u)
#define GPIO_P2_P27                             (0x0080u)
#define GPIO_P2_P28                             (0x0100u)
#define GPIO_P2_P29                             (0x0200u)
#define GPIO_P2_P210                            (0x0400u)
#define GPIO_P2_P211                            (0x0800u)
#define GPIO_P2_P212                            (0x1000u)
#define GPIO_P2_P213                            (0x2000u)
#define GPIO_P2_P214                            (0x4000u)
#define GPIO_P2_P215                            (0x8000u)

#define GPIO_PSR2_PSR20                         (0x00000001uL)
#define GPIO_PSR2_PSR21                         (0x00000002uL)
#define GPIO_PSR2_PSR22                         (0x00000004uL)
#define GPIO_PSR2_PSR23                         (0x00000008uL)
#define GPIO_PSR2_PSR24                         (0x00000010uL)
#define GPIO_PSR2_PSR25                         (0x00000020uL)
#define GPIO_PSR2_PSR26                         (0x00000040uL)
#define GPIO_PSR2_PSR27                         (0x00000080uL)
#define GPIO_PSR2_PSR28                         (0x00000100uL)
#define GPIO_PSR2_PSR29                         (0x00000200uL)
#define GPIO_PSR2_PSR210                        (0x00000400uL)
#define GPIO_PSR2_PSR211                        (0x00000800uL)
#define GPIO_PSR2_PSR212                        (0x00001000uL)
#define GPIO_PSR2_PSR213                        (0x00002000uL)
#define GPIO_PSR2_PSR214                        (0x00004000uL)
#define GPIO_PSR2_PSR215                        (0x00008000uL)
#define GPIO_PSR2_PSR216                        (0x00010000uL)
#define GPIO_PSR2_PSR217                        (0x00020000uL)
#define GPIO_PSR2_PSR218                        (0x00040000uL)
#define GPIO_PSR2_PSR219                        (0x00080000uL)
#define GPIO_PSR2_PSR220                        (0x00100000uL)
#define GPIO_PSR2_PSR221                        (0x00200000uL)
#define GPIO_PSR2_PSR222                        (0x00400000uL)
#define GPIO_PSR2_PSR223                        (0x00800000uL)
#define GPIO_PSR2_PSR224                        (0x01000000uL)
#define GPIO_PSR2_PSR225                        (0x02000000uL)
#define GPIO_PSR2_PSR226                        (0x04000000uL)
#define GPIO_PSR2_PSR227                        (0x08000000uL)
#define GPIO_PSR2_PSR228                        (0x10000000uL)
#define GPIO_PSR2_PSR229                        (0x20000000uL)
#define GPIO_PSR2_PSR230                        (0x40000000uL)
#define GPIO_PSR2_PSR231                        (0x80000000uL)

#define GPIO_PPR2_PPR20                         (0x0001u)
#define GPIO_PPR2_PPR21                         (0x0002u)
#define GPIO_PPR2_PPR22                         (0x0004u)
#define GPIO_PPR2_PPR23                         (0x0008u)
#define GPIO_PPR2_PPR24                         (0x0010u)
#define GPIO_PPR2_PPR25                         (0x0020u)
#define GPIO_PPR2_PPR26                         (0x0040u)
#define GPIO_PPR2_PPR27                         (0x0080u)
#define GPIO_PPR2_PPR28                         (0x0100u)
#define GPIO_PPR2_PPR29                         (0x0200u)
#define GPIO_PPR2_PPR210                        (0x0400u)
#define GPIO_PPR2_PPR211                        (0x0800u)
#define GPIO_PPR2_PPR212                        (0x1000u)
#define GPIO_PPR2_PPR213                        (0x2000u)
#define GPIO_PPR2_PPR214                        (0x4000u)
#define GPIO_PPR2_PPR215                        (0x8000u)

#define GPIO_PM2_PM20                           (0x0001u)
#define GPIO_PM2_PM21                           (0x0002u)
#define GPIO_PM2_PM22                           (0x0004u)
#define GPIO_PM2_PM23                           (0x0008u)
#define GPIO_PM2_PM24                           (0x0010u)
#define GPIO_PM2_PM25                           (0x0020u)
#define GPIO_PM2_PM26                           (0x0040u)
#define GPIO_PM2_PM27                           (0x0080u)
#define GPIO_PM2_PM28                           (0x0100u)
#define GPIO_PM2_PM29                           (0x0200u)
#define GPIO_PM2_PM210                          (0x0400u)
#define GPIO_PM2_PM211                          (0x0800u)
#define GPIO_PM2_PM212                          (0x1000u)
#define GPIO_PM2_PM213                          (0x2000u)
#define GPIO_PM2_PM214                          (0x4000u)
#define GPIO_PM2_PM215                          (0x8000u)

#define GPIO_PMC2_PMC20                         (0x0001u)
#define GPIO_PMC2_PMC21                         (0x0002u)
#define GPIO_PMC2_PMC22                         (0x0004u)
#define GPIO_PMC2_PMC23                         (0x0008u)
#define GPIO_PMC2_PMC24                         (0x0010u)
#define GPIO_PMC2_PMC25                         (0x0020u)
#define GPIO_PMC2_PMC26                         (0x0040u)
#define GPIO_PMC2_PMC27                         (0x0080u)
#define GPIO_PMC2_PMC28                         (0x0100u)
#define GPIO_PMC2_PMC29                         (0x0200u)
#define GPIO_PMC2_PMC210                        (0x0400u)
#define GPIO_PMC2_PMC211                        (0x0800u)
#define GPIO_PMC2_PMC212                        (0x1000u)
#define GPIO_PMC2_PMC213                        (0x2000u)
#define GPIO_PMC2_PMC214                        (0x4000u)
#define GPIO_PMC2_PMC215                        (0x8000u)

#define GPIO_PFC2_PFC20                         (0x0001u)
#define GPIO_PFC2_PFC21                         (0x0002u)
#define GPIO_PFC2_PFC22                         (0x0004u)
#define GPIO_PFC2_PFC23                         (0x0008u)
#define GPIO_PFC2_PFC24                         (0x0010u)
#define GPIO_PFC2_PFC25                         (0x0020u)
#define GPIO_PFC2_PFC26                         (0x0040u)
#define GPIO_PFC2_PFC27                         (0x0080u)
#define GPIO_PFC2_PFC28                         (0x0100u)
#define GPIO_PFC2_PFC29                         (0x0200u)
#define GPIO_PFC2_PFC210                        (0x0400u)
#define GPIO_PFC2_PFC211                        (0x0800u)
#define GPIO_PFC2_PFC212                        (0x1000u)
#define GPIO_PFC2_PFC213                        (0x2000u)
#define GPIO_PFC2_PFC214                        (0x4000u)
#define GPIO_PFC2_PFC215                        (0x8000u)

#define GPIO_PFCE2_PFCE20                       (0x0001u)
#define GPIO_PFCE2_PFCE21                       (0x0002u)
#define GPIO_PFCE2_PFCE22                       (0x0004u)
#define GPIO_PFCE2_PFCE23                       (0x0008u)
#define GPIO_PFCE2_PFCE24                       (0x0010u)
#define GPIO_PFCE2_PFCE25                       (0x0020u)
#define GPIO_PFCE2_PFCE26                       (0x0040u)
#define GPIO_PFCE2_PFCE27                       (0x0080u)
#define GPIO_PFCE2_PFCE28                       (0x0100u)
#define GPIO_PFCE2_PFCE29                       (0x0200u)
#define GPIO_PFCE2_PFCE210                      (0x0400u)
#define GPIO_PFCE2_PFCE211                      (0x0800u)
#define GPIO_PFCE2_PFCE212                      (0x1000u)
#define GPIO_PFCE2_PFCE213                      (0x2000u)
#define GPIO_PFCE2_PFCE214                      (0x4000u)
#define GPIO_PFCE2_PFCE215                      (0x8000u)

#define GPIO_PNOT2_PNOT20                       (0x0001u)
#define GPIO_PNOT2_PNOT21                       (0x0002u)
#define GPIO_PNOT2_PNOT22                       (0x0004u)
#define GPIO_PNOT2_PNOT23                       (0x0008u)
#define GPIO_PNOT2_PNOT24                       (0x0010u)
#define GPIO_PNOT2_PNOT25                       (0x0020u)
#define GPIO_PNOT2_PNOT26                       (0x0040u)
#define GPIO_PNOT2_PNOT27                       (0x0080u)
#define GPIO_PNOT2_PNOT28                       (0x0100u)
#define GPIO_PNOT2_PNOT29                       (0x0200u)
#define GPIO_PNOT2_PNOT210                      (0x0400u)
#define GPIO_PNOT2_PNOT211                      (0x0800u)
#define GPIO_PNOT2_PNOT212                      (0x1000u)
#define GPIO_PNOT2_PNOT213                      (0x2000u)
#define GPIO_PNOT2_PNOT214                      (0x4000u)
#define GPIO_PNOT2_PNOT215                      (0x8000u)

#define GPIO_PMSR2_PMSR20                       (0x00000001uL)
#define GPIO_PMSR2_PMSR21                       (0x00000002uL)
#define GPIO_PMSR2_PMSR22                       (0x00000004uL)
#define GPIO_PMSR2_PMSR23                       (0x00000008uL)
#define GPIO_PMSR2_PMSR24                       (0x00000010uL)
#define GPIO_PMSR2_PMSR25                       (0x00000020uL)
#define GPIO_PMSR2_PMSR26                       (0x00000040uL)
#define GPIO_PMSR2_PMSR27                       (0x00000080uL)
#define GPIO_PMSR2_PMSR28                       (0x00000100uL)
#define GPIO_PMSR2_PMSR29                       (0x00000200uL)
#define GPIO_PMSR2_PMSR210                      (0x00000400uL)
#define GPIO_PMSR2_PMSR211                      (0x00000800uL)
#define GPIO_PMSR2_PMSR212                      (0x00001000uL)
#define GPIO_PMSR2_PMSR213                      (0x00002000uL)
#define GPIO_PMSR2_PMSR214                      (0x00004000uL)
#define GPIO_PMSR2_PMSR215                      (0x00008000uL)
#define GPIO_PMSR2_PMSR216                      (0x00010000uL)
#define GPIO_PMSR2_PMSR217                      (0x00020000uL)
#define GPIO_PMSR2_PMSR218                      (0x00040000uL)
#define GPIO_PMSR2_PMSR219                      (0x00080000uL)
#define GPIO_PMSR2_PMSR220                      (0x00100000uL)
#define GPIO_PMSR2_PMSR221                      (0x00200000uL)
#define GPIO_PMSR2_PMSR222                      (0x00400000uL)
#define GPIO_PMSR2_PMSR223                      (0x00800000uL)
#define GPIO_PMSR2_PMSR224                      (0x01000000uL)
#define GPIO_PMSR2_PMSR225                      (0x02000000uL)
#define GPIO_PMSR2_PMSR226                      (0x04000000uL)
#define GPIO_PMSR2_PMSR227                      (0x08000000uL)
#define GPIO_PMSR2_PMSR228                      (0x10000000uL)
#define GPIO_PMSR2_PMSR229                      (0x20000000uL)
#define GPIO_PMSR2_PMSR230                      (0x40000000uL)
#define GPIO_PMSR2_PMSR231                      (0x80000000uL)

#define GPIO_PMCSR2_PMCSR20                     (0x00000001uL)
#define GPIO_PMCSR2_PMCSR21                     (0x00000002uL)
#define GPIO_PMCSR2_PMCSR22                     (0x00000004uL)
#define GPIO_PMCSR2_PMCSR23                     (0x00000008uL)
#define GPIO_PMCSR2_PMCSR24                     (0x00000010uL)
#define GPIO_PMCSR2_PMCSR25                     (0x00000020uL)
#define GPIO_PMCSR2_PMCSR26                     (0x00000040uL)
#define GPIO_PMCSR2_PMCSR27                     (0x00000080uL)
#define GPIO_PMCSR2_PMCSR28                     (0x00000100uL)
#define GPIO_PMCSR2_PMCSR29                     (0x00000200uL)
#define GPIO_PMCSR2_PMCSR210                    (0x00000400uL)
#define GPIO_PMCSR2_PMCSR211                    (0x00000800uL)
#define GPIO_PMCSR2_PMCSR212                    (0x00001000uL)
#define GPIO_PMCSR2_PMCSR213                    (0x00002000uL)
#define GPIO_PMCSR2_PMCSR214                    (0x00004000uL)
#define GPIO_PMCSR2_PMCSR215                    (0x00008000uL)
#define GPIO_PMCSR2_PMCSR216                    (0x00010000uL)
#define GPIO_PMCSR2_PMCSR217                    (0x00020000uL)
#define GPIO_PMCSR2_PMCSR218                    (0x00040000uL)
#define GPIO_PMCSR2_PMCSR219                    (0x00080000uL)
#define GPIO_PMCSR2_PMCSR220                    (0x00100000uL)
#define GPIO_PMCSR2_PMCSR221                    (0x00200000uL)
#define GPIO_PMCSR2_PMCSR222                    (0x00400000uL)
#define GPIO_PMCSR2_PMCSR223                    (0x00800000uL)
#define GPIO_PMCSR2_PMCSR224                    (0x01000000uL)
#define GPIO_PMCSR2_PMCSR225                    (0x02000000uL)
#define GPIO_PMCSR2_PMCSR226                    (0x04000000uL)
#define GPIO_PMCSR2_PMCSR227                    (0x08000000uL)
#define GPIO_PMCSR2_PMCSR228                    (0x10000000uL)
#define GPIO_PMCSR2_PMCSR229                    (0x20000000uL)
#define GPIO_PMCSR2_PMCSR230                    (0x40000000uL)
#define GPIO_PMCSR2_PMCSR231                    (0x80000000uL)

#define GPIO_PFCAE2_PFCAE20                     (0x0001u)
#define GPIO_PFCAE2_PFCAE21                     (0x0002u)
#define GPIO_PFCAE2_PFCAE22                     (0x0004u)
#define GPIO_PFCAE2_PFCAE23                     (0x0008u)
#define GPIO_PFCAE2_PFCAE24                     (0x0010u)
#define GPIO_PFCAE2_PFCAE25                     (0x0020u)
#define GPIO_PFCAE2_PFCAE26                     (0x0040u)
#define GPIO_PFCAE2_PFCAE27                     (0x0080u)
#define GPIO_PFCAE2_PFCAE28                     (0x0100u)
#define GPIO_PFCAE2_PFCAE29                     (0x0200u)
#define GPIO_PFCAE2_PFCAE210                    (0x0400u)
#define GPIO_PFCAE2_PFCAE211                    (0x0800u)
#define GPIO_PFCAE2_PFCAE212                    (0x1000u)
#define GPIO_PFCAE2_PFCAE213                    (0x2000u)
#define GPIO_PFCAE2_PFCAE214                    (0x4000u)
#define GPIO_PFCAE2_PFCAE215                    (0x8000u)

#define GPIO_PIBC2_PIBC20                       (0x0001u)
#define GPIO_PIBC2_PIBC21                       (0x0002u)
#define GPIO_PIBC2_PIBC22                       (0x0004u)
#define GPIO_PIBC2_PIBC23                       (0x0008u)
#define GPIO_PIBC2_PIBC24                       (0x0010u)
#define GPIO_PIBC2_PIBC25                       (0x0020u)
#define GPIO_PIBC2_PIBC26                       (0x0040u)
#define GPIO_PIBC2_PIBC27                       (0x0080u)
#define GPIO_PIBC2_PIBC28                       (0x0100u)
#define GPIO_PIBC2_PIBC29                       (0x0200u)
#define GPIO_PIBC2_PIBC210                      (0x0400u)
#define GPIO_PIBC2_PIBC211                      (0x0800u)
#define GPIO_PIBC2_PIBC212                      (0x1000u)
#define GPIO_PIBC2_PIBC213                      (0x2000u)
#define GPIO_PIBC2_PIBC214                      (0x4000u)
#define GPIO_PIBC2_PIBC215                      (0x8000u)

#define GPIO_PBDC2_PBDC20                       (0x0001u)
#define GPIO_PBDC2_PBDC21                       (0x0002u)
#define GPIO_PBDC2_PBDC22                       (0x0004u)
#define GPIO_PBDC2_PBDC23                       (0x0008u)
#define GPIO_PBDC2_PBDC24                       (0x0010u)
#define GPIO_PBDC2_PBDC25                       (0x0020u)
#define GPIO_PBDC2_PBDC26                       (0x0040u)
#define GPIO_PBDC2_PBDC27                       (0x0080u)
#define GPIO_PBDC2_PBDC28                       (0x0100u)
#define GPIO_PBDC2_PBDC29                       (0x0200u)
#define GPIO_PBDC2_PBDC210                      (0x0400u)
#define GPIO_PBDC2_PBDC211                      (0x0800u)
#define GPIO_PBDC2_PBDC212                      (0x1000u)
#define GPIO_PBDC2_PBDC213                      (0x2000u)
#define GPIO_PBDC2_PBDC214                      (0x4000u)
#define GPIO_PBDC2_PBDC215                      (0x8000u)

#define GPIO_PIPC2_PIPC20                       (0x0001u)
#define GPIO_PIPC2_PIPC21                       (0x0002u)
#define GPIO_PIPC2_PIPC22                       (0x0004u)
#define GPIO_PIPC2_PIPC23                       (0x0008u)
#define GPIO_PIPC2_PIPC24                       (0x0010u)
#define GPIO_PIPC2_PIPC25                       (0x0020u)
#define GPIO_PIPC2_PIPC26                       (0x0040u)
#define GPIO_PIPC2_PIPC27                       (0x0080u)
#define GPIO_PIPC2_PIPC28                       (0x0100u)
#define GPIO_PIPC2_PIPC29                       (0x0200u)
#define GPIO_PIPC2_PIPC210                      (0x0400u)
#define GPIO_PIPC2_PIPC211                      (0x0800u)
#define GPIO_PIPC2_PIPC212                      (0x1000u)
#define GPIO_PIPC2_PIPC213                      (0x2000u)
#define GPIO_PIPC2_PIPC214                      (0x4000u)
#define GPIO_PIPC2_PIPC215                      (0x8000u)

/* ---- P3 ---- */
#define GPIO_P3_P30                             (0x0001u)
#define GPIO_P3_P31                             (0x0002u)
#define GPIO_P3_P32                             (0x0004u)
#define GPIO_P3_P33                             (0x0008u)
#define GPIO_P3_P34                             (0x0010u)
#define GPIO_P3_P35                             (0x0020u)
#define GPIO_P3_P36                             (0x0040u)
#define GPIO_P3_P37                             (0x0080u)
#define GPIO_P3_P38                             (0x0100u)
#define GPIO_P3_P39                             (0x0200u)
#define GPIO_P3_P310                            (0x0400u)
#define GPIO_P3_P311                            (0x0800u)
#define GPIO_P3_P312                            (0x1000u)
#define GPIO_P3_P313                            (0x2000u)
#define GPIO_P3_P314                            (0x4000u)
#define GPIO_P3_P315                            (0x8000u)

#define GPIO_PSR3_PSR30                         (0x00000001uL)
#define GPIO_PSR3_PSR31                         (0x00000002uL)
#define GPIO_PSR3_PSR32                         (0x00000004uL)
#define GPIO_PSR3_PSR33                         (0x00000008uL)
#define GPIO_PSR3_PSR34                         (0x00000010uL)
#define GPIO_PSR3_PSR35                         (0x00000020uL)
#define GPIO_PSR3_PSR36                         (0x00000040uL)
#define GPIO_PSR3_PSR37                         (0x00000080uL)
#define GPIO_PSR3_PSR38                         (0x00000100uL)
#define GPIO_PSR3_PSR39                         (0x00000200uL)
#define GPIO_PSR3_PSR310                        (0x00000400uL)
#define GPIO_PSR3_PSR311                        (0x00000800uL)
#define GPIO_PSR3_PSR312                        (0x00001000uL)
#define GPIO_PSR3_PSR313                        (0x00002000uL)
#define GPIO_PSR3_PSR314                        (0x00004000uL)
#define GPIO_PSR3_PSR315                        (0x00008000uL)
#define GPIO_PSR3_PSR316                        (0x00010000uL)
#define GPIO_PSR3_PSR317                        (0x00020000uL)
#define GPIO_PSR3_PSR318                        (0x00040000uL)
#define GPIO_PSR3_PSR319                        (0x00080000uL)
#define GPIO_PSR3_PSR320                        (0x00100000uL)
#define GPIO_PSR3_PSR321                        (0x00200000uL)
#define GPIO_PSR3_PSR322                        (0x00400000uL)
#define GPIO_PSR3_PSR323                        (0x00800000uL)
#define GPIO_PSR3_PSR324                        (0x01000000uL)
#define GPIO_PSR3_PSR325                        (0x02000000uL)
#define GPIO_PSR3_PSR326                        (0x04000000uL)
#define GPIO_PSR3_PSR327                        (0x08000000uL)
#define GPIO_PSR3_PSR328                        (0x10000000uL)
#define GPIO_PSR3_PSR329                        (0x20000000uL)
#define GPIO_PSR3_PSR330                        (0x40000000uL)
#define GPIO_PSR3_PSR331                        (0x80000000uL)

#define GPIO_PPR3_PPR30                         (0x0001u)
#define GPIO_PPR3_PPR31                         (0x0002u)
#define GPIO_PPR3_PPR32                         (0x0004u)
#define GPIO_PPR3_PPR33                         (0x0008u)
#define GPIO_PPR3_PPR34                         (0x0010u)
#define GPIO_PPR3_PPR35                         (0x0020u)
#define GPIO_PPR3_PPR36                         (0x0040u)
#define GPIO_PPR3_PPR37                         (0x0080u)
#define GPIO_PPR3_PPR38                         (0x0100u)
#define GPIO_PPR3_PPR39                         (0x0200u)
#define GPIO_PPR3_PPR310                        (0x0400u)
#define GPIO_PPR3_PPR311                        (0x0800u)
#define GPIO_PPR3_PPR312                        (0x1000u)
#define GPIO_PPR3_PPR313                        (0x2000u)
#define GPIO_PPR3_PPR314                        (0x4000u)
#define GPIO_PPR3_PPR315                        (0x8000u)

#define GPIO_PM3_PM30                           (0x0001u)
#define GPIO_PM3_PM31                           (0x0002u)
#define GPIO_PM3_PM32                           (0x0004u)
#define GPIO_PM3_PM33                           (0x0008u)
#define GPIO_PM3_PM34                           (0x0010u)
#define GPIO_PM3_PM35                           (0x0020u)
#define GPIO_PM3_PM36                           (0x0040u)
#define GPIO_PM3_PM37                           (0x0080u)
#define GPIO_PM3_PM38                           (0x0100u)
#define GPIO_PM3_PM39                           (0x0200u)
#define GPIO_PM3_PM310                          (0x0400u)
#define GPIO_PM3_PM311                          (0x0800u)
#define GPIO_PM3_PM312                          (0x1000u)
#define GPIO_PM3_PM313                          (0x2000u)
#define GPIO_PM3_PM314                          (0x4000u)
#define GPIO_PM3_PM315                          (0x8000u)

#define GPIO_PMC3_PMC30                         (0x0001u)
#define GPIO_PMC3_PMC31                         (0x0002u)
#define GPIO_PMC3_PMC32                         (0x0004u)
#define GPIO_PMC3_PMC33                         (0x0008u)
#define GPIO_PMC3_PMC34                         (0x0010u)
#define GPIO_PMC3_PMC35                         (0x0020u)
#define GPIO_PMC3_PMC36                         (0x0040u)
#define GPIO_PMC3_PMC37                         (0x0080u)
#define GPIO_PMC3_PMC38                         (0x0100u)
#define GPIO_PMC3_PMC39                         (0x0200u)
#define GPIO_PMC3_PMC310                        (0x0400u)
#define GPIO_PMC3_PMC311                        (0x0800u)
#define GPIO_PMC3_PMC312                        (0x1000u)
#define GPIO_PMC3_PMC313                        (0x2000u)
#define GPIO_PMC3_PMC314                        (0x4000u)
#define GPIO_PMC3_PMC315                        (0x8000u)

#define GPIO_PFC3_PFC30                         (0x0001u)
#define GPIO_PFC3_PFC31                         (0x0002u)
#define GPIO_PFC3_PFC32                         (0x0004u)
#define GPIO_PFC3_PFC33                         (0x0008u)
#define GPIO_PFC3_PFC34                         (0x0010u)
#define GPIO_PFC3_PFC35                         (0x0020u)
#define GPIO_PFC3_PFC36                         (0x0040u)
#define GPIO_PFC3_PFC37                         (0x0080u)
#define GPIO_PFC3_PFC38                         (0x0100u)
#define GPIO_PFC3_PFC39                         (0x0200u)
#define GPIO_PFC3_PFC310                        (0x0400u)
#define GPIO_PFC3_PFC311                        (0x0800u)
#define GPIO_PFC3_PFC312                        (0x1000u)
#define GPIO_PFC3_PFC313                        (0x2000u)
#define GPIO_PFC3_PFC314                        (0x4000u)
#define GPIO_PFC3_PFC315                        (0x8000u)

#define GPIO_PFCE3_PFCE30                       (0x0001u)
#define GPIO_PFCE3_PFCE31                       (0x0002u)
#define GPIO_PFCE3_PFCE32                       (0x0004u)
#define GPIO_PFCE3_PFCE33                       (0x0008u)
#define GPIO_PFCE3_PFCE34                       (0x0010u)
#define GPIO_PFCE3_PFCE35                       (0x0020u)
#define GPIO_PFCE3_PFCE36                       (0x0040u)
#define GPIO_PFCE3_PFCE37                       (0x0080u)
#define GPIO_PFCE3_PFCE38                       (0x0100u)
#define GPIO_PFCE3_PFCE39                       (0x0200u)
#define GPIO_PFCE3_PFCE310                      (0x0400u)
#define GPIO_PFCE3_PFCE311                      (0x0800u)
#define GPIO_PFCE3_PFCE312                      (0x1000u)
#define GPIO_PFCE3_PFCE313                      (0x2000u)
#define GPIO_PFCE3_PFCE314                      (0x4000u)
#define GPIO_PFCE3_PFCE315                      (0x8000u)

#define GPIO_PNOT3_PNOT30                       (0x0001u)
#define GPIO_PNOT3_PNOT31                       (0x0002u)
#define GPIO_PNOT3_PNOT32                       (0x0004u)
#define GPIO_PNOT3_PNOT33                       (0x0008u)
#define GPIO_PNOT3_PNOT34                       (0x0010u)
#define GPIO_PNOT3_PNOT35                       (0x0020u)
#define GPIO_PNOT3_PNOT36                       (0x0040u)
#define GPIO_PNOT3_PNOT37                       (0x0080u)
#define GPIO_PNOT3_PNOT38                       (0x0100u)
#define GPIO_PNOT3_PNOT39                       (0x0200u)
#define GPIO_PNOT3_PNOT310                      (0x0400u)
#define GPIO_PNOT3_PNOT311                      (0x0800u)
#define GPIO_PNOT3_PNOT312                      (0x1000u)
#define GPIO_PNOT3_PNOT313                      (0x2000u)
#define GPIO_PNOT3_PNOT314                      (0x4000u)
#define GPIO_PNOT3_PNOT315                      (0x8000u)

#define GPIO_PMSR3_PMSR30                       (0x00000001uL)
#define GPIO_PMSR3_PMSR31                       (0x00000002uL)
#define GPIO_PMSR3_PMSR32                       (0x00000004uL)
#define GPIO_PMSR3_PMSR33                       (0x00000008uL)
#define GPIO_PMSR3_PMSR34                       (0x00000010uL)
#define GPIO_PMSR3_PMSR35                       (0x00000020uL)
#define GPIO_PMSR3_PMSR36                       (0x00000040uL)
#define GPIO_PMSR3_PMSR37                       (0x00000080uL)
#define GPIO_PMSR3_PMSR38                       (0x00000100uL)
#define GPIO_PMSR3_PMSR39                       (0x00000200uL)
#define GPIO_PMSR3_PMSR310                      (0x00000400uL)
#define GPIO_PMSR3_PMSR311                      (0x00000800uL)
#define GPIO_PMSR3_PMSR312                      (0x00001000uL)
#define GPIO_PMSR3_PMSR313                      (0x00002000uL)
#define GPIO_PMSR3_PMSR314                      (0x00004000uL)
#define GPIO_PMSR3_PMSR315                      (0x00008000uL)
#define GPIO_PMSR3_PMSR316                      (0x00010000uL)
#define GPIO_PMSR3_PMSR317                      (0x00020000uL)
#define GPIO_PMSR3_PMSR318                      (0x00040000uL)
#define GPIO_PMSR3_PMSR319                      (0x00080000uL)
#define GPIO_PMSR3_PMSR320                      (0x00100000uL)
#define GPIO_PMSR3_PMSR321                      (0x00200000uL)
#define GPIO_PMSR3_PMSR322                      (0x00400000uL)
#define GPIO_PMSR3_PMSR323                      (0x00800000uL)
#define GPIO_PMSR3_PMSR324                      (0x01000000uL)
#define GPIO_PMSR3_PMSR325                      (0x02000000uL)
#define GPIO_PMSR3_PMSR326                      (0x04000000uL)
#define GPIO_PMSR3_PMSR327                      (0x08000000uL)
#define GPIO_PMSR3_PMSR328                      (0x10000000uL)
#define GPIO_PMSR3_PMSR329                      (0x20000000uL)
#define GPIO_PMSR3_PMSR330                      (0x40000000uL)
#define GPIO_PMSR3_PMSR331                      (0x80000000uL)

#define GPIO_PMCSR3_PMCSR30                     (0x00000001uL)
#define GPIO_PMCSR3_PMCSR31                     (0x00000002uL)
#define GPIO_PMCSR3_PMCSR32                     (0x00000004uL)
#define GPIO_PMCSR3_PMCSR33                     (0x00000008uL)
#define GPIO_PMCSR3_PMCSR34                     (0x00000010uL)
#define GPIO_PMCSR3_PMCSR35                     (0x00000020uL)
#define GPIO_PMCSR3_PMCSR36                     (0x00000040uL)
#define GPIO_PMCSR3_PMCSR37                     (0x00000080uL)
#define GPIO_PMCSR3_PMCSR38                     (0x00000100uL)
#define GPIO_PMCSR3_PMCSR39                     (0x00000200uL)
#define GPIO_PMCSR3_PMCSR310                    (0x00000400uL)
#define GPIO_PMCSR3_PMCSR311                    (0x00000800uL)
#define GPIO_PMCSR3_PMCSR312                    (0x00001000uL)
#define GPIO_PMCSR3_PMCSR313                    (0x00002000uL)
#define GPIO_PMCSR3_PMCSR314                    (0x00004000uL)
#define GPIO_PMCSR3_PMCSR315                    (0x00008000uL)
#define GPIO_PMCSR3_PMCSR316                    (0x00010000uL)
#define GPIO_PMCSR3_PMCSR317                    (0x00020000uL)
#define GPIO_PMCSR3_PMCSR318                    (0x00040000uL)
#define GPIO_PMCSR3_PMCSR319                    (0x00080000uL)
#define GPIO_PMCSR3_PMCSR320                    (0x00100000uL)
#define GPIO_PMCSR3_PMCSR321                    (0x00200000uL)
#define GPIO_PMCSR3_PMCSR322                    (0x00400000uL)
#define GPIO_PMCSR3_PMCSR323                    (0x00800000uL)
#define GPIO_PMCSR3_PMCSR324                    (0x01000000uL)
#define GPIO_PMCSR3_PMCSR325                    (0x02000000uL)
#define GPIO_PMCSR3_PMCSR326                    (0x04000000uL)
#define GPIO_PMCSR3_PMCSR327                    (0x08000000uL)
#define GPIO_PMCSR3_PMCSR328                    (0x10000000uL)
#define GPIO_PMCSR3_PMCSR329                    (0x20000000uL)
#define GPIO_PMCSR3_PMCSR330                    (0x40000000uL)
#define GPIO_PMCSR3_PMCSR331                    (0x80000000uL)

#define GPIO_PFCAE3_PFCAE30                     (0x0001u)
#define GPIO_PFCAE3_PFCAE31                     (0x0002u)
#define GPIO_PFCAE3_PFCAE32                     (0x0004u)
#define GPIO_PFCAE3_PFCAE33                     (0x0008u)
#define GPIO_PFCAE3_PFCAE34                     (0x0010u)
#define GPIO_PFCAE3_PFCAE35                     (0x0020u)
#define GPIO_PFCAE3_PFCAE36                     (0x0040u)
#define GPIO_PFCAE3_PFCAE37                     (0x0080u)
#define GPIO_PFCAE3_PFCAE38                     (0x0100u)
#define GPIO_PFCAE3_PFCAE39                     (0x0200u)
#define GPIO_PFCAE3_PFCAE310                    (0x0400u)
#define GPIO_PFCAE3_PFCAE311                    (0x0800u)
#define GPIO_PFCAE3_PFCAE312                    (0x1000u)
#define GPIO_PFCAE3_PFCAE313                    (0x2000u)
#define GPIO_PFCAE3_PFCAE314                    (0x4000u)
#define GPIO_PFCAE3_PFCAE315                    (0x8000u)

#define GPIO_PIBC3_PIBC30                       (0x0001u)
#define GPIO_PIBC3_PIBC31                       (0x0002u)
#define GPIO_PIBC3_PIBC32                       (0x0004u)
#define GPIO_PIBC3_PIBC33                       (0x0008u)
#define GPIO_PIBC3_PIBC34                       (0x0010u)
#define GPIO_PIBC3_PIBC35                       (0x0020u)
#define GPIO_PIBC3_PIBC36                       (0x0040u)
#define GPIO_PIBC3_PIBC37                       (0x0080u)
#define GPIO_PIBC3_PIBC38                       (0x0100u)
#define GPIO_PIBC3_PIBC39                       (0x0200u)
#define GPIO_PIBC3_PIBC310                      (0x0400u)
#define GPIO_PIBC3_PIBC311                      (0x0800u)
#define GPIO_PIBC3_PIBC312                      (0x1000u)
#define GPIO_PIBC3_PIBC313                      (0x2000u)
#define GPIO_PIBC3_PIBC314                      (0x4000u)
#define GPIO_PIBC3_PIBC315                      (0x8000u)

#define GPIO_PBDC3_PBDC30                       (0x0001u)
#define GPIO_PBDC3_PBDC31                       (0x0002u)
#define GPIO_PBDC3_PBDC32                       (0x0004u)
#define GPIO_PBDC3_PBDC33                       (0x0008u)
#define GPIO_PBDC3_PBDC34                       (0x0010u)
#define GPIO_PBDC3_PBDC35                       (0x0020u)
#define GPIO_PBDC3_PBDC36                       (0x0040u)
#define GPIO_PBDC3_PBDC37                       (0x0080u)
#define GPIO_PBDC3_PBDC38                       (0x0100u)
#define GPIO_PBDC3_PBDC39                       (0x0200u)
#define GPIO_PBDC3_PBDC310                      (0x0400u)
#define GPIO_PBDC3_PBDC311                      (0x0800u)
#define GPIO_PBDC3_PBDC312                      (0x1000u)
#define GPIO_PBDC3_PBDC313                      (0x2000u)
#define GPIO_PBDC3_PBDC314                      (0x4000u)
#define GPIO_PBDC3_PBDC315                      (0x8000u)

#define GPIO_PIPC3_PIPC30                       (0x0001u)
#define GPIO_PIPC3_PIPC31                       (0x0002u)
#define GPIO_PIPC3_PIPC32                       (0x0004u)
#define GPIO_PIPC3_PIPC33                       (0x0008u)
#define GPIO_PIPC3_PIPC34                       (0x0010u)
#define GPIO_PIPC3_PIPC35                       (0x0020u)
#define GPIO_PIPC3_PIPC36                       (0x0040u)
#define GPIO_PIPC3_PIPC37                       (0x0080u)
#define GPIO_PIPC3_PIPC38                       (0x0100u)
#define GPIO_PIPC3_PIPC39                       (0x0200u)
#define GPIO_PIPC3_PIPC310                      (0x0400u)
#define GPIO_PIPC3_PIPC311                      (0x0800u)
#define GPIO_PIPC3_PIPC312                      (0x1000u)
#define GPIO_PIPC3_PIPC313                      (0x2000u)
#define GPIO_PIPC3_PIPC314                      (0x4000u)
#define GPIO_PIPC3_PIPC315                      (0x8000u)

/* ---- P4 ---- */
#define GPIO_P4_P40                             (0x0001u)
#define GPIO_P4_P41                             (0x0002u)
#define GPIO_P4_P42                             (0x0004u)
#define GPIO_P4_P43                             (0x0008u)
#define GPIO_P4_P44                             (0x0010u)
#define GPIO_P4_P45                             (0x0020u)
#define GPIO_P4_P46                             (0x0040u)
#define GPIO_P4_P47                             (0x0080u)
#define GPIO_P4_P48                             (0x0100u)
#define GPIO_P4_P49                             (0x0200u)
#define GPIO_P4_P410                            (0x0400u)
#define GPIO_P4_P411                            (0x0800u)
#define GPIO_P4_P412                            (0x1000u)
#define GPIO_P4_P413                            (0x2000u)
#define GPIO_P4_P414                            (0x4000u)
#define GPIO_P4_P415                            (0x8000u)

#define GPIO_PSR4_PSR40                         (0x00000001uL)
#define GPIO_PSR4_PSR41                         (0x00000002uL)
#define GPIO_PSR4_PSR42                         (0x00000004uL)
#define GPIO_PSR4_PSR43                         (0x00000008uL)
#define GPIO_PSR4_PSR44                         (0x00000010uL)
#define GPIO_PSR4_PSR45                         (0x00000020uL)
#define GPIO_PSR4_PSR46                         (0x00000040uL)
#define GPIO_PSR4_PSR47                         (0x00000080uL)
#define GPIO_PSR4_PSR48                         (0x00000100uL)
#define GPIO_PSR4_PSR49                         (0x00000200uL)
#define GPIO_PSR4_PSR410                        (0x00000400uL)
#define GPIO_PSR4_PSR411                        (0x00000800uL)
#define GPIO_PSR4_PSR412                        (0x00001000uL)
#define GPIO_PSR4_PSR413                        (0x00002000uL)
#define GPIO_PSR4_PSR414                        (0x00004000uL)
#define GPIO_PSR4_PSR415                        (0x00008000uL)
#define GPIO_PSR4_PSR416                        (0x00010000uL)
#define GPIO_PSR4_PSR417                        (0x00020000uL)
#define GPIO_PSR4_PSR418                        (0x00040000uL)
#define GPIO_PSR4_PSR419                        (0x00080000uL)
#define GPIO_PSR4_PSR420                        (0x00100000uL)
#define GPIO_PSR4_PSR421                        (0x00200000uL)
#define GPIO_PSR4_PSR422                        (0x00400000uL)
#define GPIO_PSR4_PSR423                        (0x00800000uL)
#define GPIO_PSR4_PSR424                        (0x01000000uL)
#define GPIO_PSR4_PSR425                        (0x02000000uL)
#define GPIO_PSR4_PSR426                        (0x04000000uL)
#define GPIO_PSR4_PSR427                        (0x08000000uL)
#define GPIO_PSR4_PSR428                        (0x10000000uL)
#define GPIO_PSR4_PSR429                        (0x20000000uL)
#define GPIO_PSR4_PSR430                        (0x40000000uL)
#define GPIO_PSR4_PSR431                        (0x80000000uL)

#define GPIO_PPR4_PPR40                         (0x0001u)
#define GPIO_PPR4_PPR41                         (0x0002u)
#define GPIO_PPR4_PPR42                         (0x0004u)
#define GPIO_PPR4_PPR43                         (0x0008u)
#define GPIO_PPR4_PPR44                         (0x0010u)
#define GPIO_PPR4_PPR45                         (0x0020u)
#define GPIO_PPR4_PPR46                         (0x0040u)
#define GPIO_PPR4_PPR47                         (0x0080u)
#define GPIO_PPR4_PPR48                         (0x0100u)
#define GPIO_PPR4_PPR49                         (0x0200u)
#define GPIO_PPR4_PPR410                        (0x0400u)
#define GPIO_PPR4_PPR411                        (0x0800u)
#define GPIO_PPR4_PPR412                        (0x1000u)
#define GPIO_PPR4_PPR413                        (0x2000u)
#define GPIO_PPR4_PPR414                        (0x4000u)
#define GPIO_PPR4_PPR415                        (0x8000u)

#define GPIO_PM4_PM40                           (0x0001u)
#define GPIO_PM4_PM41                           (0x0002u)
#define GPIO_PM4_PM42                           (0x0004u)
#define GPIO_PM4_PM43                           (0x0008u)
#define GPIO_PM4_PM44                           (0x0010u)
#define GPIO_PM4_PM45                           (0x0020u)
#define GPIO_PM4_PM46                           (0x0040u)
#define GPIO_PM4_PM47                           (0x0080u)
#define GPIO_PM4_PM48                           (0x0100u)
#define GPIO_PM4_PM49                           (0x0200u)
#define GPIO_PM4_PM410                          (0x0400u)
#define GPIO_PM4_PM411                          (0x0800u)
#define GPIO_PM4_PM412                          (0x1000u)
#define GPIO_PM4_PM413                          (0x2000u)
#define GPIO_PM4_PM414                          (0x4000u)
#define GPIO_PM4_PM415                          (0x8000u)

#define GPIO_PMC4_PMC40                         (0x0001u)
#define GPIO_PMC4_PMC41                         (0x0002u)
#define GPIO_PMC4_PMC42                         (0x0004u)
#define GPIO_PMC4_PMC43                         (0x0008u)
#define GPIO_PMC4_PMC44                         (0x0010u)
#define GPIO_PMC4_PMC45                         (0x0020u)
#define GPIO_PMC4_PMC46                         (0x0040u)
#define GPIO_PMC4_PMC47                         (0x0080u)
#define GPIO_PMC4_PMC48                         (0x0100u)
#define GPIO_PMC4_PMC49                         (0x0200u)
#define GPIO_PMC4_PMC410                        (0x0400u)
#define GPIO_PMC4_PMC411                        (0x0800u)
#define GPIO_PMC4_PMC412                        (0x1000u)
#define GPIO_PMC4_PMC413                        (0x2000u)
#define GPIO_PMC4_PMC414                        (0x4000u)
#define GPIO_PMC4_PMC415                        (0x8000u)

#define GPIO_PFC4_PFC40                         (0x0001u)
#define GPIO_PFC4_PFC41                         (0x0002u)
#define GPIO_PFC4_PFC42                         (0x0004u)
#define GPIO_PFC4_PFC43                         (0x0008u)
#define GPIO_PFC4_PFC44                         (0x0010u)
#define GPIO_PFC4_PFC45                         (0x0020u)
#define GPIO_PFC4_PFC46                         (0x0040u)
#define GPIO_PFC4_PFC47                         (0x0080u)
#define GPIO_PFC4_PFC48                         (0x0100u)
#define GPIO_PFC4_PFC49                         (0x0200u)
#define GPIO_PFC4_PFC410                        (0x0400u)
#define GPIO_PFC4_PFC411                        (0x0800u)
#define GPIO_PFC4_PFC412                        (0x1000u)
#define GPIO_PFC4_PFC413                        (0x2000u)
#define GPIO_PFC4_PFC414                        (0x4000u)
#define GPIO_PFC4_PFC415                        (0x8000u)

#define GPIO_PFCE4_PFCE40                       (0x0001u)
#define GPIO_PFCE4_PFCE41                       (0x0002u)
#define GPIO_PFCE4_PFCE42                       (0x0004u)
#define GPIO_PFCE4_PFCE43                       (0x0008u)
#define GPIO_PFCE4_PFCE44                       (0x0010u)
#define GPIO_PFCE4_PFCE45                       (0x0020u)
#define GPIO_PFCE4_PFCE46                       (0x0040u)
#define GPIO_PFCE4_PFCE47                       (0x0080u)
#define GPIO_PFCE4_PFCE48                       (0x0100u)
#define GPIO_PFCE4_PFCE49                       (0x0200u)
#define GPIO_PFCE4_PFCE410                      (0x0400u)
#define GPIO_PFCE4_PFCE411                      (0x0800u)
#define GPIO_PFCE4_PFCE412                      (0x1000u)
#define GPIO_PFCE4_PFCE413                      (0x2000u)
#define GPIO_PFCE4_PFCE414                      (0x4000u)
#define GPIO_PFCE4_PFCE415                      (0x8000u)

#define GPIO_PNOT4_PNOT40                       (0x0001u)
#define GPIO_PNOT4_PNOT41                       (0x0002u)
#define GPIO_PNOT4_PNOT42                       (0x0004u)
#define GPIO_PNOT4_PNOT43                       (0x0008u)
#define GPIO_PNOT4_PNOT44                       (0x0010u)
#define GPIO_PNOT4_PNOT45                       (0x0020u)
#define GPIO_PNOT4_PNOT46                       (0x0040u)
#define GPIO_PNOT4_PNOT47                       (0x0080u)
#define GPIO_PNOT4_PNOT48                       (0x0100u)
#define GPIO_PNOT4_PNOT49                       (0x0200u)
#define GPIO_PNOT4_PNOT410                      (0x0400u)
#define GPIO_PNOT4_PNOT411                      (0x0800u)
#define GPIO_PNOT4_PNOT412                      (0x1000u)
#define GPIO_PNOT4_PNOT413                      (0x2000u)
#define GPIO_PNOT4_PNOT414                      (0x4000u)
#define GPIO_PNOT4_PNOT415                      (0x8000u)

#define GPIO_PMSR4_PMSR40                       (0x00000001uL)
#define GPIO_PMSR4_PMSR41                       (0x00000002uL)
#define GPIO_PMSR4_PMSR42                       (0x00000004uL)
#define GPIO_PMSR4_PMSR43                       (0x00000008uL)
#define GPIO_PMSR4_PMSR44                       (0x00000010uL)
#define GPIO_PMSR4_PMSR45                       (0x00000020uL)
#define GPIO_PMSR4_PMSR46                       (0x00000040uL)
#define GPIO_PMSR4_PMSR47                       (0x00000080uL)
#define GPIO_PMSR4_PMSR48                       (0x00000100uL)
#define GPIO_PMSR4_PMSR49                       (0x00000200uL)
#define GPIO_PMSR4_PMSR410                      (0x00000400uL)
#define GPIO_PMSR4_PMSR411                      (0x00000800uL)
#define GPIO_PMSR4_PMSR412                      (0x00001000uL)
#define GPIO_PMSR4_PMSR413                      (0x00002000uL)
#define GPIO_PMSR4_PMSR414                      (0x00004000uL)
#define GPIO_PMSR4_PMSR415                      (0x00008000uL)
#define GPIO_PMSR4_PMSR416                      (0x00010000uL)
#define GPIO_PMSR4_PMSR417                      (0x00020000uL)
#define GPIO_PMSR4_PMSR418                      (0x00040000uL)
#define GPIO_PMSR4_PMSR419                      (0x00080000uL)
#define GPIO_PMSR4_PMSR420                      (0x00100000uL)
#define GPIO_PMSR4_PMSR421                      (0x00200000uL)
#define GPIO_PMSR4_PMSR422                      (0x00400000uL)
#define GPIO_PMSR4_PMSR423                      (0x00800000uL)
#define GPIO_PMSR4_PMSR424                      (0x01000000uL)
#define GPIO_PMSR4_PMSR425                      (0x02000000uL)
#define GPIO_PMSR4_PMSR426                      (0x04000000uL)
#define GPIO_PMSR4_PMSR427                      (0x08000000uL)
#define GPIO_PMSR4_PMSR428                      (0x10000000uL)
#define GPIO_PMSR4_PMSR429                      (0x20000000uL)
#define GPIO_PMSR4_PMSR430                      (0x40000000uL)
#define GPIO_PMSR4_PMSR431                      (0x80000000uL)

#define GPIO_PMCSR4_PMCSR40                     (0x00000001uL)
#define GPIO_PMCSR4_PMCSR41                     (0x00000002uL)
#define GPIO_PMCSR4_PMCSR42                     (0x00000004uL)
#define GPIO_PMCSR4_PMCSR43                     (0x00000008uL)
#define GPIO_PMCSR4_PMCSR44                     (0x00000010uL)
#define GPIO_PMCSR4_PMCSR45                     (0x00000020uL)
#define GPIO_PMCSR4_PMCSR46                     (0x00000040uL)
#define GPIO_PMCSR4_PMCSR47                     (0x00000080uL)
#define GPIO_PMCSR4_PMCSR48                     (0x00000100uL)
#define GPIO_PMCSR4_PMCSR49                     (0x00000200uL)
#define GPIO_PMCSR4_PMCSR410                    (0x00000400uL)
#define GPIO_PMCSR4_PMCSR411                    (0x00000800uL)
#define GPIO_PMCSR4_PMCSR412                    (0x00001000uL)
#define GPIO_PMCSR4_PMCSR413                    (0x00002000uL)
#define GPIO_PMCSR4_PMCSR414                    (0x00004000uL)
#define GPIO_PMCSR4_PMCSR415                    (0x00008000uL)
#define GPIO_PMCSR4_PMCSR416                    (0x00010000uL)
#define GPIO_PMCSR4_PMCSR417                    (0x00020000uL)
#define GPIO_PMCSR4_PMCSR418                    (0x00040000uL)
#define GPIO_PMCSR4_PMCSR419                    (0x00080000uL)
#define GPIO_PMCSR4_PMCSR420                    (0x00100000uL)
#define GPIO_PMCSR4_PMCSR421                    (0x00200000uL)
#define GPIO_PMCSR4_PMCSR422                    (0x00400000uL)
#define GPIO_PMCSR4_PMCSR423                    (0x00800000uL)
#define GPIO_PMCSR4_PMCSR424                    (0x01000000uL)
#define GPIO_PMCSR4_PMCSR425                    (0x02000000uL)
#define GPIO_PMCSR4_PMCSR426                    (0x04000000uL)
#define GPIO_PMCSR4_PMCSR427                    (0x08000000uL)
#define GPIO_PMCSR4_PMCSR428                    (0x10000000uL)
#define GPIO_PMCSR4_PMCSR429                    (0x20000000uL)
#define GPIO_PMCSR4_PMCSR430                    (0x40000000uL)
#define GPIO_PMCSR4_PMCSR431                    (0x80000000uL)

#define GPIO_PFCAE4_PFCAE40                     (0x0001u)
#define GPIO_PFCAE4_PFCAE41                     (0x0002u)
#define GPIO_PFCAE4_PFCAE42                     (0x0004u)
#define GPIO_PFCAE4_PFCAE43                     (0x0008u)
#define GPIO_PFCAE4_PFCAE44                     (0x0010u)
#define GPIO_PFCAE4_PFCAE45                     (0x0020u)
#define GPIO_PFCAE4_PFCAE46                     (0x0040u)
#define GPIO_PFCAE4_PFCAE47                     (0x0080u)
#define GPIO_PFCAE4_PFCAE48                     (0x0100u)
#define GPIO_PFCAE4_PFCAE49                     (0x0200u)
#define GPIO_PFCAE4_PFCAE410                    (0x0400u)
#define GPIO_PFCAE4_PFCAE411                    (0x0800u)
#define GPIO_PFCAE4_PFCAE412                    (0x1000u)
#define GPIO_PFCAE4_PFCAE413                    (0x2000u)
#define GPIO_PFCAE4_PFCAE414                    (0x4000u)
#define GPIO_PFCAE4_PFCAE415                    (0x8000u)

#define GPIO_PIBC4_PIBC40                       (0x0001u)
#define GPIO_PIBC4_PIBC41                       (0x0002u)
#define GPIO_PIBC4_PIBC42                       (0x0004u)
#define GPIO_PIBC4_PIBC43                       (0x0008u)
#define GPIO_PIBC4_PIBC44                       (0x0010u)
#define GPIO_PIBC4_PIBC45                       (0x0020u)
#define GPIO_PIBC4_PIBC46                       (0x0040u)
#define GPIO_PIBC4_PIBC47                       (0x0080u)
#define GPIO_PIBC4_PIBC48                       (0x0100u)
#define GPIO_PIBC4_PIBC49                       (0x0200u)
#define GPIO_PIBC4_PIBC410                      (0x0400u)
#define GPIO_PIBC4_PIBC411                      (0x0800u)
#define GPIO_PIBC4_PIBC412                      (0x1000u)
#define GPIO_PIBC4_PIBC413                      (0x2000u)
#define GPIO_PIBC4_PIBC414                      (0x4000u)
#define GPIO_PIBC4_PIBC415                      (0x8000u)

#define GPIO_PBDC4_PBDC40                       (0x0001u)
#define GPIO_PBDC4_PBDC41                       (0x0002u)
#define GPIO_PBDC4_PBDC42                       (0x0004u)
#define GPIO_PBDC4_PBDC43                       (0x0008u)
#define GPIO_PBDC4_PBDC44                       (0x0010u)
#define GPIO_PBDC4_PBDC45                       (0x0020u)
#define GPIO_PBDC4_PBDC46                       (0x0040u)
#define GPIO_PBDC4_PBDC47                       (0x0080u)
#define GPIO_PBDC4_PBDC48                       (0x0100u)
#define GPIO_PBDC4_PBDC49                       (0x0200u)
#define GPIO_PBDC4_PBDC410                      (0x0400u)
#define GPIO_PBDC4_PBDC411                      (0x0800u)
#define GPIO_PBDC4_PBDC412                      (0x1000u)
#define GPIO_PBDC4_PBDC413                      (0x2000u)
#define GPIO_PBDC4_PBDC414                      (0x4000u)
#define GPIO_PBDC4_PBDC415                      (0x8000u)

#define GPIO_PIPC4_PIPC40                       (0x0001u)
#define GPIO_PIPC4_PIPC41                       (0x0002u)
#define GPIO_PIPC4_PIPC42                       (0x0004u)
#define GPIO_PIPC4_PIPC43                       (0x0008u)
#define GPIO_PIPC4_PIPC44                       (0x0010u)
#define GPIO_PIPC4_PIPC45                       (0x0020u)
#define GPIO_PIPC4_PIPC46                       (0x0040u)
#define GPIO_PIPC4_PIPC47                       (0x0080u)
#define GPIO_PIPC4_PIPC48                       (0x0100u)
#define GPIO_PIPC4_PIPC49                       (0x0200u)
#define GPIO_PIPC4_PIPC410                      (0x0400u)
#define GPIO_PIPC4_PIPC411                      (0x0800u)
#define GPIO_PIPC4_PIPC412                      (0x1000u)
#define GPIO_PIPC4_PIPC413                      (0x2000u)
#define GPIO_PIPC4_PIPC414                      (0x4000u)
#define GPIO_PIPC4_PIPC415                      (0x8000u)

/* ---- P5 ---- */
#define GPIO_P5_P50                             (0x0001u)
#define GPIO_P5_P51                             (0x0002u)
#define GPIO_P5_P52                             (0x0004u)
#define GPIO_P5_P53                             (0x0008u)
#define GPIO_P5_P54                             (0x0010u)
#define GPIO_P5_P55                             (0x0020u)
#define GPIO_P5_P56                             (0x0040u)
#define GPIO_P5_P57                             (0x0080u)
#define GPIO_P5_P58                             (0x0100u)
#define GPIO_P5_P59                             (0x0200u)
#define GPIO_P5_P510                            (0x0400u)

#define GPIO_PSR5_PSR50                         (0x00000001uL)
#define GPIO_PSR5_PSR51                         (0x00000002uL)
#define GPIO_PSR5_PSR52                         (0x00000004uL)
#define GPIO_PSR5_PSR53                         (0x00000008uL)
#define GPIO_PSR5_PSR54                         (0x00000010uL)
#define GPIO_PSR5_PSR55                         (0x00000020uL)
#define GPIO_PSR5_PSR56                         (0x00000040uL)
#define GPIO_PSR5_PSR57                         (0x00000080uL)
#define GPIO_PSR5_PSR58                         (0x00000100uL)
#define GPIO_PSR5_PSR59                         (0x00000200uL)
#define GPIO_PSR5_PSR510                        (0x00000400uL)
#define GPIO_PSR5_PSR516                        (0x00010000uL)
#define GPIO_PSR5_PSR517                        (0x00020000uL)
#define GPIO_PSR5_PSR518                        (0x00040000uL)
#define GPIO_PSR5_PSR519                        (0x00080000uL)
#define GPIO_PSR5_PSR520                        (0x00100000uL)
#define GPIO_PSR5_PSR521                        (0x00200000uL)
#define GPIO_PSR5_PSR522                        (0x00400000uL)
#define GPIO_PSR5_PSR523                        (0x00800000uL)
#define GPIO_PSR5_PSR524                        (0x01000000uL)
#define GPIO_PSR5_PSR525                        (0x02000000uL)
#define GPIO_PSR5_PSR526                        (0x04000000uL)

#define GPIO_PPR5_PPR50                         (0x0001u)
#define GPIO_PPR5_PPR51                         (0x0002u)
#define GPIO_PPR5_PPR52                         (0x0004u)
#define GPIO_PPR5_PPR53                         (0x0008u)
#define GPIO_PPR5_PPR54                         (0x0010u)
#define GPIO_PPR5_PPR55                         (0x0020u)
#define GPIO_PPR5_PPR56                         (0x0040u)
#define GPIO_PPR5_PPR57                         (0x0080u)
#define GPIO_PPR5_PPR58                         (0x0100u)
#define GPIO_PPR5_PPR59                         (0x0200u)
#define GPIO_PPR5_PPR510                        (0x0400u)

#define GPIO_PM5_PM50                           (0x0001u)
#define GPIO_PM5_PM51                           (0x0002u)
#define GPIO_PM5_PM52                           (0x0004u)
#define GPIO_PM5_PM53                           (0x0008u)
#define GPIO_PM5_PM54                           (0x0010u)
#define GPIO_PM5_PM55                           (0x0020u)
#define GPIO_PM5_PM56                           (0x0040u)
#define GPIO_PM5_PM57                           (0x0080u)
#define GPIO_PM5_PM58                           (0x0100u)
#define GPIO_PM5_PM59                           (0x0200u)
#define GPIO_PM5_PM510                          (0x0400u)

#define GPIO_PMC5_PMC50                         (0x0001u)
#define GPIO_PMC5_PMC51                         (0x0002u)
#define GPIO_PMC5_PMC52                         (0x0004u)
#define GPIO_PMC5_PMC53                         (0x0008u)
#define GPIO_PMC5_PMC54                         (0x0010u)
#define GPIO_PMC5_PMC55                         (0x0020u)
#define GPIO_PMC5_PMC56                         (0x0040u)
#define GPIO_PMC5_PMC57                         (0x0080u)
#define GPIO_PMC5_PMC58                         (0x0100u)
#define GPIO_PMC5_PMC59                         (0x0200u)
#define GPIO_PMC5_PMC510                        (0x0400u)

#define GPIO_PFC5_PFC50                         (0x0001u)
#define GPIO_PFC5_PFC51                         (0x0002u)
#define GPIO_PFC5_PFC52                         (0x0004u)
#define GPIO_PFC5_PFC53                         (0x0008u)
#define GPIO_PFC5_PFC54                         (0x0010u)
#define GPIO_PFC5_PFC55                         (0x0020u)
#define GPIO_PFC5_PFC56                         (0x0040u)
#define GPIO_PFC5_PFC57                         (0x0080u)
#define GPIO_PFC5_PFC58                         (0x0100u)
#define GPIO_PFC5_PFC59                         (0x0200u)
#define GPIO_PFC5_PFC510                        (0x0400u)

#define GPIO_PFCE5_PFCE50                       (0x0001u)
#define GPIO_PFCE5_PFCE51                       (0x0002u)
#define GPIO_PFCE5_PFCE52                       (0x0004u)
#define GPIO_PFCE5_PFCE53                       (0x0008u)
#define GPIO_PFCE5_PFCE54                       (0x0010u)
#define GPIO_PFCE5_PFCE55                       (0x0020u)
#define GPIO_PFCE5_PFCE56                       (0x0040u)
#define GPIO_PFCE5_PFCE57                       (0x0080u)
#define GPIO_PFCE5_PFCE58                       (0x0100u)
#define GPIO_PFCE5_PFCE59                       (0x0200u)
#define GPIO_PFCE5_PFCE510                      (0x0400u)

#define GPIO_PNOT5_PNOT50                       (0x0001u)
#define GPIO_PNOT5_PNOT51                       (0x0002u)
#define GPIO_PNOT5_PNOT52                       (0x0004u)
#define GPIO_PNOT5_PNOT53                       (0x0008u)
#define GPIO_PNOT5_PNOT54                       (0x0010u)
#define GPIO_PNOT5_PNOT55                       (0x0020u)
#define GPIO_PNOT5_PNOT56                       (0x0040u)
#define GPIO_PNOT5_PNOT57                       (0x0080u)
#define GPIO_PNOT5_PNOT58                       (0x0100u)
#define GPIO_PNOT5_PNOT59                       (0x0200u)
#define GPIO_PNOT5_PNOT510                      (0x0400u)

#define GPIO_PMSR5_PMSR50                       (0x00000001uL)
#define GPIO_PMSR5_PMSR51                       (0x00000002uL)
#define GPIO_PMSR5_PMSR52                       (0x00000004uL)
#define GPIO_PMSR5_PMSR53                       (0x00000008uL)
#define GPIO_PMSR5_PMSR54                       (0x00000010uL)
#define GPIO_PMSR5_PMSR55                       (0x00000020uL)
#define GPIO_PMSR5_PMSR56                       (0x00000040uL)
#define GPIO_PMSR5_PMSR57                       (0x00000080uL)
#define GPIO_PMSR5_PMSR58                       (0x00000100uL)
#define GPIO_PMSR5_PMSR59                       (0x00000200uL)
#define GPIO_PMSR5_PMSR510                      (0x00000400uL)
#define GPIO_PMSR5_PMSR516                      (0x00010000uL)
#define GPIO_PMSR5_PMSR517                      (0x00020000uL)
#define GPIO_PMSR5_PMSR518                      (0x00040000uL)
#define GPIO_PMSR5_PMSR519                      (0x00080000uL)
#define GPIO_PMSR5_PMSR520                      (0x00100000uL)
#define GPIO_PMSR5_PMSR521                      (0x00200000uL)
#define GPIO_PMSR5_PMSR522                      (0x00400000uL)
#define GPIO_PMSR5_PMSR523                      (0x00800000uL)
#define GPIO_PMSR5_PMSR524                      (0x01000000uL)
#define GPIO_PMSR5_PMSR525                      (0x02000000uL)
#define GPIO_PMSR5_PMSR526                      (0x04000000uL)

#define GPIO_PMCSR5_PMCSR50                     (0x00000001uL)
#define GPIO_PMCSR5_PMCSR51                     (0x00000002uL)
#define GPIO_PMCSR5_PMCSR52                     (0x00000004uL)
#define GPIO_PMCSR5_PMCSR53                     (0x00000008uL)
#define GPIO_PMCSR5_PMCSR54                     (0x00000010uL)
#define GPIO_PMCSR5_PMCSR55                     (0x00000020uL)
#define GPIO_PMCSR5_PMCSR56                     (0x00000040uL)
#define GPIO_PMCSR5_PMCSR57                     (0x00000080uL)
#define GPIO_PMCSR5_PMCSR58                     (0x00000100uL)
#define GPIO_PMCSR5_PMCSR59                     (0x00000200uL)
#define GPIO_PMCSR5_PMCSR510                    (0x00000400uL)
#define GPIO_PMCSR5_PMCSR516                    (0x00010000uL)
#define GPIO_PMCSR5_PMCSR517                    (0x00020000uL)
#define GPIO_PMCSR5_PMCSR518                    (0x00040000uL)
#define GPIO_PMCSR5_PMCSR519                    (0x00080000uL)
#define GPIO_PMCSR5_PMCSR520                    (0x00100000uL)
#define GPIO_PMCSR5_PMCSR521                    (0x00200000uL)
#define GPIO_PMCSR5_PMCSR522                    (0x00400000uL)
#define GPIO_PMCSR5_PMCSR523                    (0x00800000uL)
#define GPIO_PMCSR5_PMCSR524                    (0x01000000uL)
#define GPIO_PMCSR5_PMCSR525                    (0x02000000uL)
#define GPIO_PMCSR5_PMCSR526                    (0x04000000uL)

#define GPIO_PFCAE5_PFCAE50                     (0x0001u)
#define GPIO_PFCAE5_PFCAE51                     (0x0002u)
#define GPIO_PFCAE5_PFCAE52                     (0x0004u)
#define GPIO_PFCAE5_PFCAE53                     (0x0008u)
#define GPIO_PFCAE5_PFCAE54                     (0x0010u)
#define GPIO_PFCAE5_PFCAE55                     (0x0020u)
#define GPIO_PFCAE5_PFCAE56                     (0x0040u)
#define GPIO_PFCAE5_PFCAE57                     (0x0080u)
#define GPIO_PFCAE5_PFCAE58                     (0x0100u)
#define GPIO_PFCAE5_PFCAE59                     (0x0200u)
#define GPIO_PFCAE5_PFCAE510                    (0x0400u)

#define GPIO_PIBC5_PIBC50                       (0x0001u)
#define GPIO_PIBC5_PIBC51                       (0x0002u)
#define GPIO_PIBC5_PIBC52                       (0x0004u)
#define GPIO_PIBC5_PIBC53                       (0x0008u)
#define GPIO_PIBC5_PIBC54                       (0x0010u)
#define GPIO_PIBC5_PIBC55                       (0x0020u)
#define GPIO_PIBC5_PIBC56                       (0x0040u)
#define GPIO_PIBC5_PIBC57                       (0x0080u)
#define GPIO_PIBC5_PIBC58                       (0x0100u)
#define GPIO_PIBC5_PIBC59                       (0x0200u)
#define GPIO_PIBC5_PIBC510                      (0x0400u)

#define GPIO_PBDC5_PBDC50                       (0x0001u)
#define GPIO_PBDC5_PBDC51                       (0x0002u)
#define GPIO_PBDC5_PBDC52                       (0x0004u)
#define GPIO_PBDC5_PBDC53                       (0x0008u)
#define GPIO_PBDC5_PBDC54                       (0x0010u)
#define GPIO_PBDC5_PBDC55                       (0x0020u)
#define GPIO_PBDC5_PBDC56                       (0x0040u)
#define GPIO_PBDC5_PBDC57                       (0x0080u)
#define GPIO_PBDC5_PBDC58                       (0x0100u)
#define GPIO_PBDC5_PBDC59                       (0x0200u)
#define GPIO_PBDC5_PBDC510                      (0x0400u)

#define GPIO_PIPC5_PIPC50                       (0x0001u)
#define GPIO_PIPC5_PIPC51                       (0x0002u)
#define GPIO_PIPC5_PIPC52                       (0x0004u)
#define GPIO_PIPC5_PIPC53                       (0x0008u)
#define GPIO_PIPC5_PIPC54                       (0x0010u)
#define GPIO_PIPC5_PIPC55                       (0x0020u)
#define GPIO_PIPC5_PIPC56                       (0x0040u)
#define GPIO_PIPC5_PIPC57                       (0x0080u)
#define GPIO_PIPC5_PIPC58                       (0x0100u)
#define GPIO_PIPC5_PIPC59                       (0x0200u)
#define GPIO_PIPC5_PIPC510                      (0x0400u)

/* ---- P6 ---- */
#define GPIO_P6_P60                             (0x0001u)
#define GPIO_P6_P61                             (0x0002u)
#define GPIO_P6_P62                             (0x0004u)
#define GPIO_P6_P63                             (0x0008u)
#define GPIO_P6_P64                             (0x0010u)
#define GPIO_P6_P65                             (0x0020u)
#define GPIO_P6_P66                             (0x0040u)
#define GPIO_P6_P67                             (0x0080u)
#define GPIO_P6_P68                             (0x0100u)
#define GPIO_P6_P69                             (0x0200u)
#define GPIO_P6_P610                            (0x0400u)
#define GPIO_P6_P611                            (0x0800u)
#define GPIO_P6_P612                            (0x1000u)
#define GPIO_P6_P613                            (0x2000u)
#define GPIO_P6_P614                            (0x4000u)
#define GPIO_P6_P615                            (0x8000u)

#define GPIO_PSR6_PSR60                         (0x00000001uL)
#define GPIO_PSR6_PSR61                         (0x00000002uL)
#define GPIO_PSR6_PSR62                         (0x00000004uL)
#define GPIO_PSR6_PSR63                         (0x00000008uL)
#define GPIO_PSR6_PSR64                         (0x00000010uL)
#define GPIO_PSR6_PSR65                         (0x00000020uL)
#define GPIO_PSR6_PSR66                         (0x00000040uL)
#define GPIO_PSR6_PSR67                         (0x00000080uL)
#define GPIO_PSR6_PSR68                         (0x00000100uL)
#define GPIO_PSR6_PSR69                         (0x00000200uL)
#define GPIO_PSR6_PSR610                        (0x00000400uL)
#define GPIO_PSR6_PSR611                        (0x00000800uL)
#define GPIO_PSR6_PSR612                        (0x00001000uL)
#define GPIO_PSR6_PSR613                        (0x00002000uL)
#define GPIO_PSR6_PSR614                        (0x00004000uL)
#define GPIO_PSR6_PSR615                        (0x00008000uL)
#define GPIO_PSR6_PSR616                        (0x00010000uL)
#define GPIO_PSR6_PSR617                        (0x00020000uL)
#define GPIO_PSR6_PSR618                        (0x00040000uL)
#define GPIO_PSR6_PSR619                        (0x00080000uL)
#define GPIO_PSR6_PSR620                        (0x00100000uL)
#define GPIO_PSR6_PSR621                        (0x00200000uL)
#define GPIO_PSR6_PSR622                        (0x00400000uL)
#define GPIO_PSR6_PSR623                        (0x00800000uL)
#define GPIO_PSR6_PSR624                        (0x01000000uL)
#define GPIO_PSR6_PSR625                        (0x02000000uL)
#define GPIO_PSR6_PSR626                        (0x04000000uL)
#define GPIO_PSR6_PSR627                        (0x08000000uL)
#define GPIO_PSR6_PSR628                        (0x10000000uL)
#define GPIO_PSR6_PSR629                        (0x20000000uL)
#define GPIO_PSR6_PSR630                        (0x40000000uL)
#define GPIO_PSR6_PSR631                        (0x80000000uL)

#define GPIO_PPR6_PPR60                         (0x0001u)
#define GPIO_PPR6_PPR61                         (0x0002u)
#define GPIO_PPR6_PPR62                         (0x0004u)
#define GPIO_PPR6_PPR63                         (0x0008u)
#define GPIO_PPR6_PPR64                         (0x0010u)
#define GPIO_PPR6_PPR65                         (0x0020u)
#define GPIO_PPR6_PPR66                         (0x0040u)
#define GPIO_PPR6_PPR67                         (0x0080u)
#define GPIO_PPR6_PPR68                         (0x0100u)
#define GPIO_PPR6_PPR69                         (0x0200u)
#define GPIO_PPR6_PPR610                        (0x0400u)
#define GPIO_PPR6_PPR611                        (0x0800u)
#define GPIO_PPR6_PPR612                        (0x1000u)
#define GPIO_PPR6_PPR613                        (0x2000u)
#define GPIO_PPR6_PPR614                        (0x4000u)
#define GPIO_PPR6_PPR615                        (0x8000u)

#define GPIO_PM6_PM60                           (0x0001u)
#define GPIO_PM6_PM61                           (0x0002u)
#define GPIO_PM6_PM62                           (0x0004u)
#define GPIO_PM6_PM63                           (0x0008u)
#define GPIO_PM6_PM64                           (0x0010u)
#define GPIO_PM6_PM65                           (0x0020u)
#define GPIO_PM6_PM66                           (0x0040u)
#define GPIO_PM6_PM67                           (0x0080u)
#define GPIO_PM6_PM68                           (0x0100u)
#define GPIO_PM6_PM69                           (0x0200u)
#define GPIO_PM6_PM610                          (0x0400u)
#define GPIO_PM6_PM611                          (0x0800u)
#define GPIO_PM6_PM612                          (0x1000u)
#define GPIO_PM6_PM613                          (0x2000u)
#define GPIO_PM6_PM614                          (0x4000u)
#define GPIO_PM6_PM615                          (0x8000u)

#define GPIO_PMC6_PMC60                         (0x0001u)
#define GPIO_PMC6_PMC61                         (0x0002u)
#define GPIO_PMC6_PMC62                         (0x0004u)
#define GPIO_PMC6_PMC63                         (0x0008u)
#define GPIO_PMC6_PMC64                         (0x0010u)
#define GPIO_PMC6_PMC65                         (0x0020u)
#define GPIO_PMC6_PMC66                         (0x0040u)
#define GPIO_PMC6_PMC67                         (0x0080u)
#define GPIO_PMC6_PMC68                         (0x0100u)
#define GPIO_PMC6_PMC69                         (0x0200u)
#define GPIO_PMC6_PMC610                        (0x0400u)
#define GPIO_PMC6_PMC611                        (0x0800u)
#define GPIO_PMC6_PMC612                        (0x1000u)
#define GPIO_PMC6_PMC613                        (0x2000u)
#define GPIO_PMC6_PMC614                        (0x4000u)
#define GPIO_PMC6_PMC615                        (0x8000u)

#define GPIO_PFC6_PFC60                         (0x0001u)
#define GPIO_PFC6_PFC61                         (0x0002u)
#define GPIO_PFC6_PFC62                         (0x0004u)
#define GPIO_PFC6_PFC63                         (0x0008u)
#define GPIO_PFC6_PFC64                         (0x0010u)
#define GPIO_PFC6_PFC65                         (0x0020u)
#define GPIO_PFC6_PFC66                         (0x0040u)
#define GPIO_PFC6_PFC67                         (0x0080u)
#define GPIO_PFC6_PFC68                         (0x0100u)
#define GPIO_PFC6_PFC69                         (0x0200u)
#define GPIO_PFC6_PFC610                        (0x0400u)
#define GPIO_PFC6_PFC611                        (0x0800u)
#define GPIO_PFC6_PFC612                        (0x1000u)
#define GPIO_PFC6_PFC613                        (0x2000u)
#define GPIO_PFC6_PFC614                        (0x4000u)
#define GPIO_PFC6_PFC615                        (0x8000u)

#define GPIO_PFCE6_PFCE60                       (0x0001u)
#define GPIO_PFCE6_PFCE61                       (0x0002u)
#define GPIO_PFCE6_PFCE62                       (0x0004u)
#define GPIO_PFCE6_PFCE63                       (0x0008u)
#define GPIO_PFCE6_PFCE64                       (0x0010u)
#define GPIO_PFCE6_PFCE65                       (0x0020u)
#define GPIO_PFCE6_PFCE66                       (0x0040u)
#define GPIO_PFCE6_PFCE67                       (0x0080u)
#define GPIO_PFCE6_PFCE68                       (0x0100u)
#define GPIO_PFCE6_PFCE69                       (0x0200u)
#define GPIO_PFCE6_PFCE610                      (0x0400u)
#define GPIO_PFCE6_PFCE611                      (0x0800u)
#define GPIO_PFCE6_PFCE612                      (0x1000u)
#define GPIO_PFCE6_PFCE613                      (0x2000u)
#define GPIO_PFCE6_PFCE614                      (0x4000u)
#define GPIO_PFCE6_PFCE615                      (0x8000u)

#define GPIO_PNOT6_PNOT60                       (0x0001u)
#define GPIO_PNOT6_PNOT61                       (0x0002u)
#define GPIO_PNOT6_PNOT62                       (0x0004u)
#define GPIO_PNOT6_PNOT63                       (0x0008u)
#define GPIO_PNOT6_PNOT64                       (0x0010u)
#define GPIO_PNOT6_PNOT65                       (0x0020u)
#define GPIO_PNOT6_PNOT66                       (0x0040u)
#define GPIO_PNOT6_PNOT67                       (0x0080u)
#define GPIO_PNOT6_PNOT68                       (0x0100u)
#define GPIO_PNOT6_PNOT69                       (0x0200u)
#define GPIO_PNOT6_PNOT610                      (0x0400u)
#define GPIO_PNOT6_PNOT611                      (0x0800u)
#define GPIO_PNOT6_PNOT612                      (0x1000u)
#define GPIO_PNOT6_PNOT613                      (0x2000u)
#define GPIO_PNOT6_PNOT614                      (0x4000u)
#define GPIO_PNOT6_PNOT615                      (0x8000u)

#define GPIO_PMSR6_PMSR60                       (0x00000001uL)
#define GPIO_PMSR6_PMSR61                       (0x00000002uL)
#define GPIO_PMSR6_PMSR62                       (0x00000004uL)
#define GPIO_PMSR6_PMSR63                       (0x00000008uL)
#define GPIO_PMSR6_PMSR64                       (0x00000010uL)
#define GPIO_PMSR6_PMSR65                       (0x00000020uL)
#define GPIO_PMSR6_PMSR66                       (0x00000040uL)
#define GPIO_PMSR6_PMSR67                       (0x00000080uL)
#define GPIO_PMSR6_PMSR68                       (0x00000100uL)
#define GPIO_PMSR6_PMSR69                       (0x00000200uL)
#define GPIO_PMSR6_PMSR610                      (0x00000400uL)
#define GPIO_PMSR6_PMSR611                      (0x00000800uL)
#define GPIO_PMSR6_PMSR612                      (0x00001000uL)
#define GPIO_PMSR6_PMSR613                      (0x00002000uL)
#define GPIO_PMSR6_PMSR614                      (0x00004000uL)
#define GPIO_PMSR6_PMSR615                      (0x00008000uL)
#define GPIO_PMSR6_PMSR616                      (0x00010000uL)
#define GPIO_PMSR6_PMSR617                      (0x00020000uL)
#define GPIO_PMSR6_PMSR618                      (0x00040000uL)
#define GPIO_PMSR6_PMSR619                      (0x00080000uL)
#define GPIO_PMSR6_PMSR620                      (0x00100000uL)
#define GPIO_PMSR6_PMSR621                      (0x00200000uL)
#define GPIO_PMSR6_PMSR622                      (0x00400000uL)
#define GPIO_PMSR6_PMSR623                      (0x00800000uL)
#define GPIO_PMSR6_PMSR624                      (0x01000000uL)
#define GPIO_PMSR6_PMSR625                      (0x02000000uL)
#define GPIO_PMSR6_PMSR626                      (0x04000000uL)
#define GPIO_PMSR6_PMSR627                      (0x08000000uL)
#define GPIO_PMSR6_PMSR628                      (0x10000000uL)
#define GPIO_PMSR6_PMSR629                      (0x20000000uL)
#define GPIO_PMSR6_PMSR630                      (0x40000000uL)
#define GPIO_PMSR6_PMSR631                      (0x80000000uL)

#define GPIO_PMCSR6_PMCSR60                     (0x00000001uL)
#define GPIO_PMCSR6_PMCSR61                     (0x00000002uL)
#define GPIO_PMCSR6_PMCSR62                     (0x00000004uL)
#define GPIO_PMCSR6_PMCSR63                     (0x00000008uL)
#define GPIO_PMCSR6_PMCSR64                     (0x00000010uL)
#define GPIO_PMCSR6_PMCSR65                     (0x00000020uL)
#define GPIO_PMCSR6_PMCSR66                     (0x00000040uL)
#define GPIO_PMCSR6_PMCSR67                     (0x00000080uL)
#define GPIO_PMCSR6_PMCSR68                     (0x00000100uL)
#define GPIO_PMCSR6_PMCSR69                     (0x00000200uL)
#define GPIO_PMCSR6_PMCSR610                    (0x00000400uL)
#define GPIO_PMCSR6_PMCSR611                    (0x00000800uL)
#define GPIO_PMCSR6_PMCSR612                    (0x00001000uL)
#define GPIO_PMCSR6_PMCSR613                    (0x00002000uL)
#define GPIO_PMCSR6_PMCSR614                    (0x00004000uL)
#define GPIO_PMCSR6_PMCSR615                    (0x00008000uL)
#define GPIO_PMCSR6_PMCSR616                    (0x00010000uL)
#define GPIO_PMCSR6_PMCSR617                    (0x00020000uL)
#define GPIO_PMCSR6_PMCSR618                    (0x00040000uL)
#define GPIO_PMCSR6_PMCSR619                    (0x00080000uL)
#define GPIO_PMCSR6_PMCSR620                    (0x00100000uL)
#define GPIO_PMCSR6_PMCSR621                    (0x00200000uL)
#define GPIO_PMCSR6_PMCSR622                    (0x00400000uL)
#define GPIO_PMCSR6_PMCSR623                    (0x00800000uL)
#define GPIO_PMCSR6_PMCSR624                    (0x01000000uL)
#define GPIO_PMCSR6_PMCSR625                    (0x02000000uL)
#define GPIO_PMCSR6_PMCSR626                    (0x04000000uL)
#define GPIO_PMCSR6_PMCSR627                    (0x08000000uL)
#define GPIO_PMCSR6_PMCSR628                    (0x10000000uL)
#define GPIO_PMCSR6_PMCSR629                    (0x20000000uL)
#define GPIO_PMCSR6_PMCSR630                    (0x40000000uL)
#define GPIO_PMCSR6_PMCSR631                    (0x80000000uL)

#define GPIO_PFCAE6_PFCAE60                     (0x0001u)
#define GPIO_PFCAE6_PFCAE61                     (0x0002u)
#define GPIO_PFCAE6_PFCAE62                     (0x0004u)
#define GPIO_PFCAE6_PFCAE63                     (0x0008u)
#define GPIO_PFCAE6_PFCAE64                     (0x0010u)
#define GPIO_PFCAE6_PFCAE65                     (0x0020u)
#define GPIO_PFCAE6_PFCAE66                     (0x0040u)
#define GPIO_PFCAE6_PFCAE67                     (0x0080u)
#define GPIO_PFCAE6_PFCAE68                     (0x0100u)
#define GPIO_PFCAE6_PFCAE69                     (0x0200u)
#define GPIO_PFCAE6_PFCAE610                    (0x0400u)
#define GPIO_PFCAE6_PFCAE611                    (0x0800u)
#define GPIO_PFCAE6_PFCAE612                    (0x1000u)
#define GPIO_PFCAE6_PFCAE613                    (0x2000u)
#define GPIO_PFCAE6_PFCAE614                    (0x4000u)
#define GPIO_PFCAE6_PFCAE615                    (0x8000u)

#define GPIO_PIBC6_PIBC60                       (0x0001u)
#define GPIO_PIBC6_PIBC61                       (0x0002u)
#define GPIO_PIBC6_PIBC62                       (0x0004u)
#define GPIO_PIBC6_PIBC63                       (0x0008u)
#define GPIO_PIBC6_PIBC64                       (0x0010u)
#define GPIO_PIBC6_PIBC65                       (0x0020u)
#define GPIO_PIBC6_PIBC66                       (0x0040u)
#define GPIO_PIBC6_PIBC67                       (0x0080u)
#define GPIO_PIBC6_PIBC68                       (0x0100u)
#define GPIO_PIBC6_PIBC69                       (0x0200u)
#define GPIO_PIBC6_PIBC610                      (0x0400u)
#define GPIO_PIBC6_PIBC611                      (0x0800u)
#define GPIO_PIBC6_PIBC612                      (0x1000u)
#define GPIO_PIBC6_PIBC613                      (0x2000u)
#define GPIO_PIBC6_PIBC614                      (0x4000u)
#define GPIO_PIBC6_PIBC615                      (0x8000u)

#define GPIO_PBDC6_PBDC60                       (0x0001u)
#define GPIO_PBDC6_PBDC61                       (0x0002u)
#define GPIO_PBDC6_PBDC62                       (0x0004u)
#define GPIO_PBDC6_PBDC63                       (0x0008u)
#define GPIO_PBDC6_PBDC64                       (0x0010u)
#define GPIO_PBDC6_PBDC65                       (0x0020u)
#define GPIO_PBDC6_PBDC66                       (0x0040u)
#define GPIO_PBDC6_PBDC67                       (0x0080u)
#define GPIO_PBDC6_PBDC68                       (0x0100u)
#define GPIO_PBDC6_PBDC69                       (0x0200u)
#define GPIO_PBDC6_PBDC610                      (0x0400u)
#define GPIO_PBDC6_PBDC611                      (0x0800u)
#define GPIO_PBDC6_PBDC612                      (0x1000u)
#define GPIO_PBDC6_PBDC613                      (0x2000u)
#define GPIO_PBDC6_PBDC614                      (0x4000u)
#define GPIO_PBDC6_PBDC615                      (0x8000u)

#define GPIO_PIPC6_PIPC60                       (0x0001u)
#define GPIO_PIPC6_PIPC61                       (0x0002u)
#define GPIO_PIPC6_PIPC62                       (0x0004u)
#define GPIO_PIPC6_PIPC63                       (0x0008u)
#define GPIO_PIPC6_PIPC64                       (0x0010u)
#define GPIO_PIPC6_PIPC65                       (0x0020u)
#define GPIO_PIPC6_PIPC66                       (0x0040u)
#define GPIO_PIPC6_PIPC67                       (0x0080u)
#define GPIO_PIPC6_PIPC68                       (0x0100u)
#define GPIO_PIPC6_PIPC69                       (0x0200u)
#define GPIO_PIPC6_PIPC610                      (0x0400u)
#define GPIO_PIPC6_PIPC611                      (0x0800u)
#define GPIO_PIPC6_PIPC612                      (0x1000u)
#define GPIO_PIPC6_PIPC613                      (0x2000u)
#define GPIO_PIPC6_PIPC614                      (0x4000u)
#define GPIO_PIPC6_PIPC615                      (0x8000u)

/* ---- P7 ---- */
#define GPIO_P7_P70                             (0x0001u)
#define GPIO_P7_P71                             (0x0002u)
#define GPIO_P7_P72                             (0x0004u)
#define GPIO_P7_P73                             (0x0008u)
#define GPIO_P7_P74                             (0x0010u)
#define GPIO_P7_P75                             (0x0020u)
#define GPIO_P7_P76                             (0x0040u)
#define GPIO_P7_P77                             (0x0080u)
#define GPIO_P7_P78                             (0x0100u)
#define GPIO_P7_P79                             (0x0200u)
#define GPIO_P7_P710                            (0x0400u)
#define GPIO_P7_P711                            (0x0800u)
#define GPIO_P7_P712                            (0x1000u)
#define GPIO_P7_P713                            (0x2000u)
#define GPIO_P7_P714                            (0x4000u)
#define GPIO_P7_P715                            (0x8000u)

#define GPIO_PSR7_PSR70                         (0x00000001uL)
#define GPIO_PSR7_PSR71                         (0x00000002uL)
#define GPIO_PSR7_PSR72                         (0x00000004uL)
#define GPIO_PSR7_PSR73                         (0x00000008uL)
#define GPIO_PSR7_PSR74                         (0x00000010uL)
#define GPIO_PSR7_PSR75                         (0x00000020uL)
#define GPIO_PSR7_PSR76                         (0x00000040uL)
#define GPIO_PSR7_PSR77                         (0x00000080uL)
#define GPIO_PSR7_PSR78                         (0x00000100uL)
#define GPIO_PSR7_PSR79                         (0x00000200uL)
#define GPIO_PSR7_PSR710                        (0x00000400uL)
#define GPIO_PSR7_PSR711                        (0x00000800uL)
#define GPIO_PSR7_PSR712                        (0x00001000uL)
#define GPIO_PSR7_PSR713                        (0x00002000uL)
#define GPIO_PSR7_PSR714                        (0x00004000uL)
#define GPIO_PSR7_PSR715                        (0x00008000uL)
#define GPIO_PSR7_PSR716                        (0x00010000uL)
#define GPIO_PSR7_PSR717                        (0x00020000uL)
#define GPIO_PSR7_PSR718                        (0x00040000uL)
#define GPIO_PSR7_PSR719                        (0x00080000uL)
#define GPIO_PSR7_PSR720                        (0x00100000uL)
#define GPIO_PSR7_PSR721                        (0x00200000uL)
#define GPIO_PSR7_PSR722                        (0x00400000uL)
#define GPIO_PSR7_PSR723                        (0x00800000uL)
#define GPIO_PSR7_PSR724                        (0x01000000uL)
#define GPIO_PSR7_PSR725                        (0x02000000uL)
#define GPIO_PSR7_PSR726                        (0x04000000uL)
#define GPIO_PSR7_PSR727                        (0x08000000uL)
#define GPIO_PSR7_PSR728                        (0x10000000uL)
#define GPIO_PSR7_PSR729                        (0x20000000uL)
#define GPIO_PSR7_PSR730                        (0x40000000uL)
#define GPIO_PSR7_PSR731                        (0x80000000uL)

#define GPIO_PPR7_PPR70                         (0x0001u)
#define GPIO_PPR7_PPR71                         (0x0002u)
#define GPIO_PPR7_PPR72                         (0x0004u)
#define GPIO_PPR7_PPR73                         (0x0008u)
#define GPIO_PPR7_PPR74                         (0x0010u)
#define GPIO_PPR7_PPR75                         (0x0020u)
#define GPIO_PPR7_PPR76                         (0x0040u)
#define GPIO_PPR7_PPR77                         (0x0080u)
#define GPIO_PPR7_PPR78                         (0x0100u)
#define GPIO_PPR7_PPR79                         (0x0200u)
#define GPIO_PPR7_PPR710                        (0x0400u)
#define GPIO_PPR7_PPR711                        (0x0800u)
#define GPIO_PPR7_PPR712                        (0x1000u)
#define GPIO_PPR7_PPR713                        (0x2000u)
#define GPIO_PPR7_PPR714                        (0x4000u)
#define GPIO_PPR7_PPR715                        (0x8000u)

#define GPIO_PM7_PM70                           (0x0001u)
#define GPIO_PM7_PM71                           (0x0002u)
#define GPIO_PM7_PM72                           (0x0004u)
#define GPIO_PM7_PM73                           (0x0008u)
#define GPIO_PM7_PM74                           (0x0010u)
#define GPIO_PM7_PM75                           (0x0020u)
#define GPIO_PM7_PM76                           (0x0040u)
#define GPIO_PM7_PM77                           (0x0080u)
#define GPIO_PM7_PM78                           (0x0100u)
#define GPIO_PM7_PM79                           (0x0200u)
#define GPIO_PM7_PM710                          (0x0400u)
#define GPIO_PM7_PM711                          (0x0800u)
#define GPIO_PM7_PM712                          (0x1000u)
#define GPIO_PM7_PM713                          (0x2000u)
#define GPIO_PM7_PM714                          (0x4000u)
#define GPIO_PM7_PM715                          (0x8000u)

#define GPIO_PMC7_PMC70                         (0x0001u)
#define GPIO_PMC7_PMC71                         (0x0002u)
#define GPIO_PMC7_PMC72                         (0x0004u)
#define GPIO_PMC7_PMC73                         (0x0008u)
#define GPIO_PMC7_PMC74                         (0x0010u)
#define GPIO_PMC7_PMC75                         (0x0020u)
#define GPIO_PMC7_PMC76                         (0x0040u)
#define GPIO_PMC7_PMC77                         (0x0080u)
#define GPIO_PMC7_PMC78                         (0x0100u)
#define GPIO_PMC7_PMC79                         (0x0200u)
#define GPIO_PMC7_PMC710                        (0x0400u)
#define GPIO_PMC7_PMC711                        (0x0800u)
#define GPIO_PMC7_PMC712                        (0x1000u)
#define GPIO_PMC7_PMC713                        (0x2000u)
#define GPIO_PMC7_PMC714                        (0x4000u)
#define GPIO_PMC7_PMC715                        (0x8000u)

#define GPIO_PFC7_PFC70                         (0x0001u)
#define GPIO_PFC7_PFC71                         (0x0002u)
#define GPIO_PFC7_PFC72                         (0x0004u)
#define GPIO_PFC7_PFC73                         (0x0008u)
#define GPIO_PFC7_PFC74                         (0x0010u)
#define GPIO_PFC7_PFC75                         (0x0020u)
#define GPIO_PFC7_PFC76                         (0x0040u)
#define GPIO_PFC7_PFC77                         (0x0080u)
#define GPIO_PFC7_PFC78                         (0x0100u)
#define GPIO_PFC7_PFC79                         (0x0200u)
#define GPIO_PFC7_PFC710                        (0x0400u)
#define GPIO_PFC7_PFC711                        (0x0800u)
#define GPIO_PFC7_PFC712                        (0x1000u)
#define GPIO_PFC7_PFC713                        (0x2000u)
#define GPIO_PFC7_PFC714                        (0x4000u)
#define GPIO_PFC7_PFC715                        (0x8000u)

#define GPIO_PFCE7_PFCE70                       (0x0001u)
#define GPIO_PFCE7_PFCE71                       (0x0002u)
#define GPIO_PFCE7_PFCE72                       (0x0004u)
#define GPIO_PFCE7_PFCE73                       (0x0008u)
#define GPIO_PFCE7_PFCE74                       (0x0010u)
#define GPIO_PFCE7_PFCE75                       (0x0020u)
#define GPIO_PFCE7_PFCE76                       (0x0040u)
#define GPIO_PFCE7_PFCE77                       (0x0080u)
#define GPIO_PFCE7_PFCE78                       (0x0100u)
#define GPIO_PFCE7_PFCE79                       (0x0200u)
#define GPIO_PFCE7_PFCE710                      (0x0400u)
#define GPIO_PFCE7_PFCE711                      (0x0800u)
#define GPIO_PFCE7_PFCE712                      (0x1000u)
#define GPIO_PFCE7_PFCE713                      (0x2000u)
#define GPIO_PFCE7_PFCE714                      (0x4000u)
#define GPIO_PFCE7_PFCE715                      (0x8000u)

#define GPIO_PNOT7_PNOT70                       (0x0001u)
#define GPIO_PNOT7_PNOT71                       (0x0002u)
#define GPIO_PNOT7_PNOT72                       (0x0004u)
#define GPIO_PNOT7_PNOT73                       (0x0008u)
#define GPIO_PNOT7_PNOT74                       (0x0010u)
#define GPIO_PNOT7_PNOT75                       (0x0020u)
#define GPIO_PNOT7_PNOT76                       (0x0040u)
#define GPIO_PNOT7_PNOT77                       (0x0080u)
#define GPIO_PNOT7_PNOT78                       (0x0100u)
#define GPIO_PNOT7_PNOT79                       (0x0200u)
#define GPIO_PNOT7_PNOT710                      (0x0400u)
#define GPIO_PNOT7_PNOT711                      (0x0800u)
#define GPIO_PNOT7_PNOT712                      (0x1000u)
#define GPIO_PNOT7_PNOT713                      (0x2000u)
#define GPIO_PNOT7_PNOT714                      (0x4000u)
#define GPIO_PNOT7_PNOT715                      (0x8000u)

#define GPIO_PMSR7_PMSR70                       (0x00000001uL)
#define GPIO_PMSR7_PMSR71                       (0x00000002uL)
#define GPIO_PMSR7_PMSR72                       (0x00000004uL)
#define GPIO_PMSR7_PMSR73                       (0x00000008uL)
#define GPIO_PMSR7_PMSR74                       (0x00000010uL)
#define GPIO_PMSR7_PMSR75                       (0x00000020uL)
#define GPIO_PMSR7_PMSR76                       (0x00000040uL)
#define GPIO_PMSR7_PMSR77                       (0x00000080uL)
#define GPIO_PMSR7_PMSR78                       (0x00000100uL)
#define GPIO_PMSR7_PMSR79                       (0x00000200uL)
#define GPIO_PMSR7_PMSR710                      (0x00000400uL)
#define GPIO_PMSR7_PMSR711                      (0x00000800uL)
#define GPIO_PMSR7_PMSR712                      (0x00001000uL)
#define GPIO_PMSR7_PMSR713                      (0x00002000uL)
#define GPIO_PMSR7_PMSR714                      (0x00004000uL)
#define GPIO_PMSR7_PMSR715                      (0x00008000uL)
#define GPIO_PMSR7_PMSR716                      (0x00010000uL)
#define GPIO_PMSR7_PMSR717                      (0x00020000uL)
#define GPIO_PMSR7_PMSR718                      (0x00040000uL)
#define GPIO_PMSR7_PMSR719                      (0x00080000uL)
#define GPIO_PMSR7_PMSR720                      (0x00100000uL)
#define GPIO_PMSR7_PMSR721                      (0x00200000uL)
#define GPIO_PMSR7_PMSR722                      (0x00400000uL)
#define GPIO_PMSR7_PMSR723                      (0x00800000uL)
#define GPIO_PMSR7_PMSR724                      (0x01000000uL)
#define GPIO_PMSR7_PMSR725                      (0x02000000uL)
#define GPIO_PMSR7_PMSR726                      (0x04000000uL)
#define GPIO_PMSR7_PMSR727                      (0x08000000uL)
#define GPIO_PMSR7_PMSR728                      (0x10000000uL)
#define GPIO_PMSR7_PMSR729                      (0x20000000uL)
#define GPIO_PMSR7_PMSR730                      (0x40000000uL)
#define GPIO_PMSR7_PMSR731                      (0x80000000uL)

#define GPIO_PMCSR7_PMCSR70                     (0x00000001uL)
#define GPIO_PMCSR7_PMCSR71                     (0x00000002uL)
#define GPIO_PMCSR7_PMCSR72                     (0x00000004uL)
#define GPIO_PMCSR7_PMCSR73                     (0x00000008uL)
#define GPIO_PMCSR7_PMCSR74                     (0x00000010uL)
#define GPIO_PMCSR7_PMCSR75                     (0x00000020uL)
#define GPIO_PMCSR7_PMCSR76                     (0x00000040uL)
#define GPIO_PMCSR7_PMCSR77                     (0x00000080uL)
#define GPIO_PMCSR7_PMCSR78                     (0x00000100uL)
#define GPIO_PMCSR7_PMCSR79                     (0x00000200uL)
#define GPIO_PMCSR7_PMCSR710                    (0x00000400uL)
#define GPIO_PMCSR7_PMCSR711                    (0x00000800uL)
#define GPIO_PMCSR7_PMCSR712                    (0x00001000uL)
#define GPIO_PMCSR7_PMCSR713                    (0x00002000uL)
#define GPIO_PMCSR7_PMCSR714                    (0x00004000uL)
#define GPIO_PMCSR7_PMCSR715                    (0x00008000uL)
#define GPIO_PMCSR7_PMCSR716                    (0x00010000uL)
#define GPIO_PMCSR7_PMCSR717                    (0x00020000uL)
#define GPIO_PMCSR7_PMCSR718                    (0x00040000uL)
#define GPIO_PMCSR7_PMCSR719                    (0x00080000uL)
#define GPIO_PMCSR7_PMCSR720                    (0x00100000uL)
#define GPIO_PMCSR7_PMCSR721                    (0x00200000uL)
#define GPIO_PMCSR7_PMCSR722                    (0x00400000uL)
#define GPIO_PMCSR7_PMCSR723                    (0x00800000uL)
#define GPIO_PMCSR7_PMCSR724                    (0x01000000uL)
#define GPIO_PMCSR7_PMCSR725                    (0x02000000uL)
#define GPIO_PMCSR7_PMCSR726                    (0x04000000uL)
#define GPIO_PMCSR7_PMCSR727                    (0x08000000uL)
#define GPIO_PMCSR7_PMCSR728                    (0x10000000uL)
#define GPIO_PMCSR7_PMCSR729                    (0x20000000uL)
#define GPIO_PMCSR7_PMCSR730                    (0x40000000uL)
#define GPIO_PMCSR7_PMCSR731                    (0x80000000uL)

#define GPIO_PFCAE7_PFCAE70                     (0x0001u)
#define GPIO_PFCAE7_PFCAE71                     (0x0002u)
#define GPIO_PFCAE7_PFCAE72                     (0x0004u)
#define GPIO_PFCAE7_PFCAE73                     (0x0008u)
#define GPIO_PFCAE7_PFCAE74                     (0x0010u)
#define GPIO_PFCAE7_PFCAE75                     (0x0020u)
#define GPIO_PFCAE7_PFCAE76                     (0x0040u)
#define GPIO_PFCAE7_PFCAE77                     (0x0080u)
#define GPIO_PFCAE7_PFCAE78                     (0x0100u)
#define GPIO_PFCAE7_PFCAE79                     (0x0200u)
#define GPIO_PFCAE7_PFCAE710                    (0x0400u)
#define GPIO_PFCAE7_PFCAE711                    (0x0800u)
#define GPIO_PFCAE7_PFCAE712                    (0x1000u)
#define GPIO_PFCAE7_PFCAE713                    (0x2000u)
#define GPIO_PFCAE7_PFCAE714                    (0x4000u)
#define GPIO_PFCAE7_PFCAE715                    (0x8000u)

#define GPIO_PIBC7_PIBC70                       (0x0001u)
#define GPIO_PIBC7_PIBC71                       (0x0002u)
#define GPIO_PIBC7_PIBC72                       (0x0004u)
#define GPIO_PIBC7_PIBC73                       (0x0008u)
#define GPIO_PIBC7_PIBC74                       (0x0010u)
#define GPIO_PIBC7_PIBC75                       (0x0020u)
#define GPIO_PIBC7_PIBC76                       (0x0040u)
#define GPIO_PIBC7_PIBC77                       (0x0080u)
#define GPIO_PIBC7_PIBC78                       (0x0100u)
#define GPIO_PIBC7_PIBC79                       (0x0200u)
#define GPIO_PIBC7_PIBC710                      (0x0400u)
#define GPIO_PIBC7_PIBC711                      (0x0800u)
#define GPIO_PIBC7_PIBC712                      (0x1000u)
#define GPIO_PIBC7_PIBC713                      (0x2000u)
#define GPIO_PIBC7_PIBC714                      (0x4000u)
#define GPIO_PIBC7_PIBC715                      (0x8000u)

#define GPIO_PBDC7_PBDC70                       (0x0001u)
#define GPIO_PBDC7_PBDC71                       (0x0002u)
#define GPIO_PBDC7_PBDC72                       (0x0004u)
#define GPIO_PBDC7_PBDC73                       (0x0008u)
#define GPIO_PBDC7_PBDC74                       (0x0010u)
#define GPIO_PBDC7_PBDC75                       (0x0020u)
#define GPIO_PBDC7_PBDC76                       (0x0040u)
#define GPIO_PBDC7_PBDC77                       (0x0080u)
#define GPIO_PBDC7_PBDC78                       (0x0100u)
#define GPIO_PBDC7_PBDC79                       (0x0200u)
#define GPIO_PBDC7_PBDC710                      (0x0400u)
#define GPIO_PBDC7_PBDC711                      (0x0800u)
#define GPIO_PBDC7_PBDC712                      (0x1000u)
#define GPIO_PBDC7_PBDC713                      (0x2000u)
#define GPIO_PBDC7_PBDC714                      (0x4000u)
#define GPIO_PBDC7_PBDC715                      (0x8000u)

#define GPIO_PIPC7_PIPC70                       (0x0001u)
#define GPIO_PIPC7_PIPC71                       (0x0002u)
#define GPIO_PIPC7_PIPC72                       (0x0004u)
#define GPIO_PIPC7_PIPC73                       (0x0008u)
#define GPIO_PIPC7_PIPC74                       (0x0010u)
#define GPIO_PIPC7_PIPC75                       (0x0020u)
#define GPIO_PIPC7_PIPC76                       (0x0040u)
#define GPIO_PIPC7_PIPC77                       (0x0080u)
#define GPIO_PIPC7_PIPC78                       (0x0100u)
#define GPIO_PIPC7_PIPC79                       (0x0200u)
#define GPIO_PIPC7_PIPC710                      (0x0400u)
#define GPIO_PIPC7_PIPC711                      (0x0800u)
#define GPIO_PIPC7_PIPC712                      (0x1000u)
#define GPIO_PIPC7_PIPC713                      (0x2000u)
#define GPIO_PIPC7_PIPC714                      (0x4000u)
#define GPIO_PIPC7_PIPC715                      (0x8000u)

/* ---- P8 ---- */
#define GPIO_P8_P80                             (0x0001u)
#define GPIO_P8_P81                             (0x0002u)
#define GPIO_P8_P82                             (0x0004u)
#define GPIO_P8_P83                             (0x0008u)
#define GPIO_P8_P84                             (0x0010u)
#define GPIO_P8_P85                             (0x0020u)
#define GPIO_P8_P86                             (0x0040u)
#define GPIO_P8_P87                             (0x0080u)
#define GPIO_P8_P88                             (0x0100u)
#define GPIO_P8_P89                             (0x0200u)
#define GPIO_P8_P810                            (0x0400u)
#define GPIO_P8_P811                            (0x0800u)
#define GPIO_P8_P812                            (0x1000u)
#define GPIO_P8_P813                            (0x2000u)
#define GPIO_P8_P814                            (0x4000u)
#define GPIO_P8_P815                            (0x8000u)

#define GPIO_PSR8_PSR80                         (0x00000001uL)
#define GPIO_PSR8_PSR81                         (0x00000002uL)
#define GPIO_PSR8_PSR82                         (0x00000004uL)
#define GPIO_PSR8_PSR83                         (0x00000008uL)
#define GPIO_PSR8_PSR84                         (0x00000010uL)
#define GPIO_PSR8_PSR85                         (0x00000020uL)
#define GPIO_PSR8_PSR86                         (0x00000040uL)
#define GPIO_PSR8_PSR87                         (0x00000080uL)
#define GPIO_PSR8_PSR88                         (0x00000100uL)
#define GPIO_PSR8_PSR89                         (0x00000200uL)
#define GPIO_PSR8_PSR810                        (0x00000400uL)
#define GPIO_PSR8_PSR811                        (0x00000800uL)
#define GPIO_PSR8_PSR812                        (0x00001000uL)
#define GPIO_PSR8_PSR813                        (0x00002000uL)
#define GPIO_PSR8_PSR814                        (0x00004000uL)
#define GPIO_PSR8_PSR815                        (0x00008000uL)
#define GPIO_PSR8_PSR816                        (0x00010000uL)
#define GPIO_PSR8_PSR817                        (0x00020000uL)
#define GPIO_PSR8_PSR818                        (0x00040000uL)
#define GPIO_PSR8_PSR819                        (0x00080000uL)
#define GPIO_PSR8_PSR820                        (0x00100000uL)
#define GPIO_PSR8_PSR821                        (0x00200000uL)
#define GPIO_PSR8_PSR822                        (0x00400000uL)
#define GPIO_PSR8_PSR823                        (0x00800000uL)
#define GPIO_PSR8_PSR824                        (0x01000000uL)
#define GPIO_PSR8_PSR825                        (0x02000000uL)
#define GPIO_PSR8_PSR826                        (0x04000000uL)
#define GPIO_PSR8_PSR827                        (0x08000000uL)
#define GPIO_PSR8_PSR828                        (0x10000000uL)
#define GPIO_PSR8_PSR829                        (0x20000000uL)
#define GPIO_PSR8_PSR830                        (0x40000000uL)
#define GPIO_PSR8_PSR831                        (0x80000000uL)

#define GPIO_PPR8_PPR80                         (0x0001u)
#define GPIO_PPR8_PPR81                         (0x0002u)
#define GPIO_PPR8_PPR82                         (0x0004u)
#define GPIO_PPR8_PPR83                         (0x0008u)
#define GPIO_PPR8_PPR84                         (0x0010u)
#define GPIO_PPR8_PPR85                         (0x0020u)
#define GPIO_PPR8_PPR86                         (0x0040u)
#define GPIO_PPR8_PPR87                         (0x0080u)
#define GPIO_PPR8_PPR88                         (0x0100u)
#define GPIO_PPR8_PPR89                         (0x0200u)
#define GPIO_PPR8_PPR810                        (0x0400u)
#define GPIO_PPR8_PPR811                        (0x0800u)
#define GPIO_PPR8_PPR812                        (0x1000u)
#define GPIO_PPR8_PPR813                        (0x2000u)
#define GPIO_PPR8_PPR814                        (0x4000u)
#define GPIO_PPR8_PPR815                        (0x8000u)

#define GPIO_PM8_PM80                           (0x0001u)
#define GPIO_PM8_PM81                           (0x0002u)
#define GPIO_PM8_PM82                           (0x0004u)
#define GPIO_PM8_PM83                           (0x0008u)
#define GPIO_PM8_PM84                           (0x0010u)
#define GPIO_PM8_PM85                           (0x0020u)
#define GPIO_PM8_PM86                           (0x0040u)
#define GPIO_PM8_PM87                           (0x0080u)
#define GPIO_PM8_PM88                           (0x0100u)
#define GPIO_PM8_PM89                           (0x0200u)
#define GPIO_PM8_PM810                          (0x0400u)
#define GPIO_PM8_PM811                          (0x0800u)
#define GPIO_PM8_PM812                          (0x1000u)
#define GPIO_PM8_PM813                          (0x2000u)
#define GPIO_PM8_PM814                          (0x4000u)
#define GPIO_PM8_PM815                          (0x8000u)

#define GPIO_PMC8_PMC80                         (0x0001u)
#define GPIO_PMC8_PMC81                         (0x0002u)
#define GPIO_PMC8_PMC82                         (0x0004u)
#define GPIO_PMC8_PMC83                         (0x0008u)
#define GPIO_PMC8_PMC84                         (0x0010u)
#define GPIO_PMC8_PMC85                         (0x0020u)
#define GPIO_PMC8_PMC86                         (0x0040u)
#define GPIO_PMC8_PMC87                         (0x0080u)
#define GPIO_PMC8_PMC88                         (0x0100u)
#define GPIO_PMC8_PMC89                         (0x0200u)
#define GPIO_PMC8_PMC810                        (0x0400u)
#define GPIO_PMC8_PMC811                        (0x0800u)
#define GPIO_PMC8_PMC812                        (0x1000u)
#define GPIO_PMC8_PMC813                        (0x2000u)
#define GPIO_PMC8_PMC814                        (0x4000u)
#define GPIO_PMC8_PMC815                        (0x8000u)

#define GPIO_PFC8_PFC80                         (0x0001u)
#define GPIO_PFC8_PFC81                         (0x0002u)
#define GPIO_PFC8_PFC82                         (0x0004u)
#define GPIO_PFC8_PFC83                         (0x0008u)
#define GPIO_PFC8_PFC84                         (0x0010u)
#define GPIO_PFC8_PFC85                         (0x0020u)
#define GPIO_PFC8_PFC86                         (0x0040u)
#define GPIO_PFC8_PFC87                         (0x0080u)
#define GPIO_PFC8_PFC88                         (0x0100u)
#define GPIO_PFC8_PFC89                         (0x0200u)
#define GPIO_PFC8_PFC810                        (0x0400u)
#define GPIO_PFC8_PFC811                        (0x0800u)
#define GPIO_PFC8_PFC812                        (0x1000u)
#define GPIO_PFC8_PFC813                        (0x2000u)
#define GPIO_PFC8_PFC814                        (0x4000u)
#define GPIO_PFC8_PFC815                        (0x8000u)

#define GPIO_PFCE8_PFCE80                       (0x0001u)
#define GPIO_PFCE8_PFCE81                       (0x0002u)
#define GPIO_PFCE8_PFCE82                       (0x0004u)
#define GPIO_PFCE8_PFCE83                       (0x0008u)
#define GPIO_PFCE8_PFCE84                       (0x0010u)
#define GPIO_PFCE8_PFCE85                       (0x0020u)
#define GPIO_PFCE8_PFCE86                       (0x0040u)
#define GPIO_PFCE8_PFCE87                       (0x0080u)
#define GPIO_PFCE8_PFCE88                       (0x0100u)
#define GPIO_PFCE8_PFCE89                       (0x0200u)
#define GPIO_PFCE8_PFCE810                      (0x0400u)
#define GPIO_PFCE8_PFCE811                      (0x0800u)
#define GPIO_PFCE8_PFCE812                      (0x1000u)
#define GPIO_PFCE8_PFCE813                      (0x2000u)
#define GPIO_PFCE8_PFCE814                      (0x4000u)
#define GPIO_PFCE8_PFCE815                      (0x8000u)

#define GPIO_PNOT8_PNOT80                       (0x0001u)
#define GPIO_PNOT8_PNOT81                       (0x0002u)
#define GPIO_PNOT8_PNOT82                       (0x0004u)
#define GPIO_PNOT8_PNOT83                       (0x0008u)
#define GPIO_PNOT8_PNOT84                       (0x0010u)
#define GPIO_PNOT8_PNOT85                       (0x0020u)
#define GPIO_PNOT8_PNOT86                       (0x0040u)
#define GPIO_PNOT8_PNOT87                       (0x0080u)
#define GPIO_PNOT8_PNOT88                       (0x0100u)
#define GPIO_PNOT8_PNOT89                       (0x0200u)
#define GPIO_PNOT8_PNOT810                      (0x0400u)
#define GPIO_PNOT8_PNOT811                      (0x0800u)
#define GPIO_PNOT8_PNOT812                      (0x1000u)
#define GPIO_PNOT8_PNOT813                      (0x2000u)
#define GPIO_PNOT8_PNOT814                      (0x4000u)
#define GPIO_PNOT8_PNOT815                      (0x8000u)

#define GPIO_PMSR8_PMSR80                       (0x00000001uL)
#define GPIO_PMSR8_PMSR81                       (0x00000002uL)
#define GPIO_PMSR8_PMSR82                       (0x00000004uL)
#define GPIO_PMSR8_PMSR83                       (0x00000008uL)
#define GPIO_PMSR8_PMSR84                       (0x00000010uL)
#define GPIO_PMSR8_PMSR85                       (0x00000020uL)
#define GPIO_PMSR8_PMSR86                       (0x00000040uL)
#define GPIO_PMSR8_PMSR87                       (0x00000080uL)
#define GPIO_PMSR8_PMSR88                       (0x00000100uL)
#define GPIO_PMSR8_PMSR89                       (0x00000200uL)
#define GPIO_PMSR8_PMSR810                      (0x00000400uL)
#define GPIO_PMSR8_PMSR811                      (0x00000800uL)
#define GPIO_PMSR8_PMSR812                      (0x00001000uL)
#define GPIO_PMSR8_PMSR813                      (0x00002000uL)
#define GPIO_PMSR8_PMSR814                      (0x00004000uL)
#define GPIO_PMSR8_PMSR815                      (0x00008000uL)
#define GPIO_PMSR8_PMSR816                      (0x00010000uL)
#define GPIO_PMSR8_PMSR817                      (0x00020000uL)
#define GPIO_PMSR8_PMSR818                      (0x00040000uL)
#define GPIO_PMSR8_PMSR819                      (0x00080000uL)
#define GPIO_PMSR8_PMSR820                      (0x00100000uL)
#define GPIO_PMSR8_PMSR821                      (0x00200000uL)
#define GPIO_PMSR8_PMSR822                      (0x00400000uL)
#define GPIO_PMSR8_PMSR823                      (0x00800000uL)
#define GPIO_PMSR8_PMSR824                      (0x01000000uL)
#define GPIO_PMSR8_PMSR825                      (0x02000000uL)
#define GPIO_PMSR8_PMSR826                      (0x04000000uL)
#define GPIO_PMSR8_PMSR827                      (0x08000000uL)
#define GPIO_PMSR8_PMSR828                      (0x10000000uL)
#define GPIO_PMSR8_PMSR829                      (0x20000000uL)
#define GPIO_PMSR8_PMSR830                      (0x40000000uL)
#define GPIO_PMSR8_PMSR831                      (0x80000000uL)

#define GPIO_PMCSR8_PMCSR80                     (0x00000001uL)
#define GPIO_PMCSR8_PMCSR81                     (0x00000002uL)
#define GPIO_PMCSR8_PMCSR82                     (0x00000004uL)
#define GPIO_PMCSR8_PMCSR83                     (0x00000008uL)
#define GPIO_PMCSR8_PMCSR84                     (0x00000010uL)
#define GPIO_PMCSR8_PMCSR85                     (0x00000020uL)
#define GPIO_PMCSR8_PMCSR86                     (0x00000040uL)
#define GPIO_PMCSR8_PMCSR87                     (0x00000080uL)
#define GPIO_PMCSR8_PMCSR88                     (0x00000100uL)
#define GPIO_PMCSR8_PMCSR89                     (0x00000200uL)
#define GPIO_PMCSR8_PMCSR810                    (0x00000400uL)
#define GPIO_PMCSR8_PMCSR811                    (0x00000800uL)
#define GPIO_PMCSR8_PMCSR812                    (0x00001000uL)
#define GPIO_PMCSR8_PMCSR813                    (0x00002000uL)
#define GPIO_PMCSR8_PMCSR814                    (0x00004000uL)
#define GPIO_PMCSR8_PMCSR815                    (0x00008000uL)
#define GPIO_PMCSR8_PMCSR816                    (0x00010000uL)
#define GPIO_PMCSR8_PMCSR817                    (0x00020000uL)
#define GPIO_PMCSR8_PMCSR818                    (0x00040000uL)
#define GPIO_PMCSR8_PMCSR819                    (0x00080000uL)
#define GPIO_PMCSR8_PMCSR820                    (0x00100000uL)
#define GPIO_PMCSR8_PMCSR821                    (0x00200000uL)
#define GPIO_PMCSR8_PMCSR822                    (0x00400000uL)
#define GPIO_PMCSR8_PMCSR823                    (0x00800000uL)
#define GPIO_PMCSR8_PMCSR824                    (0x01000000uL)
#define GPIO_PMCSR8_PMCSR825                    (0x02000000uL)
#define GPIO_PMCSR8_PMCSR826                    (0x04000000uL)
#define GPIO_PMCSR8_PMCSR827                    (0x08000000uL)
#define GPIO_PMCSR8_PMCSR828                    (0x10000000uL)
#define GPIO_PMCSR8_PMCSR829                    (0x20000000uL)
#define GPIO_PMCSR8_PMCSR830                    (0x40000000uL)
#define GPIO_PMCSR8_PMCSR831                    (0x80000000uL)

#define GPIO_PFCAE8_PFCAE80                     (0x0001u)
#define GPIO_PFCAE8_PFCAE81                     (0x0002u)
#define GPIO_PFCAE8_PFCAE82                     (0x0004u)
#define GPIO_PFCAE8_PFCAE83                     (0x0008u)
#define GPIO_PFCAE8_PFCAE84                     (0x0010u)
#define GPIO_PFCAE8_PFCAE85                     (0x0020u)
#define GPIO_PFCAE8_PFCAE86                     (0x0040u)
#define GPIO_PFCAE8_PFCAE87                     (0x0080u)
#define GPIO_PFCAE8_PFCAE88                     (0x0100u)
#define GPIO_PFCAE8_PFCAE89                     (0x0200u)
#define GPIO_PFCAE8_PFCAE810                    (0x0400u)
#define GPIO_PFCAE8_PFCAE811                    (0x0800u)
#define GPIO_PFCAE8_PFCAE812                    (0x1000u)
#define GPIO_PFCAE8_PFCAE813                    (0x2000u)
#define GPIO_PFCAE8_PFCAE814                    (0x4000u)
#define GPIO_PFCAE8_PFCAE815                    (0x8000u)

#define GPIO_PIBC8_PIBC80                       (0x0001u)
#define GPIO_PIBC8_PIBC81                       (0x0002u)
#define GPIO_PIBC8_PIBC82                       (0x0004u)
#define GPIO_PIBC8_PIBC83                       (0x0008u)
#define GPIO_PIBC8_PIBC84                       (0x0010u)
#define GPIO_PIBC8_PIBC85                       (0x0020u)
#define GPIO_PIBC8_PIBC86                       (0x0040u)
#define GPIO_PIBC8_PIBC87                       (0x0080u)
#define GPIO_PIBC8_PIBC88                       (0x0100u)
#define GPIO_PIBC8_PIBC89                       (0x0200u)
#define GPIO_PIBC8_PIBC810                      (0x0400u)
#define GPIO_PIBC8_PIBC811                      (0x0800u)
#define GPIO_PIBC8_PIBC812                      (0x1000u)
#define GPIO_PIBC8_PIBC813                      (0x2000u)
#define GPIO_PIBC8_PIBC814                      (0x4000u)
#define GPIO_PIBC8_PIBC815                      (0x8000u)

#define GPIO_PBDC8_PBDC80                       (0x0001u)
#define GPIO_PBDC8_PBDC81                       (0x0002u)
#define GPIO_PBDC8_PBDC82                       (0x0004u)
#define GPIO_PBDC8_PBDC83                       (0x0008u)
#define GPIO_PBDC8_PBDC84                       (0x0010u)
#define GPIO_PBDC8_PBDC85                       (0x0020u)
#define GPIO_PBDC8_PBDC86                       (0x0040u)
#define GPIO_PBDC8_PBDC87                       (0x0080u)
#define GPIO_PBDC8_PBDC88                       (0x0100u)
#define GPIO_PBDC8_PBDC89                       (0x0200u)
#define GPIO_PBDC8_PBDC810                      (0x0400u)
#define GPIO_PBDC8_PBDC811                      (0x0800u)
#define GPIO_PBDC8_PBDC812                      (0x1000u)
#define GPIO_PBDC8_PBDC813                      (0x2000u)
#define GPIO_PBDC8_PBDC814                      (0x4000u)
#define GPIO_PBDC8_PBDC815                      (0x8000u)

#define GPIO_PIPC8_PIPC80                       (0x0001u)
#define GPIO_PIPC8_PIPC81                       (0x0002u)
#define GPIO_PIPC8_PIPC82                       (0x0004u)
#define GPIO_PIPC8_PIPC83                       (0x0008u)
#define GPIO_PIPC8_PIPC84                       (0x0010u)
#define GPIO_PIPC8_PIPC85                       (0x0020u)
#define GPIO_PIPC8_PIPC86                       (0x0040u)
#define GPIO_PIPC8_PIPC87                       (0x0080u)
#define GPIO_PIPC8_PIPC88                       (0x0100u)
#define GPIO_PIPC8_PIPC89                       (0x0200u)
#define GPIO_PIPC8_PIPC810                      (0x0400u)
#define GPIO_PIPC8_PIPC811                      (0x0800u)
#define GPIO_PIPC8_PIPC812                      (0x1000u)
#define GPIO_PIPC8_PIPC813                      (0x2000u)
#define GPIO_PIPC8_PIPC814                      (0x4000u)
#define GPIO_PIPC8_PIPC815                      (0x8000u)

/* ---- P9 ---- */
#define GPIO_P9_P90                             (0x0001u)
#define GPIO_P9_P91                             (0x0002u)
#define GPIO_P9_P92                             (0x0004u)
#define GPIO_P9_P93                             (0x0008u)
#define GPIO_P9_P94                             (0x0010u)
#define GPIO_P9_P95                             (0x0020u)
#define GPIO_P9_P96                             (0x0040u)
#define GPIO_P9_P97                             (0x0080u)

#define GPIO_PSR9_PSR90                         (0x00000001uL)
#define GPIO_PSR9_PSR91                         (0x00000002uL)
#define GPIO_PSR9_PSR92                         (0x00000004uL)
#define GPIO_PSR9_PSR93                         (0x00000008uL)
#define GPIO_PSR9_PSR94                         (0x00000010uL)
#define GPIO_PSR9_PSR95                         (0x00000020uL)
#define GPIO_PSR9_PSR96                         (0x00000040uL)
#define GPIO_PSR9_PSR97                         (0x00000080uL)
#define GPIO_PSR9_PSR916                        (0x00010000uL)
#define GPIO_PSR9_PSR917                        (0x00020000uL)
#define GPIO_PSR9_PSR918                        (0x00040000uL)
#define GPIO_PSR9_PSR919                        (0x00080000uL)
#define GPIO_PSR9_PSR920                        (0x00100000uL)
#define GPIO_PSR9_PSR921                        (0x00200000uL)
#define GPIO_PSR9_PSR922                        (0x00400000uL)
#define GPIO_PSR9_PSR923                        (0x00800000uL)

#define GPIO_PPR9_PPR90                         (0x0001u)
#define GPIO_PPR9_PPR91                         (0x0002u)
#define GPIO_PPR9_PPR92                         (0x0004u)
#define GPIO_PPR9_PPR93                         (0x0008u)
#define GPIO_PPR9_PPR94                         (0x0010u)
#define GPIO_PPR9_PPR95                         (0x0020u)
#define GPIO_PPR9_PPR96                         (0x0040u)
#define GPIO_PPR9_PPR97                         (0x0080u)

#define GPIO_PM9_PM90                           (0x0001u)
#define GPIO_PM9_PM91                           (0x0002u)
#define GPIO_PM9_PM92                           (0x0004u)
#define GPIO_PM9_PM93                           (0x0008u)
#define GPIO_PM9_PM94                           (0x0010u)
#define GPIO_PM9_PM95                           (0x0020u)
#define GPIO_PM9_PM96                           (0x0040u)
#define GPIO_PM9_PM97                           (0x0080u)

#define GPIO_PMC9_PMC90                         (0x0001u)
#define GPIO_PMC9_PMC91                         (0x0002u)
#define GPIO_PMC9_PMC92                         (0x0004u)
#define GPIO_PMC9_PMC93                         (0x0008u)
#define GPIO_PMC9_PMC94                         (0x0010u)
#define GPIO_PMC9_PMC95                         (0x0020u)
#define GPIO_PMC9_PMC96                         (0x0040u)
#define GPIO_PMC9_PMC97                         (0x0080u)

#define GPIO_PFC9_PFC90                         (0x0001u)
#define GPIO_PFC9_PFC91                         (0x0002u)
#define GPIO_PFC9_PFC92                         (0x0004u)
#define GPIO_PFC9_PFC93                         (0x0008u)
#define GPIO_PFC9_PFC94                         (0x0010u)
#define GPIO_PFC9_PFC95                         (0x0020u)
#define GPIO_PFC9_PFC96                         (0x0040u)
#define GPIO_PFC9_PFC97                         (0x0080u)

#define GPIO_PFCE9_PFCE90                       (0x0001u)
#define GPIO_PFCE9_PFCE91                       (0x0002u)
#define GPIO_PFCE9_PFCE92                       (0x0004u)
#define GPIO_PFCE9_PFCE93                       (0x0008u)
#define GPIO_PFCE9_PFCE94                       (0x0010u)
#define GPIO_PFCE9_PFCE95                       (0x0020u)
#define GPIO_PFCE9_PFCE96                       (0x0040u)
#define GPIO_PFCE9_PFCE97                       (0x0080u)

#define GPIO_PNOT9_PNOT90                       (0x0001u)
#define GPIO_PNOT9_PNOT91                       (0x0002u)
#define GPIO_PNOT9_PNOT92                       (0x0004u)
#define GPIO_PNOT9_PNOT93                       (0x0008u)
#define GPIO_PNOT9_PNOT94                       (0x0010u)
#define GPIO_PNOT9_PNOT95                       (0x0020u)
#define GPIO_PNOT9_PNOT96                       (0x0040u)
#define GPIO_PNOT9_PNOT97                       (0x0080u)

#define GPIO_PMSR9_PMSR90                       (0x00000001uL)
#define GPIO_PMSR9_PMSR91                       (0x00000002uL)
#define GPIO_PMSR9_PMSR92                       (0x00000004uL)
#define GPIO_PMSR9_PMSR93                       (0x00000008uL)
#define GPIO_PMSR9_PMSR94                       (0x00000010uL)
#define GPIO_PMSR9_PMSR95                       (0x00000020uL)
#define GPIO_PMSR9_PMSR96                       (0x00000040uL)
#define GPIO_PMSR9_PMSR97                       (0x00000080uL)
#define GPIO_PMSR9_PMSR916                      (0x00010000uL)
#define GPIO_PMSR9_PMSR917                      (0x00020000uL)
#define GPIO_PMSR9_PMSR918                      (0x00040000uL)
#define GPIO_PMSR9_PMSR919                      (0x00080000uL)
#define GPIO_PMSR9_PMSR920                      (0x00100000uL)
#define GPIO_PMSR9_PMSR921                      (0x00200000uL)
#define GPIO_PMSR9_PMSR922                      (0x00400000uL)
#define GPIO_PMSR9_PMSR923                      (0x00800000uL)

#define GPIO_PMCSR9_PMCSR90                     (0x00000001uL)
#define GPIO_PMCSR9_PMCSR91                     (0x00000002uL)
#define GPIO_PMCSR9_PMCSR92                     (0x00000004uL)
#define GPIO_PMCSR9_PMCSR93                     (0x00000008uL)
#define GPIO_PMCSR9_PMCSR94                     (0x00000010uL)
#define GPIO_PMCSR9_PMCSR95                     (0x00000020uL)
#define GPIO_PMCSR9_PMCSR96                     (0x00000040uL)
#define GPIO_PMCSR9_PMCSR97                     (0x00000080uL)
#define GPIO_PMCSR9_PMCSR916                    (0x00010000uL)
#define GPIO_PMCSR9_PMCSR917                    (0x00020000uL)
#define GPIO_PMCSR9_PMCSR918                    (0x00040000uL)
#define GPIO_PMCSR9_PMCSR919                    (0x00080000uL)
#define GPIO_PMCSR9_PMCSR920                    (0x00100000uL)
#define GPIO_PMCSR9_PMCSR921                    (0x00200000uL)
#define GPIO_PMCSR9_PMCSR922                    (0x00400000uL)
#define GPIO_PMCSR9_PMCSR923                    (0x00800000uL)

#define GPIO_PFCAE9_PFCAE90                     (0x0001u)
#define GPIO_PFCAE9_PFCAE91                     (0x0002u)
#define GPIO_PFCAE9_PFCAE92                     (0x0004u)
#define GPIO_PFCAE9_PFCAE93                     (0x0008u)
#define GPIO_PFCAE9_PFCAE94                     (0x0010u)
#define GPIO_PFCAE9_PFCAE95                     (0x0020u)
#define GPIO_PFCAE9_PFCAE96                     (0x0040u)
#define GPIO_PFCAE9_PFCAE97                     (0x0080u)

#define GPIO_PIBC9_PIBC90                       (0x0001u)
#define GPIO_PIBC9_PIBC91                       (0x0002u)
#define GPIO_PIBC9_PIBC92                       (0x0004u)
#define GPIO_PIBC9_PIBC93                       (0x0008u)
#define GPIO_PIBC9_PIBC94                       (0x0010u)
#define GPIO_PIBC9_PIBC95                       (0x0020u)
#define GPIO_PIBC9_PIBC96                       (0x0040u)
#define GPIO_PIBC9_PIBC97                       (0x0080u)

#define GPIO_PBDC9_PBDC90                       (0x0001u)
#define GPIO_PBDC9_PBDC91                       (0x0002u)
#define GPIO_PBDC9_PBDC92                       (0x0004u)
#define GPIO_PBDC9_PBDC93                       (0x0008u)
#define GPIO_PBDC9_PBDC94                       (0x0010u)
#define GPIO_PBDC9_PBDC95                       (0x0020u)
#define GPIO_PBDC9_PBDC96                       (0x0040u)
#define GPIO_PBDC9_PBDC97                       (0x0080u)

#define GPIO_PIPC9_PIPC90                       (0x0001u)
#define GPIO_PIPC9_PIPC91                       (0x0002u)
#define GPIO_PIPC9_PIPC92                       (0x0004u)
#define GPIO_PIPC9_PIPC93                       (0x0008u)
#define GPIO_PIPC9_PIPC94                       (0x0010u)
#define GPIO_PIPC9_PIPC95                       (0x0020u)
#define GPIO_PIPC9_PIPC96                       (0x0040u)
#define GPIO_PIPC9_PIPC97                       (0x0080u)

/* ---- P10 ---- */
#define GPIO_P10_P100                           (0x0001u)
#define GPIO_P10_P101                           (0x0002u)
#define GPIO_P10_P102                           (0x0004u)
#define GPIO_P10_P103                           (0x0008u)
#define GPIO_P10_P104                           (0x0010u)
#define GPIO_P10_P105                           (0x0020u)
#define GPIO_P10_P106                           (0x0040u)
#define GPIO_P10_P107                           (0x0080u)
#define GPIO_P10_P108                           (0x0100u)
#define GPIO_P10_P109                           (0x0200u)
#define GPIO_P10_P1010                          (0x0400u)
#define GPIO_P10_P1011                          (0x0800u)
#define GPIO_P10_P1012                          (0x1000u)
#define GPIO_P10_P1013                          (0x2000u)
#define GPIO_P10_P1014                          (0x4000u)
#define GPIO_P10_P1015                          (0x8000u)

#define GPIO_PSR10_PSR100                       (0x00000001uL)
#define GPIO_PSR10_PSR101                       (0x00000002uL)
#define GPIO_PSR10_PSR102                       (0x00000004uL)
#define GPIO_PSR10_PSR103                       (0x00000008uL)
#define GPIO_PSR10_PSR104                       (0x00000010uL)
#define GPIO_PSR10_PSR105                       (0x00000020uL)
#define GPIO_PSR10_PSR106                       (0x00000040uL)
#define GPIO_PSR10_PSR107                       (0x00000080uL)
#define GPIO_PSR10_PSR108                       (0x00000100uL)
#define GPIO_PSR10_PSR109                       (0x00000200uL)
#define GPIO_PSR10_PSR1010                      (0x00000400uL)
#define GPIO_PSR10_PSR1011                      (0x00000800uL)
#define GPIO_PSR10_PSR1012                      (0x00001000uL)
#define GPIO_PSR10_PSR1013                      (0x00002000uL)
#define GPIO_PSR10_PSR1014                      (0x00004000uL)
#define GPIO_PSR10_PSR1015                      (0x00008000uL)
#define GPIO_PSR10_PSR1016                      (0x00010000uL)
#define GPIO_PSR10_PSR1017                      (0x00020000uL)
#define GPIO_PSR10_PSR1018                      (0x00040000uL)
#define GPIO_PSR10_PSR1019                      (0x00080000uL)
#define GPIO_PSR10_PSR1020                      (0x00100000uL)
#define GPIO_PSR10_PSR1021                      (0x00200000uL)
#define GPIO_PSR10_PSR1022                      (0x00400000uL)
#define GPIO_PSR10_PSR1023                      (0x00800000uL)
#define GPIO_PSR10_PSR1024                      (0x01000000uL)
#define GPIO_PSR10_PSR1025                      (0x02000000uL)
#define GPIO_PSR10_PSR1026                      (0x04000000uL)
#define GPIO_PSR10_PSR1027                      (0x08000000uL)
#define GPIO_PSR10_PSR1028                      (0x10000000uL)
#define GPIO_PSR10_PSR1029                      (0x20000000uL)
#define GPIO_PSR10_PSR1030                      (0x40000000uL)
#define GPIO_PSR10_PSR1031                      (0x80000000uL)

#define GPIO_PPR10_PPR100                       (0x0001u)
#define GPIO_PPR10_PPR101                       (0x0002u)
#define GPIO_PPR10_PPR102                       (0x0004u)
#define GPIO_PPR10_PPR103                       (0x0008u)
#define GPIO_PPR10_PPR104                       (0x0010u)
#define GPIO_PPR10_PPR105                       (0x0020u)
#define GPIO_PPR10_PPR106                       (0x0040u)
#define GPIO_PPR10_PPR107                       (0x0080u)
#define GPIO_PPR10_PPR108                       (0x0100u)
#define GPIO_PPR10_PPR109                       (0x0200u)
#define GPIO_PPR10_PPR1010                      (0x0400u)
#define GPIO_PPR10_PPR1011                      (0x0800u)
#define GPIO_PPR10_PPR1012                      (0x1000u)
#define GPIO_PPR10_PPR1013                      (0x2000u)
#define GPIO_PPR10_PPR1014                      (0x4000u)
#define GPIO_PPR10_PPR1015                      (0x8000u)

#define GPIO_PM10_PM100                         (0x0001u)
#define GPIO_PM10_PM101                         (0x0002u)
#define GPIO_PM10_PM102                         (0x0004u)
#define GPIO_PM10_PM103                         (0x0008u)
#define GPIO_PM10_PM104                         (0x0010u)
#define GPIO_PM10_PM105                         (0x0020u)
#define GPIO_PM10_PM106                         (0x0040u)
#define GPIO_PM10_PM107                         (0x0080u)
#define GPIO_PM10_PM108                         (0x0100u)
#define GPIO_PM10_PM109                         (0x0200u)
#define GPIO_PM10_PM1010                        (0x0400u)
#define GPIO_PM10_PM1011                        (0x0800u)
#define GPIO_PM10_PM1012                        (0x1000u)
#define GPIO_PM10_PM1013                        (0x2000u)
#define GPIO_PM10_PM1014                        (0x4000u)
#define GPIO_PM10_PM1015                        (0x8000u)

#define GPIO_PMC10_PMC100                       (0x0001u)
#define GPIO_PMC10_PMC101                       (0x0002u)
#define GPIO_PMC10_PMC102                       (0x0004u)
#define GPIO_PMC10_PMC103                       (0x0008u)
#define GPIO_PMC10_PMC104                       (0x0010u)
#define GPIO_PMC10_PMC105                       (0x0020u)
#define GPIO_PMC10_PMC106                       (0x0040u)
#define GPIO_PMC10_PMC107                       (0x0080u)
#define GPIO_PMC10_PMC108                       (0x0100u)
#define GPIO_PMC10_PMC109                       (0x0200u)
#define GPIO_PMC10_PMC1010                      (0x0400u)
#define GPIO_PMC10_PMC1011                      (0x0800u)
#define GPIO_PMC10_PMC1012                      (0x1000u)
#define GPIO_PMC10_PMC1013                      (0x2000u)
#define GPIO_PMC10_PMC1014                      (0x4000u)
#define GPIO_PMC10_PMC1015                      (0x8000u)

#define GPIO_PFC10_PFC100                       (0x0001u)
#define GPIO_PFC10_PFC101                       (0x0002u)
#define GPIO_PFC10_PFC102                       (0x0004u)
#define GPIO_PFC10_PFC103                       (0x0008u)
#define GPIO_PFC10_PFC104                       (0x0010u)
#define GPIO_PFC10_PFC105                       (0x0020u)
#define GPIO_PFC10_PFC106                       (0x0040u)
#define GPIO_PFC10_PFC107                       (0x0080u)
#define GPIO_PFC10_PFC108                       (0x0100u)
#define GPIO_PFC10_PFC109                       (0x0200u)
#define GPIO_PFC10_PFC1010                      (0x0400u)
#define GPIO_PFC10_PFC1011                      (0x0800u)
#define GPIO_PFC10_PFC1012                      (0x1000u)
#define GPIO_PFC10_PFC1013                      (0x2000u)
#define GPIO_PFC10_PFC1014                      (0x4000u)
#define GPIO_PFC10_PFC1015                      (0x8000u)

#define GPIO_PFCE10_PFCE100                     (0x0001u)
#define GPIO_PFCE10_PFCE101                     (0x0002u)
#define GPIO_PFCE10_PFCE102                     (0x0004u)
#define GPIO_PFCE10_PFCE103                     (0x0008u)
#define GPIO_PFCE10_PFCE104                     (0x0010u)
#define GPIO_PFCE10_PFCE105                     (0x0020u)
#define GPIO_PFCE10_PFCE106                     (0x0040u)
#define GPIO_PFCE10_PFCE107                     (0x0080u)
#define GPIO_PFCE10_PFCE108                     (0x0100u)
#define GPIO_PFCE10_PFCE109                     (0x0200u)
#define GPIO_PFCE10_PFCE1010                    (0x0400u)
#define GPIO_PFCE10_PFCE1011                    (0x0800u)
#define GPIO_PFCE10_PFCE1012                    (0x1000u)
#define GPIO_PFCE10_PFCE1013                    (0x2000u)
#define GPIO_PFCE10_PFCE1014                    (0x4000u)
#define GPIO_PFCE10_PFCE1015                    (0x8000u)

#define GPIO_PNOT10_PNOT100                     (0x0001u)
#define GPIO_PNOT10_PNOT101                     (0x0002u)
#define GPIO_PNOT10_PNOT102                     (0x0004u)
#define GPIO_PNOT10_PNOT103                     (0x0008u)
#define GPIO_PNOT10_PNOT104                     (0x0010u)
#define GPIO_PNOT10_PNOT105                     (0x0020u)
#define GPIO_PNOT10_PNOT106                     (0x0040u)
#define GPIO_PNOT10_PNOT107                     (0x0080u)
#define GPIO_PNOT10_PNOT108                     (0x0100u)
#define GPIO_PNOT10_PNOT109                     (0x0200u)
#define GPIO_PNOT10_PNOT1010                    (0x0400u)
#define GPIO_PNOT10_PNOT1011                    (0x0800u)
#define GPIO_PNOT10_PNOT1012                    (0x1000u)
#define GPIO_PNOT10_PNOT1013                    (0x2000u)
#define GPIO_PNOT10_PNOT1014                    (0x4000u)
#define GPIO_PNOT10_PNOT1015                    (0x8000u)

#define GPIO_PMSR10_PMSR100                     (0x00000001uL)
#define GPIO_PMSR10_PMSR101                     (0x00000002uL)
#define GPIO_PMSR10_PMSR102                     (0x00000004uL)
#define GPIO_PMSR10_PMSR103                     (0x00000008uL)
#define GPIO_PMSR10_PMSR104                     (0x00000010uL)
#define GPIO_PMSR10_PMSR105                     (0x00000020uL)
#define GPIO_PMSR10_PMSR106                     (0x00000040uL)
#define GPIO_PMSR10_PMSR107                     (0x00000080uL)
#define GPIO_PMSR10_PMSR108                     (0x00000100uL)
#define GPIO_PMSR10_PMSR109                     (0x00000200uL)
#define GPIO_PMSR10_PMSR1010                    (0x00000400uL)
#define GPIO_PMSR10_PMSR1011                    (0x00000800uL)
#define GPIO_PMSR10_PMSR1012                    (0x00001000uL)
#define GPIO_PMSR10_PMSR1013                    (0x00002000uL)
#define GPIO_PMSR10_PMSR1014                    (0x00004000uL)
#define GPIO_PMSR10_PMSR1015                    (0x00008000uL)
#define GPIO_PMSR10_PMSR1016                    (0x00010000uL)
#define GPIO_PMSR10_PMSR1017                    (0x00020000uL)
#define GPIO_PMSR10_PMSR1018                    (0x00040000uL)
#define GPIO_PMSR10_PMSR1019                    (0x00080000uL)
#define GPIO_PMSR10_PMSR1020                    (0x00100000uL)
#define GPIO_PMSR10_PMSR1021                    (0x00200000uL)
#define GPIO_PMSR10_PMSR1022                    (0x00400000uL)
#define GPIO_PMSR10_PMSR1023                    (0x00800000uL)
#define GPIO_PMSR10_PMSR1024                    (0x01000000uL)
#define GPIO_PMSR10_PMSR1025                    (0x02000000uL)
#define GPIO_PMSR10_PMSR1026                    (0x04000000uL)
#define GPIO_PMSR10_PMSR1027                    (0x08000000uL)
#define GPIO_PMSR10_PMSR1028                    (0x10000000uL)
#define GPIO_PMSR10_PMSR1029                    (0x20000000uL)
#define GPIO_PMSR10_PMSR1030                    (0x40000000uL)
#define GPIO_PMSR10_PMSR1031                    (0x80000000uL)

#define GPIO_PMCSR10_PMCSR100                   (0x00000001uL)
#define GPIO_PMCSR10_PMCSR101                   (0x00000002uL)
#define GPIO_PMCSR10_PMCSR102                   (0x00000004uL)
#define GPIO_PMCSR10_PMCSR103                   (0x00000008uL)
#define GPIO_PMCSR10_PMCSR104                   (0x00000010uL)
#define GPIO_PMCSR10_PMCSR105                   (0x00000020uL)
#define GPIO_PMCSR10_PMCSR106                   (0x00000040uL)
#define GPIO_PMCSR10_PMCSR107                   (0x00000080uL)
#define GPIO_PMCSR10_PMCSR108                   (0x00000100uL)
#define GPIO_PMCSR10_PMCSR109                   (0x00000200uL)
#define GPIO_PMCSR10_PMCSR1010                  (0x00000400uL)
#define GPIO_PMCSR10_PMCSR1011                  (0x00000800uL)
#define GPIO_PMCSR10_PMCSR1012                  (0x00001000uL)
#define GPIO_PMCSR10_PMCSR1013                  (0x00002000uL)
#define GPIO_PMCSR10_PMCSR1014                  (0x00004000uL)
#define GPIO_PMCSR10_PMCSR1015                  (0x00008000uL)
#define GPIO_PMCSR10_PMCSR1016                  (0x00010000uL)
#define GPIO_PMCSR10_PMCSR1017                  (0x00020000uL)
#define GPIO_PMCSR10_PMCSR1018                  (0x00040000uL)
#define GPIO_PMCSR10_PMCSR1019                  (0x00080000uL)
#define GPIO_PMCSR10_PMCSR1020                  (0x00100000uL)
#define GPIO_PMCSR10_PMCSR1021                  (0x00200000uL)
#define GPIO_PMCSR10_PMCSR1022                  (0x00400000uL)
#define GPIO_PMCSR10_PMCSR1023                  (0x00800000uL)
#define GPIO_PMCSR10_PMCSR1024                  (0x01000000uL)
#define GPIO_PMCSR10_PMCSR1025                  (0x02000000uL)
#define GPIO_PMCSR10_PMCSR1026                  (0x04000000uL)
#define GPIO_PMCSR10_PMCSR1027                  (0x08000000uL)
#define GPIO_PMCSR10_PMCSR1028                  (0x10000000uL)
#define GPIO_PMCSR10_PMCSR1029                  (0x20000000uL)
#define GPIO_PMCSR10_PMCSR1030                  (0x40000000uL)
#define GPIO_PMCSR10_PMCSR1031                  (0x80000000uL)

#define GPIO_PFCAE10_PFCAE100                   (0x0001u)
#define GPIO_PFCAE10_PFCAE101                   (0x0002u)
#define GPIO_PFCAE10_PFCAE102                   (0x0004u)
#define GPIO_PFCAE10_PFCAE103                   (0x0008u)
#define GPIO_PFCAE10_PFCAE104                   (0x0010u)
#define GPIO_PFCAE10_PFCAE105                   (0x0020u)
#define GPIO_PFCAE10_PFCAE106                   (0x0040u)
#define GPIO_PFCAE10_PFCAE107                   (0x0080u)
#define GPIO_PFCAE10_PFCAE108                   (0x0100u)
#define GPIO_PFCAE10_PFCAE109                   (0x0200u)
#define GPIO_PFCAE10_PFCAE1010                  (0x0400u)
#define GPIO_PFCAE10_PFCAE1011                  (0x0800u)
#define GPIO_PFCAE10_PFCAE1012                  (0x1000u)
#define GPIO_PFCAE10_PFCAE1013                  (0x2000u)
#define GPIO_PFCAE10_PFCAE1014                  (0x4000u)
#define GPIO_PFCAE10_PFCAE1015                  (0x8000u)

#define GPIO_PIBC10_PIBC100                     (0x0001u)
#define GPIO_PIBC10_PIBC101                     (0x0002u)
#define GPIO_PIBC10_PIBC102                     (0x0004u)
#define GPIO_PIBC10_PIBC103                     (0x0008u)
#define GPIO_PIBC10_PIBC104                     (0x0010u)
#define GPIO_PIBC10_PIBC105                     (0x0020u)
#define GPIO_PIBC10_PIBC106                     (0x0040u)
#define GPIO_PIBC10_PIBC107                     (0x0080u)
#define GPIO_PIBC10_PIBC108                     (0x0100u)
#define GPIO_PIBC10_PIBC109                     (0x0200u)
#define GPIO_PIBC10_PIBC1010                    (0x0400u)
#define GPIO_PIBC10_PIBC1011                    (0x0800u)
#define GPIO_PIBC10_PIBC1012                    (0x1000u)
#define GPIO_PIBC10_PIBC1013                    (0x2000u)
#define GPIO_PIBC10_PIBC1014                    (0x4000u)
#define GPIO_PIBC10_PIBC1015                    (0x8000u)

#define GPIO_PBDC10_PBDC100                     (0x0001u)
#define GPIO_PBDC10_PBDC101                     (0x0002u)
#define GPIO_PBDC10_PBDC102                     (0x0004u)
#define GPIO_PBDC10_PBDC103                     (0x0008u)
#define GPIO_PBDC10_PBDC104                     (0x0010u)
#define GPIO_PBDC10_PBDC105                     (0x0020u)
#define GPIO_PBDC10_PBDC106                     (0x0040u)
#define GPIO_PBDC10_PBDC107                     (0x0080u)
#define GPIO_PBDC10_PBDC108                     (0x0100u)
#define GPIO_PBDC10_PBDC109                     (0x0200u)
#define GPIO_PBDC10_PBDC1010                    (0x0400u)
#define GPIO_PBDC10_PBDC1011                    (0x0800u)
#define GPIO_PBDC10_PBDC1012                    (0x1000u)
#define GPIO_PBDC10_PBDC1013                    (0x2000u)
#define GPIO_PBDC10_PBDC1014                    (0x4000u)
#define GPIO_PBDC10_PBDC1015                    (0x8000u)

#define GPIO_PIPC10_PIPC100                     (0x0001u)
#define GPIO_PIPC10_PIPC101                     (0x0002u)
#define GPIO_PIPC10_PIPC102                     (0x0004u)
#define GPIO_PIPC10_PIPC103                     (0x0008u)
#define GPIO_PIPC10_PIPC104                     (0x0010u)
#define GPIO_PIPC10_PIPC105                     (0x0020u)
#define GPIO_PIPC10_PIPC106                     (0x0040u)
#define GPIO_PIPC10_PIPC107                     (0x0080u)
#define GPIO_PIPC10_PIPC108                     (0x0100u)
#define GPIO_PIPC10_PIPC109                     (0x0200u)
#define GPIO_PIPC10_PIPC1010                    (0x0400u)
#define GPIO_PIPC10_PIPC1011                    (0x0800u)
#define GPIO_PIPC10_PIPC1012                    (0x1000u)
#define GPIO_PIPC10_PIPC1013                    (0x2000u)
#define GPIO_PIPC10_PIPC1014                    (0x4000u)
#define GPIO_PIPC10_PIPC1015                    (0x8000u)

/* ---- P11 ---- */
#define GPIO_P11_P110                           (0x0001u)
#define GPIO_P11_P111                           (0x0002u)
#define GPIO_P11_P112                           (0x0004u)
#define GPIO_P11_P113                           (0x0008u)
#define GPIO_P11_P114                           (0x0010u)
#define GPIO_P11_P115                           (0x0020u)
#define GPIO_P11_P116                           (0x0040u)
#define GPIO_P11_P117                           (0x0080u)
#define GPIO_P11_P118                           (0x0100u)
#define GPIO_P11_P119                           (0x0200u)
#define GPIO_P11_P1110                          (0x0400u)
#define GPIO_P11_P1111                          (0x0800u)
#define GPIO_P11_P1112                          (0x1000u)
#define GPIO_P11_P1113                          (0x2000u)
#define GPIO_P11_P1114                          (0x4000u)
#define GPIO_P11_P1115                          (0x8000u)

#define GPIO_PSR11_PSR110                       (0x00000001uL)
#define GPIO_PSR11_PSR111                       (0x00000002uL)
#define GPIO_PSR11_PSR112                       (0x00000004uL)
#define GPIO_PSR11_PSR113                       (0x00000008uL)
#define GPIO_PSR11_PSR114                       (0x00000010uL)
#define GPIO_PSR11_PSR115                       (0x00000020uL)
#define GPIO_PSR11_PSR116                       (0x00000040uL)
#define GPIO_PSR11_PSR117                       (0x00000080uL)
#define GPIO_PSR11_PSR118                       (0x00000100uL)
#define GPIO_PSR11_PSR119                       (0x00000200uL)
#define GPIO_PSR11_PSR1110                      (0x00000400uL)
#define GPIO_PSR11_PSR1111                      (0x00000800uL)
#define GPIO_PSR11_PSR1112                      (0x00001000uL)
#define GPIO_PSR11_PSR1113                      (0x00002000uL)
#define GPIO_PSR11_PSR1114                      (0x00004000uL)
#define GPIO_PSR11_PSR1115                      (0x00008000uL)
#define GPIO_PSR11_PSR1116                      (0x00010000uL)
#define GPIO_PSR11_PSR1117                      (0x00020000uL)
#define GPIO_PSR11_PSR1118                      (0x00040000uL)
#define GPIO_PSR11_PSR1119                      (0x00080000uL)
#define GPIO_PSR11_PSR1120                      (0x00100000uL)
#define GPIO_PSR11_PSR1121                      (0x00200000uL)
#define GPIO_PSR11_PSR1122                      (0x00400000uL)
#define GPIO_PSR11_PSR1123                      (0x00800000uL)
#define GPIO_PSR11_PSR1124                      (0x01000000uL)
#define GPIO_PSR11_PSR1125                      (0x02000000uL)
#define GPIO_PSR11_PSR1126                      (0x04000000uL)
#define GPIO_PSR11_PSR1127                      (0x08000000uL)
#define GPIO_PSR11_PSR1128                      (0x10000000uL)
#define GPIO_PSR11_PSR1129                      (0x20000000uL)
#define GPIO_PSR11_PSR1130                      (0x40000000uL)
#define GPIO_PSR11_PSR1131                      (0x80000000uL)

#define GPIO_PPR11_PPR110                       (0x0001u)
#define GPIO_PPR11_PPR111                       (0x0002u)
#define GPIO_PPR11_PPR112                       (0x0004u)
#define GPIO_PPR11_PPR113                       (0x0008u)
#define GPIO_PPR11_PPR114                       (0x0010u)
#define GPIO_PPR11_PPR115                       (0x0020u)
#define GPIO_PPR11_PPR116                       (0x0040u)
#define GPIO_PPR11_PPR117                       (0x0080u)
#define GPIO_PPR11_PPR118                       (0x0100u)
#define GPIO_PPR11_PPR119                       (0x0200u)
#define GPIO_PPR11_PPR1110                      (0x0400u)
#define GPIO_PPR11_PPR1111                      (0x0800u)
#define GPIO_PPR11_PPR1112                      (0x1000u)
#define GPIO_PPR11_PPR1113                      (0x2000u)
#define GPIO_PPR11_PPR1114                      (0x4000u)
#define GPIO_PPR11_PPR1115                      (0x8000u)

#define GPIO_PM11_PM110                         (0x0001u)
#define GPIO_PM11_PM111                         (0x0002u)
#define GPIO_PM11_PM112                         (0x0004u)
#define GPIO_PM11_PM113                         (0x0008u)
#define GPIO_PM11_PM114                         (0x0010u)
#define GPIO_PM11_PM115                         (0x0020u)
#define GPIO_PM11_PM116                         (0x0040u)
#define GPIO_PM11_PM117                         (0x0080u)
#define GPIO_PM11_PM118                         (0x0100u)
#define GPIO_PM11_PM119                         (0x0200u)
#define GPIO_PM11_PM1110                        (0x0400u)
#define GPIO_PM11_PM1111                        (0x0800u)
#define GPIO_PM11_PM1112                        (0x1000u)
#define GPIO_PM11_PM1113                        (0x2000u)
#define GPIO_PM11_PM1114                        (0x4000u)
#define GPIO_PM11_PM1115                        (0x8000u)

#define GPIO_PMC11_PMC110                       (0x0001u)
#define GPIO_PMC11_PMC111                       (0x0002u)
#define GPIO_PMC11_PMC112                       (0x0004u)
#define GPIO_PMC11_PMC113                       (0x0008u)
#define GPIO_PMC11_PMC114                       (0x0010u)
#define GPIO_PMC11_PMC115                       (0x0020u)
#define GPIO_PMC11_PMC116                       (0x0040u)
#define GPIO_PMC11_PMC117                       (0x0080u)
#define GPIO_PMC11_PMC118                       (0x0100u)
#define GPIO_PMC11_PMC119                       (0x0200u)
#define GPIO_PMC11_PMC1110                      (0x0400u)
#define GPIO_PMC11_PMC1111                      (0x0800u)
#define GPIO_PMC11_PMC1112                      (0x1000u)
#define GPIO_PMC11_PMC1113                      (0x2000u)
#define GPIO_PMC11_PMC1114                      (0x4000u)
#define GPIO_PMC11_PMC1115                      (0x8000u)

#define GPIO_PFC11_PFC110                       (0x0001u)
#define GPIO_PFC11_PFC111                       (0x0002u)
#define GPIO_PFC11_PFC112                       (0x0004u)
#define GPIO_PFC11_PFC113                       (0x0008u)
#define GPIO_PFC11_PFC114                       (0x0010u)
#define GPIO_PFC11_PFC115                       (0x0020u)
#define GPIO_PFC11_PFC116                       (0x0040u)
#define GPIO_PFC11_PFC117                       (0x0080u)
#define GPIO_PFC11_PFC118                       (0x0100u)
#define GPIO_PFC11_PFC119                       (0x0200u)
#define GPIO_PFC11_PFC1110                      (0x0400u)
#define GPIO_PFC11_PFC1111                      (0x0800u)
#define GPIO_PFC11_PFC1112                      (0x1000u)
#define GPIO_PFC11_PFC1113                      (0x2000u)
#define GPIO_PFC11_PFC1114                      (0x4000u)
#define GPIO_PFC11_PFC1115                      (0x8000u)

#define GPIO_PFCE11_PFCE110                     (0x0001u)
#define GPIO_PFCE11_PFCE111                     (0x0002u)
#define GPIO_PFCE11_PFCE112                     (0x0004u)
#define GPIO_PFCE11_PFCE113                     (0x0008u)
#define GPIO_PFCE11_PFCE114                     (0x0010u)
#define GPIO_PFCE11_PFCE115                     (0x0020u)
#define GPIO_PFCE11_PFCE116                     (0x0040u)
#define GPIO_PFCE11_PFCE117                     (0x0080u)
#define GPIO_PFCE11_PFCE118                     (0x0100u)
#define GPIO_PFCE11_PFCE119                     (0x0200u)
#define GPIO_PFCE11_PFCE1110                    (0x0400u)
#define GPIO_PFCE11_PFCE1111                    (0x0800u)
#define GPIO_PFCE11_PFCE1112                    (0x1000u)
#define GPIO_PFCE11_PFCE1113                    (0x2000u)
#define GPIO_PFCE11_PFCE1114                    (0x4000u)
#define GPIO_PFCE11_PFCE1115                    (0x8000u)

#define GPIO_PNOT11_PNOT110                     (0x0001u)
#define GPIO_PNOT11_PNOT111                     (0x0002u)
#define GPIO_PNOT11_PNOT112                     (0x0004u)
#define GPIO_PNOT11_PNOT113                     (0x0008u)
#define GPIO_PNOT11_PNOT114                     (0x0010u)
#define GPIO_PNOT11_PNOT115                     (0x0020u)
#define GPIO_PNOT11_PNOT116                     (0x0040u)
#define GPIO_PNOT11_PNOT117                     (0x0080u)
#define GPIO_PNOT11_PNOT118                     (0x0100u)
#define GPIO_PNOT11_PNOT119                     (0x0200u)
#define GPIO_PNOT11_PNOT1110                    (0x0400u)
#define GPIO_PNOT11_PNOT1111                    (0x0800u)
#define GPIO_PNOT11_PNOT1112                    (0x1000u)
#define GPIO_PNOT11_PNOT1113                    (0x2000u)
#define GPIO_PNOT11_PNOT1114                    (0x4000u)
#define GPIO_PNOT11_PNOT1115                    (0x8000u)

#define GPIO_PMSR11_PMSR110                     (0x00000001uL)
#define GPIO_PMSR11_PMSR111                     (0x00000002uL)
#define GPIO_PMSR11_PMSR112                     (0x00000004uL)
#define GPIO_PMSR11_PMSR113                     (0x00000008uL)
#define GPIO_PMSR11_PMSR114                     (0x00000010uL)
#define GPIO_PMSR11_PMSR115                     (0x00000020uL)
#define GPIO_PMSR11_PMSR116                     (0x00000040uL)
#define GPIO_PMSR11_PMSR117                     (0x00000080uL)
#define GPIO_PMSR11_PMSR118                     (0x00000100uL)
#define GPIO_PMSR11_PMSR119                     (0x00000200uL)
#define GPIO_PMSR11_PMSR1110                    (0x00000400uL)
#define GPIO_PMSR11_PMSR1111                    (0x00000800uL)
#define GPIO_PMSR11_PMSR1112                    (0x00001000uL)
#define GPIO_PMSR11_PMSR1113                    (0x00002000uL)
#define GPIO_PMSR11_PMSR1114                    (0x00004000uL)
#define GPIO_PMSR11_PMSR1115                    (0x00008000uL)
#define GPIO_PMSR11_PMSR1116                    (0x00010000uL)
#define GPIO_PMSR11_PMSR1117                    (0x00020000uL)
#define GPIO_PMSR11_PMSR1118                    (0x00040000uL)
#define GPIO_PMSR11_PMSR1119                    (0x00080000uL)
#define GPIO_PMSR11_PMSR1120                    (0x00100000uL)
#define GPIO_PMSR11_PMSR1121                    (0x00200000uL)
#define GPIO_PMSR11_PMSR1122                    (0x00400000uL)
#define GPIO_PMSR11_PMSR1123                    (0x00800000uL)
#define GPIO_PMSR11_PMSR1124                    (0x01000000uL)
#define GPIO_PMSR11_PMSR1125                    (0x02000000uL)
#define GPIO_PMSR11_PMSR1126                    (0x04000000uL)
#define GPIO_PMSR11_PMSR1127                    (0x08000000uL)
#define GPIO_PMSR11_PMSR1128                    (0x10000000uL)
#define GPIO_PMSR11_PMSR1129                    (0x20000000uL)
#define GPIO_PMSR11_PMSR1130                    (0x40000000uL)
#define GPIO_PMSR11_PMSR1131                    (0x80000000uL)

#define GPIO_PMCSR11_PMCSR110                   (0x00000001uL)
#define GPIO_PMCSR11_PMCSR111                   (0x00000002uL)
#define GPIO_PMCSR11_PMCSR112                   (0x00000004uL)
#define GPIO_PMCSR11_PMCSR113                   (0x00000008uL)
#define GPIO_PMCSR11_PMCSR114                   (0x00000010uL)
#define GPIO_PMCSR11_PMCSR115                   (0x00000020uL)
#define GPIO_PMCSR11_PMCSR116                   (0x00000040uL)
#define GPIO_PMCSR11_PMCSR117                   (0x00000080uL)
#define GPIO_PMCSR11_PMCSR118                   (0x00000100uL)
#define GPIO_PMCSR11_PMCSR119                   (0x00000200uL)
#define GPIO_PMCSR11_PMCSR1110                  (0x00000400uL)
#define GPIO_PMCSR11_PMCSR1111                  (0x00000800uL)
#define GPIO_PMCSR11_PMCSR1112                  (0x00001000uL)
#define GPIO_PMCSR11_PMCSR1113                  (0x00002000uL)
#define GPIO_PMCSR11_PMCSR1114                  (0x00004000uL)
#define GPIO_PMCSR11_PMCSR1115                  (0x00008000uL)
#define GPIO_PMCSR11_PMCSR1116                  (0x00010000uL)
#define GPIO_PMCSR11_PMCSR1117                  (0x00020000uL)
#define GPIO_PMCSR11_PMCSR1118                  (0x00040000uL)
#define GPIO_PMCSR11_PMCSR1119                  (0x00080000uL)
#define GPIO_PMCSR11_PMCSR1120                  (0x00100000uL)
#define GPIO_PMCSR11_PMCSR1121                  (0x00200000uL)
#define GPIO_PMCSR11_PMCSR1122                  (0x00400000uL)
#define GPIO_PMCSR11_PMCSR1123                  (0x00800000uL)
#define GPIO_PMCSR11_PMCSR1124                  (0x01000000uL)
#define GPIO_PMCSR11_PMCSR1125                  (0x02000000uL)
#define GPIO_PMCSR11_PMCSR1126                  (0x04000000uL)
#define GPIO_PMCSR11_PMCSR1127                  (0x08000000uL)
#define GPIO_PMCSR11_PMCSR1128                  (0x10000000uL)
#define GPIO_PMCSR11_PMCSR1129                  (0x20000000uL)
#define GPIO_PMCSR11_PMCSR1130                  (0x40000000uL)
#define GPIO_PMCSR11_PMCSR1131                  (0x80000000uL)

#define GPIO_PFCAE11_PFCAE110                   (0x0001u)
#define GPIO_PFCAE11_PFCAE111                   (0x0002u)
#define GPIO_PFCAE11_PFCAE112                   (0x0004u)
#define GPIO_PFCAE11_PFCAE113                   (0x0008u)
#define GPIO_PFCAE11_PFCAE114                   (0x0010u)
#define GPIO_PFCAE11_PFCAE115                   (0x0020u)
#define GPIO_PFCAE11_PFCAE116                   (0x0040u)
#define GPIO_PFCAE11_PFCAE117                   (0x0080u)
#define GPIO_PFCAE11_PFCAE118                   (0x0100u)
#define GPIO_PFCAE11_PFCAE119                   (0x0200u)
#define GPIO_PFCAE11_PFCAE1110                  (0x0400u)
#define GPIO_PFCAE11_PFCAE1111                  (0x0800u)
#define GPIO_PFCAE11_PFCAE1112                  (0x1000u)
#define GPIO_PFCAE11_PFCAE1113                  (0x2000u)
#define GPIO_PFCAE11_PFCAE1114                  (0x4000u)
#define GPIO_PFCAE11_PFCAE1115                  (0x8000u)

#define GPIO_PIBC11_PIBC110                     (0x0001u)
#define GPIO_PIBC11_PIBC111                     (0x0002u)
#define GPIO_PIBC11_PIBC112                     (0x0004u)
#define GPIO_PIBC11_PIBC113                     (0x0008u)
#define GPIO_PIBC11_PIBC114                     (0x0010u)
#define GPIO_PIBC11_PIBC115                     (0x0020u)
#define GPIO_PIBC11_PIBC116                     (0x0040u)
#define GPIO_PIBC11_PIBC117                     (0x0080u)
#define GPIO_PIBC11_PIBC118                     (0x0100u)
#define GPIO_PIBC11_PIBC119                     (0x0200u)
#define GPIO_PIBC11_PIBC1110                    (0x0400u)
#define GPIO_PIBC11_PIBC1111                    (0x0800u)
#define GPIO_PIBC11_PIBC1112                    (0x1000u)
#define GPIO_PIBC11_PIBC1113                    (0x2000u)
#define GPIO_PIBC11_PIBC1114                    (0x4000u)
#define GPIO_PIBC11_PIBC1115                    (0x8000u)

#define GPIO_PBDC11_PBDC110                     (0x0001u)
#define GPIO_PBDC11_PBDC111                     (0x0002u)
#define GPIO_PBDC11_PBDC112                     (0x0004u)
#define GPIO_PBDC11_PBDC113                     (0x0008u)
#define GPIO_PBDC11_PBDC114                     (0x0010u)
#define GPIO_PBDC11_PBDC115                     (0x0020u)
#define GPIO_PBDC11_PBDC116                     (0x0040u)
#define GPIO_PBDC11_PBDC117                     (0x0080u)
#define GPIO_PBDC11_PBDC118                     (0x0100u)
#define GPIO_PBDC11_PBDC119                     (0x0200u)
#define GPIO_PBDC11_PBDC1110                    (0x0400u)
#define GPIO_PBDC11_PBDC1111                    (0x0800u)
#define GPIO_PBDC11_PBDC1112                    (0x1000u)
#define GPIO_PBDC11_PBDC1113                    (0x2000u)
#define GPIO_PBDC11_PBDC1114                    (0x4000u)
#define GPIO_PBDC11_PBDC1115                    (0x8000u)

#define GPIO_PIPC11_PIPC110                     (0x0001u)
#define GPIO_PIPC11_PIPC111                     (0x0002u)
#define GPIO_PIPC11_PIPC112                     (0x0004u)
#define GPIO_PIPC11_PIPC113                     (0x0008u)
#define GPIO_PIPC11_PIPC114                     (0x0010u)
#define GPIO_PIPC11_PIPC115                     (0x0020u)
#define GPIO_PIPC11_PIPC116                     (0x0040u)
#define GPIO_PIPC11_PIPC117                     (0x0080u)
#define GPIO_PIPC11_PIPC118                     (0x0100u)
#define GPIO_PIPC11_PIPC119                     (0x0200u)
#define GPIO_PIPC11_PIPC1110                    (0x0400u)
#define GPIO_PIPC11_PIPC1111                    (0x0800u)
#define GPIO_PIPC11_PIPC1112                    (0x1000u)
#define GPIO_PIPC11_PIPC1113                    (0x2000u)
#define GPIO_PIPC11_PIPC1114                    (0x4000u)
#define GPIO_PIPC11_PIPC1115                    (0x8000u)


/* ==== Shift values for IO registers ==== */
/* ---- P0 ---- */
#define GPIO_PPR0_PPR00_SHIFT                   (0u)
#define GPIO_PPR0_PPR01_SHIFT                   (1u)
#define GPIO_PPR0_PPR02_SHIFT                   (2u)
#define GPIO_PPR0_PPR03_SHIFT                   (3u)
#define GPIO_PPR0_PPR04_SHIFT                   (4u)
#define GPIO_PPR0_PPR05_SHIFT                   (5u)

#define GPIO_PMC0_PMC04_SHIFT                   (4u)
#define GPIO_PMC0_PMC05_SHIFT                   (5u)

#define GPIO_PMCSR0_PMCSR04_SHIFT               (4u)
#define GPIO_PMCSR0_PMCSR05_SHIFT               (5u)

#define GPIO_PIBC0_PIBC00_SHIFT                 (0u)
#define GPIO_PIBC0_PIBC01_SHIFT                 (1u)
#define GPIO_PIBC0_PIBC02_SHIFT                 (2u)
#define GPIO_PIBC0_PIBC03_SHIFT                 (3u)
#define GPIO_PIBC0_PIBC04_SHIFT                 (4u)
#define GPIO_PIBC0_PIBC05_SHIFT                 (5u)

/* ---- P1 ---- */
#define GPIO_P1_P10_SHIFT                       (0u)
#define GPIO_P1_P11_SHIFT                       (1u)
#define GPIO_P1_P12_SHIFT                       (2u)
#define GPIO_P1_P13_SHIFT                       (3u)
#define GPIO_P1_P14_SHIFT                       (4u)
#define GPIO_P1_P15_SHIFT                       (5u)
#define GPIO_P1_P16_SHIFT                       (6u)
#define GPIO_P1_P17_SHIFT                       (7u)

#define GPIO_PSR1_PSR10_SHIFT                   (0u)
#define GPIO_PSR1_PSR11_SHIFT                   (1u)
#define GPIO_PSR1_PSR12_SHIFT                   (2u)
#define GPIO_PSR1_PSR13_SHIFT                   (3u)
#define GPIO_PSR1_PSR14_SHIFT                   (4u)
#define GPIO_PSR1_PSR15_SHIFT                   (5u)
#define GPIO_PSR1_PSR16_SHIFT                   (6u)
#define GPIO_PSR1_PSR17_SHIFT                   (7u)
#define GPIO_PSR1_PSR116_SHIFT                  (16u)
#define GPIO_PSR1_PSR117_SHIFT                  (17u)
#define GPIO_PSR1_PSR118_SHIFT                  (18u)
#define GPIO_PSR1_PSR119_SHIFT                  (19u)
#define GPIO_PSR1_PSR120_SHIFT                  (20u)
#define GPIO_PSR1_PSR121_SHIFT                  (21u)
#define GPIO_PSR1_PSR122_SHIFT                  (22u)
#define GPIO_PSR1_PSR123_SHIFT                  (23u)

#define GPIO_PPR1_PPR10_SHIFT                   (0u)
#define GPIO_PPR1_PPR11_SHIFT                   (1u)
#define GPIO_PPR1_PPR12_SHIFT                   (2u)
#define GPIO_PPR1_PPR13_SHIFT                   (3u)
#define GPIO_PPR1_PPR14_SHIFT                   (4u)
#define GPIO_PPR1_PPR15_SHIFT                   (5u)
#define GPIO_PPR1_PPR16_SHIFT                   (6u)
#define GPIO_PPR1_PPR17_SHIFT                   (7u)
#define GPIO_PPR1_PPR18_SHIFT                   (8u)
#define GPIO_PPR1_PPR19_SHIFT                   (9u)
#define GPIO_PPR1_PPR110_SHIFT                  (10u)
#define GPIO_PPR1_PPR111_SHIFT                  (11u)
#define GPIO_PPR1_PPR112_SHIFT                  (12u)
#define GPIO_PPR1_PPR113_SHIFT                  (13u)
#define GPIO_PPR1_PPR114_SHIFT                  (14u)
#define GPIO_PPR1_PPR115_SHIFT                  (15u)

#define GPIO_PM1_PM10_SHIFT                     (0u)
#define GPIO_PM1_PM11_SHIFT                     (1u)
#define GPIO_PM1_PM12_SHIFT                     (2u)
#define GPIO_PM1_PM13_SHIFT                     (3u)
#define GPIO_PM1_PM14_SHIFT                     (4u)
#define GPIO_PM1_PM15_SHIFT                     (5u)
#define GPIO_PM1_PM16_SHIFT                     (6u)
#define GPIO_PM1_PM17_SHIFT                     (7u)

#define GPIO_PMC1_PMC10_SHIFT                   (0u)
#define GPIO_PMC1_PMC11_SHIFT                   (1u)
#define GPIO_PMC1_PMC12_SHIFT                   (2u)
#define GPIO_PMC1_PMC13_SHIFT                   (3u)
#define GPIO_PMC1_PMC14_SHIFT                   (4u)
#define GPIO_PMC1_PMC15_SHIFT                   (5u)
#define GPIO_PMC1_PMC16_SHIFT                   (6u)
#define GPIO_PMC1_PMC17_SHIFT                   (7u)
#define GPIO_PMC1_PMC18_SHIFT                   (8u)
#define GPIO_PMC1_PMC19_SHIFT                   (9u)
#define GPIO_PMC1_PMC110_SHIFT                  (10u)
#define GPIO_PMC1_PMC111_SHIFT                  (11u)
#define GPIO_PMC1_PMC112_SHIFT                  (12u)
#define GPIO_PMC1_PMC113_SHIFT                  (13u)
#define GPIO_PMC1_PMC114_SHIFT                  (14u)
#define GPIO_PMC1_PMC115_SHIFT                  (15u)

#define GPIO_PFC1_PFC10_SHIFT                   (0u)
#define GPIO_PFC1_PFC11_SHIFT                   (1u)
#define GPIO_PFC1_PFC12_SHIFT                   (2u)
#define GPIO_PFC1_PFC13_SHIFT                   (3u)
#define GPIO_PFC1_PFC14_SHIFT                   (4u)
#define GPIO_PFC1_PFC15_SHIFT                   (5u)
#define GPIO_PFC1_PFC16_SHIFT                   (6u)
#define GPIO_PFC1_PFC17_SHIFT                   (7u)
#define GPIO_PFC1_PFC18_SHIFT                   (8u)
#define GPIO_PFC1_PFC19_SHIFT                   (9u)
#define GPIO_PFC1_PFC110_SHIFT                  (10u)
#define GPIO_PFC1_PFC111_SHIFT                  (11u)
#define GPIO_PFC1_PFC112_SHIFT                  (12u)
#define GPIO_PFC1_PFC113_SHIFT                  (13u)
#define GPIO_PFC1_PFC114_SHIFT                  (14u)
#define GPIO_PFC1_PFC115_SHIFT                  (15u)

#define GPIO_PFCE1_PFCE10_SHIFT                 (0u)
#define GPIO_PFCE1_PFCE11_SHIFT                 (1u)
#define GPIO_PFCE1_PFCE12_SHIFT                 (2u)
#define GPIO_PFCE1_PFCE13_SHIFT                 (3u)
#define GPIO_PFCE1_PFCE14_SHIFT                 (4u)
#define GPIO_PFCE1_PFCE15_SHIFT                 (5u)
#define GPIO_PFCE1_PFCE16_SHIFT                 (6u)
#define GPIO_PFCE1_PFCE17_SHIFT                 (7u)
#define GPIO_PFCE1_PFCE18_SHIFT                 (8u)
#define GPIO_PFCE1_PFCE19_SHIFT                 (9u)
#define GPIO_PFCE1_PFCE110_SHIFT                (10u)
#define GPIO_PFCE1_PFCE111_SHIFT                (11u)
#define GPIO_PFCE1_PFCE112_SHIFT                (12u)
#define GPIO_PFCE1_PFCE113_SHIFT                (13u)
#define GPIO_PFCE1_PFCE114_SHIFT                (14u)
#define GPIO_PFCE1_PFCE115_SHIFT                (15u)

#define GPIO_PNOT1_PNOT10_SHIFT                 (0u)
#define GPIO_PNOT1_PNOT11_SHIFT                 (1u)
#define GPIO_PNOT1_PNOT12_SHIFT                 (2u)
#define GPIO_PNOT1_PNOT13_SHIFT                 (3u)
#define GPIO_PNOT1_PNOT14_SHIFT                 (4u)
#define GPIO_PNOT1_PNOT15_SHIFT                 (5u)
#define GPIO_PNOT1_PNOT16_SHIFT                 (6u)
#define GPIO_PNOT1_PNOT17_SHIFT                 (7u)

#define GPIO_PMSR1_PMSR10_SHIFT                 (0u)
#define GPIO_PMSR1_PMSR11_SHIFT                 (1u)
#define GPIO_PMSR1_PMSR12_SHIFT                 (2u)
#define GPIO_PMSR1_PMSR13_SHIFT                 (3u)
#define GPIO_PMSR1_PMSR14_SHIFT                 (4u)
#define GPIO_PMSR1_PMSR15_SHIFT                 (5u)
#define GPIO_PMSR1_PMSR16_SHIFT                 (6u)
#define GPIO_PMSR1_PMSR17_SHIFT                 (7u)
#define GPIO_PMSR1_PMSR116_SHIFT                (16u)
#define GPIO_PMSR1_PMSR117_SHIFT                (17u)
#define GPIO_PMSR1_PMSR118_SHIFT                (18u)
#define GPIO_PMSR1_PMSR119_SHIFT                (19u)
#define GPIO_PMSR1_PMSR120_SHIFT                (20u)
#define GPIO_PMSR1_PMSR121_SHIFT                (21u)
#define GPIO_PMSR1_PMSR122_SHIFT                (22u)
#define GPIO_PMSR1_PMSR123_SHIFT                (23u)

#define GPIO_PMCSR1_PMCSR10_SHIFT               (0u)
#define GPIO_PMCSR1_PMCSR11_SHIFT               (1u)
#define GPIO_PMCSR1_PMCSR12_SHIFT               (2u)
#define GPIO_PMCSR1_PMCSR13_SHIFT               (3u)
#define GPIO_PMCSR1_PMCSR14_SHIFT               (4u)
#define GPIO_PMCSR1_PMCSR15_SHIFT               (5u)
#define GPIO_PMCSR1_PMCSR16_SHIFT               (6u)
#define GPIO_PMCSR1_PMCSR17_SHIFT               (7u)
#define GPIO_PMCSR1_PMCSR116_SHIFT              (16u)
#define GPIO_PMCSR1_PMCSR117_SHIFT              (17u)
#define GPIO_PMCSR1_PMCSR118_SHIFT              (18u)
#define GPIO_PMCSR1_PMCSR119_SHIFT              (19u)
#define GPIO_PMCSR1_PMCSR120_SHIFT              (20u)
#define GPIO_PMCSR1_PMCSR121_SHIFT              (21u)
#define GPIO_PMCSR1_PMCSR122_SHIFT              (22u)
#define GPIO_PMCSR1_PMCSR123_SHIFT              (23u)

#define GPIO_PFCAE1_PFCAE10_SHIFT               (0u)
#define GPIO_PFCAE1_PFCAE11_SHIFT               (1u)
#define GPIO_PFCAE1_PFCAE12_SHIFT               (2u)
#define GPIO_PFCAE1_PFCAE13_SHIFT               (3u)
#define GPIO_PFCAE1_PFCAE14_SHIFT               (4u)
#define GPIO_PFCAE1_PFCAE15_SHIFT               (5u)
#define GPIO_PFCAE1_PFCAE16_SHIFT               (6u)
#define GPIO_PFCAE1_PFCAE17_SHIFT               (7u)
#define GPIO_PFCAE1_PFCAE18_SHIFT               (8u)
#define GPIO_PFCAE1_PFCAE19_SHIFT               (9u)
#define GPIO_PFCAE1_PFCAE110_SHIFT              (10u)
#define GPIO_PFCAE1_PFCAE111_SHIFT              (11u)
#define GPIO_PFCAE1_PFCAE112_SHIFT              (12u)
#define GPIO_PFCAE1_PFCAE113_SHIFT              (13u)
#define GPIO_PFCAE1_PFCAE114_SHIFT              (14u)
#define GPIO_PFCAE1_PFCAE115_SHIFT              (15u)

#define GPIO_PIBC1_PIBC10_SHIFT                 (0u)
#define GPIO_PIBC1_PIBC11_SHIFT                 (1u)
#define GPIO_PIBC1_PIBC12_SHIFT                 (2u)
#define GPIO_PIBC1_PIBC13_SHIFT                 (3u)
#define GPIO_PIBC1_PIBC14_SHIFT                 (4u)
#define GPIO_PIBC1_PIBC15_SHIFT                 (5u)
#define GPIO_PIBC1_PIBC16_SHIFT                 (6u)
#define GPIO_PIBC1_PIBC17_SHIFT                 (7u)
#define GPIO_PIBC1_PIBC18_SHIFT                 (8u)
#define GPIO_PIBC1_PIBC19_SHIFT                 (9u)
#define GPIO_PIBC1_PIBC110_SHIFT                (10u)
#define GPIO_PIBC1_PIBC111_SHIFT                (11u)
#define GPIO_PIBC1_PIBC112_SHIFT                (12u)
#define GPIO_PIBC1_PIBC113_SHIFT                (13u)
#define GPIO_PIBC1_PIBC114_SHIFT                (14u)
#define GPIO_PIBC1_PIBC115_SHIFT                (15u)

#define GPIO_PBDC1_PBDC10_SHIFT                 (0u)
#define GPIO_PBDC1_PBDC11_SHIFT                 (1u)
#define GPIO_PBDC1_PBDC12_SHIFT                 (2u)
#define GPIO_PBDC1_PBDC13_SHIFT                 (3u)
#define GPIO_PBDC1_PBDC14_SHIFT                 (4u)
#define GPIO_PBDC1_PBDC15_SHIFT                 (5u)
#define GPIO_PBDC1_PBDC16_SHIFT                 (6u)
#define GPIO_PBDC1_PBDC17_SHIFT                 (7u)
#define GPIO_PBDC1_PBDC18_SHIFT                 (8u)
#define GPIO_PBDC1_PBDC19_SHIFT                 (9u)
#define GPIO_PBDC1_PBDC110_SHIFT                (10u)
#define GPIO_PBDC1_PBDC111_SHIFT                (11u)
#define GPIO_PBDC1_PBDC112_SHIFT                (12u)
#define GPIO_PBDC1_PBDC113_SHIFT                (13u)
#define GPIO_PBDC1_PBDC114_SHIFT                (14u)
#define GPIO_PBDC1_PBDC115_SHIFT                (15u)

#define GPIO_PIPC1_PIPC10_SHIFT                 (0u)
#define GPIO_PIPC1_PIPC11_SHIFT                 (1u)
#define GPIO_PIPC1_PIPC12_SHIFT                 (2u)
#define GPIO_PIPC1_PIPC13_SHIFT                 (3u)
#define GPIO_PIPC1_PIPC14_SHIFT                 (4u)
#define GPIO_PIPC1_PIPC15_SHIFT                 (5u)
#define GPIO_PIPC1_PIPC16_SHIFT                 (6u)
#define GPIO_PIPC1_PIPC17_SHIFT                 (7u)

/* ---- P2 ---- */
#define GPIO_P2_P20_SHIFT                       (0u)
#define GPIO_P2_P21_SHIFT                       (1u)
#define GPIO_P2_P22_SHIFT                       (2u)
#define GPIO_P2_P23_SHIFT                       (3u)
#define GPIO_P2_P24_SHIFT                       (4u)
#define GPIO_P2_P25_SHIFT                       (5u)
#define GPIO_P2_P26_SHIFT                       (6u)
#define GPIO_P2_P27_SHIFT                       (7u)
#define GPIO_P2_P28_SHIFT                       (8u)
#define GPIO_P2_P29_SHIFT                       (9u)
#define GPIO_P2_P210_SHIFT                      (10u)
#define GPIO_P2_P211_SHIFT                      (11u)
#define GPIO_P2_P212_SHIFT                      (12u)
#define GPIO_P2_P213_SHIFT                      (13u)
#define GPIO_P2_P214_SHIFT                      (14u)
#define GPIO_P2_P215_SHIFT                      (15u)

#define GPIO_PSR2_PSR20_SHIFT                   (0u)
#define GPIO_PSR2_PSR21_SHIFT                   (1u)
#define GPIO_PSR2_PSR22_SHIFT                   (2u)
#define GPIO_PSR2_PSR23_SHIFT                   (3u)
#define GPIO_PSR2_PSR24_SHIFT                   (4u)
#define GPIO_PSR2_PSR25_SHIFT                   (5u)
#define GPIO_PSR2_PSR26_SHIFT                   (6u)
#define GPIO_PSR2_PSR27_SHIFT                   (7u)
#define GPIO_PSR2_PSR28_SHIFT                   (8u)
#define GPIO_PSR2_PSR29_SHIFT                   (9u)
#define GPIO_PSR2_PSR210_SHIFT                  (10u)
#define GPIO_PSR2_PSR211_SHIFT                  (11u)
#define GPIO_PSR2_PSR212_SHIFT                  (12u)
#define GPIO_PSR2_PSR213_SHIFT                  (13u)
#define GPIO_PSR2_PSR214_SHIFT                  (14u)
#define GPIO_PSR2_PSR215_SHIFT                  (15u)
#define GPIO_PSR2_PSR216_SHIFT                  (16u)
#define GPIO_PSR2_PSR217_SHIFT                  (17u)
#define GPIO_PSR2_PSR218_SHIFT                  (18u)
#define GPIO_PSR2_PSR219_SHIFT                  (19u)
#define GPIO_PSR2_PSR220_SHIFT                  (20u)
#define GPIO_PSR2_PSR221_SHIFT                  (21u)
#define GPIO_PSR2_PSR222_SHIFT                  (22u)
#define GPIO_PSR2_PSR223_SHIFT                  (23u)
#define GPIO_PSR2_PSR224_SHIFT                  (24u)
#define GPIO_PSR2_PSR225_SHIFT                  (25u)
#define GPIO_PSR2_PSR226_SHIFT                  (26u)
#define GPIO_PSR2_PSR227_SHIFT                  (27u)
#define GPIO_PSR2_PSR228_SHIFT                  (28u)
#define GPIO_PSR2_PSR229_SHIFT                  (29u)
#define GPIO_PSR2_PSR230_SHIFT                  (30u)
#define GPIO_PSR2_PSR231_SHIFT                  (31u)

#define GPIO_PPR2_PPR20_SHIFT                   (0u)
#define GPIO_PPR2_PPR21_SHIFT                   (1u)
#define GPIO_PPR2_PPR22_SHIFT                   (2u)
#define GPIO_PPR2_PPR23_SHIFT                   (3u)
#define GPIO_PPR2_PPR24_SHIFT                   (4u)
#define GPIO_PPR2_PPR25_SHIFT                   (5u)
#define GPIO_PPR2_PPR26_SHIFT                   (6u)
#define GPIO_PPR2_PPR27_SHIFT                   (7u)
#define GPIO_PPR2_PPR28_SHIFT                   (8u)
#define GPIO_PPR2_PPR29_SHIFT                   (9u)
#define GPIO_PPR2_PPR210_SHIFT                  (10u)
#define GPIO_PPR2_PPR211_SHIFT                  (11u)
#define GPIO_PPR2_PPR212_SHIFT                  (12u)
#define GPIO_PPR2_PPR213_SHIFT                  (13u)
#define GPIO_PPR2_PPR214_SHIFT                  (14u)
#define GPIO_PPR2_PPR215_SHIFT                  (15u)

#define GPIO_PM2_PM20_SHIFT                     (0u)
#define GPIO_PM2_PM21_SHIFT                     (1u)
#define GPIO_PM2_PM22_SHIFT                     (2u)
#define GPIO_PM2_PM23_SHIFT                     (3u)
#define GPIO_PM2_PM24_SHIFT                     (4u)
#define GPIO_PM2_PM25_SHIFT                     (5u)
#define GPIO_PM2_PM26_SHIFT                     (6u)
#define GPIO_PM2_PM27_SHIFT                     (7u)
#define GPIO_PM2_PM28_SHIFT                     (8u)
#define GPIO_PM2_PM29_SHIFT                     (9u)
#define GPIO_PM2_PM210_SHIFT                    (10u)
#define GPIO_PM2_PM211_SHIFT                    (11u)
#define GPIO_PM2_PM212_SHIFT                    (12u)
#define GPIO_PM2_PM213_SHIFT                    (13u)
#define GPIO_PM2_PM214_SHIFT                    (14u)
#define GPIO_PM2_PM215_SHIFT                    (15u)

#define GPIO_PMC2_PMC20_SHIFT                   (0u)
#define GPIO_PMC2_PMC21_SHIFT                   (1u)
#define GPIO_PMC2_PMC22_SHIFT                   (2u)
#define GPIO_PMC2_PMC23_SHIFT                   (3u)
#define GPIO_PMC2_PMC24_SHIFT                   (4u)
#define GPIO_PMC2_PMC25_SHIFT                   (5u)
#define GPIO_PMC2_PMC26_SHIFT                   (6u)
#define GPIO_PMC2_PMC27_SHIFT                   (7u)
#define GPIO_PMC2_PMC28_SHIFT                   (8u)
#define GPIO_PMC2_PMC29_SHIFT                   (9u)
#define GPIO_PMC2_PMC210_SHIFT                  (10u)
#define GPIO_PMC2_PMC211_SHIFT                  (11u)
#define GPIO_PMC2_PMC212_SHIFT                  (12u)
#define GPIO_PMC2_PMC213_SHIFT                  (13u)
#define GPIO_PMC2_PMC214_SHIFT                  (14u)
#define GPIO_PMC2_PMC215_SHIFT                  (15u)

#define GPIO_PFC2_PFC20_SHIFT                   (0u)
#define GPIO_PFC2_PFC21_SHIFT                   (1u)
#define GPIO_PFC2_PFC22_SHIFT                   (2u)
#define GPIO_PFC2_PFC23_SHIFT                   (3u)
#define GPIO_PFC2_PFC24_SHIFT                   (4u)
#define GPIO_PFC2_PFC25_SHIFT                   (5u)
#define GPIO_PFC2_PFC26_SHIFT                   (6u)
#define GPIO_PFC2_PFC27_SHIFT                   (7u)
#define GPIO_PFC2_PFC28_SHIFT                   (8u)
#define GPIO_PFC2_PFC29_SHIFT                   (9u)
#define GPIO_PFC2_PFC210_SHIFT                  (10u)
#define GPIO_PFC2_PFC211_SHIFT                  (11u)
#define GPIO_PFC2_PFC212_SHIFT                  (12u)
#define GPIO_PFC2_PFC213_SHIFT                  (13u)
#define GPIO_PFC2_PFC214_SHIFT                  (14u)
#define GPIO_PFC2_PFC215_SHIFT                  (15u)

#define GPIO_PFCE2_PFCE20_SHIFT                 (0u)
#define GPIO_PFCE2_PFCE21_SHIFT                 (1u)
#define GPIO_PFCE2_PFCE22_SHIFT                 (2u)
#define GPIO_PFCE2_PFCE23_SHIFT                 (3u)
#define GPIO_PFCE2_PFCE24_SHIFT                 (4u)
#define GPIO_PFCE2_PFCE25_SHIFT                 (5u)
#define GPIO_PFCE2_PFCE26_SHIFT                 (6u)
#define GPIO_PFCE2_PFCE27_SHIFT                 (7u)
#define GPIO_PFCE2_PFCE28_SHIFT                 (8u)
#define GPIO_PFCE2_PFCE29_SHIFT                 (9u)
#define GPIO_PFCE2_PFCE210_SHIFT                (10u)
#define GPIO_PFCE2_PFCE211_SHIFT                (11u)
#define GPIO_PFCE2_PFCE212_SHIFT                (12u)
#define GPIO_PFCE2_PFCE213_SHIFT                (13u)
#define GPIO_PFCE2_PFCE214_SHIFT                (14u)
#define GPIO_PFCE2_PFCE215_SHIFT                (15u)

#define GPIO_PNOT2_PNOT20_SHIFT                 (0u)
#define GPIO_PNOT2_PNOT21_SHIFT                 (1u)
#define GPIO_PNOT2_PNOT22_SHIFT                 (2u)
#define GPIO_PNOT2_PNOT23_SHIFT                 (3u)
#define GPIO_PNOT2_PNOT24_SHIFT                 (4u)
#define GPIO_PNOT2_PNOT25_SHIFT                 (5u)
#define GPIO_PNOT2_PNOT26_SHIFT                 (6u)
#define GPIO_PNOT2_PNOT27_SHIFT                 (7u)
#define GPIO_PNOT2_PNOT28_SHIFT                 (8u)
#define GPIO_PNOT2_PNOT29_SHIFT                 (9u)
#define GPIO_PNOT2_PNOT210_SHIFT                (10u)
#define GPIO_PNOT2_PNOT211_SHIFT                (11u)
#define GPIO_PNOT2_PNOT212_SHIFT                (12u)
#define GPIO_PNOT2_PNOT213_SHIFT                (13u)
#define GPIO_PNOT2_PNOT214_SHIFT                (14u)
#define GPIO_PNOT2_PNOT215_SHIFT                (15u)

#define GPIO_PMSR2_PMSR20_SHIFT                 (0u)
#define GPIO_PMSR2_PMSR21_SHIFT                 (1u)
#define GPIO_PMSR2_PMSR22_SHIFT                 (2u)
#define GPIO_PMSR2_PMSR23_SHIFT                 (3u)
#define GPIO_PMSR2_PMSR24_SHIFT                 (4u)
#define GPIO_PMSR2_PMSR25_SHIFT                 (5u)
#define GPIO_PMSR2_PMSR26_SHIFT                 (6u)
#define GPIO_PMSR2_PMSR27_SHIFT                 (7u)
#define GPIO_PMSR2_PMSR28_SHIFT                 (8u)
#define GPIO_PMSR2_PMSR29_SHIFT                 (9u)
#define GPIO_PMSR2_PMSR210_SHIFT                (10u)
#define GPIO_PMSR2_PMSR211_SHIFT                (11u)
#define GPIO_PMSR2_PMSR212_SHIFT                (12u)
#define GPIO_PMSR2_PMSR213_SHIFT                (13u)
#define GPIO_PMSR2_PMSR214_SHIFT                (14u)
#define GPIO_PMSR2_PMSR215_SHIFT                (15u)
#define GPIO_PMSR2_PMSR216_SHIFT                (16u)
#define GPIO_PMSR2_PMSR217_SHIFT                (17u)
#define GPIO_PMSR2_PMSR218_SHIFT                (18u)
#define GPIO_PMSR2_PMSR219_SHIFT                (19u)
#define GPIO_PMSR2_PMSR220_SHIFT                (20u)
#define GPIO_PMSR2_PMSR221_SHIFT                (21u)
#define GPIO_PMSR2_PMSR222_SHIFT                (22u)
#define GPIO_PMSR2_PMSR223_SHIFT                (23u)
#define GPIO_PMSR2_PMSR224_SHIFT                (24u)
#define GPIO_PMSR2_PMSR225_SHIFT                (25u)
#define GPIO_PMSR2_PMSR226_SHIFT                (26u)
#define GPIO_PMSR2_PMSR227_SHIFT                (27u)
#define GPIO_PMSR2_PMSR228_SHIFT                (28u)
#define GPIO_PMSR2_PMSR229_SHIFT                (29u)
#define GPIO_PMSR2_PMSR230_SHIFT                (30u)
#define GPIO_PMSR2_PMSR231_SHIFT                (31u)

#define GPIO_PMCSR2_PMCSR20_SHIFT               (0u)
#define GPIO_PMCSR2_PMCSR21_SHIFT               (1u)
#define GPIO_PMCSR2_PMCSR22_SHIFT               (2u)
#define GPIO_PMCSR2_PMCSR23_SHIFT               (3u)
#define GPIO_PMCSR2_PMCSR24_SHIFT               (4u)
#define GPIO_PMCSR2_PMCSR25_SHIFT               (5u)
#define GPIO_PMCSR2_PMCSR26_SHIFT               (6u)
#define GPIO_PMCSR2_PMCSR27_SHIFT               (7u)
#define GPIO_PMCSR2_PMCSR28_SHIFT               (8u)
#define GPIO_PMCSR2_PMCSR29_SHIFT               (9u)
#define GPIO_PMCSR2_PMCSR210_SHIFT              (10u)
#define GPIO_PMCSR2_PMCSR211_SHIFT              (11u)
#define GPIO_PMCSR2_PMCSR212_SHIFT              (12u)
#define GPIO_PMCSR2_PMCSR213_SHIFT              (13u)
#define GPIO_PMCSR2_PMCSR214_SHIFT              (14u)
#define GPIO_PMCSR2_PMCSR215_SHIFT              (15u)
#define GPIO_PMCSR2_PMCSR216_SHIFT              (16u)
#define GPIO_PMCSR2_PMCSR217_SHIFT              (17u)
#define GPIO_PMCSR2_PMCSR218_SHIFT              (18u)
#define GPIO_PMCSR2_PMCSR219_SHIFT              (19u)
#define GPIO_PMCSR2_PMCSR220_SHIFT              (20u)
#define GPIO_PMCSR2_PMCSR221_SHIFT              (21u)
#define GPIO_PMCSR2_PMCSR222_SHIFT              (22u)
#define GPIO_PMCSR2_PMCSR223_SHIFT              (23u)
#define GPIO_PMCSR2_PMCSR224_SHIFT              (24u)
#define GPIO_PMCSR2_PMCSR225_SHIFT              (25u)
#define GPIO_PMCSR2_PMCSR226_SHIFT              (26u)
#define GPIO_PMCSR2_PMCSR227_SHIFT              (27u)
#define GPIO_PMCSR2_PMCSR228_SHIFT              (28u)
#define GPIO_PMCSR2_PMCSR229_SHIFT              (29u)
#define GPIO_PMCSR2_PMCSR230_SHIFT              (30u)
#define GPIO_PMCSR2_PMCSR231_SHIFT              (31u)

#define GPIO_PFCAE2_PFCAE20_SHIFT               (0u)
#define GPIO_PFCAE2_PFCAE21_SHIFT               (1u)
#define GPIO_PFCAE2_PFCAE22_SHIFT               (2u)
#define GPIO_PFCAE2_PFCAE23_SHIFT               (3u)
#define GPIO_PFCAE2_PFCAE24_SHIFT               (4u)
#define GPIO_PFCAE2_PFCAE25_SHIFT               (5u)
#define GPIO_PFCAE2_PFCAE26_SHIFT               (6u)
#define GPIO_PFCAE2_PFCAE27_SHIFT               (7u)
#define GPIO_PFCAE2_PFCAE28_SHIFT               (8u)
#define GPIO_PFCAE2_PFCAE29_SHIFT               (9u)
#define GPIO_PFCAE2_PFCAE210_SHIFT              (10u)
#define GPIO_PFCAE2_PFCAE211_SHIFT              (11u)
#define GPIO_PFCAE2_PFCAE212_SHIFT              (12u)
#define GPIO_PFCAE2_PFCAE213_SHIFT              (13u)
#define GPIO_PFCAE2_PFCAE214_SHIFT              (14u)
#define GPIO_PFCAE2_PFCAE215_SHIFT              (15u)

#define GPIO_PIBC2_PIBC20_SHIFT                 (0u)
#define GPIO_PIBC2_PIBC21_SHIFT                 (1u)
#define GPIO_PIBC2_PIBC22_SHIFT                 (2u)
#define GPIO_PIBC2_PIBC23_SHIFT                 (3u)
#define GPIO_PIBC2_PIBC24_SHIFT                 (4u)
#define GPIO_PIBC2_PIBC25_SHIFT                 (5u)
#define GPIO_PIBC2_PIBC26_SHIFT                 (6u)
#define GPIO_PIBC2_PIBC27_SHIFT                 (7u)
#define GPIO_PIBC2_PIBC28_SHIFT                 (8u)
#define GPIO_PIBC2_PIBC29_SHIFT                 (9u)
#define GPIO_PIBC2_PIBC210_SHIFT                (10u)
#define GPIO_PIBC2_PIBC211_SHIFT                (11u)
#define GPIO_PIBC2_PIBC212_SHIFT                (12u)
#define GPIO_PIBC2_PIBC213_SHIFT                (13u)
#define GPIO_PIBC2_PIBC214_SHIFT                (14u)
#define GPIO_PIBC2_PIBC215_SHIFT                (15u)

#define GPIO_PBDC2_PBDC20_SHIFT                 (0u)
#define GPIO_PBDC2_PBDC21_SHIFT                 (1u)
#define GPIO_PBDC2_PBDC22_SHIFT                 (2u)
#define GPIO_PBDC2_PBDC23_SHIFT                 (3u)
#define GPIO_PBDC2_PBDC24_SHIFT                 (4u)
#define GPIO_PBDC2_PBDC25_SHIFT                 (5u)
#define GPIO_PBDC2_PBDC26_SHIFT                 (6u)
#define GPIO_PBDC2_PBDC27_SHIFT                 (7u)
#define GPIO_PBDC2_PBDC28_SHIFT                 (8u)
#define GPIO_PBDC2_PBDC29_SHIFT                 (9u)
#define GPIO_PBDC2_PBDC210_SHIFT                (10u)
#define GPIO_PBDC2_PBDC211_SHIFT                (11u)
#define GPIO_PBDC2_PBDC212_SHIFT                (12u)
#define GPIO_PBDC2_PBDC213_SHIFT                (13u)
#define GPIO_PBDC2_PBDC214_SHIFT                (14u)
#define GPIO_PBDC2_PBDC215_SHIFT                (15u)

#define GPIO_PIPC2_PIPC20_SHIFT                 (0u)
#define GPIO_PIPC2_PIPC21_SHIFT                 (1u)
#define GPIO_PIPC2_PIPC22_SHIFT                 (2u)
#define GPIO_PIPC2_PIPC23_SHIFT                 (3u)
#define GPIO_PIPC2_PIPC24_SHIFT                 (4u)
#define GPIO_PIPC2_PIPC25_SHIFT                 (5u)
#define GPIO_PIPC2_PIPC26_SHIFT                 (6u)
#define GPIO_PIPC2_PIPC27_SHIFT                 (7u)
#define GPIO_PIPC2_PIPC28_SHIFT                 (8u)
#define GPIO_PIPC2_PIPC29_SHIFT                 (9u)
#define GPIO_PIPC2_PIPC210_SHIFT                (10u)
#define GPIO_PIPC2_PIPC211_SHIFT                (11u)
#define GPIO_PIPC2_PIPC212_SHIFT                (12u)
#define GPIO_PIPC2_PIPC213_SHIFT                (13u)
#define GPIO_PIPC2_PIPC214_SHIFT                (14u)
#define GPIO_PIPC2_PIPC215_SHIFT                (15u)

/* ---- P3 ---- */
#define GPIO_P3_P30_SHIFT                       (0u)
#define GPIO_P3_P31_SHIFT                       (1u)
#define GPIO_P3_P32_SHIFT                       (2u)
#define GPIO_P3_P33_SHIFT                       (3u)
#define GPIO_P3_P34_SHIFT                       (4u)
#define GPIO_P3_P35_SHIFT                       (5u)
#define GPIO_P3_P36_SHIFT                       (6u)
#define GPIO_P3_P37_SHIFT                       (7u)
#define GPIO_P3_P38_SHIFT                       (8u)
#define GPIO_P3_P39_SHIFT                       (9u)
#define GPIO_P3_P310_SHIFT                      (10u)
#define GPIO_P3_P311_SHIFT                      (11u)
#define GPIO_P3_P312_SHIFT                      (12u)
#define GPIO_P3_P313_SHIFT                      (13u)
#define GPIO_P3_P314_SHIFT                      (14u)
#define GPIO_P3_P315_SHIFT                      (15u)

#define GPIO_PSR3_PSR30_SHIFT                   (0u)
#define GPIO_PSR3_PSR31_SHIFT                   (1u)
#define GPIO_PSR3_PSR32_SHIFT                   (2u)
#define GPIO_PSR3_PSR33_SHIFT                   (3u)
#define GPIO_PSR3_PSR34_SHIFT                   (4u)
#define GPIO_PSR3_PSR35_SHIFT                   (5u)
#define GPIO_PSR3_PSR36_SHIFT                   (6u)
#define GPIO_PSR3_PSR37_SHIFT                   (7u)
#define GPIO_PSR3_PSR38_SHIFT                   (8u)
#define GPIO_PSR3_PSR39_SHIFT                   (9u)
#define GPIO_PSR3_PSR310_SHIFT                  (10u)
#define GPIO_PSR3_PSR311_SHIFT                  (11u)
#define GPIO_PSR3_PSR312_SHIFT                  (12u)
#define GPIO_PSR3_PSR313_SHIFT                  (13u)
#define GPIO_PSR3_PSR314_SHIFT                  (14u)
#define GPIO_PSR3_PSR315_SHIFT                  (15u)
#define GPIO_PSR3_PSR316_SHIFT                  (16u)
#define GPIO_PSR3_PSR317_SHIFT                  (17u)
#define GPIO_PSR3_PSR318_SHIFT                  (18u)
#define GPIO_PSR3_PSR319_SHIFT                  (19u)
#define GPIO_PSR3_PSR320_SHIFT                  (20u)
#define GPIO_PSR3_PSR321_SHIFT                  (21u)
#define GPIO_PSR3_PSR322_SHIFT                  (22u)
#define GPIO_PSR3_PSR323_SHIFT                  (23u)
#define GPIO_PSR3_PSR324_SHIFT                  (24u)
#define GPIO_PSR3_PSR325_SHIFT                  (25u)
#define GPIO_PSR3_PSR326_SHIFT                  (26u)
#define GPIO_PSR3_PSR327_SHIFT                  (27u)
#define GPIO_PSR3_PSR328_SHIFT                  (28u)
#define GPIO_PSR3_PSR329_SHIFT                  (29u)
#define GPIO_PSR3_PSR330_SHIFT                  (30u)
#define GPIO_PSR3_PSR331_SHIFT                  (31u)

#define GPIO_PPR3_PPR30_SHIFT                   (0u)
#define GPIO_PPR3_PPR31_SHIFT                   (1u)
#define GPIO_PPR3_PPR32_SHIFT                   (2u)
#define GPIO_PPR3_PPR33_SHIFT                   (3u)
#define GPIO_PPR3_PPR34_SHIFT                   (4u)
#define GPIO_PPR3_PPR35_SHIFT                   (5u)
#define GPIO_PPR3_PPR36_SHIFT                   (6u)
#define GPIO_PPR3_PPR37_SHIFT                   (7u)
#define GPIO_PPR3_PPR38_SHIFT                   (8u)
#define GPIO_PPR3_PPR39_SHIFT                   (9u)
#define GPIO_PPR3_PPR310_SHIFT                  (10u)
#define GPIO_PPR3_PPR311_SHIFT                  (11u)
#define GPIO_PPR3_PPR312_SHIFT                  (12u)
#define GPIO_PPR3_PPR313_SHIFT                  (13u)
#define GPIO_PPR3_PPR314_SHIFT                  (14u)
#define GPIO_PPR3_PPR315_SHIFT                  (15u)

#define GPIO_PM3_PM30_SHIFT                     (0u)
#define GPIO_PM3_PM31_SHIFT                     (1u)
#define GPIO_PM3_PM32_SHIFT                     (2u)
#define GPIO_PM3_PM33_SHIFT                     (3u)
#define GPIO_PM3_PM34_SHIFT                     (4u)
#define GPIO_PM3_PM35_SHIFT                     (5u)
#define GPIO_PM3_PM36_SHIFT                     (6u)
#define GPIO_PM3_PM37_SHIFT                     (7u)
#define GPIO_PM3_PM38_SHIFT                     (8u)
#define GPIO_PM3_PM39_SHIFT                     (9u)
#define GPIO_PM3_PM310_SHIFT                    (10u)
#define GPIO_PM3_PM311_SHIFT                    (11u)
#define GPIO_PM3_PM312_SHIFT                    (12u)
#define GPIO_PM3_PM313_SHIFT                    (13u)
#define GPIO_PM3_PM314_SHIFT                    (14u)
#define GPIO_PM3_PM315_SHIFT                    (15u)

#define GPIO_PMC3_PMC30_SHIFT                   (0u)
#define GPIO_PMC3_PMC31_SHIFT                   (1u)
#define GPIO_PMC3_PMC32_SHIFT                   (2u)
#define GPIO_PMC3_PMC33_SHIFT                   (3u)
#define GPIO_PMC3_PMC34_SHIFT                   (4u)
#define GPIO_PMC3_PMC35_SHIFT                   (5u)
#define GPIO_PMC3_PMC36_SHIFT                   (6u)
#define GPIO_PMC3_PMC37_SHIFT                   (7u)
#define GPIO_PMC3_PMC38_SHIFT                   (8u)
#define GPIO_PMC3_PMC39_SHIFT                   (9u)
#define GPIO_PMC3_PMC310_SHIFT                  (10u)
#define GPIO_PMC3_PMC311_SHIFT                  (11u)
#define GPIO_PMC3_PMC312_SHIFT                  (12u)
#define GPIO_PMC3_PMC313_SHIFT                  (13u)
#define GPIO_PMC3_PMC314_SHIFT                  (14u)
#define GPIO_PMC3_PMC315_SHIFT                  (15u)

#define GPIO_PFC3_PFC30_SHIFT                   (0u)
#define GPIO_PFC3_PFC31_SHIFT                   (1u)
#define GPIO_PFC3_PFC32_SHIFT                   (2u)
#define GPIO_PFC3_PFC33_SHIFT                   (3u)
#define GPIO_PFC3_PFC34_SHIFT                   (4u)
#define GPIO_PFC3_PFC35_SHIFT                   (5u)
#define GPIO_PFC3_PFC36_SHIFT                   (6u)
#define GPIO_PFC3_PFC37_SHIFT                   (7u)
#define GPIO_PFC3_PFC38_SHIFT                   (8u)
#define GPIO_PFC3_PFC39_SHIFT                   (9u)
#define GPIO_PFC3_PFC310_SHIFT                  (10u)
#define GPIO_PFC3_PFC311_SHIFT                  (11u)
#define GPIO_PFC3_PFC312_SHIFT                  (12u)
#define GPIO_PFC3_PFC313_SHIFT                  (13u)
#define GPIO_PFC3_PFC314_SHIFT                  (14u)
#define GPIO_PFC3_PFC315_SHIFT                  (15u)

#define GPIO_PFCE3_PFCE30_SHIFT                 (0u)
#define GPIO_PFCE3_PFCE31_SHIFT                 (1u)
#define GPIO_PFCE3_PFCE32_SHIFT                 (2u)
#define GPIO_PFCE3_PFCE33_SHIFT                 (3u)
#define GPIO_PFCE3_PFCE34_SHIFT                 (4u)
#define GPIO_PFCE3_PFCE35_SHIFT                 (5u)
#define GPIO_PFCE3_PFCE36_SHIFT                 (6u)
#define GPIO_PFCE3_PFCE37_SHIFT                 (7u)
#define GPIO_PFCE3_PFCE38_SHIFT                 (8u)
#define GPIO_PFCE3_PFCE39_SHIFT                 (9u)
#define GPIO_PFCE3_PFCE310_SHIFT                (10u)
#define GPIO_PFCE3_PFCE311_SHIFT                (11u)
#define GPIO_PFCE3_PFCE312_SHIFT                (12u)
#define GPIO_PFCE3_PFCE313_SHIFT                (13u)
#define GPIO_PFCE3_PFCE314_SHIFT                (14u)
#define GPIO_PFCE3_PFCE315_SHIFT                (15u)

#define GPIO_PNOT3_PNOT30_SHIFT                 (0u)
#define GPIO_PNOT3_PNOT31_SHIFT                 (1u)
#define GPIO_PNOT3_PNOT32_SHIFT                 (2u)
#define GPIO_PNOT3_PNOT33_SHIFT                 (3u)
#define GPIO_PNOT3_PNOT34_SHIFT                 (4u)
#define GPIO_PNOT3_PNOT35_SHIFT                 (5u)
#define GPIO_PNOT3_PNOT36_SHIFT                 (6u)
#define GPIO_PNOT3_PNOT37_SHIFT                 (7u)
#define GPIO_PNOT3_PNOT38_SHIFT                 (8u)
#define GPIO_PNOT3_PNOT39_SHIFT                 (9u)
#define GPIO_PNOT3_PNOT310_SHIFT                (10u)
#define GPIO_PNOT3_PNOT311_SHIFT                (11u)
#define GPIO_PNOT3_PNOT312_SHIFT                (12u)
#define GPIO_PNOT3_PNOT313_SHIFT                (13u)
#define GPIO_PNOT3_PNOT314_SHIFT                (14u)
#define GPIO_PNOT3_PNOT315_SHIFT                (15u)

#define GPIO_PMSR3_PMSR30_SHIFT                 (0u)
#define GPIO_PMSR3_PMSR31_SHIFT                 (1u)
#define GPIO_PMSR3_PMSR32_SHIFT                 (2u)
#define GPIO_PMSR3_PMSR33_SHIFT                 (3u)
#define GPIO_PMSR3_PMSR34_SHIFT                 (4u)
#define GPIO_PMSR3_PMSR35_SHIFT                 (5u)
#define GPIO_PMSR3_PMSR36_SHIFT                 (6u)
#define GPIO_PMSR3_PMSR37_SHIFT                 (7u)
#define GPIO_PMSR3_PMSR38_SHIFT                 (8u)
#define GPIO_PMSR3_PMSR39_SHIFT                 (9u)
#define GPIO_PMSR3_PMSR310_SHIFT                (10u)
#define GPIO_PMSR3_PMSR311_SHIFT                (11u)
#define GPIO_PMSR3_PMSR312_SHIFT                (12u)
#define GPIO_PMSR3_PMSR313_SHIFT                (13u)
#define GPIO_PMSR3_PMSR314_SHIFT                (14u)
#define GPIO_PMSR3_PMSR315_SHIFT                (15u)
#define GPIO_PMSR3_PMSR316_SHIFT                (16u)
#define GPIO_PMSR3_PMSR317_SHIFT                (17u)
#define GPIO_PMSR3_PMSR318_SHIFT                (18u)
#define GPIO_PMSR3_PMSR319_SHIFT                (19u)
#define GPIO_PMSR3_PMSR320_SHIFT                (20u)
#define GPIO_PMSR3_PMSR321_SHIFT                (21u)
#define GPIO_PMSR3_PMSR322_SHIFT                (22u)
#define GPIO_PMSR3_PMSR323_SHIFT                (23u)
#define GPIO_PMSR3_PMSR324_SHIFT                (24u)
#define GPIO_PMSR3_PMSR325_SHIFT                (25u)
#define GPIO_PMSR3_PMSR326_SHIFT                (26u)
#define GPIO_PMSR3_PMSR327_SHIFT                (27u)
#define GPIO_PMSR3_PMSR328_SHIFT                (28u)
#define GPIO_PMSR3_PMSR329_SHIFT                (29u)
#define GPIO_PMSR3_PMSR330_SHIFT                (30u)
#define GPIO_PMSR3_PMSR331_SHIFT                (31u)

#define GPIO_PMCSR3_PMCSR30_SHIFT               (0u)
#define GPIO_PMCSR3_PMCSR31_SHIFT               (1u)
#define GPIO_PMCSR3_PMCSR32_SHIFT               (2u)
#define GPIO_PMCSR3_PMCSR33_SHIFT               (3u)
#define GPIO_PMCSR3_PMCSR34_SHIFT               (4u)
#define GPIO_PMCSR3_PMCSR35_SHIFT               (5u)
#define GPIO_PMCSR3_PMCSR36_SHIFT               (6u)
#define GPIO_PMCSR3_PMCSR37_SHIFT               (7u)
#define GPIO_PMCSR3_PMCSR38_SHIFT               (8u)
#define GPIO_PMCSR3_PMCSR39_SHIFT               (9u)
#define GPIO_PMCSR3_PMCSR310_SHIFT              (10u)
#define GPIO_PMCSR3_PMCSR311_SHIFT              (11u)
#define GPIO_PMCSR3_PMCSR312_SHIFT              (12u)
#define GPIO_PMCSR3_PMCSR313_SHIFT              (13u)
#define GPIO_PMCSR3_PMCSR314_SHIFT              (14u)
#define GPIO_PMCSR3_PMCSR315_SHIFT              (15u)
#define GPIO_PMCSR3_PMCSR316_SHIFT              (16u)
#define GPIO_PMCSR3_PMCSR317_SHIFT              (17u)
#define GPIO_PMCSR3_PMCSR318_SHIFT              (18u)
#define GPIO_PMCSR3_PMCSR319_SHIFT              (19u)
#define GPIO_PMCSR3_PMCSR320_SHIFT              (20u)
#define GPIO_PMCSR3_PMCSR321_SHIFT              (21u)
#define GPIO_PMCSR3_PMCSR322_SHIFT              (22u)
#define GPIO_PMCSR3_PMCSR323_SHIFT              (23u)
#define GPIO_PMCSR3_PMCSR324_SHIFT              (24u)
#define GPIO_PMCSR3_PMCSR325_SHIFT              (25u)
#define GPIO_PMCSR3_PMCSR326_SHIFT              (26u)
#define GPIO_PMCSR3_PMCSR327_SHIFT              (27u)
#define GPIO_PMCSR3_PMCSR328_SHIFT              (28u)
#define GPIO_PMCSR3_PMCSR329_SHIFT              (29u)
#define GPIO_PMCSR3_PMCSR330_SHIFT              (30u)
#define GPIO_PMCSR3_PMCSR331_SHIFT              (31u)

#define GPIO_PFCAE3_PFCAE30_SHIFT               (0u)
#define GPIO_PFCAE3_PFCAE31_SHIFT               (1u)
#define GPIO_PFCAE3_PFCAE32_SHIFT               (2u)
#define GPIO_PFCAE3_PFCAE33_SHIFT               (3u)
#define GPIO_PFCAE3_PFCAE34_SHIFT               (4u)
#define GPIO_PFCAE3_PFCAE35_SHIFT               (5u)
#define GPIO_PFCAE3_PFCAE36_SHIFT               (6u)
#define GPIO_PFCAE3_PFCAE37_SHIFT               (7u)
#define GPIO_PFCAE3_PFCAE38_SHIFT               (8u)
#define GPIO_PFCAE3_PFCAE39_SHIFT               (9u)
#define GPIO_PFCAE3_PFCAE310_SHIFT              (10u)
#define GPIO_PFCAE3_PFCAE311_SHIFT              (11u)
#define GPIO_PFCAE3_PFCAE312_SHIFT              (12u)
#define GPIO_PFCAE3_PFCAE313_SHIFT              (13u)
#define GPIO_PFCAE3_PFCAE314_SHIFT              (14u)
#define GPIO_PFCAE3_PFCAE315_SHIFT              (15u)

#define GPIO_PIBC3_PIBC30_SHIFT                 (0u)
#define GPIO_PIBC3_PIBC31_SHIFT                 (1u)
#define GPIO_PIBC3_PIBC32_SHIFT                 (2u)
#define GPIO_PIBC3_PIBC33_SHIFT                 (3u)
#define GPIO_PIBC3_PIBC34_SHIFT                 (4u)
#define GPIO_PIBC3_PIBC35_SHIFT                 (5u)
#define GPIO_PIBC3_PIBC36_SHIFT                 (6u)
#define GPIO_PIBC3_PIBC37_SHIFT                 (7u)
#define GPIO_PIBC3_PIBC38_SHIFT                 (8u)
#define GPIO_PIBC3_PIBC39_SHIFT                 (9u)
#define GPIO_PIBC3_PIBC310_SHIFT                (10u)
#define GPIO_PIBC3_PIBC311_SHIFT                (11u)
#define GPIO_PIBC3_PIBC312_SHIFT                (12u)
#define GPIO_PIBC3_PIBC313_SHIFT                (13u)
#define GPIO_PIBC3_PIBC314_SHIFT                (14u)
#define GPIO_PIBC3_PIBC315_SHIFT                (15u)

#define GPIO_PBDC3_PBDC30_SHIFT                 (0u)
#define GPIO_PBDC3_PBDC31_SHIFT                 (1u)
#define GPIO_PBDC3_PBDC32_SHIFT                 (2u)
#define GPIO_PBDC3_PBDC33_SHIFT                 (3u)
#define GPIO_PBDC3_PBDC34_SHIFT                 (4u)
#define GPIO_PBDC3_PBDC35_SHIFT                 (5u)
#define GPIO_PBDC3_PBDC36_SHIFT                 (6u)
#define GPIO_PBDC3_PBDC37_SHIFT                 (7u)
#define GPIO_PBDC3_PBDC38_SHIFT                 (8u)
#define GPIO_PBDC3_PBDC39_SHIFT                 (9u)
#define GPIO_PBDC3_PBDC310_SHIFT                (10u)
#define GPIO_PBDC3_PBDC311_SHIFT                (11u)
#define GPIO_PBDC3_PBDC312_SHIFT                (12u)
#define GPIO_PBDC3_PBDC313_SHIFT                (13u)
#define GPIO_PBDC3_PBDC314_SHIFT                (14u)
#define GPIO_PBDC3_PBDC315_SHIFT                (15u)

#define GPIO_PIPC3_PIPC30_SHIFT                 (0u)
#define GPIO_PIPC3_PIPC31_SHIFT                 (1u)
#define GPIO_PIPC3_PIPC32_SHIFT                 (2u)
#define GPIO_PIPC3_PIPC33_SHIFT                 (3u)
#define GPIO_PIPC3_PIPC34_SHIFT                 (4u)
#define GPIO_PIPC3_PIPC35_SHIFT                 (5u)
#define GPIO_PIPC3_PIPC36_SHIFT                 (6u)
#define GPIO_PIPC3_PIPC37_SHIFT                 (7u)
#define GPIO_PIPC3_PIPC38_SHIFT                 (8u)
#define GPIO_PIPC3_PIPC39_SHIFT                 (9u)
#define GPIO_PIPC3_PIPC310_SHIFT                (10u)
#define GPIO_PIPC3_PIPC311_SHIFT                (11u)
#define GPIO_PIPC3_PIPC312_SHIFT                (12u)
#define GPIO_PIPC3_PIPC313_SHIFT                (13u)
#define GPIO_PIPC3_PIPC314_SHIFT                (14u)
#define GPIO_PIPC3_PIPC315_SHIFT                (15u)

/* ---- P4 ---- */
#define GPIO_P4_P40_SHIFT                       (0u)
#define GPIO_P4_P41_SHIFT                       (1u)
#define GPIO_P4_P42_SHIFT                       (2u)
#define GPIO_P4_P43_SHIFT                       (3u)
#define GPIO_P4_P44_SHIFT                       (4u)
#define GPIO_P4_P45_SHIFT                       (5u)
#define GPIO_P4_P46_SHIFT                       (6u)
#define GPIO_P4_P47_SHIFT                       (7u)
#define GPIO_P4_P48_SHIFT                       (8u)
#define GPIO_P4_P49_SHIFT                       (9u)
#define GPIO_P4_P410_SHIFT                      (10u)
#define GPIO_P4_P411_SHIFT                      (11u)
#define GPIO_P4_P412_SHIFT                      (12u)
#define GPIO_P4_P413_SHIFT                      (13u)
#define GPIO_P4_P414_SHIFT                      (14u)
#define GPIO_P4_P415_SHIFT                      (15u)

#define GPIO_PSR4_PSR40_SHIFT                   (0u)
#define GPIO_PSR4_PSR41_SHIFT                   (1u)
#define GPIO_PSR4_PSR42_SHIFT                   (2u)
#define GPIO_PSR4_PSR43_SHIFT                   (3u)
#define GPIO_PSR4_PSR44_SHIFT                   (4u)
#define GPIO_PSR4_PSR45_SHIFT                   (5u)
#define GPIO_PSR4_PSR46_SHIFT                   (6u)
#define GPIO_PSR4_PSR47_SHIFT                   (7u)
#define GPIO_PSR4_PSR48_SHIFT                   (8u)
#define GPIO_PSR4_PSR49_SHIFT                   (9u)
#define GPIO_PSR4_PSR410_SHIFT                  (10u)
#define GPIO_PSR4_PSR411_SHIFT                  (11u)
#define GPIO_PSR4_PSR412_SHIFT                  (12u)
#define GPIO_PSR4_PSR413_SHIFT                  (13u)
#define GPIO_PSR4_PSR414_SHIFT                  (14u)
#define GPIO_PSR4_PSR415_SHIFT                  (15u)
#define GPIO_PSR4_PSR416_SHIFT                  (16u)
#define GPIO_PSR4_PSR417_SHIFT                  (17u)
#define GPIO_PSR4_PSR418_SHIFT                  (18u)
#define GPIO_PSR4_PSR419_SHIFT                  (19u)
#define GPIO_PSR4_PSR420_SHIFT                  (20u)
#define GPIO_PSR4_PSR421_SHIFT                  (21u)
#define GPIO_PSR4_PSR422_SHIFT                  (22u)
#define GPIO_PSR4_PSR423_SHIFT                  (23u)
#define GPIO_PSR4_PSR424_SHIFT                  (24u)
#define GPIO_PSR4_PSR425_SHIFT                  (25u)
#define GPIO_PSR4_PSR426_SHIFT                  (26u)
#define GPIO_PSR4_PSR427_SHIFT                  (27u)
#define GPIO_PSR4_PSR428_SHIFT                  (28u)
#define GPIO_PSR4_PSR429_SHIFT                  (29u)
#define GPIO_PSR4_PSR430_SHIFT                  (30u)
#define GPIO_PSR4_PSR431_SHIFT                  (31u)

#define GPIO_PPR4_PPR40_SHIFT                   (0u)
#define GPIO_PPR4_PPR41_SHIFT                   (1u)
#define GPIO_PPR4_PPR42_SHIFT                   (2u)
#define GPIO_PPR4_PPR43_SHIFT                   (3u)
#define GPIO_PPR4_PPR44_SHIFT                   (4u)
#define GPIO_PPR4_PPR45_SHIFT                   (5u)
#define GPIO_PPR4_PPR46_SHIFT                   (6u)
#define GPIO_PPR4_PPR47_SHIFT                   (7u)
#define GPIO_PPR4_PPR48_SHIFT                   (8u)
#define GPIO_PPR4_PPR49_SHIFT                   (9u)
#define GPIO_PPR4_PPR410_SHIFT                  (10u)
#define GPIO_PPR4_PPR411_SHIFT                  (11u)
#define GPIO_PPR4_PPR412_SHIFT                  (12u)
#define GPIO_PPR4_PPR413_SHIFT                  (13u)
#define GPIO_PPR4_PPR414_SHIFT                  (14u)
#define GPIO_PPR4_PPR415_SHIFT                  (15u)

#define GPIO_PM4_PM40_SHIFT                     (0u)
#define GPIO_PM4_PM41_SHIFT                     (1u)
#define GPIO_PM4_PM42_SHIFT                     (2u)
#define GPIO_PM4_PM43_SHIFT                     (3u)
#define GPIO_PM4_PM44_SHIFT                     (4u)
#define GPIO_PM4_PM45_SHIFT                     (5u)
#define GPIO_PM4_PM46_SHIFT                     (6u)
#define GPIO_PM4_PM47_SHIFT                     (7u)
#define GPIO_PM4_PM48_SHIFT                     (8u)
#define GPIO_PM4_PM49_SHIFT                     (9u)
#define GPIO_PM4_PM410_SHIFT                    (10u)
#define GPIO_PM4_PM411_SHIFT                    (11u)
#define GPIO_PM4_PM412_SHIFT                    (12u)
#define GPIO_PM4_PM413_SHIFT                    (13u)
#define GPIO_PM4_PM414_SHIFT                    (14u)
#define GPIO_PM4_PM415_SHIFT                    (15u)

#define GPIO_PMC4_PMC40_SHIFT                   (0u)
#define GPIO_PMC4_PMC41_SHIFT                   (1u)
#define GPIO_PMC4_PMC42_SHIFT                   (2u)
#define GPIO_PMC4_PMC43_SHIFT                   (3u)
#define GPIO_PMC4_PMC44_SHIFT                   (4u)
#define GPIO_PMC4_PMC45_SHIFT                   (5u)
#define GPIO_PMC4_PMC46_SHIFT                   (6u)
#define GPIO_PMC4_PMC47_SHIFT                   (7u)
#define GPIO_PMC4_PMC48_SHIFT                   (8u)
#define GPIO_PMC4_PMC49_SHIFT                   (9u)
#define GPIO_PMC4_PMC410_SHIFT                  (10u)
#define GPIO_PMC4_PMC411_SHIFT                  (11u)
#define GPIO_PMC4_PMC412_SHIFT                  (12u)
#define GPIO_PMC4_PMC413_SHIFT                  (13u)
#define GPIO_PMC4_PMC414_SHIFT                  (14u)
#define GPIO_PMC4_PMC415_SHIFT                  (15u)

#define GPIO_PFC4_PFC40_SHIFT                   (0u)
#define GPIO_PFC4_PFC41_SHIFT                   (1u)
#define GPIO_PFC4_PFC42_SHIFT                   (2u)
#define GPIO_PFC4_PFC43_SHIFT                   (3u)
#define GPIO_PFC4_PFC44_SHIFT                   (4u)
#define GPIO_PFC4_PFC45_SHIFT                   (5u)
#define GPIO_PFC4_PFC46_SHIFT                   (6u)
#define GPIO_PFC4_PFC47_SHIFT                   (7u)
#define GPIO_PFC4_PFC48_SHIFT                   (8u)
#define GPIO_PFC4_PFC49_SHIFT                   (9u)
#define GPIO_PFC4_PFC410_SHIFT                  (10u)
#define GPIO_PFC4_PFC411_SHIFT                  (11u)
#define GPIO_PFC4_PFC412_SHIFT                  (12u)
#define GPIO_PFC4_PFC413_SHIFT                  (13u)
#define GPIO_PFC4_PFC414_SHIFT                  (14u)
#define GPIO_PFC4_PFC415_SHIFT                  (15u)

#define GPIO_PFCE4_PFCE40_SHIFT                 (0u)
#define GPIO_PFCE4_PFCE41_SHIFT                 (1u)
#define GPIO_PFCE4_PFCE42_SHIFT                 (2u)
#define GPIO_PFCE4_PFCE43_SHIFT                 (3u)
#define GPIO_PFCE4_PFCE44_SHIFT                 (4u)
#define GPIO_PFCE4_PFCE45_SHIFT                 (5u)
#define GPIO_PFCE4_PFCE46_SHIFT                 (6u)
#define GPIO_PFCE4_PFCE47_SHIFT                 (7u)
#define GPIO_PFCE4_PFCE48_SHIFT                 (8u)
#define GPIO_PFCE4_PFCE49_SHIFT                 (9u)
#define GPIO_PFCE4_PFCE410_SHIFT                (10u)
#define GPIO_PFCE4_PFCE411_SHIFT                (11u)
#define GPIO_PFCE4_PFCE412_SHIFT                (12u)
#define GPIO_PFCE4_PFCE413_SHIFT                (13u)
#define GPIO_PFCE4_PFCE414_SHIFT                (14u)
#define GPIO_PFCE4_PFCE415_SHIFT                (15u)

#define GPIO_PNOT4_PNOT40_SHIFT                 (0u)
#define GPIO_PNOT4_PNOT41_SHIFT                 (1u)
#define GPIO_PNOT4_PNOT42_SHIFT                 (2u)
#define GPIO_PNOT4_PNOT43_SHIFT                 (3u)
#define GPIO_PNOT4_PNOT44_SHIFT                 (4u)
#define GPIO_PNOT4_PNOT45_SHIFT                 (5u)
#define GPIO_PNOT4_PNOT46_SHIFT                 (6u)
#define GPIO_PNOT4_PNOT47_SHIFT                 (7u)
#define GPIO_PNOT4_PNOT48_SHIFT                 (8u)
#define GPIO_PNOT4_PNOT49_SHIFT                 (9u)
#define GPIO_PNOT4_PNOT410_SHIFT                (10u)
#define GPIO_PNOT4_PNOT411_SHIFT                (11u)
#define GPIO_PNOT4_PNOT412_SHIFT                (12u)
#define GPIO_PNOT4_PNOT413_SHIFT                (13u)
#define GPIO_PNOT4_PNOT414_SHIFT                (14u)
#define GPIO_PNOT4_PNOT415_SHIFT                (15u)

#define GPIO_PMSR4_PMSR40_SHIFT                 (0u)
#define GPIO_PMSR4_PMSR41_SHIFT                 (1u)
#define GPIO_PMSR4_PMSR42_SHIFT                 (2u)
#define GPIO_PMSR4_PMSR43_SHIFT                 (3u)
#define GPIO_PMSR4_PMSR44_SHIFT                 (4u)
#define GPIO_PMSR4_PMSR45_SHIFT                 (5u)
#define GPIO_PMSR4_PMSR46_SHIFT                 (6u)
#define GPIO_PMSR4_PMSR47_SHIFT                 (7u)
#define GPIO_PMSR4_PMSR48_SHIFT                 (8u)
#define GPIO_PMSR4_PMSR49_SHIFT                 (9u)
#define GPIO_PMSR4_PMSR410_SHIFT                (10u)
#define GPIO_PMSR4_PMSR411_SHIFT                (11u)
#define GPIO_PMSR4_PMSR412_SHIFT                (12u)
#define GPIO_PMSR4_PMSR413_SHIFT                (13u)
#define GPIO_PMSR4_PMSR414_SHIFT                (14u)
#define GPIO_PMSR4_PMSR415_SHIFT                (15u)
#define GPIO_PMSR4_PMSR416_SHIFT                (16u)
#define GPIO_PMSR4_PMSR417_SHIFT                (17u)
#define GPIO_PMSR4_PMSR418_SHIFT                (18u)
#define GPIO_PMSR4_PMSR419_SHIFT                (19u)
#define GPIO_PMSR4_PMSR420_SHIFT                (20u)
#define GPIO_PMSR4_PMSR421_SHIFT                (21u)
#define GPIO_PMSR4_PMSR422_SHIFT                (22u)
#define GPIO_PMSR4_PMSR423_SHIFT                (23u)
#define GPIO_PMSR4_PMSR424_SHIFT                (24u)
#define GPIO_PMSR4_PMSR425_SHIFT                (25u)
#define GPIO_PMSR4_PMSR426_SHIFT                (26u)
#define GPIO_PMSR4_PMSR427_SHIFT                (27u)
#define GPIO_PMSR4_PMSR428_SHIFT                (28u)
#define GPIO_PMSR4_PMSR429_SHIFT                (29u)
#define GPIO_PMSR4_PMSR430_SHIFT                (30u)
#define GPIO_PMSR4_PMSR431_SHIFT                (31u)

#define GPIO_PMCSR4_PMCSR40_SHIFT               (0u)
#define GPIO_PMCSR4_PMCSR41_SHIFT               (1u)
#define GPIO_PMCSR4_PMCSR42_SHIFT               (2u)
#define GPIO_PMCSR4_PMCSR43_SHIFT               (3u)
#define GPIO_PMCSR4_PMCSR44_SHIFT               (4u)
#define GPIO_PMCSR4_PMCSR45_SHIFT               (5u)
#define GPIO_PMCSR4_PMCSR46_SHIFT               (6u)
#define GPIO_PMCSR4_PMCSR47_SHIFT               (7u)
#define GPIO_PMCSR4_PMCSR48_SHIFT               (8u)
#define GPIO_PMCSR4_PMCSR49_SHIFT               (9u)
#define GPIO_PMCSR4_PMCSR410_SHIFT              (10u)
#define GPIO_PMCSR4_PMCSR411_SHIFT              (11u)
#define GPIO_PMCSR4_PMCSR412_SHIFT              (12u)
#define GPIO_PMCSR4_PMCSR413_SHIFT              (13u)
#define GPIO_PMCSR4_PMCSR414_SHIFT              (14u)
#define GPIO_PMCSR4_PMCSR415_SHIFT              (15u)
#define GPIO_PMCSR4_PMCSR416_SHIFT              (16u)
#define GPIO_PMCSR4_PMCSR417_SHIFT              (17u)
#define GPIO_PMCSR4_PMCSR418_SHIFT              (18u)
#define GPIO_PMCSR4_PMCSR419_SHIFT              (19u)
#define GPIO_PMCSR4_PMCSR420_SHIFT              (20u)
#define GPIO_PMCSR4_PMCSR421_SHIFT              (21u)
#define GPIO_PMCSR4_PMCSR422_SHIFT              (22u)
#define GPIO_PMCSR4_PMCSR423_SHIFT              (23u)
#define GPIO_PMCSR4_PMCSR424_SHIFT              (24u)
#define GPIO_PMCSR4_PMCSR425_SHIFT              (25u)
#define GPIO_PMCSR4_PMCSR426_SHIFT              (26u)
#define GPIO_PMCSR4_PMCSR427_SHIFT              (27u)
#define GPIO_PMCSR4_PMCSR428_SHIFT              (28u)
#define GPIO_PMCSR4_PMCSR429_SHIFT              (29u)
#define GPIO_PMCSR4_PMCSR430_SHIFT              (30u)
#define GPIO_PMCSR4_PMCSR431_SHIFT              (31u)

#define GPIO_PFCAE4_PFCAE40_SHIFT               (0u)
#define GPIO_PFCAE4_PFCAE41_SHIFT               (1u)
#define GPIO_PFCAE4_PFCAE42_SHIFT               (2u)
#define GPIO_PFCAE4_PFCAE43_SHIFT               (3u)
#define GPIO_PFCAE4_PFCAE44_SHIFT               (4u)
#define GPIO_PFCAE4_PFCAE45_SHIFT               (5u)
#define GPIO_PFCAE4_PFCAE46_SHIFT               (6u)
#define GPIO_PFCAE4_PFCAE47_SHIFT               (7u)
#define GPIO_PFCAE4_PFCAE48_SHIFT               (8u)
#define GPIO_PFCAE4_PFCAE49_SHIFT               (9u)
#define GPIO_PFCAE4_PFCAE410_SHIFT              (10u)
#define GPIO_PFCAE4_PFCAE411_SHIFT              (11u)
#define GPIO_PFCAE4_PFCAE412_SHIFT              (12u)
#define GPIO_PFCAE4_PFCAE413_SHIFT              (13u)
#define GPIO_PFCAE4_PFCAE414_SHIFT              (14u)
#define GPIO_PFCAE4_PFCAE415_SHIFT              (15u)

#define GPIO_PIBC4_PIBC40_SHIFT                 (0u)
#define GPIO_PIBC4_PIBC41_SHIFT                 (1u)
#define GPIO_PIBC4_PIBC42_SHIFT                 (2u)
#define GPIO_PIBC4_PIBC43_SHIFT                 (3u)
#define GPIO_PIBC4_PIBC44_SHIFT                 (4u)
#define GPIO_PIBC4_PIBC45_SHIFT                 (5u)
#define GPIO_PIBC4_PIBC46_SHIFT                 (6u)
#define GPIO_PIBC4_PIBC47_SHIFT                 (7u)
#define GPIO_PIBC4_PIBC48_SHIFT                 (8u)
#define GPIO_PIBC4_PIBC49_SHIFT                 (9u)
#define GPIO_PIBC4_PIBC410_SHIFT                (10u)
#define GPIO_PIBC4_PIBC411_SHIFT                (11u)
#define GPIO_PIBC4_PIBC412_SHIFT                (12u)
#define GPIO_PIBC4_PIBC413_SHIFT                (13u)
#define GPIO_PIBC4_PIBC414_SHIFT                (14u)
#define GPIO_PIBC4_PIBC415_SHIFT                (15u)

#define GPIO_PBDC4_PBDC40_SHIFT                 (0u)
#define GPIO_PBDC4_PBDC41_SHIFT                 (1u)
#define GPIO_PBDC4_PBDC42_SHIFT                 (2u)
#define GPIO_PBDC4_PBDC43_SHIFT                 (3u)
#define GPIO_PBDC4_PBDC44_SHIFT                 (4u)
#define GPIO_PBDC4_PBDC45_SHIFT                 (5u)
#define GPIO_PBDC4_PBDC46_SHIFT                 (6u)
#define GPIO_PBDC4_PBDC47_SHIFT                 (7u)
#define GPIO_PBDC4_PBDC48_SHIFT                 (8u)
#define GPIO_PBDC4_PBDC49_SHIFT                 (9u)
#define GPIO_PBDC4_PBDC410_SHIFT                (10u)
#define GPIO_PBDC4_PBDC411_SHIFT                (11u)
#define GPIO_PBDC4_PBDC412_SHIFT                (12u)
#define GPIO_PBDC4_PBDC413_SHIFT                (13u)
#define GPIO_PBDC4_PBDC414_SHIFT                (14u)
#define GPIO_PBDC4_PBDC415_SHIFT                (15u)

#define GPIO_PIPC4_PIPC40_SHIFT                 (0u)
#define GPIO_PIPC4_PIPC41_SHIFT                 (1u)
#define GPIO_PIPC4_PIPC42_SHIFT                 (2u)
#define GPIO_PIPC4_PIPC43_SHIFT                 (3u)
#define GPIO_PIPC4_PIPC44_SHIFT                 (4u)
#define GPIO_PIPC4_PIPC45_SHIFT                 (5u)
#define GPIO_PIPC4_PIPC46_SHIFT                 (6u)
#define GPIO_PIPC4_PIPC47_SHIFT                 (7u)
#define GPIO_PIPC4_PIPC48_SHIFT                 (8u)
#define GPIO_PIPC4_PIPC49_SHIFT                 (9u)
#define GPIO_PIPC4_PIPC410_SHIFT                (10u)
#define GPIO_PIPC4_PIPC411_SHIFT                (11u)
#define GPIO_PIPC4_PIPC412_SHIFT                (12u)
#define GPIO_PIPC4_PIPC413_SHIFT                (13u)
#define GPIO_PIPC4_PIPC414_SHIFT                (14u)
#define GPIO_PIPC4_PIPC415_SHIFT                (15u)

/* ---- P5 ---- */
#define GPIO_P5_P50_SHIFT                       (0u)
#define GPIO_P5_P51_SHIFT                       (1u)
#define GPIO_P5_P52_SHIFT                       (2u)
#define GPIO_P5_P53_SHIFT                       (3u)
#define GPIO_P5_P54_SHIFT                       (4u)
#define GPIO_P5_P55_SHIFT                       (5u)
#define GPIO_P5_P56_SHIFT                       (6u)
#define GPIO_P5_P57_SHIFT                       (7u)
#define GPIO_P5_P58_SHIFT                       (8u)
#define GPIO_P5_P59_SHIFT                       (9u)
#define GPIO_P5_P510_SHIFT                      (10u)

#define GPIO_PSR5_PSR50_SHIFT                   (0u)
#define GPIO_PSR5_PSR51_SHIFT                   (1u)
#define GPIO_PSR5_PSR52_SHIFT                   (2u)
#define GPIO_PSR5_PSR53_SHIFT                   (3u)
#define GPIO_PSR5_PSR54_SHIFT                   (4u)
#define GPIO_PSR5_PSR55_SHIFT                   (5u)
#define GPIO_PSR5_PSR56_SHIFT                   (6u)
#define GPIO_PSR5_PSR57_SHIFT                   (7u)
#define GPIO_PSR5_PSR58_SHIFT                   (8u)
#define GPIO_PSR5_PSR59_SHIFT                   (9u)
#define GPIO_PSR5_PSR510_SHIFT                  (10u)
#define GPIO_PSR5_PSR516_SHIFT                  (16u)
#define GPIO_PSR5_PSR517_SHIFT                  (17u)
#define GPIO_PSR5_PSR518_SHIFT                  (18u)
#define GPIO_PSR5_PSR519_SHIFT                  (19u)
#define GPIO_PSR5_PSR520_SHIFT                  (20u)
#define GPIO_PSR5_PSR521_SHIFT                  (21u)
#define GPIO_PSR5_PSR522_SHIFT                  (22u)
#define GPIO_PSR5_PSR523_SHIFT                  (23u)
#define GPIO_PSR5_PSR524_SHIFT                  (24u)
#define GPIO_PSR5_PSR525_SHIFT                  (25u)
#define GPIO_PSR5_PSR526_SHIFT                  (26u)

#define GPIO_PPR5_PPR50_SHIFT                   (0u)
#define GPIO_PPR5_PPR51_SHIFT                   (1u)
#define GPIO_PPR5_PPR52_SHIFT                   (2u)
#define GPIO_PPR5_PPR53_SHIFT                   (3u)
#define GPIO_PPR5_PPR54_SHIFT                   (4u)
#define GPIO_PPR5_PPR55_SHIFT                   (5u)
#define GPIO_PPR5_PPR56_SHIFT                   (6u)
#define GPIO_PPR5_PPR57_SHIFT                   (7u)
#define GPIO_PPR5_PPR58_SHIFT                   (8u)
#define GPIO_PPR5_PPR59_SHIFT                   (9u)
#define GPIO_PPR5_PPR510_SHIFT                  (10u)

#define GPIO_PM5_PM50_SHIFT                     (0u)
#define GPIO_PM5_PM51_SHIFT                     (1u)
#define GPIO_PM5_PM52_SHIFT                     (2u)
#define GPIO_PM5_PM53_SHIFT                     (3u)
#define GPIO_PM5_PM54_SHIFT                     (4u)
#define GPIO_PM5_PM55_SHIFT                     (5u)
#define GPIO_PM5_PM56_SHIFT                     (6u)
#define GPIO_PM5_PM57_SHIFT                     (7u)
#define GPIO_PM5_PM58_SHIFT                     (8u)
#define GPIO_PM5_PM59_SHIFT                     (9u)
#define GPIO_PM5_PM510_SHIFT                    (10u)

#define GPIO_PMC5_PMC50_SHIFT                   (0u)
#define GPIO_PMC5_PMC51_SHIFT                   (1u)
#define GPIO_PMC5_PMC52_SHIFT                   (2u)
#define GPIO_PMC5_PMC53_SHIFT                   (3u)
#define GPIO_PMC5_PMC54_SHIFT                   (4u)
#define GPIO_PMC5_PMC55_SHIFT                   (5u)
#define GPIO_PMC5_PMC56_SHIFT                   (6u)
#define GPIO_PMC5_PMC57_SHIFT                   (7u)
#define GPIO_PMC5_PMC58_SHIFT                   (8u)
#define GPIO_PMC5_PMC59_SHIFT                   (9u)
#define GPIO_PMC5_PMC510_SHIFT                  (10u)

#define GPIO_PFC5_PFC50_SHIFT                   (0u)
#define GPIO_PFC5_PFC51_SHIFT                   (1u)
#define GPIO_PFC5_PFC52_SHIFT                   (2u)
#define GPIO_PFC5_PFC53_SHIFT                   (3u)
#define GPIO_PFC5_PFC54_SHIFT                   (4u)
#define GPIO_PFC5_PFC55_SHIFT                   (5u)
#define GPIO_PFC5_PFC56_SHIFT                   (6u)
#define GPIO_PFC5_PFC57_SHIFT                   (7u)
#define GPIO_PFC5_PFC58_SHIFT                   (8u)
#define GPIO_PFC5_PFC59_SHIFT                   (9u)
#define GPIO_PFC5_PFC510_SHIFT                  (10u)

#define GPIO_PFCE5_PFCE50_SHIFT                 (0u)
#define GPIO_PFCE5_PFCE51_SHIFT                 (1u)
#define GPIO_PFCE5_PFCE52_SHIFT                 (2u)
#define GPIO_PFCE5_PFCE53_SHIFT                 (3u)
#define GPIO_PFCE5_PFCE54_SHIFT                 (4u)
#define GPIO_PFCE5_PFCE55_SHIFT                 (5u)
#define GPIO_PFCE5_PFCE56_SHIFT                 (6u)
#define GPIO_PFCE5_PFCE57_SHIFT                 (7u)
#define GPIO_PFCE5_PFCE58_SHIFT                 (8u)
#define GPIO_PFCE5_PFCE59_SHIFT                 (9u)
#define GPIO_PFCE5_PFCE510_SHIFT                (10u)

#define GPIO_PNOT5_PNOT50_SHIFT                 (0u)
#define GPIO_PNOT5_PNOT51_SHIFT                 (1u)
#define GPIO_PNOT5_PNOT52_SHIFT                 (2u)
#define GPIO_PNOT5_PNOT53_SHIFT                 (3u)
#define GPIO_PNOT5_PNOT54_SHIFT                 (4u)
#define GPIO_PNOT5_PNOT55_SHIFT                 (5u)
#define GPIO_PNOT5_PNOT56_SHIFT                 (6u)
#define GPIO_PNOT5_PNOT57_SHIFT                 (7u)
#define GPIO_PNOT5_PNOT58_SHIFT                 (8u)
#define GPIO_PNOT5_PNOT59_SHIFT                 (9u)
#define GPIO_PNOT5_PNOT510_SHIFT                (10u)

#define GPIO_PMSR5_PMSR50_SHIFT                 (0u)
#define GPIO_PMSR5_PMSR51_SHIFT                 (1u)
#define GPIO_PMSR5_PMSR52_SHIFT                 (2u)
#define GPIO_PMSR5_PMSR53_SHIFT                 (3u)
#define GPIO_PMSR5_PMSR54_SHIFT                 (4u)
#define GPIO_PMSR5_PMSR55_SHIFT                 (5u)
#define GPIO_PMSR5_PMSR56_SHIFT                 (6u)
#define GPIO_PMSR5_PMSR57_SHIFT                 (7u)
#define GPIO_PMSR5_PMSR58_SHIFT                 (8u)
#define GPIO_PMSR5_PMSR59_SHIFT                 (9u)
#define GPIO_PMSR5_PMSR510_SHIFT                (10u)
#define GPIO_PMSR5_PMSR516_SHIFT                (16u)
#define GPIO_PMSR5_PMSR517_SHIFT                (17u)
#define GPIO_PMSR5_PMSR518_SHIFT                (18u)
#define GPIO_PMSR5_PMSR519_SHIFT                (19u)
#define GPIO_PMSR5_PMSR520_SHIFT                (20u)
#define GPIO_PMSR5_PMSR521_SHIFT                (21u)
#define GPIO_PMSR5_PMSR522_SHIFT                (22u)
#define GPIO_PMSR5_PMSR523_SHIFT                (23u)
#define GPIO_PMSR5_PMSR524_SHIFT                (24u)
#define GPIO_PMSR5_PMSR525_SHIFT                (25u)
#define GPIO_PMSR5_PMSR526_SHIFT                (26u)

#define GPIO_PMCSR5_PMCSR50_SHIFT               (0u)
#define GPIO_PMCSR5_PMCSR51_SHIFT               (1u)
#define GPIO_PMCSR5_PMCSR52_SHIFT               (2u)
#define GPIO_PMCSR5_PMCSR53_SHIFT               (3u)
#define GPIO_PMCSR5_PMCSR54_SHIFT               (4u)
#define GPIO_PMCSR5_PMCSR55_SHIFT               (5u)
#define GPIO_PMCSR5_PMCSR56_SHIFT               (6u)
#define GPIO_PMCSR5_PMCSR57_SHIFT               (7u)
#define GPIO_PMCSR5_PMCSR58_SHIFT               (8u)
#define GPIO_PMCSR5_PMCSR59_SHIFT               (9u)
#define GPIO_PMCSR5_PMCSR510_SHIFT              (10u)
#define GPIO_PMCSR5_PMCSR516_SHIFT              (16u)
#define GPIO_PMCSR5_PMCSR517_SHIFT              (17u)
#define GPIO_PMCSR5_PMCSR518_SHIFT              (18u)
#define GPIO_PMCSR5_PMCSR519_SHIFT              (19u)
#define GPIO_PMCSR5_PMCSR520_SHIFT              (20u)
#define GPIO_PMCSR5_PMCSR521_SHIFT              (21u)
#define GPIO_PMCSR5_PMCSR522_SHIFT              (22u)
#define GPIO_PMCSR5_PMCSR523_SHIFT              (23u)
#define GPIO_PMCSR5_PMCSR524_SHIFT              (24u)
#define GPIO_PMCSR5_PMCSR525_SHIFT              (25u)
#define GPIO_PMCSR5_PMCSR526_SHIFT              (26u)

#define GPIO_PFCAE5_PFCAE50_SHIFT               (0u)
#define GPIO_PFCAE5_PFCAE51_SHIFT               (1u)
#define GPIO_PFCAE5_PFCAE52_SHIFT               (2u)
#define GPIO_PFCAE5_PFCAE53_SHIFT               (3u)
#define GPIO_PFCAE5_PFCAE54_SHIFT               (4u)
#define GPIO_PFCAE5_PFCAE55_SHIFT               (5u)
#define GPIO_PFCAE5_PFCAE56_SHIFT               (6u)
#define GPIO_PFCAE5_PFCAE57_SHIFT               (7u)
#define GPIO_PFCAE5_PFCAE58_SHIFT               (8u)
#define GPIO_PFCAE5_PFCAE59_SHIFT               (9u)
#define GPIO_PFCAE5_PFCAE510_SHIFT              (10u)

#define GPIO_PIBC5_PIBC50_SHIFT                 (0u)
#define GPIO_PIBC5_PIBC51_SHIFT                 (1u)
#define GPIO_PIBC5_PIBC52_SHIFT                 (2u)
#define GPIO_PIBC5_PIBC53_SHIFT                 (3u)
#define GPIO_PIBC5_PIBC54_SHIFT                 (4u)
#define GPIO_PIBC5_PIBC55_SHIFT                 (5u)
#define GPIO_PIBC5_PIBC56_SHIFT                 (6u)
#define GPIO_PIBC5_PIBC57_SHIFT                 (7u)
#define GPIO_PIBC5_PIBC58_SHIFT                 (8u)
#define GPIO_PIBC5_PIBC59_SHIFT                 (9u)
#define GPIO_PIBC5_PIBC510_SHIFT                (10u)

#define GPIO_PBDC5_PBDC50_SHIFT                 (0u)
#define GPIO_PBDC5_PBDC51_SHIFT                 (1u)
#define GPIO_PBDC5_PBDC52_SHIFT                 (2u)
#define GPIO_PBDC5_PBDC53_SHIFT                 (3u)
#define GPIO_PBDC5_PBDC54_SHIFT                 (4u)
#define GPIO_PBDC5_PBDC55_SHIFT                 (5u)
#define GPIO_PBDC5_PBDC56_SHIFT                 (6u)
#define GPIO_PBDC5_PBDC57_SHIFT                 (7u)
#define GPIO_PBDC5_PBDC58_SHIFT                 (8u)
#define GPIO_PBDC5_PBDC59_SHIFT                 (9u)
#define GPIO_PBDC5_PBDC510_SHIFT                (10u)

#define GPIO_PIPC5_PIPC50_SHIFT                 (0u)
#define GPIO_PIPC5_PIPC51_SHIFT                 (1u)
#define GPIO_PIPC5_PIPC52_SHIFT                 (2u)
#define GPIO_PIPC5_PIPC53_SHIFT                 (3u)
#define GPIO_PIPC5_PIPC54_SHIFT                 (4u)
#define GPIO_PIPC5_PIPC55_SHIFT                 (5u)
#define GPIO_PIPC5_PIPC56_SHIFT                 (6u)
#define GPIO_PIPC5_PIPC57_SHIFT                 (7u)
#define GPIO_PIPC5_PIPC58_SHIFT                 (8u)
#define GPIO_PIPC5_PIPC59_SHIFT                 (9u)
#define GPIO_PIPC5_PIPC510_SHIFT                (10u)

/* ---- P6 ---- */
#define GPIO_P6_P60_SHIFT                       (0u)
#define GPIO_P6_P61_SHIFT                       (1u)
#define GPIO_P6_P62_SHIFT                       (2u)
#define GPIO_P6_P63_SHIFT                       (3u)
#define GPIO_P6_P64_SHIFT                       (4u)
#define GPIO_P6_P65_SHIFT                       (5u)
#define GPIO_P6_P66_SHIFT                       (6u)
#define GPIO_P6_P67_SHIFT                       (7u)
#define GPIO_P6_P68_SHIFT                       (8u)
#define GPIO_P6_P69_SHIFT                       (9u)
#define GPIO_P6_P610_SHIFT                      (10u)
#define GPIO_P6_P611_SHIFT                      (11u)
#define GPIO_P6_P612_SHIFT                      (12u)
#define GPIO_P6_P613_SHIFT                      (13u)
#define GPIO_P6_P614_SHIFT                      (14u)
#define GPIO_P6_P615_SHIFT                      (15u)

#define GPIO_PSR6_PSR60_SHIFT                   (0u)
#define GPIO_PSR6_PSR61_SHIFT                   (1u)
#define GPIO_PSR6_PSR62_SHIFT                   (2u)
#define GPIO_PSR6_PSR63_SHIFT                   (3u)
#define GPIO_PSR6_PSR64_SHIFT                   (4u)
#define GPIO_PSR6_PSR65_SHIFT                   (5u)
#define GPIO_PSR6_PSR66_SHIFT                   (6u)
#define GPIO_PSR6_PSR67_SHIFT                   (7u)
#define GPIO_PSR6_PSR68_SHIFT                   (8u)
#define GPIO_PSR6_PSR69_SHIFT                   (9u)
#define GPIO_PSR6_PSR610_SHIFT                  (10u)
#define GPIO_PSR6_PSR611_SHIFT                  (11u)
#define GPIO_PSR6_PSR612_SHIFT                  (12u)
#define GPIO_PSR6_PSR613_SHIFT                  (13u)
#define GPIO_PSR6_PSR614_SHIFT                  (14u)
#define GPIO_PSR6_PSR615_SHIFT                  (15u)
#define GPIO_PSR6_PSR616_SHIFT                  (16u)
#define GPIO_PSR6_PSR617_SHIFT                  (17u)
#define GPIO_PSR6_PSR618_SHIFT                  (18u)
#define GPIO_PSR6_PSR619_SHIFT                  (19u)
#define GPIO_PSR6_PSR620_SHIFT                  (20u)
#define GPIO_PSR6_PSR621_SHIFT                  (21u)
#define GPIO_PSR6_PSR622_SHIFT                  (22u)
#define GPIO_PSR6_PSR623_SHIFT                  (23u)
#define GPIO_PSR6_PSR624_SHIFT                  (24u)
#define GPIO_PSR6_PSR625_SHIFT                  (25u)
#define GPIO_PSR6_PSR626_SHIFT                  (26u)
#define GPIO_PSR6_PSR627_SHIFT                  (27u)
#define GPIO_PSR6_PSR628_SHIFT                  (28u)
#define GPIO_PSR6_PSR629_SHIFT                  (29u)
#define GPIO_PSR6_PSR630_SHIFT                  (30u)
#define GPIO_PSR6_PSR631_SHIFT                  (31u)

#define GPIO_PPR6_PPR60_SHIFT                   (0u)
#define GPIO_PPR6_PPR61_SHIFT                   (1u)
#define GPIO_PPR6_PPR62_SHIFT                   (2u)
#define GPIO_PPR6_PPR63_SHIFT                   (3u)
#define GPIO_PPR6_PPR64_SHIFT                   (4u)
#define GPIO_PPR6_PPR65_SHIFT                   (5u)
#define GPIO_PPR6_PPR66_SHIFT                   (6u)
#define GPIO_PPR6_PPR67_SHIFT                   (7u)
#define GPIO_PPR6_PPR68_SHIFT                   (8u)
#define GPIO_PPR6_PPR69_SHIFT                   (9u)
#define GPIO_PPR6_PPR610_SHIFT                  (10u)
#define GPIO_PPR6_PPR611_SHIFT                  (11u)
#define GPIO_PPR6_PPR612_SHIFT                  (12u)
#define GPIO_PPR6_PPR613_SHIFT                  (13u)
#define GPIO_PPR6_PPR614_SHIFT                  (14u)
#define GPIO_PPR6_PPR615_SHIFT                  (15u)

#define GPIO_PM6_PM60_SHIFT                     (0u)
#define GPIO_PM6_PM61_SHIFT                     (1u)
#define GPIO_PM6_PM62_SHIFT                     (2u)
#define GPIO_PM6_PM63_SHIFT                     (3u)
#define GPIO_PM6_PM64_SHIFT                     (4u)
#define GPIO_PM6_PM65_SHIFT                     (5u)
#define GPIO_PM6_PM66_SHIFT                     (6u)
#define GPIO_PM6_PM67_SHIFT                     (7u)
#define GPIO_PM6_PM68_SHIFT                     (8u)
#define GPIO_PM6_PM69_SHIFT                     (9u)
#define GPIO_PM6_PM610_SHIFT                    (10u)
#define GPIO_PM6_PM611_SHIFT                    (11u)
#define GPIO_PM6_PM612_SHIFT                    (12u)
#define GPIO_PM6_PM613_SHIFT                    (13u)
#define GPIO_PM6_PM614_SHIFT                    (14u)
#define GPIO_PM6_PM615_SHIFT                    (15u)

#define GPIO_PMC6_PMC60_SHIFT                   (0u)
#define GPIO_PMC6_PMC61_SHIFT                   (1u)
#define GPIO_PMC6_PMC62_SHIFT                   (2u)
#define GPIO_PMC6_PMC63_SHIFT                   (3u)
#define GPIO_PMC6_PMC64_SHIFT                   (4u)
#define GPIO_PMC6_PMC65_SHIFT                   (5u)
#define GPIO_PMC6_PMC66_SHIFT                   (6u)
#define GPIO_PMC6_PMC67_SHIFT                   (7u)
#define GPIO_PMC6_PMC68_SHIFT                   (8u)
#define GPIO_PMC6_PMC69_SHIFT                   (9u)
#define GPIO_PMC6_PMC610_SHIFT                  (10u)
#define GPIO_PMC6_PMC611_SHIFT                  (11u)
#define GPIO_PMC6_PMC612_SHIFT                  (12u)
#define GPIO_PMC6_PMC613_SHIFT                  (13u)
#define GPIO_PMC6_PMC614_SHIFT                  (14u)
#define GPIO_PMC6_PMC615_SHIFT                  (15u)

#define GPIO_PFC6_PFC60_SHIFT                   (0u)
#define GPIO_PFC6_PFC61_SHIFT                   (1u)
#define GPIO_PFC6_PFC62_SHIFT                   (2u)
#define GPIO_PFC6_PFC63_SHIFT                   (3u)
#define GPIO_PFC6_PFC64_SHIFT                   (4u)
#define GPIO_PFC6_PFC65_SHIFT                   (5u)
#define GPIO_PFC6_PFC66_SHIFT                   (6u)
#define GPIO_PFC6_PFC67_SHIFT                   (7u)
#define GPIO_PFC6_PFC68_SHIFT                   (8u)
#define GPIO_PFC6_PFC69_SHIFT                   (9u)
#define GPIO_PFC6_PFC610_SHIFT                  (10u)
#define GPIO_PFC6_PFC611_SHIFT                  (11u)
#define GPIO_PFC6_PFC612_SHIFT                  (12u)
#define GPIO_PFC6_PFC613_SHIFT                  (13u)
#define GPIO_PFC6_PFC614_SHIFT                  (14u)
#define GPIO_PFC6_PFC615_SHIFT                  (15u)

#define GPIO_PFCE6_PFCE60_SHIFT                 (0u)
#define GPIO_PFCE6_PFCE61_SHIFT                 (1u)
#define GPIO_PFCE6_PFCE62_SHIFT                 (2u)
#define GPIO_PFCE6_PFCE63_SHIFT                 (3u)
#define GPIO_PFCE6_PFCE64_SHIFT                 (4u)
#define GPIO_PFCE6_PFCE65_SHIFT                 (5u)
#define GPIO_PFCE6_PFCE66_SHIFT                 (6u)
#define GPIO_PFCE6_PFCE67_SHIFT                 (7u)
#define GPIO_PFCE6_PFCE68_SHIFT                 (8u)
#define GPIO_PFCE6_PFCE69_SHIFT                 (9u)
#define GPIO_PFCE6_PFCE610_SHIFT                (10u)
#define GPIO_PFCE6_PFCE611_SHIFT                (11u)
#define GPIO_PFCE6_PFCE612_SHIFT                (12u)
#define GPIO_PFCE6_PFCE613_SHIFT                (13u)
#define GPIO_PFCE6_PFCE614_SHIFT                (14u)
#define GPIO_PFCE6_PFCE615_SHIFT                (15u)

#define GPIO_PNOT6_PNOT60_SHIFT                 (0u)
#define GPIO_PNOT6_PNOT61_SHIFT                 (1u)
#define GPIO_PNOT6_PNOT62_SHIFT                 (2u)
#define GPIO_PNOT6_PNOT63_SHIFT                 (3u)
#define GPIO_PNOT6_PNOT64_SHIFT                 (4u)
#define GPIO_PNOT6_PNOT65_SHIFT                 (5u)
#define GPIO_PNOT6_PNOT66_SHIFT                 (6u)
#define GPIO_PNOT6_PNOT67_SHIFT                 (7u)
#define GPIO_PNOT6_PNOT68_SHIFT                 (8u)
#define GPIO_PNOT6_PNOT69_SHIFT                 (9u)
#define GPIO_PNOT6_PNOT610_SHIFT                (10u)
#define GPIO_PNOT6_PNOT611_SHIFT                (11u)
#define GPIO_PNOT6_PNOT612_SHIFT                (12u)
#define GPIO_PNOT6_PNOT613_SHIFT                (13u)
#define GPIO_PNOT6_PNOT614_SHIFT                (14u)
#define GPIO_PNOT6_PNOT615_SHIFT                (15u)

#define GPIO_PMSR6_PMSR60_SHIFT                 (0u)
#define GPIO_PMSR6_PMSR61_SHIFT                 (1u)
#define GPIO_PMSR6_PMSR62_SHIFT                 (2u)
#define GPIO_PMSR6_PMSR63_SHIFT                 (3u)
#define GPIO_PMSR6_PMSR64_SHIFT                 (4u)
#define GPIO_PMSR6_PMSR65_SHIFT                 (5u)
#define GPIO_PMSR6_PMSR66_SHIFT                 (6u)
#define GPIO_PMSR6_PMSR67_SHIFT                 (7u)
#define GPIO_PMSR6_PMSR68_SHIFT                 (8u)
#define GPIO_PMSR6_PMSR69_SHIFT                 (9u)
#define GPIO_PMSR6_PMSR610_SHIFT                (10u)
#define GPIO_PMSR6_PMSR611_SHIFT                (11u)
#define GPIO_PMSR6_PMSR612_SHIFT                (12u)
#define GPIO_PMSR6_PMSR613_SHIFT                (13u)
#define GPIO_PMSR6_PMSR614_SHIFT                (14u)
#define GPIO_PMSR6_PMSR615_SHIFT                (15u)
#define GPIO_PMSR6_PMSR616_SHIFT                (16u)
#define GPIO_PMSR6_PMSR617_SHIFT                (17u)
#define GPIO_PMSR6_PMSR618_SHIFT                (18u)
#define GPIO_PMSR6_PMSR619_SHIFT                (19u)
#define GPIO_PMSR6_PMSR620_SHIFT                (20u)
#define GPIO_PMSR6_PMSR621_SHIFT                (21u)
#define GPIO_PMSR6_PMSR622_SHIFT                (22u)
#define GPIO_PMSR6_PMSR623_SHIFT                (23u)
#define GPIO_PMSR6_PMSR624_SHIFT                (24u)
#define GPIO_PMSR6_PMSR625_SHIFT                (25u)
#define GPIO_PMSR6_PMSR626_SHIFT                (26u)
#define GPIO_PMSR6_PMSR627_SHIFT                (27u)
#define GPIO_PMSR6_PMSR628_SHIFT                (28u)
#define GPIO_PMSR6_PMSR629_SHIFT                (29u)
#define GPIO_PMSR6_PMSR630_SHIFT                (30u)
#define GPIO_PMSR6_PMSR631_SHIFT                (31u)

#define GPIO_PMCSR6_PMCSR60_SHIFT               (0u)
#define GPIO_PMCSR6_PMCSR61_SHIFT               (1u)
#define GPIO_PMCSR6_PMCSR62_SHIFT               (2u)
#define GPIO_PMCSR6_PMCSR63_SHIFT               (3u)
#define GPIO_PMCSR6_PMCSR64_SHIFT               (4u)
#define GPIO_PMCSR6_PMCSR65_SHIFT               (5u)
#define GPIO_PMCSR6_PMCSR66_SHIFT               (6u)
#define GPIO_PMCSR6_PMCSR67_SHIFT               (7u)
#define GPIO_PMCSR6_PMCSR68_SHIFT               (8u)
#define GPIO_PMCSR6_PMCSR69_SHIFT               (9u)
#define GPIO_PMCSR6_PMCSR610_SHIFT              (10u)
#define GPIO_PMCSR6_PMCSR611_SHIFT              (11u)
#define GPIO_PMCSR6_PMCSR612_SHIFT              (12u)
#define GPIO_PMCSR6_PMCSR613_SHIFT              (13u)
#define GPIO_PMCSR6_PMCSR614_SHIFT              (14u)
#define GPIO_PMCSR6_PMCSR615_SHIFT              (15u)
#define GPIO_PMCSR6_PMCSR616_SHIFT              (16u)
#define GPIO_PMCSR6_PMCSR617_SHIFT              (17u)
#define GPIO_PMCSR6_PMCSR618_SHIFT              (18u)
#define GPIO_PMCSR6_PMCSR619_SHIFT              (19u)
#define GPIO_PMCSR6_PMCSR620_SHIFT              (20u)
#define GPIO_PMCSR6_PMCSR621_SHIFT              (21u)
#define GPIO_PMCSR6_PMCSR622_SHIFT              (22u)
#define GPIO_PMCSR6_PMCSR623_SHIFT              (23u)
#define GPIO_PMCSR6_PMCSR624_SHIFT              (24u)
#define GPIO_PMCSR6_PMCSR625_SHIFT              (25u)
#define GPIO_PMCSR6_PMCSR626_SHIFT              (26u)
#define GPIO_PMCSR6_PMCSR627_SHIFT              (27u)
#define GPIO_PMCSR6_PMCSR628_SHIFT              (28u)
#define GPIO_PMCSR6_PMCSR629_SHIFT              (29u)
#define GPIO_PMCSR6_PMCSR630_SHIFT              (30u)
#define GPIO_PMCSR6_PMCSR631_SHIFT              (31u)

#define GPIO_PFCAE6_PFCAE60_SHIFT               (0u)
#define GPIO_PFCAE6_PFCAE61_SHIFT               (1u)
#define GPIO_PFCAE6_PFCAE62_SHIFT               (2u)
#define GPIO_PFCAE6_PFCAE63_SHIFT               (3u)
#define GPIO_PFCAE6_PFCAE64_SHIFT               (4u)
#define GPIO_PFCAE6_PFCAE65_SHIFT               (5u)
#define GPIO_PFCAE6_PFCAE66_SHIFT               (6u)
#define GPIO_PFCAE6_PFCAE67_SHIFT               (7u)
#define GPIO_PFCAE6_PFCAE68_SHIFT               (8u)
#define GPIO_PFCAE6_PFCAE69_SHIFT               (9u)
#define GPIO_PFCAE6_PFCAE610_SHIFT              (10u)
#define GPIO_PFCAE6_PFCAE611_SHIFT              (11u)
#define GPIO_PFCAE6_PFCAE612_SHIFT              (12u)
#define GPIO_PFCAE6_PFCAE613_SHIFT              (13u)
#define GPIO_PFCAE6_PFCAE614_SHIFT              (14u)
#define GPIO_PFCAE6_PFCAE615_SHIFT              (15u)

#define GPIO_PIBC6_PIBC60_SHIFT                 (0u)
#define GPIO_PIBC6_PIBC61_SHIFT                 (1u)
#define GPIO_PIBC6_PIBC62_SHIFT                 (2u)
#define GPIO_PIBC6_PIBC63_SHIFT                 (3u)
#define GPIO_PIBC6_PIBC64_SHIFT                 (4u)
#define GPIO_PIBC6_PIBC65_SHIFT                 (5u)
#define GPIO_PIBC6_PIBC66_SHIFT                 (6u)
#define GPIO_PIBC6_PIBC67_SHIFT                 (7u)
#define GPIO_PIBC6_PIBC68_SHIFT                 (8u)
#define GPIO_PIBC6_PIBC69_SHIFT                 (9u)
#define GPIO_PIBC6_PIBC610_SHIFT                (10u)
#define GPIO_PIBC6_PIBC611_SHIFT                (11u)
#define GPIO_PIBC6_PIBC612_SHIFT                (12u)
#define GPIO_PIBC6_PIBC613_SHIFT                (13u)
#define GPIO_PIBC6_PIBC614_SHIFT                (14u)
#define GPIO_PIBC6_PIBC615_SHIFT                (15u)

#define GPIO_PBDC6_PBDC60_SHIFT                 (0u)
#define GPIO_PBDC6_PBDC61_SHIFT                 (1u)
#define GPIO_PBDC6_PBDC62_SHIFT                 (2u)
#define GPIO_PBDC6_PBDC63_SHIFT                 (3u)
#define GPIO_PBDC6_PBDC64_SHIFT                 (4u)
#define GPIO_PBDC6_PBDC65_SHIFT                 (5u)
#define GPIO_PBDC6_PBDC66_SHIFT                 (6u)
#define GPIO_PBDC6_PBDC67_SHIFT                 (7u)
#define GPIO_PBDC6_PBDC68_SHIFT                 (8u)
#define GPIO_PBDC6_PBDC69_SHIFT                 (9u)
#define GPIO_PBDC6_PBDC610_SHIFT                (10u)
#define GPIO_PBDC6_PBDC611_SHIFT                (11u)
#define GPIO_PBDC6_PBDC612_SHIFT                (12u)
#define GPIO_PBDC6_PBDC613_SHIFT                (13u)
#define GPIO_PBDC6_PBDC614_SHIFT                (14u)
#define GPIO_PBDC6_PBDC615_SHIFT                (15u)

#define GPIO_PIPC6_PIPC60_SHIFT                 (0u)
#define GPIO_PIPC6_PIPC61_SHIFT                 (1u)
#define GPIO_PIPC6_PIPC62_SHIFT                 (2u)
#define GPIO_PIPC6_PIPC63_SHIFT                 (3u)
#define GPIO_PIPC6_PIPC64_SHIFT                 (4u)
#define GPIO_PIPC6_PIPC65_SHIFT                 (5u)
#define GPIO_PIPC6_PIPC66_SHIFT                 (6u)
#define GPIO_PIPC6_PIPC67_SHIFT                 (7u)
#define GPIO_PIPC6_PIPC68_SHIFT                 (8u)
#define GPIO_PIPC6_PIPC69_SHIFT                 (9u)
#define GPIO_PIPC6_PIPC610_SHIFT                (10u)
#define GPIO_PIPC6_PIPC611_SHIFT                (11u)
#define GPIO_PIPC6_PIPC612_SHIFT                (12u)
#define GPIO_PIPC6_PIPC613_SHIFT                (13u)
#define GPIO_PIPC6_PIPC614_SHIFT                (14u)
#define GPIO_PIPC6_PIPC615_SHIFT                (15u)

/* ---- P7 ---- */
#define GPIO_P7_P70_SHIFT                       (0u)
#define GPIO_P7_P71_SHIFT                       (1u)
#define GPIO_P7_P72_SHIFT                       (2u)
#define GPIO_P7_P73_SHIFT                       (3u)
#define GPIO_P7_P74_SHIFT                       (4u)
#define GPIO_P7_P75_SHIFT                       (5u)
#define GPIO_P7_P76_SHIFT                       (6u)
#define GPIO_P7_P77_SHIFT                       (7u)
#define GPIO_P7_P78_SHIFT                       (8u)
#define GPIO_P7_P79_SHIFT                       (9u)
#define GPIO_P7_P710_SHIFT                      (10u)
#define GPIO_P7_P711_SHIFT                      (11u)
#define GPIO_P7_P712_SHIFT                      (12u)
#define GPIO_P7_P713_SHIFT                      (13u)
#define GPIO_P7_P714_SHIFT                      (14u)
#define GPIO_P7_P715_SHIFT                      (15u)

#define GPIO_PSR7_PSR70_SHIFT                   (0u)
#define GPIO_PSR7_PSR71_SHIFT                   (1u)
#define GPIO_PSR7_PSR72_SHIFT                   (2u)
#define GPIO_PSR7_PSR73_SHIFT                   (3u)
#define GPIO_PSR7_PSR74_SHIFT                   (4u)
#define GPIO_PSR7_PSR75_SHIFT                   (5u)
#define GPIO_PSR7_PSR76_SHIFT                   (6u)
#define GPIO_PSR7_PSR77_SHIFT                   (7u)
#define GPIO_PSR7_PSR78_SHIFT                   (8u)
#define GPIO_PSR7_PSR79_SHIFT                   (9u)
#define GPIO_PSR7_PSR710_SHIFT                  (10u)
#define GPIO_PSR7_PSR711_SHIFT                  (11u)
#define GPIO_PSR7_PSR712_SHIFT                  (12u)
#define GPIO_PSR7_PSR713_SHIFT                  (13u)
#define GPIO_PSR7_PSR714_SHIFT                  (14u)
#define GPIO_PSR7_PSR715_SHIFT                  (15u)
#define GPIO_PSR7_PSR716_SHIFT                  (16u)
#define GPIO_PSR7_PSR717_SHIFT                  (17u)
#define GPIO_PSR7_PSR718_SHIFT                  (18u)
#define GPIO_PSR7_PSR719_SHIFT                  (19u)
#define GPIO_PSR7_PSR720_SHIFT                  (20u)
#define GPIO_PSR7_PSR721_SHIFT                  (21u)
#define GPIO_PSR7_PSR722_SHIFT                  (22u)
#define GPIO_PSR7_PSR723_SHIFT                  (23u)
#define GPIO_PSR7_PSR724_SHIFT                  (24u)
#define GPIO_PSR7_PSR725_SHIFT                  (25u)
#define GPIO_PSR7_PSR726_SHIFT                  (26u)
#define GPIO_PSR7_PSR727_SHIFT                  (27u)
#define GPIO_PSR7_PSR728_SHIFT                  (28u)
#define GPIO_PSR7_PSR729_SHIFT                  (29u)
#define GPIO_PSR7_PSR730_SHIFT                  (30u)
#define GPIO_PSR7_PSR731_SHIFT                  (31u)

#define GPIO_PPR7_PPR70_SHIFT                   (0u)
#define GPIO_PPR7_PPR71_SHIFT                   (1u)
#define GPIO_PPR7_PPR72_SHIFT                   (2u)
#define GPIO_PPR7_PPR73_SHIFT                   (3u)
#define GPIO_PPR7_PPR74_SHIFT                   (4u)
#define GPIO_PPR7_PPR75_SHIFT                   (5u)
#define GPIO_PPR7_PPR76_SHIFT                   (6u)
#define GPIO_PPR7_PPR77_SHIFT                   (7u)
#define GPIO_PPR7_PPR78_SHIFT                   (8u)
#define GPIO_PPR7_PPR79_SHIFT                   (9u)
#define GPIO_PPR7_PPR710_SHIFT                  (10u)
#define GPIO_PPR7_PPR711_SHIFT                  (11u)
#define GPIO_PPR7_PPR712_SHIFT                  (12u)
#define GPIO_PPR7_PPR713_SHIFT                  (13u)
#define GPIO_PPR7_PPR714_SHIFT                  (14u)
#define GPIO_PPR7_PPR715_SHIFT                  (15u)

#define GPIO_PM7_PM70_SHIFT                     (0u)
#define GPIO_PM7_PM71_SHIFT                     (1u)
#define GPIO_PM7_PM72_SHIFT                     (2u)
#define GPIO_PM7_PM73_SHIFT                     (3u)
#define GPIO_PM7_PM74_SHIFT                     (4u)
#define GPIO_PM7_PM75_SHIFT                     (5u)
#define GPIO_PM7_PM76_SHIFT                     (6u)
#define GPIO_PM7_PM77_SHIFT                     (7u)
#define GPIO_PM7_PM78_SHIFT                     (8u)
#define GPIO_PM7_PM79_SHIFT                     (9u)
#define GPIO_PM7_PM710_SHIFT                    (10u)
#define GPIO_PM7_PM711_SHIFT                    (11u)
#define GPIO_PM7_PM712_SHIFT                    (12u)
#define GPIO_PM7_PM713_SHIFT                    (13u)
#define GPIO_PM7_PM714_SHIFT                    (14u)
#define GPIO_PM7_PM715_SHIFT                    (15u)

#define GPIO_PMC7_PMC70_SHIFT                   (0u)
#define GPIO_PMC7_PMC71_SHIFT                   (1u)
#define GPIO_PMC7_PMC72_SHIFT                   (2u)
#define GPIO_PMC7_PMC73_SHIFT                   (3u)
#define GPIO_PMC7_PMC74_SHIFT                   (4u)
#define GPIO_PMC7_PMC75_SHIFT                   (5u)
#define GPIO_PMC7_PMC76_SHIFT                   (6u)
#define GPIO_PMC7_PMC77_SHIFT                   (7u)
#define GPIO_PMC7_PMC78_SHIFT                   (8u)
#define GPIO_PMC7_PMC79_SHIFT                   (9u)
#define GPIO_PMC7_PMC710_SHIFT                  (10u)
#define GPIO_PMC7_PMC711_SHIFT                  (11u)
#define GPIO_PMC7_PMC712_SHIFT                  (12u)
#define GPIO_PMC7_PMC713_SHIFT                  (13u)
#define GPIO_PMC7_PMC714_SHIFT                  (14u)
#define GPIO_PMC7_PMC715_SHIFT                  (15u)

#define GPIO_PFC7_PFC70_SHIFT                   (0u)
#define GPIO_PFC7_PFC71_SHIFT                   (1u)
#define GPIO_PFC7_PFC72_SHIFT                   (2u)
#define GPIO_PFC7_PFC73_SHIFT                   (3u)
#define GPIO_PFC7_PFC74_SHIFT                   (4u)
#define GPIO_PFC7_PFC75_SHIFT                   (5u)
#define GPIO_PFC7_PFC76_SHIFT                   (6u)
#define GPIO_PFC7_PFC77_SHIFT                   (7u)
#define GPIO_PFC7_PFC78_SHIFT                   (8u)
#define GPIO_PFC7_PFC79_SHIFT                   (9u)
#define GPIO_PFC7_PFC710_SHIFT                  (10u)
#define GPIO_PFC7_PFC711_SHIFT                  (11u)
#define GPIO_PFC7_PFC712_SHIFT                  (12u)
#define GPIO_PFC7_PFC713_SHIFT                  (13u)
#define GPIO_PFC7_PFC714_SHIFT                  (14u)
#define GPIO_PFC7_PFC715_SHIFT                  (15u)

#define GPIO_PFCE7_PFCE70_SHIFT                 (0u)
#define GPIO_PFCE7_PFCE71_SHIFT                 (1u)
#define GPIO_PFCE7_PFCE72_SHIFT                 (2u)
#define GPIO_PFCE7_PFCE73_SHIFT                 (3u)
#define GPIO_PFCE7_PFCE74_SHIFT                 (4u)
#define GPIO_PFCE7_PFCE75_SHIFT                 (5u)
#define GPIO_PFCE7_PFCE76_SHIFT                 (6u)
#define GPIO_PFCE7_PFCE77_SHIFT                 (7u)
#define GPIO_PFCE7_PFCE78_SHIFT                 (8u)
#define GPIO_PFCE7_PFCE79_SHIFT                 (9u)
#define GPIO_PFCE7_PFCE710_SHIFT                (10u)
#define GPIO_PFCE7_PFCE711_SHIFT                (11u)
#define GPIO_PFCE7_PFCE712_SHIFT                (12u)
#define GPIO_PFCE7_PFCE713_SHIFT                (13u)
#define GPIO_PFCE7_PFCE714_SHIFT                (14u)
#define GPIO_PFCE7_PFCE715_SHIFT                (15u)

#define GPIO_PNOT7_PNOT70_SHIFT                 (0u)
#define GPIO_PNOT7_PNOT71_SHIFT                 (1u)
#define GPIO_PNOT7_PNOT72_SHIFT                 (2u)
#define GPIO_PNOT7_PNOT73_SHIFT                 (3u)
#define GPIO_PNOT7_PNOT74_SHIFT                 (4u)
#define GPIO_PNOT7_PNOT75_SHIFT                 (5u)
#define GPIO_PNOT7_PNOT76_SHIFT                 (6u)
#define GPIO_PNOT7_PNOT77_SHIFT                 (7u)
#define GPIO_PNOT7_PNOT78_SHIFT                 (8u)
#define GPIO_PNOT7_PNOT79_SHIFT                 (9u)
#define GPIO_PNOT7_PNOT710_SHIFT                (10u)
#define GPIO_PNOT7_PNOT711_SHIFT                (11u)
#define GPIO_PNOT7_PNOT712_SHIFT                (12u)
#define GPIO_PNOT7_PNOT713_SHIFT                (13u)
#define GPIO_PNOT7_PNOT714_SHIFT                (14u)
#define GPIO_PNOT7_PNOT715_SHIFT                (15u)

#define GPIO_PMSR7_PMSR70_SHIFT                 (0u)
#define GPIO_PMSR7_PMSR71_SHIFT                 (1u)
#define GPIO_PMSR7_PMSR72_SHIFT                 (2u)
#define GPIO_PMSR7_PMSR73_SHIFT                 (3u)
#define GPIO_PMSR7_PMSR74_SHIFT                 (4u)
#define GPIO_PMSR7_PMSR75_SHIFT                 (5u)
#define GPIO_PMSR7_PMSR76_SHIFT                 (6u)
#define GPIO_PMSR7_PMSR77_SHIFT                 (7u)
#define GPIO_PMSR7_PMSR78_SHIFT                 (8u)
#define GPIO_PMSR7_PMSR79_SHIFT                 (9u)
#define GPIO_PMSR7_PMSR710_SHIFT                (10u)
#define GPIO_PMSR7_PMSR711_SHIFT                (11u)
#define GPIO_PMSR7_PMSR712_SHIFT                (12u)
#define GPIO_PMSR7_PMSR713_SHIFT                (13u)
#define GPIO_PMSR7_PMSR714_SHIFT                (14u)
#define GPIO_PMSR7_PMSR715_SHIFT                (15u)
#define GPIO_PMSR7_PMSR716_SHIFT                (16u)
#define GPIO_PMSR7_PMSR717_SHIFT                (17u)
#define GPIO_PMSR7_PMSR718_SHIFT                (18u)
#define GPIO_PMSR7_PMSR719_SHIFT                (19u)
#define GPIO_PMSR7_PMSR720_SHIFT                (20u)
#define GPIO_PMSR7_PMSR721_SHIFT                (21u)
#define GPIO_PMSR7_PMSR722_SHIFT                (22u)
#define GPIO_PMSR7_PMSR723_SHIFT                (23u)
#define GPIO_PMSR7_PMSR724_SHIFT                (24u)
#define GPIO_PMSR7_PMSR725_SHIFT                (25u)
#define GPIO_PMSR7_PMSR726_SHIFT                (26u)
#define GPIO_PMSR7_PMSR727_SHIFT                (27u)
#define GPIO_PMSR7_PMSR728_SHIFT                (28u)
#define GPIO_PMSR7_PMSR729_SHIFT                (29u)
#define GPIO_PMSR7_PMSR730_SHIFT                (30u)
#define GPIO_PMSR7_PMSR731_SHIFT                (31u)

#define GPIO_PMCSR7_PMCSR70_SHIFT               (0u)
#define GPIO_PMCSR7_PMCSR71_SHIFT               (1u)
#define GPIO_PMCSR7_PMCSR72_SHIFT               (2u)
#define GPIO_PMCSR7_PMCSR73_SHIFT               (3u)
#define GPIO_PMCSR7_PMCSR74_SHIFT               (4u)
#define GPIO_PMCSR7_PMCSR75_SHIFT               (5u)
#define GPIO_PMCSR7_PMCSR76_SHIFT               (6u)
#define GPIO_PMCSR7_PMCSR77_SHIFT               (7u)
#define GPIO_PMCSR7_PMCSR78_SHIFT               (8u)
#define GPIO_PMCSR7_PMCSR79_SHIFT               (9u)
#define GPIO_PMCSR7_PMCSR710_SHIFT              (10u)
#define GPIO_PMCSR7_PMCSR711_SHIFT              (11u)
#define GPIO_PMCSR7_PMCSR712_SHIFT              (12u)
#define GPIO_PMCSR7_PMCSR713_SHIFT              (13u)
#define GPIO_PMCSR7_PMCSR714_SHIFT              (14u)
#define GPIO_PMCSR7_PMCSR715_SHIFT              (15u)
#define GPIO_PMCSR7_PMCSR716_SHIFT              (16u)
#define GPIO_PMCSR7_PMCSR717_SHIFT              (17u)
#define GPIO_PMCSR7_PMCSR718_SHIFT              (18u)
#define GPIO_PMCSR7_PMCSR719_SHIFT              (19u)
#define GPIO_PMCSR7_PMCSR720_SHIFT              (20u)
#define GPIO_PMCSR7_PMCSR721_SHIFT              (21u)
#define GPIO_PMCSR7_PMCSR722_SHIFT              (22u)
#define GPIO_PMCSR7_PMCSR723_SHIFT              (23u)
#define GPIO_PMCSR7_PMCSR724_SHIFT              (24u)
#define GPIO_PMCSR7_PMCSR725_SHIFT              (25u)
#define GPIO_PMCSR7_PMCSR726_SHIFT              (26u)
#define GPIO_PMCSR7_PMCSR727_SHIFT              (27u)
#define GPIO_PMCSR7_PMCSR728_SHIFT              (28u)
#define GPIO_PMCSR7_PMCSR729_SHIFT              (29u)
#define GPIO_PMCSR7_PMCSR730_SHIFT              (30u)
#define GPIO_PMCSR7_PMCSR731_SHIFT              (31u)

#define GPIO_PFCAE7_PFCAE70_SHIFT               (0u)
#define GPIO_PFCAE7_PFCAE71_SHIFT               (1u)
#define GPIO_PFCAE7_PFCAE72_SHIFT               (2u)
#define GPIO_PFCAE7_PFCAE73_SHIFT               (3u)
#define GPIO_PFCAE7_PFCAE74_SHIFT               (4u)
#define GPIO_PFCAE7_PFCAE75_SHIFT               (5u)
#define GPIO_PFCAE7_PFCAE76_SHIFT               (6u)
#define GPIO_PFCAE7_PFCAE77_SHIFT               (7u)
#define GPIO_PFCAE7_PFCAE78_SHIFT               (8u)
#define GPIO_PFCAE7_PFCAE79_SHIFT               (9u)
#define GPIO_PFCAE7_PFCAE710_SHIFT              (10u)
#define GPIO_PFCAE7_PFCAE711_SHIFT              (11u)
#define GPIO_PFCAE7_PFCAE712_SHIFT              (12u)
#define GPIO_PFCAE7_PFCAE713_SHIFT              (13u)
#define GPIO_PFCAE7_PFCAE714_SHIFT              (14u)
#define GPIO_PFCAE7_PFCAE715_SHIFT              (15u)

#define GPIO_PIBC7_PIBC70_SHIFT                 (0u)
#define GPIO_PIBC7_PIBC71_SHIFT                 (1u)
#define GPIO_PIBC7_PIBC72_SHIFT                 (2u)
#define GPIO_PIBC7_PIBC73_SHIFT                 (3u)
#define GPIO_PIBC7_PIBC74_SHIFT                 (4u)
#define GPIO_PIBC7_PIBC75_SHIFT                 (5u)
#define GPIO_PIBC7_PIBC76_SHIFT                 (6u)
#define GPIO_PIBC7_PIBC77_SHIFT                 (7u)
#define GPIO_PIBC7_PIBC78_SHIFT                 (8u)
#define GPIO_PIBC7_PIBC79_SHIFT                 (9u)
#define GPIO_PIBC7_PIBC710_SHIFT                (10u)
#define GPIO_PIBC7_PIBC711_SHIFT                (11u)
#define GPIO_PIBC7_PIBC712_SHIFT                (12u)
#define GPIO_PIBC7_PIBC713_SHIFT                (13u)
#define GPIO_PIBC7_PIBC714_SHIFT                (14u)
#define GPIO_PIBC7_PIBC715_SHIFT                (15u)

#define GPIO_PBDC7_PBDC70_SHIFT                 (0u)
#define GPIO_PBDC7_PBDC71_SHIFT                 (1u)
#define GPIO_PBDC7_PBDC72_SHIFT                 (2u)
#define GPIO_PBDC7_PBDC73_SHIFT                 (3u)
#define GPIO_PBDC7_PBDC74_SHIFT                 (4u)
#define GPIO_PBDC7_PBDC75_SHIFT                 (5u)
#define GPIO_PBDC7_PBDC76_SHIFT                 (6u)
#define GPIO_PBDC7_PBDC77_SHIFT                 (7u)
#define GPIO_PBDC7_PBDC78_SHIFT                 (8u)
#define GPIO_PBDC7_PBDC79_SHIFT                 (9u)
#define GPIO_PBDC7_PBDC710_SHIFT                (10u)
#define GPIO_PBDC7_PBDC711_SHIFT                (11u)
#define GPIO_PBDC7_PBDC712_SHIFT                (12u)
#define GPIO_PBDC7_PBDC713_SHIFT                (13u)
#define GPIO_PBDC7_PBDC714_SHIFT                (14u)
#define GPIO_PBDC7_PBDC715_SHIFT                (15u)

#define GPIO_PIPC7_PIPC70_SHIFT                 (0u)
#define GPIO_PIPC7_PIPC71_SHIFT                 (1u)
#define GPIO_PIPC7_PIPC72_SHIFT                 (2u)
#define GPIO_PIPC7_PIPC73_SHIFT                 (3u)
#define GPIO_PIPC7_PIPC74_SHIFT                 (4u)
#define GPIO_PIPC7_PIPC75_SHIFT                 (5u)
#define GPIO_PIPC7_PIPC76_SHIFT                 (6u)
#define GPIO_PIPC7_PIPC77_SHIFT                 (7u)
#define GPIO_PIPC7_PIPC78_SHIFT                 (8u)
#define GPIO_PIPC7_PIPC79_SHIFT                 (9u)
#define GPIO_PIPC7_PIPC710_SHIFT                (10u)
#define GPIO_PIPC7_PIPC711_SHIFT                (11u)
#define GPIO_PIPC7_PIPC712_SHIFT                (12u)
#define GPIO_PIPC7_PIPC713_SHIFT                (13u)
#define GPIO_PIPC7_PIPC714_SHIFT                (14u)
#define GPIO_PIPC7_PIPC715_SHIFT                (15u)

/* ---- P8 ---- */
#define GPIO_P8_P80_SHIFT                       (0u)
#define GPIO_P8_P81_SHIFT                       (1u)
#define GPIO_P8_P82_SHIFT                       (2u)
#define GPIO_P8_P83_SHIFT                       (3u)
#define GPIO_P8_P84_SHIFT                       (4u)
#define GPIO_P8_P85_SHIFT                       (5u)
#define GPIO_P8_P86_SHIFT                       (6u)
#define GPIO_P8_P87_SHIFT                       (7u)
#define GPIO_P8_P88_SHIFT                       (8u)
#define GPIO_P8_P89_SHIFT                       (9u)
#define GPIO_P8_P810_SHIFT                      (10u)
#define GPIO_P8_P811_SHIFT                      (11u)
#define GPIO_P8_P812_SHIFT                      (12u)
#define GPIO_P8_P813_SHIFT                      (13u)
#define GPIO_P8_P814_SHIFT                      (14u)
#define GPIO_P8_P815_SHIFT                      (15u)

#define GPIO_PSR8_PSR80_SHIFT                   (0u)
#define GPIO_PSR8_PSR81_SHIFT                   (1u)
#define GPIO_PSR8_PSR82_SHIFT                   (2u)
#define GPIO_PSR8_PSR83_SHIFT                   (3u)
#define GPIO_PSR8_PSR84_SHIFT                   (4u)
#define GPIO_PSR8_PSR85_SHIFT                   (5u)
#define GPIO_PSR8_PSR86_SHIFT                   (6u)
#define GPIO_PSR8_PSR87_SHIFT                   (7u)
#define GPIO_PSR8_PSR88_SHIFT                   (8u)
#define GPIO_PSR8_PSR89_SHIFT                   (9u)
#define GPIO_PSR8_PSR810_SHIFT                  (10u)
#define GPIO_PSR8_PSR811_SHIFT                  (11u)
#define GPIO_PSR8_PSR812_SHIFT                  (12u)
#define GPIO_PSR8_PSR813_SHIFT                  (13u)
#define GPIO_PSR8_PSR814_SHIFT                  (14u)
#define GPIO_PSR8_PSR815_SHIFT                  (15u)
#define GPIO_PSR8_PSR816_SHIFT                  (16u)
#define GPIO_PSR8_PSR817_SHIFT                  (17u)
#define GPIO_PSR8_PSR818_SHIFT                  (18u)
#define GPIO_PSR8_PSR819_SHIFT                  (19u)
#define GPIO_PSR8_PSR820_SHIFT                  (20u)
#define GPIO_PSR8_PSR821_SHIFT                  (21u)
#define GPIO_PSR8_PSR822_SHIFT                  (22u)
#define GPIO_PSR8_PSR823_SHIFT                  (23u)
#define GPIO_PSR8_PSR824_SHIFT                  (24u)
#define GPIO_PSR8_PSR825_SHIFT                  (25u)
#define GPIO_PSR8_PSR826_SHIFT                  (26u)
#define GPIO_PSR8_PSR827_SHIFT                  (27u)
#define GPIO_PSR8_PSR828_SHIFT                  (28u)
#define GPIO_PSR8_PSR829_SHIFT                  (29u)
#define GPIO_PSR8_PSR830_SHIFT                  (30u)
#define GPIO_PSR8_PSR831_SHIFT                  (31u)

#define GPIO_PPR8_PPR80_SHIFT                   (0u)
#define GPIO_PPR8_PPR81_SHIFT                   (1u)
#define GPIO_PPR8_PPR82_SHIFT                   (2u)
#define GPIO_PPR8_PPR83_SHIFT                   (3u)
#define GPIO_PPR8_PPR84_SHIFT                   (4u)
#define GPIO_PPR8_PPR85_SHIFT                   (5u)
#define GPIO_PPR8_PPR86_SHIFT                   (6u)
#define GPIO_PPR8_PPR87_SHIFT                   (7u)
#define GPIO_PPR8_PPR88_SHIFT                   (8u)
#define GPIO_PPR8_PPR89_SHIFT                   (9u)
#define GPIO_PPR8_PPR810_SHIFT                  (10u)
#define GPIO_PPR8_PPR811_SHIFT                  (11u)
#define GPIO_PPR8_PPR812_SHIFT                  (12u)
#define GPIO_PPR8_PPR813_SHIFT                  (13u)
#define GPIO_PPR8_PPR814_SHIFT                  (14u)
#define GPIO_PPR8_PPR815_SHIFT                  (15u)

#define GPIO_PM8_PM80_SHIFT                     (0u)
#define GPIO_PM8_PM81_SHIFT                     (1u)
#define GPIO_PM8_PM82_SHIFT                     (2u)
#define GPIO_PM8_PM83_SHIFT                     (3u)
#define GPIO_PM8_PM84_SHIFT                     (4u)
#define GPIO_PM8_PM85_SHIFT                     (5u)
#define GPIO_PM8_PM86_SHIFT                     (6u)
#define GPIO_PM8_PM87_SHIFT                     (7u)
#define GPIO_PM8_PM88_SHIFT                     (8u)
#define GPIO_PM8_PM89_SHIFT                     (9u)
#define GPIO_PM8_PM810_SHIFT                    (10u)
#define GPIO_PM8_PM811_SHIFT                    (11u)
#define GPIO_PM8_PM812_SHIFT                    (12u)
#define GPIO_PM8_PM813_SHIFT                    (13u)
#define GPIO_PM8_PM814_SHIFT                    (14u)
#define GPIO_PM8_PM815_SHIFT                    (15u)

#define GPIO_PMC8_PMC80_SHIFT                   (0u)
#define GPIO_PMC8_PMC81_SHIFT                   (1u)
#define GPIO_PMC8_PMC82_SHIFT                   (2u)
#define GPIO_PMC8_PMC83_SHIFT                   (3u)
#define GPIO_PMC8_PMC84_SHIFT                   (4u)
#define GPIO_PMC8_PMC85_SHIFT                   (5u)
#define GPIO_PMC8_PMC86_SHIFT                   (6u)
#define GPIO_PMC8_PMC87_SHIFT                   (7u)
#define GPIO_PMC8_PMC88_SHIFT                   (8u)
#define GPIO_PMC8_PMC89_SHIFT                   (9u)
#define GPIO_PMC8_PMC810_SHIFT                  (10u)
#define GPIO_PMC8_PMC811_SHIFT                  (11u)
#define GPIO_PMC8_PMC812_SHIFT                  (12u)
#define GPIO_PMC8_PMC813_SHIFT                  (13u)
#define GPIO_PMC8_PMC814_SHIFT                  (14u)
#define GPIO_PMC8_PMC815_SHIFT                  (15u)

#define GPIO_PFC8_PFC80_SHIFT                   (0u)
#define GPIO_PFC8_PFC81_SHIFT                   (1u)
#define GPIO_PFC8_PFC82_SHIFT                   (2u)
#define GPIO_PFC8_PFC83_SHIFT                   (3u)
#define GPIO_PFC8_PFC84_SHIFT                   (4u)
#define GPIO_PFC8_PFC85_SHIFT                   (5u)
#define GPIO_PFC8_PFC86_SHIFT                   (6u)
#define GPIO_PFC8_PFC87_SHIFT                   (7u)
#define GPIO_PFC8_PFC88_SHIFT                   (8u)
#define GPIO_PFC8_PFC89_SHIFT                   (9u)
#define GPIO_PFC8_PFC810_SHIFT                  (10u)
#define GPIO_PFC8_PFC811_SHIFT                  (11u)
#define GPIO_PFC8_PFC812_SHIFT                  (12u)
#define GPIO_PFC8_PFC813_SHIFT                  (13u)
#define GPIO_PFC8_PFC814_SHIFT                  (14u)
#define GPIO_PFC8_PFC815_SHIFT                  (15u)

#define GPIO_PFCE8_PFCE80_SHIFT                 (0u)
#define GPIO_PFCE8_PFCE81_SHIFT                 (1u)
#define GPIO_PFCE8_PFCE82_SHIFT                 (2u)
#define GPIO_PFCE8_PFCE83_SHIFT                 (3u)
#define GPIO_PFCE8_PFCE84_SHIFT                 (4u)
#define GPIO_PFCE8_PFCE85_SHIFT                 (5u)
#define GPIO_PFCE8_PFCE86_SHIFT                 (6u)
#define GPIO_PFCE8_PFCE87_SHIFT                 (7u)
#define GPIO_PFCE8_PFCE88_SHIFT                 (8u)
#define GPIO_PFCE8_PFCE89_SHIFT                 (9u)
#define GPIO_PFCE8_PFCE810_SHIFT                (10u)
#define GPIO_PFCE8_PFCE811_SHIFT                (11u)
#define GPIO_PFCE8_PFCE812_SHIFT                (12u)
#define GPIO_PFCE8_PFCE813_SHIFT                (13u)
#define GPIO_PFCE8_PFCE814_SHIFT                (14u)
#define GPIO_PFCE8_PFCE815_SHIFT                (15u)

#define GPIO_PNOT8_PNOT80_SHIFT                 (0u)
#define GPIO_PNOT8_PNOT81_SHIFT                 (1u)
#define GPIO_PNOT8_PNOT82_SHIFT                 (2u)
#define GPIO_PNOT8_PNOT83_SHIFT                 (3u)
#define GPIO_PNOT8_PNOT84_SHIFT                 (4u)
#define GPIO_PNOT8_PNOT85_SHIFT                 (5u)
#define GPIO_PNOT8_PNOT86_SHIFT                 (6u)
#define GPIO_PNOT8_PNOT87_SHIFT                 (7u)
#define GPIO_PNOT8_PNOT88_SHIFT                 (8u)
#define GPIO_PNOT8_PNOT89_SHIFT                 (9u)
#define GPIO_PNOT8_PNOT810_SHIFT                (10u)
#define GPIO_PNOT8_PNOT811_SHIFT                (11u)
#define GPIO_PNOT8_PNOT812_SHIFT                (12u)
#define GPIO_PNOT8_PNOT813_SHIFT                (13u)
#define GPIO_PNOT8_PNOT814_SHIFT                (14u)
#define GPIO_PNOT8_PNOT815_SHIFT                (15u)

#define GPIO_PMSR8_PMSR80_SHIFT                 (0u)
#define GPIO_PMSR8_PMSR81_SHIFT                 (1u)
#define GPIO_PMSR8_PMSR82_SHIFT                 (2u)
#define GPIO_PMSR8_PMSR83_SHIFT                 (3u)
#define GPIO_PMSR8_PMSR84_SHIFT                 (4u)
#define GPIO_PMSR8_PMSR85_SHIFT                 (5u)
#define GPIO_PMSR8_PMSR86_SHIFT                 (6u)
#define GPIO_PMSR8_PMSR87_SHIFT                 (7u)
#define GPIO_PMSR8_PMSR88_SHIFT                 (8u)
#define GPIO_PMSR8_PMSR89_SHIFT                 (9u)
#define GPIO_PMSR8_PMSR810_SHIFT                (10u)
#define GPIO_PMSR8_PMSR811_SHIFT                (11u)
#define GPIO_PMSR8_PMSR812_SHIFT                (12u)
#define GPIO_PMSR8_PMSR813_SHIFT                (13u)
#define GPIO_PMSR8_PMSR814_SHIFT                (14u)
#define GPIO_PMSR8_PMSR815_SHIFT                (15u)
#define GPIO_PMSR8_PMSR816_SHIFT                (16u)
#define GPIO_PMSR8_PMSR817_SHIFT                (17u)
#define GPIO_PMSR8_PMSR818_SHIFT                (18u)
#define GPIO_PMSR8_PMSR819_SHIFT                (19u)
#define GPIO_PMSR8_PMSR820_SHIFT                (20u)
#define GPIO_PMSR8_PMSR821_SHIFT                (21u)
#define GPIO_PMSR8_PMSR822_SHIFT                (22u)
#define GPIO_PMSR8_PMSR823_SHIFT                (23u)
#define GPIO_PMSR8_PMSR824_SHIFT                (24u)
#define GPIO_PMSR8_PMSR825_SHIFT                (25u)
#define GPIO_PMSR8_PMSR826_SHIFT                (26u)
#define GPIO_PMSR8_PMSR827_SHIFT                (27u)
#define GPIO_PMSR8_PMSR828_SHIFT                (28u)
#define GPIO_PMSR8_PMSR829_SHIFT                (29u)
#define GPIO_PMSR8_PMSR830_SHIFT                (30u)
#define GPIO_PMSR8_PMSR831_SHIFT                (31u)

#define GPIO_PMCSR8_PMCSR80_SHIFT               (0u)
#define GPIO_PMCSR8_PMCSR81_SHIFT               (1u)
#define GPIO_PMCSR8_PMCSR82_SHIFT               (2u)
#define GPIO_PMCSR8_PMCSR83_SHIFT               (3u)
#define GPIO_PMCSR8_PMCSR84_SHIFT               (4u)
#define GPIO_PMCSR8_PMCSR85_SHIFT               (5u)
#define GPIO_PMCSR8_PMCSR86_SHIFT               (6u)
#define GPIO_PMCSR8_PMCSR87_SHIFT               (7u)
#define GPIO_PMCSR8_PMCSR88_SHIFT               (8u)
#define GPIO_PMCSR8_PMCSR89_SHIFT               (9u)
#define GPIO_PMCSR8_PMCSR810_SHIFT              (10u)
#define GPIO_PMCSR8_PMCSR811_SHIFT              (11u)
#define GPIO_PMCSR8_PMCSR812_SHIFT              (12u)
#define GPIO_PMCSR8_PMCSR813_SHIFT              (13u)
#define GPIO_PMCSR8_PMCSR814_SHIFT              (14u)
#define GPIO_PMCSR8_PMCSR815_SHIFT              (15u)
#define GPIO_PMCSR8_PMCSR816_SHIFT              (16u)
#define GPIO_PMCSR8_PMCSR817_SHIFT              (17u)
#define GPIO_PMCSR8_PMCSR818_SHIFT              (18u)
#define GPIO_PMCSR8_PMCSR819_SHIFT              (19u)
#define GPIO_PMCSR8_PMCSR820_SHIFT              (20u)
#define GPIO_PMCSR8_PMCSR821_SHIFT              (21u)
#define GPIO_PMCSR8_PMCSR822_SHIFT              (22u)
#define GPIO_PMCSR8_PMCSR823_SHIFT              (23u)
#define GPIO_PMCSR8_PMCSR824_SHIFT              (24u)
#define GPIO_PMCSR8_PMCSR825_SHIFT              (25u)
#define GPIO_PMCSR8_PMCSR826_SHIFT              (26u)
#define GPIO_PMCSR8_PMCSR827_SHIFT              (27u)
#define GPIO_PMCSR8_PMCSR828_SHIFT              (28u)
#define GPIO_PMCSR8_PMCSR829_SHIFT              (29u)
#define GPIO_PMCSR8_PMCSR830_SHIFT              (30u)
#define GPIO_PMCSR8_PMCSR831_SHIFT              (31u)

#define GPIO_PFCAE8_PFCAE80_SHIFT               (0u)
#define GPIO_PFCAE8_PFCAE81_SHIFT               (1u)
#define GPIO_PFCAE8_PFCAE82_SHIFT               (2u)
#define GPIO_PFCAE8_PFCAE83_SHIFT               (3u)
#define GPIO_PFCAE8_PFCAE84_SHIFT               (4u)
#define GPIO_PFCAE8_PFCAE85_SHIFT               (5u)
#define GPIO_PFCAE8_PFCAE86_SHIFT               (6u)
#define GPIO_PFCAE8_PFCAE87_SHIFT               (7u)
#define GPIO_PFCAE8_PFCAE88_SHIFT               (8u)
#define GPIO_PFCAE8_PFCAE89_SHIFT               (9u)
#define GPIO_PFCAE8_PFCAE810_SHIFT              (10u)
#define GPIO_PFCAE8_PFCAE811_SHIFT              (11u)
#define GPIO_PFCAE8_PFCAE812_SHIFT              (12u)
#define GPIO_PFCAE8_PFCAE813_SHIFT              (13u)
#define GPIO_PFCAE8_PFCAE814_SHIFT              (14u)
#define GPIO_PFCAE8_PFCAE815_SHIFT              (15u)

#define GPIO_PIBC8_PIBC80_SHIFT                 (0u)
#define GPIO_PIBC8_PIBC81_SHIFT                 (1u)
#define GPIO_PIBC8_PIBC82_SHIFT                 (2u)
#define GPIO_PIBC8_PIBC83_SHIFT                 (3u)
#define GPIO_PIBC8_PIBC84_SHIFT                 (4u)
#define GPIO_PIBC8_PIBC85_SHIFT                 (5u)
#define GPIO_PIBC8_PIBC86_SHIFT                 (6u)
#define GPIO_PIBC8_PIBC87_SHIFT                 (7u)
#define GPIO_PIBC8_PIBC88_SHIFT                 (8u)
#define GPIO_PIBC8_PIBC89_SHIFT                 (9u)
#define GPIO_PIBC8_PIBC810_SHIFT                (10u)
#define GPIO_PIBC8_PIBC811_SHIFT                (11u)
#define GPIO_PIBC8_PIBC812_SHIFT                (12u)
#define GPIO_PIBC8_PIBC813_SHIFT                (13u)
#define GPIO_PIBC8_PIBC814_SHIFT                (14u)
#define GPIO_PIBC8_PIBC815_SHIFT                (15u)

#define GPIO_PBDC8_PBDC80_SHIFT                 (0u)
#define GPIO_PBDC8_PBDC81_SHIFT                 (1u)
#define GPIO_PBDC8_PBDC82_SHIFT                 (2u)
#define GPIO_PBDC8_PBDC83_SHIFT                 (3u)
#define GPIO_PBDC8_PBDC84_SHIFT                 (4u)
#define GPIO_PBDC8_PBDC85_SHIFT                 (5u)
#define GPIO_PBDC8_PBDC86_SHIFT                 (6u)
#define GPIO_PBDC8_PBDC87_SHIFT                 (7u)
#define GPIO_PBDC8_PBDC88_SHIFT                 (8u)
#define GPIO_PBDC8_PBDC89_SHIFT                 (9u)
#define GPIO_PBDC8_PBDC810_SHIFT                (10u)
#define GPIO_PBDC8_PBDC811_SHIFT                (11u)
#define GPIO_PBDC8_PBDC812_SHIFT                (12u)
#define GPIO_PBDC8_PBDC813_SHIFT                (13u)
#define GPIO_PBDC8_PBDC814_SHIFT                (14u)
#define GPIO_PBDC8_PBDC815_SHIFT                (15u)

#define GPIO_PIPC8_PIPC80_SHIFT                 (0u)
#define GPIO_PIPC8_PIPC81_SHIFT                 (1u)
#define GPIO_PIPC8_PIPC82_SHIFT                 (2u)
#define GPIO_PIPC8_PIPC83_SHIFT                 (3u)
#define GPIO_PIPC8_PIPC84_SHIFT                 (4u)
#define GPIO_PIPC8_PIPC85_SHIFT                 (5u)
#define GPIO_PIPC8_PIPC86_SHIFT                 (6u)
#define GPIO_PIPC8_PIPC87_SHIFT                 (7u)
#define GPIO_PIPC8_PIPC88_SHIFT                 (8u)
#define GPIO_PIPC8_PIPC89_SHIFT                 (9u)
#define GPIO_PIPC8_PIPC810_SHIFT                (10u)
#define GPIO_PIPC8_PIPC811_SHIFT                (11u)
#define GPIO_PIPC8_PIPC812_SHIFT                (12u)
#define GPIO_PIPC8_PIPC813_SHIFT                (13u)
#define GPIO_PIPC8_PIPC814_SHIFT                (14u)
#define GPIO_PIPC8_PIPC815_SHIFT                (15u)

/* ---- P9 ---- */
#define GPIO_P9_P90_SHIFT                       (0u)
#define GPIO_P9_P91_SHIFT                       (1u)
#define GPIO_P9_P92_SHIFT                       (2u)
#define GPIO_P9_P93_SHIFT                       (3u)
#define GPIO_P9_P94_SHIFT                       (4u)
#define GPIO_P9_P95_SHIFT                       (5u)
#define GPIO_P9_P96_SHIFT                       (6u)
#define GPIO_P9_P97_SHIFT                       (7u)

#define GPIO_PSR9_PSR90_SHIFT                   (0u)
#define GPIO_PSR9_PSR91_SHIFT                   (1u)
#define GPIO_PSR9_PSR92_SHIFT                   (2u)
#define GPIO_PSR9_PSR93_SHIFT                   (3u)
#define GPIO_PSR9_PSR94_SHIFT                   (4u)
#define GPIO_PSR9_PSR95_SHIFT                   (5u)
#define GPIO_PSR9_PSR96_SHIFT                   (6u)
#define GPIO_PSR9_PSR97_SHIFT                   (7u)
#define GPIO_PSR9_PSR916_SHIFT                  (16u)
#define GPIO_PSR9_PSR917_SHIFT                  (17u)
#define GPIO_PSR9_PSR918_SHIFT                  (18u)
#define GPIO_PSR9_PSR919_SHIFT                  (19u)
#define GPIO_PSR9_PSR920_SHIFT                  (20u)
#define GPIO_PSR9_PSR921_SHIFT                  (21u)
#define GPIO_PSR9_PSR922_SHIFT                  (22u)
#define GPIO_PSR9_PSR923_SHIFT                  (23u)

#define GPIO_PPR9_PPR90_SHIFT                   (0u)
#define GPIO_PPR9_PPR91_SHIFT                   (1u)
#define GPIO_PPR9_PPR92_SHIFT                   (2u)
#define GPIO_PPR9_PPR93_SHIFT                   (3u)
#define GPIO_PPR9_PPR94_SHIFT                   (4u)
#define GPIO_PPR9_PPR95_SHIFT                   (5u)
#define GPIO_PPR9_PPR96_SHIFT                   (6u)
#define GPIO_PPR9_PPR97_SHIFT                   (7u)

#define GPIO_PM9_PM90_SHIFT                     (0u)
#define GPIO_PM9_PM91_SHIFT                     (1u)
#define GPIO_PM9_PM92_SHIFT                     (2u)
#define GPIO_PM9_PM93_SHIFT                     (3u)
#define GPIO_PM9_PM94_SHIFT                     (4u)
#define GPIO_PM9_PM95_SHIFT                     (5u)
#define GPIO_PM9_PM96_SHIFT                     (6u)
#define GPIO_PM9_PM97_SHIFT                     (7u)

#define GPIO_PMC9_PMC90_SHIFT                   (0u)
#define GPIO_PMC9_PMC91_SHIFT                   (1u)
#define GPIO_PMC9_PMC92_SHIFT                   (2u)
#define GPIO_PMC9_PMC93_SHIFT                   (3u)
#define GPIO_PMC9_PMC94_SHIFT                   (4u)
#define GPIO_PMC9_PMC95_SHIFT                   (5u)
#define GPIO_PMC9_PMC96_SHIFT                   (6u)
#define GPIO_PMC9_PMC97_SHIFT                   (7u)

#define GPIO_PFC9_PFC90_SHIFT                   (0u)
#define GPIO_PFC9_PFC91_SHIFT                   (1u)
#define GPIO_PFC9_PFC92_SHIFT                   (2u)
#define GPIO_PFC9_PFC93_SHIFT                   (3u)
#define GPIO_PFC9_PFC94_SHIFT                   (4u)
#define GPIO_PFC9_PFC95_SHIFT                   (5u)
#define GPIO_PFC9_PFC96_SHIFT                   (6u)
#define GPIO_PFC9_PFC97_SHIFT                   (7u)

#define GPIO_PFCE9_PFCE90_SHIFT                 (0u)
#define GPIO_PFCE9_PFCE91_SHIFT                 (1u)
#define GPIO_PFCE9_PFCE92_SHIFT                 (2u)
#define GPIO_PFCE9_PFCE93_SHIFT                 (3u)
#define GPIO_PFCE9_PFCE94_SHIFT                 (4u)
#define GPIO_PFCE9_PFCE95_SHIFT                 (5u)
#define GPIO_PFCE9_PFCE96_SHIFT                 (6u)
#define GPIO_PFCE9_PFCE97_SHIFT                 (7u)

#define GPIO_PNOT9_PNOT90_SHIFT                 (0u)
#define GPIO_PNOT9_PNOT91_SHIFT                 (1u)
#define GPIO_PNOT9_PNOT92_SHIFT                 (2u)
#define GPIO_PNOT9_PNOT93_SHIFT                 (3u)
#define GPIO_PNOT9_PNOT94_SHIFT                 (4u)
#define GPIO_PNOT9_PNOT95_SHIFT                 (5u)
#define GPIO_PNOT9_PNOT96_SHIFT                 (6u)
#define GPIO_PNOT9_PNOT97_SHIFT                 (7u)

#define GPIO_PMSR9_PMSR90_SHIFT                 (0u)
#define GPIO_PMSR9_PMSR91_SHIFT                 (1u)
#define GPIO_PMSR9_PMSR92_SHIFT                 (2u)
#define GPIO_PMSR9_PMSR93_SHIFT                 (3u)
#define GPIO_PMSR9_PMSR94_SHIFT                 (4u)
#define GPIO_PMSR9_PMSR95_SHIFT                 (5u)
#define GPIO_PMSR9_PMSR96_SHIFT                 (6u)
#define GPIO_PMSR9_PMSR97_SHIFT                 (7u)
#define GPIO_PMSR9_PMSR916_SHIFT                (16u)
#define GPIO_PMSR9_PMSR917_SHIFT                (17u)
#define GPIO_PMSR9_PMSR918_SHIFT                (18u)
#define GPIO_PMSR9_PMSR919_SHIFT                (19u)
#define GPIO_PMSR9_PMSR920_SHIFT                (20u)
#define GPIO_PMSR9_PMSR921_SHIFT                (21u)
#define GPIO_PMSR9_PMSR922_SHIFT                (22u)
#define GPIO_PMSR9_PMSR923_SHIFT                (23u)

#define GPIO_PMCSR9_PMCSR90_SHIFT               (0u)
#define GPIO_PMCSR9_PMCSR91_SHIFT               (1u)
#define GPIO_PMCSR9_PMCSR92_SHIFT               (2u)
#define GPIO_PMCSR9_PMCSR93_SHIFT               (3u)
#define GPIO_PMCSR9_PMCSR94_SHIFT               (4u)
#define GPIO_PMCSR9_PMCSR95_SHIFT               (5u)
#define GPIO_PMCSR9_PMCSR96_SHIFT               (6u)
#define GPIO_PMCSR9_PMCSR97_SHIFT               (7u)
#define GPIO_PMCSR9_PMCSR916_SHIFT              (16u)
#define GPIO_PMCSR9_PMCSR917_SHIFT              (17u)
#define GPIO_PMCSR9_PMCSR918_SHIFT              (18u)
#define GPIO_PMCSR9_PMCSR919_SHIFT              (19u)
#define GPIO_PMCSR9_PMCSR920_SHIFT              (20u)
#define GPIO_PMCSR9_PMCSR921_SHIFT              (21u)
#define GPIO_PMCSR9_PMCSR922_SHIFT              (22u)
#define GPIO_PMCSR9_PMCSR923_SHIFT              (23u)

#define GPIO_PFCAE9_PFCAE90_SHIFT               (0u)
#define GPIO_PFCAE9_PFCAE91_SHIFT               (1u)
#define GPIO_PFCAE9_PFCAE92_SHIFT               (2u)
#define GPIO_PFCAE9_PFCAE93_SHIFT               (3u)
#define GPIO_PFCAE9_PFCAE94_SHIFT               (4u)
#define GPIO_PFCAE9_PFCAE95_SHIFT               (5u)
#define GPIO_PFCAE9_PFCAE96_SHIFT               (6u)
#define GPIO_PFCAE9_PFCAE97_SHIFT               (7u)

#define GPIO_PIBC9_PIBC90_SHIFT                 (0u)
#define GPIO_PIBC9_PIBC91_SHIFT                 (1u)
#define GPIO_PIBC9_PIBC92_SHIFT                 (2u)
#define GPIO_PIBC9_PIBC93_SHIFT                 (3u)
#define GPIO_PIBC9_PIBC94_SHIFT                 (4u)
#define GPIO_PIBC9_PIBC95_SHIFT                 (5u)
#define GPIO_PIBC9_PIBC96_SHIFT                 (6u)
#define GPIO_PIBC9_PIBC97_SHIFT                 (7u)

#define GPIO_PBDC9_PBDC90_SHIFT                 (0u)
#define GPIO_PBDC9_PBDC91_SHIFT                 (1u)
#define GPIO_PBDC9_PBDC92_SHIFT                 (2u)
#define GPIO_PBDC9_PBDC93_SHIFT                 (3u)
#define GPIO_PBDC9_PBDC94_SHIFT                 (4u)
#define GPIO_PBDC9_PBDC95_SHIFT                 (5u)
#define GPIO_PBDC9_PBDC96_SHIFT                 (6u)
#define GPIO_PBDC9_PBDC97_SHIFT                 (7u)

#define GPIO_PIPC9_PIPC90_SHIFT                 (0u)
#define GPIO_PIPC9_PIPC91_SHIFT                 (1u)
#define GPIO_PIPC9_PIPC92_SHIFT                 (2u)
#define GPIO_PIPC9_PIPC93_SHIFT                 (3u)
#define GPIO_PIPC9_PIPC94_SHIFT                 (4u)
#define GPIO_PIPC9_PIPC95_SHIFT                 (5u)
#define GPIO_PIPC9_PIPC96_SHIFT                 (6u)
#define GPIO_PIPC9_PIPC97_SHIFT                 (7u)

/* ---- P10 ---- */
#define GPIO_P10_P100_SHIFT                     (0u)
#define GPIO_P10_P101_SHIFT                     (1u)
#define GPIO_P10_P102_SHIFT                     (2u)
#define GPIO_P10_P103_SHIFT                     (3u)
#define GPIO_P10_P104_SHIFT                     (4u)
#define GPIO_P10_P105_SHIFT                     (5u)
#define GPIO_P10_P106_SHIFT                     (6u)
#define GPIO_P10_P107_SHIFT                     (7u)
#define GPIO_P10_P108_SHIFT                     (8u)
#define GPIO_P10_P109_SHIFT                     (9u)
#define GPIO_P10_P1010_SHIFT                    (10u)
#define GPIO_P10_P1011_SHIFT                    (11u)
#define GPIO_P10_P1012_SHIFT                    (12u)
#define GPIO_P10_P1013_SHIFT                    (13u)
#define GPIO_P10_P1014_SHIFT                    (14u)
#define GPIO_P10_P1015_SHIFT                    (15u)

#define GPIO_PSR10_PSR100_SHIFT                 (0u)
#define GPIO_PSR10_PSR101_SHIFT                 (1u)
#define GPIO_PSR10_PSR102_SHIFT                 (2u)
#define GPIO_PSR10_PSR103_SHIFT                 (3u)
#define GPIO_PSR10_PSR104_SHIFT                 (4u)
#define GPIO_PSR10_PSR105_SHIFT                 (5u)
#define GPIO_PSR10_PSR106_SHIFT                 (6u)
#define GPIO_PSR10_PSR107_SHIFT                 (7u)
#define GPIO_PSR10_PSR108_SHIFT                 (8u)
#define GPIO_PSR10_PSR109_SHIFT                 (9u)
#define GPIO_PSR10_PSR1010_SHIFT                (10u)
#define GPIO_PSR10_PSR1011_SHIFT                (11u)
#define GPIO_PSR10_PSR1012_SHIFT                (12u)
#define GPIO_PSR10_PSR1013_SHIFT                (13u)
#define GPIO_PSR10_PSR1014_SHIFT                (14u)
#define GPIO_PSR10_PSR1015_SHIFT                (15u)
#define GPIO_PSR10_PSR1016_SHIFT                (16u)
#define GPIO_PSR10_PSR1017_SHIFT                (17u)
#define GPIO_PSR10_PSR1018_SHIFT                (18u)
#define GPIO_PSR10_PSR1019_SHIFT                (19u)
#define GPIO_PSR10_PSR1020_SHIFT                (20u)
#define GPIO_PSR10_PSR1021_SHIFT                (21u)
#define GPIO_PSR10_PSR1022_SHIFT                (22u)
#define GPIO_PSR10_PSR1023_SHIFT                (23u)
#define GPIO_PSR10_PSR1024_SHIFT                (24u)
#define GPIO_PSR10_PSR1025_SHIFT                (25u)
#define GPIO_PSR10_PSR1026_SHIFT                (26u)
#define GPIO_PSR10_PSR1027_SHIFT                (27u)
#define GPIO_PSR10_PSR1028_SHIFT                (28u)
#define GPIO_PSR10_PSR1029_SHIFT                (29u)
#define GPIO_PSR10_PSR1030_SHIFT                (30u)
#define GPIO_PSR10_PSR1031_SHIFT                (31u)

#define GPIO_PPR10_PPR100_SHIFT                 (0u)
#define GPIO_PPR10_PPR101_SHIFT                 (1u)
#define GPIO_PPR10_PPR102_SHIFT                 (2u)
#define GPIO_PPR10_PPR103_SHIFT                 (3u)
#define GPIO_PPR10_PPR104_SHIFT                 (4u)
#define GPIO_PPR10_PPR105_SHIFT                 (5u)
#define GPIO_PPR10_PPR106_SHIFT                 (6u)
#define GPIO_PPR10_PPR107_SHIFT                 (7u)
#define GPIO_PPR10_PPR108_SHIFT                 (8u)
#define GPIO_PPR10_PPR109_SHIFT                 (9u)
#define GPIO_PPR10_PPR1010_SHIFT                (10u)
#define GPIO_PPR10_PPR1011_SHIFT                (11u)
#define GPIO_PPR10_PPR1012_SHIFT                (12u)
#define GPIO_PPR10_PPR1013_SHIFT                (13u)
#define GPIO_PPR10_PPR1014_SHIFT                (14u)
#define GPIO_PPR10_PPR1015_SHIFT                (15u)

#define GPIO_PM10_PM100_SHIFT                   (0u)
#define GPIO_PM10_PM101_SHIFT                   (1u)
#define GPIO_PM10_PM102_SHIFT                   (2u)
#define GPIO_PM10_PM103_SHIFT                   (3u)
#define GPIO_PM10_PM104_SHIFT                   (4u)
#define GPIO_PM10_PM105_SHIFT                   (5u)
#define GPIO_PM10_PM106_SHIFT                   (6u)
#define GPIO_PM10_PM107_SHIFT                   (7u)
#define GPIO_PM10_PM108_SHIFT                   (8u)
#define GPIO_PM10_PM109_SHIFT                   (9u)
#define GPIO_PM10_PM1010_SHIFT                  (10u)
#define GPIO_PM10_PM1011_SHIFT                  (11u)
#define GPIO_PM10_PM1012_SHIFT                  (12u)
#define GPIO_PM10_PM1013_SHIFT                  (13u)
#define GPIO_PM10_PM1014_SHIFT                  (14u)
#define GPIO_PM10_PM1015_SHIFT                  (15u)

#define GPIO_PMC10_PMC100_SHIFT                 (0u)
#define GPIO_PMC10_PMC101_SHIFT                 (1u)
#define GPIO_PMC10_PMC102_SHIFT                 (2u)
#define GPIO_PMC10_PMC103_SHIFT                 (3u)
#define GPIO_PMC10_PMC104_SHIFT                 (4u)
#define GPIO_PMC10_PMC105_SHIFT                 (5u)
#define GPIO_PMC10_PMC106_SHIFT                 (6u)
#define GPIO_PMC10_PMC107_SHIFT                 (7u)
#define GPIO_PMC10_PMC108_SHIFT                 (8u)
#define GPIO_PMC10_PMC109_SHIFT                 (9u)
#define GPIO_PMC10_PMC1010_SHIFT                (10u)
#define GPIO_PMC10_PMC1011_SHIFT                (11u)
#define GPIO_PMC10_PMC1012_SHIFT                (12u)
#define GPIO_PMC10_PMC1013_SHIFT                (13u)
#define GPIO_PMC10_PMC1014_SHIFT                (14u)
#define GPIO_PMC10_PMC1015_SHIFT                (15u)

#define GPIO_PFC10_PFC100_SHIFT                 (0u)
#define GPIO_PFC10_PFC101_SHIFT                 (1u)
#define GPIO_PFC10_PFC102_SHIFT                 (2u)
#define GPIO_PFC10_PFC103_SHIFT                 (3u)
#define GPIO_PFC10_PFC104_SHIFT                 (4u)
#define GPIO_PFC10_PFC105_SHIFT                 (5u)
#define GPIO_PFC10_PFC106_SHIFT                 (6u)
#define GPIO_PFC10_PFC107_SHIFT                 (7u)
#define GPIO_PFC10_PFC108_SHIFT                 (8u)
#define GPIO_PFC10_PFC109_SHIFT                 (9u)
#define GPIO_PFC10_PFC1010_SHIFT                (10u)
#define GPIO_PFC10_PFC1011_SHIFT                (11u)
#define GPIO_PFC10_PFC1012_SHIFT                (12u)
#define GPIO_PFC10_PFC1013_SHIFT                (13u)
#define GPIO_PFC10_PFC1014_SHIFT                (14u)
#define GPIO_PFC10_PFC1015_SHIFT                (15u)

#define GPIO_PFCE10_PFCE100_SHIFT               (0u)
#define GPIO_PFCE10_PFCE101_SHIFT               (1u)
#define GPIO_PFCE10_PFCE102_SHIFT               (2u)
#define GPIO_PFCE10_PFCE103_SHIFT               (3u)
#define GPIO_PFCE10_PFCE104_SHIFT               (4u)
#define GPIO_PFCE10_PFCE105_SHIFT               (5u)
#define GPIO_PFCE10_PFCE106_SHIFT               (6u)
#define GPIO_PFCE10_PFCE107_SHIFT               (7u)
#define GPIO_PFCE10_PFCE108_SHIFT               (8u)
#define GPIO_PFCE10_PFCE109_SHIFT               (9u)
#define GPIO_PFCE10_PFCE1010_SHIFT              (10u)
#define GPIO_PFCE10_PFCE1011_SHIFT              (11u)
#define GPIO_PFCE10_PFCE1012_SHIFT              (12u)
#define GPIO_PFCE10_PFCE1013_SHIFT              (13u)
#define GPIO_PFCE10_PFCE1014_SHIFT              (14u)
#define GPIO_PFCE10_PFCE1015_SHIFT              (15u)

#define GPIO_PNOT10_PNOT100_SHIFT               (0u)
#define GPIO_PNOT10_PNOT101_SHIFT               (1u)
#define GPIO_PNOT10_PNOT102_SHIFT               (2u)
#define GPIO_PNOT10_PNOT103_SHIFT               (3u)
#define GPIO_PNOT10_PNOT104_SHIFT               (4u)
#define GPIO_PNOT10_PNOT105_SHIFT               (5u)
#define GPIO_PNOT10_PNOT106_SHIFT               (6u)
#define GPIO_PNOT10_PNOT107_SHIFT               (7u)
#define GPIO_PNOT10_PNOT108_SHIFT               (8u)
#define GPIO_PNOT10_PNOT109_SHIFT               (9u)
#define GPIO_PNOT10_PNOT1010_SHIFT              (10u)
#define GPIO_PNOT10_PNOT1011_SHIFT              (11u)
#define GPIO_PNOT10_PNOT1012_SHIFT              (12u)
#define GPIO_PNOT10_PNOT1013_SHIFT              (13u)
#define GPIO_PNOT10_PNOT1014_SHIFT              (14u)
#define GPIO_PNOT10_PNOT1015_SHIFT              (15u)

#define GPIO_PMSR10_PMSR100_SHIFT               (0u)
#define GPIO_PMSR10_PMSR101_SHIFT               (1u)
#define GPIO_PMSR10_PMSR102_SHIFT               (2u)
#define GPIO_PMSR10_PMSR103_SHIFT               (3u)
#define GPIO_PMSR10_PMSR104_SHIFT               (4u)
#define GPIO_PMSR10_PMSR105_SHIFT               (5u)
#define GPIO_PMSR10_PMSR106_SHIFT               (6u)
#define GPIO_PMSR10_PMSR107_SHIFT               (7u)
#define GPIO_PMSR10_PMSR108_SHIFT               (8u)
#define GPIO_PMSR10_PMSR109_SHIFT               (9u)
#define GPIO_PMSR10_PMSR1010_SHIFT              (10u)
#define GPIO_PMSR10_PMSR1011_SHIFT              (11u)
#define GPIO_PMSR10_PMSR1012_SHIFT              (12u)
#define GPIO_PMSR10_PMSR1013_SHIFT              (13u)
#define GPIO_PMSR10_PMSR1014_SHIFT              (14u)
#define GPIO_PMSR10_PMSR1015_SHIFT              (15u)
#define GPIO_PMSR10_PMSR1016_SHIFT              (16u)
#define GPIO_PMSR10_PMSR1017_SHIFT              (17u)
#define GPIO_PMSR10_PMSR1018_SHIFT              (18u)
#define GPIO_PMSR10_PMSR1019_SHIFT              (19u)
#define GPIO_PMSR10_PMSR1020_SHIFT              (20u)
#define GPIO_PMSR10_PMSR1021_SHIFT              (21u)
#define GPIO_PMSR10_PMSR1022_SHIFT              (22u)
#define GPIO_PMSR10_PMSR1023_SHIFT              (23u)
#define GPIO_PMSR10_PMSR1024_SHIFT              (24u)
#define GPIO_PMSR10_PMSR1025_SHIFT              (25u)
#define GPIO_PMSR10_PMSR1026_SHIFT              (26u)
#define GPIO_PMSR10_PMSR1027_SHIFT              (27u)
#define GPIO_PMSR10_PMSR1028_SHIFT              (28u)
#define GPIO_PMSR10_PMSR1029_SHIFT              (29u)
#define GPIO_PMSR10_PMSR1030_SHIFT              (30u)
#define GPIO_PMSR10_PMSR1031_SHIFT              (31u)

#define GPIO_PMCSR10_PMCSR100_SHIFT             (0u)
#define GPIO_PMCSR10_PMCSR101_SHIFT             (1u)
#define GPIO_PMCSR10_PMCSR102_SHIFT             (2u)
#define GPIO_PMCSR10_PMCSR103_SHIFT             (3u)
#define GPIO_PMCSR10_PMCSR104_SHIFT             (4u)
#define GPIO_PMCSR10_PMCSR105_SHIFT             (5u)
#define GPIO_PMCSR10_PMCSR106_SHIFT             (6u)
#define GPIO_PMCSR10_PMCSR107_SHIFT             (7u)
#define GPIO_PMCSR10_PMCSR108_SHIFT             (8u)
#define GPIO_PMCSR10_PMCSR109_SHIFT             (9u)
#define GPIO_PMCSR10_PMCSR1010_SHIFT            (10u)
#define GPIO_PMCSR10_PMCSR1011_SHIFT            (11u)
#define GPIO_PMCSR10_PMCSR1012_SHIFT            (12u)
#define GPIO_PMCSR10_PMCSR1013_SHIFT            (13u)
#define GPIO_PMCSR10_PMCSR1014_SHIFT            (14u)
#define GPIO_PMCSR10_PMCSR1015_SHIFT            (15u)
#define GPIO_PMCSR10_PMCSR1016_SHIFT            (16u)
#define GPIO_PMCSR10_PMCSR1017_SHIFT            (17u)
#define GPIO_PMCSR10_PMCSR1018_SHIFT            (18u)
#define GPIO_PMCSR10_PMCSR1019_SHIFT            (19u)
#define GPIO_PMCSR10_PMCSR1020_SHIFT            (20u)
#define GPIO_PMCSR10_PMCSR1021_SHIFT            (21u)
#define GPIO_PMCSR10_PMCSR1022_SHIFT            (22u)
#define GPIO_PMCSR10_PMCSR1023_SHIFT            (23u)
#define GPIO_PMCSR10_PMCSR1024_SHIFT            (24u)
#define GPIO_PMCSR10_PMCSR1025_SHIFT            (25u)
#define GPIO_PMCSR10_PMCSR1026_SHIFT            (26u)
#define GPIO_PMCSR10_PMCSR1027_SHIFT            (27u)
#define GPIO_PMCSR10_PMCSR1028_SHIFT            (28u)
#define GPIO_PMCSR10_PMCSR1029_SHIFT            (29u)
#define GPIO_PMCSR10_PMCSR1030_SHIFT            (30u)
#define GPIO_PMCSR10_PMCSR1031_SHIFT            (31u)

#define GPIO_PFCAE10_PFCAE100_SHIFT             (0u)
#define GPIO_PFCAE10_PFCAE101_SHIFT             (1u)
#define GPIO_PFCAE10_PFCAE102_SHIFT             (2u)
#define GPIO_PFCAE10_PFCAE103_SHIFT             (3u)
#define GPIO_PFCAE10_PFCAE104_SHIFT             (4u)
#define GPIO_PFCAE10_PFCAE105_SHIFT             (5u)
#define GPIO_PFCAE10_PFCAE106_SHIFT             (6u)
#define GPIO_PFCAE10_PFCAE107_SHIFT             (7u)
#define GPIO_PFCAE10_PFCAE108_SHIFT             (8u)
#define GPIO_PFCAE10_PFCAE109_SHIFT             (9u)
#define GPIO_PFCAE10_PFCAE1010_SHIFT            (10u)
#define GPIO_PFCAE10_PFCAE1011_SHIFT            (11u)
#define GPIO_PFCAE10_PFCAE1012_SHIFT            (12u)
#define GPIO_PFCAE10_PFCAE1013_SHIFT            (13u)
#define GPIO_PFCAE10_PFCAE1014_SHIFT            (14u)
#define GPIO_PFCAE10_PFCAE1015_SHIFT            (15u)

#define GPIO_PIBC10_PIBC100_SHIFT               (0u)
#define GPIO_PIBC10_PIBC101_SHIFT               (1u)
#define GPIO_PIBC10_PIBC102_SHIFT               (2u)
#define GPIO_PIBC10_PIBC103_SHIFT               (3u)
#define GPIO_PIBC10_PIBC104_SHIFT               (4u)
#define GPIO_PIBC10_PIBC105_SHIFT               (5u)
#define GPIO_PIBC10_PIBC106_SHIFT               (6u)
#define GPIO_PIBC10_PIBC107_SHIFT               (7u)
#define GPIO_PIBC10_PIBC108_SHIFT               (8u)
#define GPIO_PIBC10_PIBC109_SHIFT               (9u)
#define GPIO_PIBC10_PIBC1010_SHIFT              (10u)
#define GPIO_PIBC10_PIBC1011_SHIFT              (11u)
#define GPIO_PIBC10_PIBC1012_SHIFT              (12u)
#define GPIO_PIBC10_PIBC1013_SHIFT              (13u)
#define GPIO_PIBC10_PIBC1014_SHIFT              (14u)
#define GPIO_PIBC10_PIBC1015_SHIFT              (15u)

#define GPIO_PBDC10_PBDC100_SHIFT               (0u)
#define GPIO_PBDC10_PBDC101_SHIFT               (1u)
#define GPIO_PBDC10_PBDC102_SHIFT               (2u)
#define GPIO_PBDC10_PBDC103_SHIFT               (3u)
#define GPIO_PBDC10_PBDC104_SHIFT               (4u)
#define GPIO_PBDC10_PBDC105_SHIFT               (5u)
#define GPIO_PBDC10_PBDC106_SHIFT               (6u)
#define GPIO_PBDC10_PBDC107_SHIFT               (7u)
#define GPIO_PBDC10_PBDC108_SHIFT               (8u)
#define GPIO_PBDC10_PBDC109_SHIFT               (9u)
#define GPIO_PBDC10_PBDC1010_SHIFT              (10u)
#define GPIO_PBDC10_PBDC1011_SHIFT              (11u)
#define GPIO_PBDC10_PBDC1012_SHIFT              (12u)
#define GPIO_PBDC10_PBDC1013_SHIFT              (13u)
#define GPIO_PBDC10_PBDC1014_SHIFT              (14u)
#define GPIO_PBDC10_PBDC1015_SHIFT              (15u)

#define GPIO_PIPC10_PIPC100_SHIFT               (0u)
#define GPIO_PIPC10_PIPC101_SHIFT               (1u)
#define GPIO_PIPC10_PIPC102_SHIFT               (2u)
#define GPIO_PIPC10_PIPC103_SHIFT               (3u)
#define GPIO_PIPC10_PIPC104_SHIFT               (4u)
#define GPIO_PIPC10_PIPC105_SHIFT               (5u)
#define GPIO_PIPC10_PIPC106_SHIFT               (6u)
#define GPIO_PIPC10_PIPC107_SHIFT               (7u)
#define GPIO_PIPC10_PIPC108_SHIFT               (8u)
#define GPIO_PIPC10_PIPC109_SHIFT               (9u)
#define GPIO_PIPC10_PIPC1010_SHIFT              (10u)
#define GPIO_PIPC10_PIPC1011_SHIFT              (11u)
#define GPIO_PIPC10_PIPC1012_SHIFT              (12u)
#define GPIO_PIPC10_PIPC1013_SHIFT              (13u)
#define GPIO_PIPC10_PIPC1014_SHIFT              (14u)
#define GPIO_PIPC10_PIPC1015_SHIFT              (15u)

/* ---- P11 ---- */
#define GPIO_P11_P110_SHIFT                     (0u)
#define GPIO_P11_P111_SHIFT                     (1u)
#define GPIO_P11_P112_SHIFT                     (2u)
#define GPIO_P11_P113_SHIFT                     (3u)
#define GPIO_P11_P114_SHIFT                     (4u)
#define GPIO_P11_P115_SHIFT                     (5u)
#define GPIO_P11_P116_SHIFT                     (6u)
#define GPIO_P11_P117_SHIFT                     (7u)
#define GPIO_P11_P118_SHIFT                     (8u)
#define GPIO_P11_P119_SHIFT                     (9u)
#define GPIO_P11_P1110_SHIFT                    (10u)
#define GPIO_P11_P1111_SHIFT                    (11u)
#define GPIO_P11_P1112_SHIFT                    (12u)
#define GPIO_P11_P1113_SHIFT                    (13u)
#define GPIO_P11_P1114_SHIFT                    (14u)
#define GPIO_P11_P1115_SHIFT                    (15u)

#define GPIO_PSR11_PSR110_SHIFT                 (0u)
#define GPIO_PSR11_PSR111_SHIFT                 (1u)
#define GPIO_PSR11_PSR112_SHIFT                 (2u)
#define GPIO_PSR11_PSR113_SHIFT                 (3u)
#define GPIO_PSR11_PSR114_SHIFT                 (4u)
#define GPIO_PSR11_PSR115_SHIFT                 (5u)
#define GPIO_PSR11_PSR116_SHIFT                 (6u)
#define GPIO_PSR11_PSR117_SHIFT                 (7u)
#define GPIO_PSR11_PSR118_SHIFT                 (8u)
#define GPIO_PSR11_PSR119_SHIFT                 (9u)
#define GPIO_PSR11_PSR1110_SHIFT                (10u)
#define GPIO_PSR11_PSR1111_SHIFT                (11u)
#define GPIO_PSR11_PSR1112_SHIFT                (12u)
#define GPIO_PSR11_PSR1113_SHIFT                (13u)
#define GPIO_PSR11_PSR1114_SHIFT                (14u)
#define GPIO_PSR11_PSR1115_SHIFT                (15u)
#define GPIO_PSR11_PSR1116_SHIFT                (16u)
#define GPIO_PSR11_PSR1117_SHIFT                (17u)
#define GPIO_PSR11_PSR1118_SHIFT                (18u)
#define GPIO_PSR11_PSR1119_SHIFT                (19u)
#define GPIO_PSR11_PSR1120_SHIFT                (20u)
#define GPIO_PSR11_PSR1121_SHIFT                (21u)
#define GPIO_PSR11_PSR1122_SHIFT                (22u)
#define GPIO_PSR11_PSR1123_SHIFT                (23u)
#define GPIO_PSR11_PSR1124_SHIFT                (24u)
#define GPIO_PSR11_PSR1125_SHIFT                (25u)
#define GPIO_PSR11_PSR1126_SHIFT                (26u)
#define GPIO_PSR11_PSR1127_SHIFT                (27u)
#define GPIO_PSR11_PSR1128_SHIFT                (28u)
#define GPIO_PSR11_PSR1129_SHIFT                (29u)
#define GPIO_PSR11_PSR1130_SHIFT                (30u)
#define GPIO_PSR11_PSR1131_SHIFT                (31u)

#define GPIO_PPR11_PPR110_SHIFT                 (0u)
#define GPIO_PPR11_PPR111_SHIFT                 (1u)
#define GPIO_PPR11_PPR112_SHIFT                 (2u)
#define GPIO_PPR11_PPR113_SHIFT                 (3u)
#define GPIO_PPR11_PPR114_SHIFT                 (4u)
#define GPIO_PPR11_PPR115_SHIFT                 (5u)
#define GPIO_PPR11_PPR116_SHIFT                 (6u)
#define GPIO_PPR11_PPR117_SHIFT                 (7u)
#define GPIO_PPR11_PPR118_SHIFT                 (8u)
#define GPIO_PPR11_PPR119_SHIFT                 (9u)
#define GPIO_PPR11_PPR1110_SHIFT                (10u)
#define GPIO_PPR11_PPR1111_SHIFT                (11u)
#define GPIO_PPR11_PPR1112_SHIFT                (12u)
#define GPIO_PPR11_PPR1113_SHIFT                (13u)
#define GPIO_PPR11_PPR1114_SHIFT                (14u)
#define GPIO_PPR11_PPR1115_SHIFT                (15u)

#define GPIO_PM11_PM110_SHIFT                   (0u)
#define GPIO_PM11_PM111_SHIFT                   (1u)
#define GPIO_PM11_PM112_SHIFT                   (2u)
#define GPIO_PM11_PM113_SHIFT                   (3u)
#define GPIO_PM11_PM114_SHIFT                   (4u)
#define GPIO_PM11_PM115_SHIFT                   (5u)
#define GPIO_PM11_PM116_SHIFT                   (6u)
#define GPIO_PM11_PM117_SHIFT                   (7u)
#define GPIO_PM11_PM118_SHIFT                   (8u)
#define GPIO_PM11_PM119_SHIFT                   (9u)
#define GPIO_PM11_PM1110_SHIFT                  (10u)
#define GPIO_PM11_PM1111_SHIFT                  (11u)
#define GPIO_PM11_PM1112_SHIFT                  (12u)
#define GPIO_PM11_PM1113_SHIFT                  (13u)
#define GPIO_PM11_PM1114_SHIFT                  (14u)
#define GPIO_PM11_PM1115_SHIFT                  (15u)

#define GPIO_PMC11_PMC110_SHIFT                 (0u)
#define GPIO_PMC11_PMC111_SHIFT                 (1u)
#define GPIO_PMC11_PMC112_SHIFT                 (2u)
#define GPIO_PMC11_PMC113_SHIFT                 (3u)
#define GPIO_PMC11_PMC114_SHIFT                 (4u)
#define GPIO_PMC11_PMC115_SHIFT                 (5u)
#define GPIO_PMC11_PMC116_SHIFT                 (6u)
#define GPIO_PMC11_PMC117_SHIFT                 (7u)
#define GPIO_PMC11_PMC118_SHIFT                 (8u)
#define GPIO_PMC11_PMC119_SHIFT                 (9u)
#define GPIO_PMC11_PMC1110_SHIFT                (10u)
#define GPIO_PMC11_PMC1111_SHIFT                (11u)
#define GPIO_PMC11_PMC1112_SHIFT                (12u)
#define GPIO_PMC11_PMC1113_SHIFT                (13u)
#define GPIO_PMC11_PMC1114_SHIFT                (14u)
#define GPIO_PMC11_PMC1115_SHIFT                (15u)

#define GPIO_PFC11_PFC110_SHIFT                 (0u)
#define GPIO_PFC11_PFC111_SHIFT                 (1u)
#define GPIO_PFC11_PFC112_SHIFT                 (2u)
#define GPIO_PFC11_PFC113_SHIFT                 (3u)
#define GPIO_PFC11_PFC114_SHIFT                 (4u)
#define GPIO_PFC11_PFC115_SHIFT                 (5u)
#define GPIO_PFC11_PFC116_SHIFT                 (6u)
#define GPIO_PFC11_PFC117_SHIFT                 (7u)
#define GPIO_PFC11_PFC118_SHIFT                 (8u)
#define GPIO_PFC11_PFC119_SHIFT                 (9u)
#define GPIO_PFC11_PFC1110_SHIFT                (10u)
#define GPIO_PFC11_PFC1111_SHIFT                (11u)
#define GPIO_PFC11_PFC1112_SHIFT                (12u)
#define GPIO_PFC11_PFC1113_SHIFT                (13u)
#define GPIO_PFC11_PFC1114_SHIFT                (14u)
#define GPIO_PFC11_PFC1115_SHIFT                (15u)

#define GPIO_PFCE11_PFCE110_SHIFT               (0u)
#define GPIO_PFCE11_PFCE111_SHIFT               (1u)
#define GPIO_PFCE11_PFCE112_SHIFT               (2u)
#define GPIO_PFCE11_PFCE113_SHIFT               (3u)
#define GPIO_PFCE11_PFCE114_SHIFT               (4u)
#define GPIO_PFCE11_PFCE115_SHIFT               (5u)
#define GPIO_PFCE11_PFCE116_SHIFT               (6u)
#define GPIO_PFCE11_PFCE117_SHIFT               (7u)
#define GPIO_PFCE11_PFCE118_SHIFT               (8u)
#define GPIO_PFCE11_PFCE119_SHIFT               (9u)
#define GPIO_PFCE11_PFCE1110_SHIFT              (10u)
#define GPIO_PFCE11_PFCE1111_SHIFT              (11u)
#define GPIO_PFCE11_PFCE1112_SHIFT              (12u)
#define GPIO_PFCE11_PFCE1113_SHIFT              (13u)
#define GPIO_PFCE11_PFCE1114_SHIFT              (14u)
#define GPIO_PFCE11_PFCE1115_SHIFT              (15u)

#define GPIO_PNOT11_PNOT110_SHIFT               (0u)
#define GPIO_PNOT11_PNOT111_SHIFT               (1u)
#define GPIO_PNOT11_PNOT112_SHIFT               (2u)
#define GPIO_PNOT11_PNOT113_SHIFT               (3u)
#define GPIO_PNOT11_PNOT114_SHIFT               (4u)
#define GPIO_PNOT11_PNOT115_SHIFT               (5u)
#define GPIO_PNOT11_PNOT116_SHIFT               (6u)
#define GPIO_PNOT11_PNOT117_SHIFT               (7u)
#define GPIO_PNOT11_PNOT118_SHIFT               (8u)
#define GPIO_PNOT11_PNOT119_SHIFT               (9u)
#define GPIO_PNOT11_PNOT1110_SHIFT              (10u)
#define GPIO_PNOT11_PNOT1111_SHIFT              (11u)
#define GPIO_PNOT11_PNOT1112_SHIFT              (12u)
#define GPIO_PNOT11_PNOT1113_SHIFT              (13u)
#define GPIO_PNOT11_PNOT1114_SHIFT              (14u)
#define GPIO_PNOT11_PNOT1115_SHIFT              (15u)

#define GPIO_PMSR11_PMSR110_SHIFT               (0u)
#define GPIO_PMSR11_PMSR111_SHIFT               (1u)
#define GPIO_PMSR11_PMSR112_SHIFT               (2u)
#define GPIO_PMSR11_PMSR113_SHIFT               (3u)
#define GPIO_PMSR11_PMSR114_SHIFT               (4u)
#define GPIO_PMSR11_PMSR115_SHIFT               (5u)
#define GPIO_PMSR11_PMSR116_SHIFT               (6u)
#define GPIO_PMSR11_PMSR117_SHIFT               (7u)
#define GPIO_PMSR11_PMSR118_SHIFT               (8u)
#define GPIO_PMSR11_PMSR119_SHIFT               (9u)
#define GPIO_PMSR11_PMSR1110_SHIFT              (10u)
#define GPIO_PMSR11_PMSR1111_SHIFT              (11u)
#define GPIO_PMSR11_PMSR1112_SHIFT              (12u)
#define GPIO_PMSR11_PMSR1113_SHIFT              (13u)
#define GPIO_PMSR11_PMSR1114_SHIFT              (14u)
#define GPIO_PMSR11_PMSR1115_SHIFT              (15u)
#define GPIO_PMSR11_PMSR1116_SHIFT              (16u)
#define GPIO_PMSR11_PMSR1117_SHIFT              (17u)
#define GPIO_PMSR11_PMSR1118_SHIFT              (18u)
#define GPIO_PMSR11_PMSR1119_SHIFT              (19u)
#define GPIO_PMSR11_PMSR1120_SHIFT              (20u)
#define GPIO_PMSR11_PMSR1121_SHIFT              (21u)
#define GPIO_PMSR11_PMSR1122_SHIFT              (22u)
#define GPIO_PMSR11_PMSR1123_SHIFT              (23u)
#define GPIO_PMSR11_PMSR1124_SHIFT              (24u)
#define GPIO_PMSR11_PMSR1125_SHIFT              (25u)
#define GPIO_PMSR11_PMSR1126_SHIFT              (26u)
#define GPIO_PMSR11_PMSR1127_SHIFT              (27u)
#define GPIO_PMSR11_PMSR1128_SHIFT              (28u)
#define GPIO_PMSR11_PMSR1129_SHIFT              (29u)
#define GPIO_PMSR11_PMSR1130_SHIFT              (30u)
#define GPIO_PMSR11_PMSR1131_SHIFT              (31u)

#define GPIO_PMCSR11_PMCSR110_SHIFT             (0u)
#define GPIO_PMCSR11_PMCSR111_SHIFT             (1u)
#define GPIO_PMCSR11_PMCSR112_SHIFT             (2u)
#define GPIO_PMCSR11_PMCSR113_SHIFT             (3u)
#define GPIO_PMCSR11_PMCSR114_SHIFT             (4u)
#define GPIO_PMCSR11_PMCSR115_SHIFT             (5u)
#define GPIO_PMCSR11_PMCSR116_SHIFT             (6u)
#define GPIO_PMCSR11_PMCSR117_SHIFT             (7u)
#define GPIO_PMCSR11_PMCSR118_SHIFT             (8u)
#define GPIO_PMCSR11_PMCSR119_SHIFT             (9u)
#define GPIO_PMCSR11_PMCSR1110_SHIFT            (10u)
#define GPIO_PMCSR11_PMCSR1111_SHIFT            (11u)
#define GPIO_PMCSR11_PMCSR1112_SHIFT            (12u)
#define GPIO_PMCSR11_PMCSR1113_SHIFT            (13u)
#define GPIO_PMCSR11_PMCSR1114_SHIFT            (14u)
#define GPIO_PMCSR11_PMCSR1115_SHIFT            (15u)
#define GPIO_PMCSR11_PMCSR1116_SHIFT            (16u)
#define GPIO_PMCSR11_PMCSR1117_SHIFT            (17u)
#define GPIO_PMCSR11_PMCSR1118_SHIFT            (18u)
#define GPIO_PMCSR11_PMCSR1119_SHIFT            (19u)
#define GPIO_PMCSR11_PMCSR1120_SHIFT            (20u)
#define GPIO_PMCSR11_PMCSR1121_SHIFT            (21u)
#define GPIO_PMCSR11_PMCSR1122_SHIFT            (22u)
#define GPIO_PMCSR11_PMCSR1123_SHIFT            (23u)
#define GPIO_PMCSR11_PMCSR1124_SHIFT            (24u)
#define GPIO_PMCSR11_PMCSR1125_SHIFT            (25u)
#define GPIO_PMCSR11_PMCSR1126_SHIFT            (26u)
#define GPIO_PMCSR11_PMCSR1127_SHIFT            (27u)
#define GPIO_PMCSR11_PMCSR1128_SHIFT            (28u)
#define GPIO_PMCSR11_PMCSR1129_SHIFT            (29u)
#define GPIO_PMCSR11_PMCSR1130_SHIFT            (30u)
#define GPIO_PMCSR11_PMCSR1131_SHIFT            (31u)

#define GPIO_PFCAE11_PFCAE110_SHIFT             (0u)
#define GPIO_PFCAE11_PFCAE111_SHIFT             (1u)
#define GPIO_PFCAE11_PFCAE112_SHIFT             (2u)
#define GPIO_PFCAE11_PFCAE113_SHIFT             (3u)
#define GPIO_PFCAE11_PFCAE114_SHIFT             (4u)
#define GPIO_PFCAE11_PFCAE115_SHIFT             (5u)
#define GPIO_PFCAE11_PFCAE116_SHIFT             (6u)
#define GPIO_PFCAE11_PFCAE117_SHIFT             (7u)
#define GPIO_PFCAE11_PFCAE118_SHIFT             (8u)
#define GPIO_PFCAE11_PFCAE119_SHIFT             (9u)
#define GPIO_PFCAE11_PFCAE1110_SHIFT            (10u)
#define GPIO_PFCAE11_PFCAE1111_SHIFT            (11u)
#define GPIO_PFCAE11_PFCAE1112_SHIFT            (12u)
#define GPIO_PFCAE11_PFCAE1113_SHIFT            (13u)
#define GPIO_PFCAE11_PFCAE1114_SHIFT            (14u)
#define GPIO_PFCAE11_PFCAE1115_SHIFT            (15u)

#define GPIO_PIBC11_PIBC110_SHIFT               (0u)
#define GPIO_PIBC11_PIBC111_SHIFT               (1u)
#define GPIO_PIBC11_PIBC112_SHIFT               (2u)
#define GPIO_PIBC11_PIBC113_SHIFT               (3u)
#define GPIO_PIBC11_PIBC114_SHIFT               (4u)
#define GPIO_PIBC11_PIBC115_SHIFT               (5u)
#define GPIO_PIBC11_PIBC116_SHIFT               (6u)
#define GPIO_PIBC11_PIBC117_SHIFT               (7u)
#define GPIO_PIBC11_PIBC118_SHIFT               (8u)
#define GPIO_PIBC11_PIBC119_SHIFT               (9u)
#define GPIO_PIBC11_PIBC1110_SHIFT              (10u)
#define GPIO_PIBC11_PIBC1111_SHIFT              (11u)
#define GPIO_PIBC11_PIBC1112_SHIFT              (12u)
#define GPIO_PIBC11_PIBC1113_SHIFT              (13u)
#define GPIO_PIBC11_PIBC1114_SHIFT              (14u)
#define GPIO_PIBC11_PIBC1115_SHIFT              (15u)

#define GPIO_PBDC11_PBDC110_SHIFT               (0u)
#define GPIO_PBDC11_PBDC111_SHIFT               (1u)
#define GPIO_PBDC11_PBDC112_SHIFT               (2u)
#define GPIO_PBDC11_PBDC113_SHIFT               (3u)
#define GPIO_PBDC11_PBDC114_SHIFT               (4u)
#define GPIO_PBDC11_PBDC115_SHIFT               (5u)
#define GPIO_PBDC11_PBDC116_SHIFT               (6u)
#define GPIO_PBDC11_PBDC117_SHIFT               (7u)
#define GPIO_PBDC11_PBDC118_SHIFT               (8u)
#define GPIO_PBDC11_PBDC119_SHIFT               (9u)
#define GPIO_PBDC11_PBDC1110_SHIFT              (10u)
#define GPIO_PBDC11_PBDC1111_SHIFT              (11u)
#define GPIO_PBDC11_PBDC1112_SHIFT              (12u)
#define GPIO_PBDC11_PBDC1113_SHIFT              (13u)
#define GPIO_PBDC11_PBDC1114_SHIFT              (14u)
#define GPIO_PBDC11_PBDC1115_SHIFT              (15u)

#define GPIO_PIPC11_PIPC110_SHIFT               (0u)
#define GPIO_PIPC11_PIPC111_SHIFT               (1u)
#define GPIO_PIPC11_PIPC112_SHIFT               (2u)
#define GPIO_PIPC11_PIPC113_SHIFT               (3u)
#define GPIO_PIPC11_PIPC114_SHIFT               (4u)
#define GPIO_PIPC11_PIPC115_SHIFT               (5u)
#define GPIO_PIPC11_PIPC116_SHIFT               (6u)
#define GPIO_PIPC11_PIPC117_SHIFT               (7u)
#define GPIO_PIPC11_PIPC118_SHIFT               (8u)
#define GPIO_PIPC11_PIPC119_SHIFT               (9u)
#define GPIO_PIPC11_PIPC1110_SHIFT              (10u)
#define GPIO_PIPC11_PIPC1111_SHIFT              (11u)
#define GPIO_PIPC11_PIPC1112_SHIFT              (12u)
#define GPIO_PIPC11_PIPC1113_SHIFT              (13u)
#define GPIO_PIPC11_PIPC1114_SHIFT              (14u)
#define GPIO_PIPC11_PIPC1115_SHIFT              (15u)


#endif /* GPIO_IOBITMASK_H */

/* End of File */
