/* mbed Microcontroller Library
 *******************************************************************************
 * Copyright (c) 2014, STMicroelectronics
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of STMicroelectronics nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *******************************************************************************
 */
#ifndef MBED_PINNAMES_H
#define MBED_PINNAMES_H

#include "cmsis.h"
#include "PinNamesTypes.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef enum {
    PA_0  = 0x00,
    PA_1  = 0x01,
    PA_2  = 0x02,
    PA_3  = 0x03,
    PA_4  = 0x04,
    PA_5  = 0x05,
    PA_6  = 0x06,
    PA_7  = 0x07,
    PA_8  = 0x08,
    PA_9  = 0x09,
    PA_10 = 0x0A,
    PA_11 = 0x0B,
    PA_12 = 0x0C,
    PA_13 = 0x0D,
    PA_14 = 0x0E,
    PA_15 = 0x0F,

    PB_0  = 0x10,
    PB_1  = 0x11,
    PB_2  = 0x12,
    PB_3  = 0x13,
    PB_4  = 0x14,
    PB_5  = 0x15,
    PB_6  = 0x16,
    PB_7  = 0x17,
    PB_8  = 0x18,
    PB_9  = 0x19,
    PB_10 = 0x1A,
    PB_11 = 0x1B,
    PB_12 = 0x1C,
    PB_13 = 0x1D,
    PB_14 = 0x1E,
    PB_15 = 0x1F,

    PC_0  = 0x20,
    PC_1  = 0x21,
    PC_2  = 0x22,
    PC_3  = 0x23,
    PC_4  = 0x24,
    PC_5  = 0x25,
    PC_6  = 0x26,
    PC_7  = 0x27,
    PC_8  = 0x28,
    PC_9  = 0x29,
    PC_10 = 0x2A,
    PC_11 = 0x2B,
    PC_12 = 0x2C,
    PC_13 = 0x2D,
    PC_14 = 0x2E,
    PC_15 = 0x2F,

    PD_2  = 0x32,

    PF_0  = 0x50,
    PF_1  = 0x51,
    PF_4  = 0x54,
    PF_5  = 0x55,
    PF_6  = 0x56,
    PF_7  = 0x57,

    // ADC internal channels
    ADC_TEMP = 0xF0,
    ADC_VREF = 0xF1,
    ADC_VBAT = 0xF2,

    // Arduino connector namings
    A0          = PC_0,
    A1          = PC_1,
    A2          = PC_2,
    A3          = PC_3,
    A4          = PC_4,
    A5          = PC_5,
    D0          = PA_3,
    D1          = PA_2,
    D2          = PB_12,
    D3          = PB_11,
    D4          = PA_7,
    D5          = PB_9,
    D6          = PB_8,
    D7          = PA_6,
    D8          = PA_5,
    D9          = PA_4,
    D10         = PA_11,
    D11         = PB_5,
    D12         = PB_4,
    D13         = PB_3,
//    D14         = PB_9,
//    D15         = PB_8,

    // STM32F0-Discovery(STM32F051R8) connector namings
    PA0          = PA_0,
    PA1          = PA_1,
    PA2          = PA_2,
    PA3          = PA_3,
    PA4          = PA_4,
    PA5          = PA_5,
    PA6          = PA_6,
    PA7          = PA_7,
    PA8          = PA_8,
    PA9          = PA_9,
    PA10         = PA_10,
    PA11         = PA_11,
    PA12         = PA_12,
    PA13         = PA_13,
    PA14         = PA_14,
    PA15         = PA_15,

    PC0          = PC_0,
    PC1          = PC_1,
    PC2          = PC_2,
    PC3          = PC_3,
    PC4          = PC_4,
    PC5          = PC_5,
    PC6          = PC_6,
    PC7          = PC_7,
    PC8          = PC_8,
    PC9          = PC_9,
    PC10         = PC_10,
    PC11         = PC_13,
    PC12         = PC_12,
    PC13         = PC_13,
    PC14         = PC_14,
    PC15         = PC_15,

    PD2          = PD_2,

    PB0          = PB_0,
    PB1          = PB_1,
    PB2          = PB_2,
    PB3          = PB_3,
    PB4          = PB_4,
    PB5          = PB_5,
    PB6          = PB_6,
    PB7          = PB_7,
    PB8          = PB_8,
    PB9          = PB_9,
    PB10         = PB_10,
    PB11         = PB_11,
    PB12         = PB_12,
    PB13         = PB_13,
    PB14         = PB_14,
    PB15         = PB_15,
    // Generic signals namings
    LED1        = PC_9,
    LED2        = PC_8,
    LED3        = PC_9,
    LED4        = PC_8,
    USER_BUTTON = PA_0,
    SERIAL_TX   = PA_2,
    SERIAL_RX   = PA_3,
    USBTX       = PA_2,
    USBRX       = PA_3,
    I2C_SCL     = PB_8,
    I2C_SDA     = PB_9,
    SPI_MOSI    = PA_7,
    SPI_MISO    = PA_6,
    SPI_SCK     = PA_5,
    SPI_CS      = PB_6,
    PWM_OUT     = PB_3,

    // Not connected
    NC = (int)0xFFFFFFFF
} PinName;

#ifdef __cplusplus
}
#endif

#endif
