#ifndef CONFIG_H
#define CONFIG_H

#include "BNO055.h"

//This header contains calibration data

#define NodeID 7
#define RadioChannel 90
#define SendDelay 3 //ms



//define MCU for bias and pinout
#define F042
//#define L052
//#define F103







//Macro for pinout

#ifdef F042
    #define ledpin      PA_10
    
    #define nrf_CE      PA_1
    #define nrf_CSN     PA_4
    #define spi_SCK     PA_5
    #define spi_MOSI    PA_7
    #define spi_MISO    PA_6
    #define nrf_irq     PA_1 //TODO
    
    #define i2c_sda     PF_0
    #define i2c_scl     PF_1
    
#elif defined L052
    

    #define ledpin      PA_8
    
    #define nrf_CE      PB_4
    #define nrf_CSN     PB_3
    #define spi_SCK     PA_5
    #define spi_MOSI    PA_7
    #define spi_MISO    PA_6
    #define nrf_irq     PA_15 
    
    #define i2c_sda     PB_7 
    #define i2c_scl     PB_6
    
#elif defined F103

    #define ledpin      PA_10
    
    #define nrf_CE      PA_9
    #define nrf_CSN     PA_8
    #define spi_SCK     PB_13
    #define spi_MOSI    PB_15
    #define spi_MISO    PB_14
    #define nrf_irq     PA_12
    
    #define i2c_sda     PB_11
    #define i2c_scl     PB_10
        
#endif






#endif