
#define SAMPLE_RATE    1500000
#include "mbed.h"
#include "adc.h"
#include "EthernetNetIf.h"
#include "UDPSocket.h"

EthernetNetIf eth;
UDPSocket udp;

DigitalOut int_led(LED1);
Serial pc(USBTX,USBRX);
Host multicast(IpAddr(192,168,0,199), 27200, NULL);   //Target IP and port
ADC adc(SAMPLE_RATE, 1);
Ticker flipper;
unsigned short samples1,samples2,samples3,samples4;
int k=0;
Timer tmr;
char str[50];


void onUDPSocketEvent(UDPSocketEvent e) {  //Incoming UDP packet processing
    switch (e) {
        case UDPSOCKET_READABLE: //The only event for now
            char buf[64] = {0};
            Host host;
            while ( int len = udp.recvfrom( buf, 63, &host ) ) {
                if ( len <= 0 )
                    break;
                printf("From %d.%d.%d.%d: %s\n", host.getIp()[0], host.getIp()[1], host.getIp()[2], host.getIp()[3], buf);
            }
            break;
    }
}

void flip() {                       // interrupt function: measurement and sending a UDP packet
    int_led = !int_led;
/*    samples1=adc.read(p20);
    samples2=adc.read(p19);
    samples3=adc.read(p18);
    samples4=adc.read(p17);*/
        Net::poll();                //Do network stuff
    k++;                             //cycle number counter
    sprintf(str, "1=%04u 2=%04u 3=%04u 4=%04u",adc.read(p17),adc.read(p18),adc.read(p19),adc.read(p20));
    udp.sendto( str, strlen(str), &multicast );
}


int main() {
    pc.baud(57600);
    //Ethernet initializing, Serial Interface - 57600 kbit/s
    printf("Setting up...\n");
    EthernetErr ethErr = eth.setup();
    if (ethErr) {
        printf("Error %d in setup.\n", ethErr);
        return -1;
    }
    printf("Setup OK\n");
 //   Host multicast(IpAddr(239, 192, 1, 100), 50000, NULL); //Join multicast group on port 50000
    udp.setOnEvent(&onUDPSocketEvent);
    udp.bind(multicast);
    
    Net::poll();
    
    tmr.start();

    //Turning ON Burst-mode ADC on pins 17,18,19,20  note: connect not used ADC ping to ground
    adc.startmode(0,0);
    adc.burst(1);
    adc.setup(p20,1);
    adc.setup(p19,1);
    adc.setup(p18,1);
    adc.setup(p17,1);

    printf("start\n");

    flipper.attach_us(&flip, 100); // Interrupt Turn ON   10kHz
    wait(10);                      // 10 seconds measurement
    flipper.detach();              // Interrupt Turn OFF

    adc.burst(0);                 //ADC Turn OFF
    adc.setup(p20,0);
    adc.setup(p19,0);
    adc.setup(p18,0);
    adc.setup(p17,0);


    printf("number of cycles= %d\n",k);
    printf("End: %f\n",tmr.read());

}