#ifndef __CONTROL_H
#define __CONTROL_H

#define CONTROL_MODE_NONE   0
#define CONTROL_MODE_ONOFF  1
#define CONTROL_MODE_P      2
#define CONTROL_MODE_PI     3
#define CONTROL_MODE_PD     4
#define CONTROL_MODE_PID    5

typedef struct{
    unsigned char input;

    double presentvalue;

    double setpoint;

    double upperlimit;
    double lowerlimit;

    double upperdeadband;
    double lowerdeadband;
    
    unsigned char mode;
    double gain_p;
    double gain_i;
    double gain_d;
        
    double error;
    double error_p;
    double error_i;
    double error_d;
    
    double output;
}CONTROLLER;    

void CONTROL_InputMode_Set(CONTROLLER* control, unsigned char input, double mode);
void CONTROL_Setpoint_Set(CONTROLLER* control, double sp);
void CONTROL_Gain_Set(CONTROLLER* control, double p, double i, double d);
void CONTROL_Limit_Set(CONTROLLER* control, double upper, double lower);
void CONTROL_Deadband_Set(CONTROLLER* control, double upper, double lower);
void CONTROL_PresentValue_Set(CONTROLLER* control, double pv);
double CONTROL_Output_Get(CONTROLLER* control);

void CONTROL_OnOff(CONTROLLER* control);
void CONTROL_P(CONTROLLER* control);
void CONTROL_PID(CONTROLLER* control);
void CONTROL_PI(CONTROLLER* control);
void CONTROL_PD(CONTROLLER* control);
 
void CONTROL_Config(void);
void CONTROL_Task(void);

#endif
